# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
from typing import Any, Callable, IO, Optional, TypeVar, Union, overload

from azure.core import AsyncPipelineClient
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._utils.utils import ClientMixinABC
from ...operations._resource_graph_client_operations import build_resources_request
from .._configuration import ResourceGraphClientConfiguration

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, dict[str, Any]], Any]]
List = list


class _ResourceGraphClientOperationsMixin(
    ClientMixinABC[AsyncPipelineClient[HttpRequest, AsyncHttpResponse], ResourceGraphClientConfiguration]
):

    @overload
    async def resources(
        self, query: _models.QueryRequest, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.QueryResponse:
        """Queries the resources managed by Azure Resource Manager for scopes specified in the request.

        .. seealso::
           - https://aka.ms/resource-graph/learntoquery

        :param query: Request specifying query and its options. Required.
        :type query: ~azure.mgmt.resourcegraph.models.QueryRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: QueryResponse or the result of cls(response)
        :rtype: ~azure.mgmt.resourcegraph.models.QueryResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def resources(
        self, query: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.QueryResponse:
        """Queries the resources managed by Azure Resource Manager for scopes specified in the request.

        .. seealso::
           - https://aka.ms/resource-graph/learntoquery

        :param query: Request specifying query and its options. Required.
        :type query: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: QueryResponse or the result of cls(response)
        :rtype: ~azure.mgmt.resourcegraph.models.QueryResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def resources(self, query: Union[_models.QueryRequest, IO[bytes]], **kwargs: Any) -> _models.QueryResponse:
        """Queries the resources managed by Azure Resource Manager for scopes specified in the request.

        .. seealso::
           - https://aka.ms/resource-graph/learntoquery

        :param query: Request specifying query and its options. Is either a QueryRequest type or a
         IO[bytes] type. Required.
        :type query: ~azure.mgmt.resourcegraph.models.QueryRequest or IO[bytes]
        :return: QueryResponse or the result of cls(response)
        :rtype: ~azure.mgmt.resourcegraph.models.QueryResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.QueryResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(query, (IOBase, bytes)):
            _content = query
        else:
            _json = self._serialize.body(query, "QueryRequest")

        _request = build_resources_request(
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(
                _models.ErrorResponse,
                pipeline_response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("QueryResponse", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
