# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Dict, List, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_discriminator, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class AzStackHCIClusterProperties(_Model):
    """AzStackHCI cluster properties.

    :ivar cluster_name: Gets or sets the AzStackHCICluster FQDN name. Required.
    :vartype cluster_name: str
    :ivar resource_name: Gets or sets the AzStackHCICluster resource name. Required.
    :vartype resource_name: str
    :ivar storage_account_name: Gets or sets the Storage account name. Required.
    :vartype storage_account_name: str
    :ivar storage_containers: Gets or sets the list of AzStackHCICluster Storage Container.
     Required.
    :vartype storage_containers:
     list[~azure.mgmt.recoveryservicesdatareplication.models.StorageContainerProperties]
    """

    cluster_name: str = rest_field(name="clusterName", visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the AzStackHCICluster FQDN name. Required."""
    resource_name: str = rest_field(name="resourceName", visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the AzStackHCICluster resource name. Required."""
    storage_account_name: str = rest_field(
        name="storageAccountName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the Storage account name. Required."""
    storage_containers: List["_models.StorageContainerProperties"] = rest_field(
        name="storageContainers", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the list of AzStackHCICluster Storage Container. Required."""

    @overload
    def __init__(
        self,
        *,
        cluster_name: str,
        resource_name: str,
        storage_account_name: str,
        storage_containers: List["_models.StorageContainerProperties"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FabricModelCustomProperties(_Model):
    """Fabric model custom properties.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzStackHCIFabricModelCustomProperties, HyperVMigrateFabricModelCustomProperties,
    VMwareMigrateFabricModelCustomProperties

    :ivar instance_type: Discriminator property for FabricModelCustomProperties. Required. Default
     value is None.
    :vartype instance_type: str
    """

    __mapping__: Dict[str, _Model] = {}
    instance_type: str = rest_discriminator(name="instanceType")
    """Discriminator property for FabricModelCustomProperties. Required. Default value is None."""

    @overload
    def __init__(
        self,
        *,
        instance_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzStackHCIFabricModelCustomProperties(FabricModelCustomProperties, discriminator="AzStackHCI"):
    """AzStackHCI fabric model custom properties.

    :ivar az_stack_hci_site_id: Gets or sets the ARM Id of the AzStackHCI site. Required.
    :vartype az_stack_hci_site_id: str
    :ivar appliance_name: Gets or sets the Appliance name.
    :vartype appliance_name: list[str]
    :ivar cluster: AzStackHCI cluster properties. Required.
    :vartype cluster:
     ~azure.mgmt.recoveryservicesdatareplication.models.AzStackHCIClusterProperties
    :ivar fabric_resource_id: Gets or sets the fabric resource Id.
    :vartype fabric_resource_id: str
    :ivar fabric_container_id: Gets or sets the fabric container Id.
    :vartype fabric_container_id: str
    :ivar migration_solution_id: Gets or sets the Migration solution ARM Id. Required.
    :vartype migration_solution_id: str
    :ivar migration_hub_uri: Gets or sets the migration hub Uri.
    :vartype migration_hub_uri: str
    :ivar instance_type: Gets or sets the instance type. Required. Default value is "AzStackHCI".
    :vartype instance_type: str
    """

    az_stack_hci_site_id: str = rest_field(
        name="azStackHciSiteId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the ARM Id of the AzStackHCI site. Required."""
    appliance_name: Optional[List[str]] = rest_field(name="applianceName", visibility=["read"])
    """Gets or sets the Appliance name."""
    cluster: "_models.AzStackHCIClusterProperties" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """AzStackHCI cluster properties. Required."""
    fabric_resource_id: Optional[str] = rest_field(name="fabricResourceId", visibility=["read"])
    """Gets or sets the fabric resource Id."""
    fabric_container_id: Optional[str] = rest_field(name="fabricContainerId", visibility=["read"])
    """Gets or sets the fabric container Id."""
    migration_solution_id: str = rest_field(
        name="migrationSolutionId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the Migration solution ARM Id. Required."""
    migration_hub_uri: Optional[str] = rest_field(name="migrationHubUri", visibility=["read"])
    """Gets or sets the migration hub Uri."""
    instance_type: Literal["AzStackHCI"] = rest_discriminator(name="instanceType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Gets or sets the instance type. Required. Default value is \"AzStackHCI\"."""

    @overload
    def __init__(
        self,
        *,
        az_stack_hci_site_id: str,
        cluster: "_models.AzStackHCIClusterProperties",
        migration_solution_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, instance_type="AzStackHCI", **kwargs)


class CheckNameAvailabilityModel(_Model):
    """Check name availability model.

    :ivar name: Gets or sets the resource name.
    :vartype name: str
    :ivar type: Gets or sets the resource type.
    :vartype type: str
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the resource name."""
    type: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the resource type."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CheckNameAvailabilityResponseModel(_Model):
    """Check name availability response model.

    :ivar name_available: Gets or sets a value indicating whether resource name is available or
     not.
    :vartype name_available: bool
    :ivar reason: Gets or sets the reason for resource name unavailability.
    :vartype reason: str
    :ivar message: Gets or sets the message for resource name unavailability.
    :vartype message: str
    """

    name_available: Optional[bool] = rest_field(
        name="nameAvailable", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets a value indicating whether resource name is available or not."""
    reason: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the reason for resource name unavailability."""
    message: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the message for resource name unavailability."""

    @overload
    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[str] = None,
        message: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConnectionDetails(_Model):
    """Private endpoint connection details at member level.

    :ivar id: Gets or sets id.
    :vartype id: str
    :ivar private_ip_address: Gets or sets private IP address.
    :vartype private_ip_address: str
    :ivar link_identifier: Gets or sets link identifier.
    :vartype link_identifier: str
    :ivar group_id: Gets or sets group id.
    :vartype group_id: str
    :ivar member_name: Gets or sets member name.
    :vartype member_name: str
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets id."""
    private_ip_address: Optional[str] = rest_field(
        name="privateIpAddress", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets private IP address."""
    link_identifier: Optional[str] = rest_field(
        name="linkIdentifier", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets link identifier."""
    group_id: Optional[str] = rest_field(name="groupId", visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets group id."""
    member_name: Optional[str] = rest_field(
        name="memberName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets member name."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        private_ip_address: Optional[str] = None,
        link_identifier: Optional[str] = None,
        group_id: Optional[str] = None,
        member_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DeploymentPreflightModel(_Model):
    """Deployment preflight model.

    :ivar resources: Gets or sets the list of resources.
    :vartype resources:
     list[~azure.mgmt.recoveryservicesdatareplication.models.DeploymentPreflightResource]
    """

    resources: Optional[List["_models.DeploymentPreflightResource"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the list of resources."""

    @overload
    def __init__(
        self,
        *,
        resources: Optional[List["_models.DeploymentPreflightResource"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DeploymentPreflightResource(_Model):
    """Deployment preflight resource.

    :ivar name: Gets or sets the resource name.
    :vartype name: str
    :ivar type: Gets or sets the resource type.
    :vartype type: str
    :ivar location: Gets or sets the location of the resource.
    :vartype location: str
    :ivar api_version: Gets or sets the Api version.
    :vartype api_version: str
    :ivar properties: Gets or sets the properties of the resource.
    :vartype properties: any
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the resource name."""
    type: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the resource type."""
    location: Optional[str] = rest_field(visibility=["read", "create"])
    """Gets or sets the location of the resource."""
    api_version: Optional[str] = rest_field(
        name="apiVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the Api version."""
    properties: Optional[Any] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the properties of the resource."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[str] = None,
        location: Optional[str] = None,
        api_version: Optional[str] = None,
        properties: Optional[Any] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DiskControllerInputs(_Model):
    """Disk controller.

    :ivar controller_name: Gets or sets the controller name (IDE,SCSI). Required.
    :vartype controller_name: str
    :ivar controller_id: Gets or sets the controller ID. Required.
    :vartype controller_id: int
    :ivar controller_location: Gets or sets the controller Location. Required.
    :vartype controller_location: int
    """

    controller_name: str = rest_field(name="controllerName", visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the controller name (IDE,SCSI). Required."""
    controller_id: int = rest_field(name="controllerId", visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the controller ID. Required."""
    controller_location: int = rest_field(
        name="controllerLocation", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the controller Location. Required."""

    @overload
    def __init__(
        self,
        *,
        controller_name: str,
        controller_id: int,
        controller_location: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Resource(_Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.recoveryservicesdatareplication.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.recoveryservicesdatareplication.models.SystemData
    """


class EmailConfigurationModel(ProxyResource):
    """Email configuration model.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.recoveryservicesdatareplication.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties:
     ~azure.mgmt.recoveryservicesdatareplication.models.EmailConfigurationModelProperties
    """

    properties: Optional["_models.EmailConfigurationModelProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.EmailConfigurationModelProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EmailConfigurationModelProperties(_Model):
    """Email configuration model properties.

    :ivar send_to_owners: Gets or sets a value indicating whether to send email to subscription
     administrator. Required.
    :vartype send_to_owners: bool
    :ivar custom_email_addresses: Gets or sets the custom email address for sending emails.
    :vartype custom_email_addresses: list[str]
    :ivar locale: Gets or sets the locale for the email notification.
    :vartype locale: str
    :ivar provisioning_state: Gets or sets the provisioning state of the email configuration. Known
     values are: "Canceled", "Creating", "Deleting", "Deleted", "Failed", "Succeeded", and
     "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.ProvisioningState
    """

    send_to_owners: bool = rest_field(name="sendToOwners", visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets a value indicating whether to send email to subscription administrator. Required."""
    custom_email_addresses: Optional[List[str]] = rest_field(
        name="customEmailAddresses", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the custom email address for sending emails."""
    locale: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the locale for the email notification."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Gets or sets the provisioning state of the email configuration. Known values are: \"Canceled\",
     \"Creating\", \"Deleting\", \"Deleted\", \"Failed\", \"Succeeded\", and \"Updating\"."""

    @overload
    def __init__(
        self,
        *,
        send_to_owners: bool,
        custom_email_addresses: Optional[List[str]] = None,
        locale: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.recoveryservicesdatareplication.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.recoveryservicesdatareplication.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[List["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorModel(_Model):
    """Error model.

    :ivar code: Gets or sets the error code.
    :vartype code: str
    :ivar type: Gets or sets the error type.
    :vartype type: str
    :ivar severity: Gets or sets the error severity.
    :vartype severity: str
    :ivar creation_time: Gets or sets the creation time of error.
    :vartype creation_time: ~datetime.datetime
    :ivar message: Gets or sets the error message.
    :vartype message: str
    :ivar causes: Gets or sets the possible causes of error.
    :vartype causes: str
    :ivar recommendation: Gets or sets the recommended action to resolve error.
    :vartype recommendation: str
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets the error code."""
    type: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets the error type."""
    severity: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets the error severity."""
    creation_time: Optional[datetime.datetime] = rest_field(name="creationTime", visibility=["read"], format="rfc3339")
    """Gets or sets the creation time of error."""
    message: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets the error message."""
    causes: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets the possible causes of error."""
    recommendation: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets the recommended action to resolve error."""


class ErrorResponse(_Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.recoveryservicesdatareplication.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EventModel(ProxyResource):
    """Event model.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.recoveryservicesdatareplication.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.recoveryservicesdatareplication.models.EventModelProperties
    """

    properties: Optional["_models.EventModelProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.EventModelProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EventModelCustomProperties(_Model):
    """Event model custom properties.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    HyperVToAzStackHCIEventModelCustomProperties, VMwareToAzStackHCIEventModelCustomProperties

    :ivar instance_type: Discriminator property for EventModelCustomProperties. Required. Default
     value is None.
    :vartype instance_type: str
    """

    __mapping__: Dict[str, _Model] = {}
    instance_type: str = rest_discriminator(name="instanceType")
    """Discriminator property for EventModelCustomProperties. Required. Default value is None."""

    @overload
    def __init__(
        self,
        *,
        instance_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EventModelProperties(_Model):
    """Event model properties.

    :ivar resource_type: Gets or sets the resource type.
    :vartype resource_type: str
    :ivar resource_name: Gets or sets the resource name.
    :vartype resource_name: str
    :ivar event_type: Gets or sets the event type.
    :vartype event_type: str
    :ivar event_name: Gets or sets the event name.
    :vartype event_name: str
    :ivar time_of_occurrence: Gets or sets the time at which the event occurred at source.
    :vartype time_of_occurrence: ~datetime.datetime
    :ivar severity: Gets or sets the event severity.
    :vartype severity: str
    :ivar description: Gets or sets the event description.
    :vartype description: str
    :ivar correlation_id: Gets or sets the event correlation Id.
    :vartype correlation_id: str
    :ivar health_errors: Gets or sets the errors associated with this event.
    :vartype health_errors:
     list[~azure.mgmt.recoveryservicesdatareplication.models.HealthErrorModel]
    :ivar custom_properties: Event model custom properties. Required.
    :vartype custom_properties:
     ~azure.mgmt.recoveryservicesdatareplication.models.EventModelCustomProperties
    :ivar provisioning_state: Gets or sets the provisioning state of the event. Known values are:
     "Canceled", "Creating", "Deleting", "Deleted", "Failed", "Succeeded", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.ProvisioningState
    """

    resource_type: Optional[str] = rest_field(name="resourceType", visibility=["read"])
    """Gets or sets the resource type."""
    resource_name: Optional[str] = rest_field(name="resourceName", visibility=["read"])
    """Gets or sets the resource name."""
    event_type: Optional[str] = rest_field(name="eventType", visibility=["read"])
    """Gets or sets the event type."""
    event_name: Optional[str] = rest_field(name="eventName", visibility=["read"])
    """Gets or sets the event name."""
    time_of_occurrence: Optional[datetime.datetime] = rest_field(
        name="timeOfOccurrence", visibility=["read"], format="rfc3339"
    )
    """Gets or sets the time at which the event occurred at source."""
    severity: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets the event severity."""
    description: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets the event description."""
    correlation_id: Optional[str] = rest_field(name="correlationId", visibility=["read"])
    """Gets or sets the event correlation Id."""
    health_errors: Optional[List["_models.HealthErrorModel"]] = rest_field(name="healthErrors", visibility=["read"])
    """Gets or sets the errors associated with this event."""
    custom_properties: "_models.EventModelCustomProperties" = rest_field(
        name="customProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Event model custom properties. Required."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Gets or sets the provisioning state of the event. Known values are: \"Canceled\", \"Creating\",
     \"Deleting\", \"Deleted\", \"Failed\", \"Succeeded\", and \"Updating\"."""

    @overload
    def __init__(
        self,
        *,
        custom_properties: "_models.EventModelCustomProperties",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FabricAgentModel(ProxyResource):
    """Fabric agent model.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.recoveryservicesdatareplication.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties:
     ~azure.mgmt.recoveryservicesdatareplication.models.FabricAgentModelProperties
    """

    properties: Optional["_models.FabricAgentModelProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.FabricAgentModelProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FabricAgentModelCustomProperties(_Model):
    """Fabric agent model custom properties.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    VMwareFabricAgentModelCustomProperties

    :ivar instance_type: Discriminator property for FabricAgentModelCustomProperties. Required.
     Default value is None.
    :vartype instance_type: str
    """

    __mapping__: Dict[str, _Model] = {}
    instance_type: str = rest_discriminator(name="instanceType")
    """Discriminator property for FabricAgentModelCustomProperties. Required. Default value is None."""

    @overload
    def __init__(
        self,
        *,
        instance_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FabricAgentModelProperties(_Model):
    """Fabric agent model properties.

    :ivar correlation_id: Gets or sets the fabric agent correlation Id.
    :vartype correlation_id: str
    :ivar machine_id: Gets or sets the machine Id where fabric agent is running. Required.
    :vartype machine_id: str
    :ivar machine_name: Gets or sets the machine name where fabric agent is running. Required.
    :vartype machine_name: str
    :ivar authentication_identity: Identity model. Required.
    :vartype authentication_identity:
     ~azure.mgmt.recoveryservicesdatareplication.models.IdentityModel
    :ivar resource_access_identity: Identity model. Required.
    :vartype resource_access_identity:
     ~azure.mgmt.recoveryservicesdatareplication.models.IdentityModel
    :ivar is_responsive: Gets or sets a value indicating whether the fabric agent is responsive.
    :vartype is_responsive: bool
    :ivar last_heartbeat: Gets or sets the time when last heartbeat was sent by the fabric agent.
    :vartype last_heartbeat: ~datetime.datetime
    :ivar version_number: Gets or sets the fabric agent version.
    :vartype version_number: str
    :ivar provisioning_state: Gets or sets the provisioning state of the fabric agent. Known values
     are: "Canceled", "Creating", "Deleting", "Deleted", "Failed", "Succeeded", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.ProvisioningState
    :ivar health_errors: Gets or sets the list of health errors.
    :vartype health_errors:
     list[~azure.mgmt.recoveryservicesdatareplication.models.HealthErrorModel]
    :ivar custom_properties: Fabric agent model custom properties. Required.
    :vartype custom_properties:
     ~azure.mgmt.recoveryservicesdatareplication.models.FabricAgentModelCustomProperties
    """

    correlation_id: Optional[str] = rest_field(name="correlationId", visibility=["read"])
    """Gets or sets the fabric agent correlation Id."""
    machine_id: str = rest_field(name="machineId", visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the machine Id where fabric agent is running. Required."""
    machine_name: str = rest_field(name="machineName", visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the machine name where fabric agent is running. Required."""
    authentication_identity: "_models.IdentityModel" = rest_field(
        name="authenticationIdentity", visibility=["read", "create", "update", "delete", "query"]
    )
    """Identity model. Required."""
    resource_access_identity: "_models.IdentityModel" = rest_field(
        name="resourceAccessIdentity", visibility=["read", "create", "update", "delete", "query"]
    )
    """Identity model. Required."""
    is_responsive: Optional[bool] = rest_field(name="isResponsive", visibility=["read"])
    """Gets or sets a value indicating whether the fabric agent is responsive."""
    last_heartbeat: Optional[datetime.datetime] = rest_field(
        name="lastHeartbeat", visibility=["read"], format="rfc3339"
    )
    """Gets or sets the time when last heartbeat was sent by the fabric agent."""
    version_number: Optional[str] = rest_field(name="versionNumber", visibility=["read"])
    """Gets or sets the fabric agent version."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Gets or sets the provisioning state of the fabric agent. Known values are: \"Canceled\",
     \"Creating\", \"Deleting\", \"Deleted\", \"Failed\", \"Succeeded\", and \"Updating\"."""
    health_errors: Optional[List["_models.HealthErrorModel"]] = rest_field(name="healthErrors", visibility=["read"])
    """Gets or sets the list of health errors."""
    custom_properties: "_models.FabricAgentModelCustomProperties" = rest_field(
        name="customProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Fabric agent model custom properties. Required."""

    @overload
    def __init__(
        self,
        *,
        machine_id: str,
        machine_name: str,
        authentication_identity: "_models.IdentityModel",
        resource_access_identity: "_models.IdentityModel",
        custom_properties: "_models.FabricAgentModelCustomProperties",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.recoveryservicesdatareplication.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FabricModel(TrackedResource):
    """Fabric model.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.recoveryservicesdatareplication.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.recoveryservicesdatareplication.models.FabricModelProperties
    """

    properties: Optional["_models.FabricModelProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.FabricModelProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FabricModelProperties(_Model):
    """Fabric model properties.

    :ivar provisioning_state: Gets or sets the provisioning state of the fabric. Known values are:
     "Canceled", "Creating", "Deleting", "Deleted", "Failed", "Succeeded", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.ProvisioningState
    :ivar service_endpoint: Gets or sets the service endpoint.
    :vartype service_endpoint: str
    :ivar service_resource_id: Gets or sets the service resource Id.
    :vartype service_resource_id: str
    :ivar health: Gets or sets the fabric health. Known values are: "Normal", "Warning", and
     "Critical".
    :vartype health: str or ~azure.mgmt.recoveryservicesdatareplication.models.HealthStatus
    :ivar health_errors: Gets or sets the list of health errors.
    :vartype health_errors:
     list[~azure.mgmt.recoveryservicesdatareplication.models.HealthErrorModel]
    :ivar custom_properties: Fabric model custom properties. Required.
    :vartype custom_properties:
     ~azure.mgmt.recoveryservicesdatareplication.models.FabricModelCustomProperties
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Gets or sets the provisioning state of the fabric. Known values are: \"Canceled\",
     \"Creating\", \"Deleting\", \"Deleted\", \"Failed\", \"Succeeded\", and \"Updating\"."""
    service_endpoint: Optional[str] = rest_field(name="serviceEndpoint", visibility=["read"])
    """Gets or sets the service endpoint."""
    service_resource_id: Optional[str] = rest_field(name="serviceResourceId", visibility=["read"])
    """Gets or sets the service resource Id."""
    health: Optional[Union[str, "_models.HealthStatus"]] = rest_field(visibility=["read"])
    """Gets or sets the fabric health. Known values are: \"Normal\", \"Warning\", and \"Critical\"."""
    health_errors: Optional[List["_models.HealthErrorModel"]] = rest_field(name="healthErrors", visibility=["read"])
    """Gets or sets the list of health errors."""
    custom_properties: "_models.FabricModelCustomProperties" = rest_field(
        name="customProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Fabric model custom properties. Required."""

    @overload
    def __init__(
        self,
        *,
        custom_properties: "_models.FabricModelCustomProperties",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FabricModelUpdate(_Model):
    """Fabric model update.

    :ivar tags: Gets or sets the resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: Fabric model properties.
    :vartype properties: ~azure.mgmt.recoveryservicesdatareplication.models.FabricModelProperties
    :ivar id: Gets or sets the Id of the resource.
    :vartype id: str
    :ivar name: Gets or sets the name of the resource.
    :vartype name: str
    :ivar type: Gets or sets the type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.recoveryservicesdatareplication.models.SystemData
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the resource tags."""
    properties: Optional["_models.FabricModelProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Fabric model properties."""
    id: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets the Id of the resource."""
    name: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets the name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets the type of the resource."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Metadata pertaining to creation and last modification of the resource."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.FabricModelProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class JobModelCustomProperties(_Model):
    """Job model custom properties.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    FailoverJobModelCustomProperties, TestFailoverCleanupJobModelCustomProperties,
    TestFailoverJobModelCustomProperties

    :ivar instance_type: Discriminator property for JobModelCustomProperties. Required. Default
     value is None.
    :vartype instance_type: str
    :ivar affected_object_details: Gets or sets any custom properties of the affected object.
    :vartype affected_object_details:
     ~azure.mgmt.recoveryservicesdatareplication.models.JobModelCustomPropertiesAffectedObjectDetails
    """

    __mapping__: Dict[str, _Model] = {}
    instance_type: str = rest_discriminator(name="instanceType")
    """Discriminator property for JobModelCustomProperties. Required. Default value is None."""
    affected_object_details: Optional["_models.JobModelCustomPropertiesAffectedObjectDetails"] = rest_field(
        name="affectedObjectDetails", visibility=["read"]
    )
    """Gets or sets any custom properties of the affected object."""

    @overload
    def __init__(
        self,
        *,
        instance_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FailoverJobModelCustomProperties(JobModelCustomProperties, discriminator="FailoverJobDetails"):
    """Failover job model custom properties.

    :ivar affected_object_details: Gets or sets any custom properties of the affected object.
    :vartype affected_object_details:
     ~azure.mgmt.recoveryservicesdatareplication.models.JobModelCustomPropertiesAffectedObjectDetails
    :ivar protected_item_details: Gets or sets the failed over protected item details.
    :vartype protected_item_details:
     list[~azure.mgmt.recoveryservicesdatareplication.models.FailoverProtectedItemProperties]
    :ivar instance_type: Gets or sets the instance type. Required. Default value is
     "FailoverJobDetails".
    :vartype instance_type: str
    """

    protected_item_details: Optional[List["_models.FailoverProtectedItemProperties"]] = rest_field(
        name="protectedItemDetails", visibility=["read"]
    )
    """Gets or sets the failed over protected item details."""
    instance_type: Literal["FailoverJobDetails"] = rest_discriminator(name="instanceType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Gets or sets the instance type. Required. Default value is \"FailoverJobDetails\"."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, instance_type="FailoverJobDetails", **kwargs)


class FailoverProtectedItemProperties(_Model):
    """Failover properties of the protected item.

    :ivar protected_item_name: Gets or sets the protected item name.
    :vartype protected_item_name: str
    :ivar vm_name: Gets or sets the VM name.
    :vartype vm_name: str
    :ivar test_vm_name: Gets or sets the test VM name.
    :vartype test_vm_name: str
    :ivar recovery_point_id: Gets or sets the recovery point Id.
    :vartype recovery_point_id: str
    :ivar recovery_point_time: Gets or sets the recovery point time.
    :vartype recovery_point_time: ~datetime.datetime
    :ivar network_name: Gets or sets the network name.
    :vartype network_name: str
    :ivar subnet: Gets or sets the network subnet.
    :vartype subnet: str
    """

    protected_item_name: Optional[str] = rest_field(name="protectedItemName", visibility=["read"])
    """Gets or sets the protected item name."""
    vm_name: Optional[str] = rest_field(name="vmName", visibility=["read"])
    """Gets or sets the VM name."""
    test_vm_name: Optional[str] = rest_field(name="testVmName", visibility=["read"])
    """Gets or sets the test VM name."""
    recovery_point_id: Optional[str] = rest_field(name="recoveryPointId", visibility=["read"])
    """Gets or sets the recovery point Id."""
    recovery_point_time: Optional[datetime.datetime] = rest_field(
        name="recoveryPointTime", visibility=["read"], format="rfc3339"
    )
    """Gets or sets the recovery point time."""
    network_name: Optional[str] = rest_field(name="networkName", visibility=["read"])
    """Gets or sets the network name."""
    subnet: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets the network subnet."""


class GroupConnectivityInformation(_Model):
    """Represents of a connection's group information.

    :ivar group_id: Gets or sets group id.
    :vartype group_id: str
    :ivar member_name: Gets or sets member name.
    :vartype member_name: str
    :ivar customer_visible_fqdns: Gets or sets customer visible FQDNs.
    :vartype customer_visible_fqdns: list[str]
    :ivar internal_fqdn: Gets or sets Internal Fqdn.
    :vartype internal_fqdn: str
    :ivar redirect_map_id: Gets or sets the redirect map id.
    :vartype redirect_map_id: str
    :ivar private_link_service_arm_region: Gets or sets the private link service arm region.
    :vartype private_link_service_arm_region: str
    """

    group_id: Optional[str] = rest_field(name="groupId", visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets group id."""
    member_name: Optional[str] = rest_field(
        name="memberName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets member name."""
    customer_visible_fqdns: Optional[List[str]] = rest_field(
        name="customerVisibleFqdns", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets customer visible FQDNs."""
    internal_fqdn: Optional[str] = rest_field(
        name="internalFqdn", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets Internal Fqdn."""
    redirect_map_id: Optional[str] = rest_field(
        name="redirectMapId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the redirect map id."""
    private_link_service_arm_region: Optional[str] = rest_field(
        name="privateLinkServiceArmRegion", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the private link service arm region."""

    @overload
    def __init__(
        self,
        *,
        group_id: Optional[str] = None,
        member_name: Optional[str] = None,
        customer_visible_fqdns: Optional[List[str]] = None,
        internal_fqdn: Optional[str] = None,
        redirect_map_id: Optional[str] = None,
        private_link_service_arm_region: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HealthErrorModel(_Model):
    """Health error model.

    :ivar affected_resource_type: Gets or sets the type of affected resource type.
    :vartype affected_resource_type: str
    :ivar affected_resource_correlation_ids: Gets or sets the list of affected resource correlation
     Ids. This can be used to uniquely identify the count of items affected by a specific category
     and severity as well as count of item affected by an specific issue.
    :vartype affected_resource_correlation_ids: list[str]
    :ivar child_errors: Gets or sets a list of child health errors associated with this error.
    :vartype child_errors:
     list[~azure.mgmt.recoveryservicesdatareplication.models.InnerHealthErrorModel]
    :ivar code: Gets or sets the error code.
    :vartype code: str
    :ivar health_category: Gets or sets the health category.
    :vartype health_category: str
    :ivar category: Gets or sets the error category.
    :vartype category: str
    :ivar severity: Gets or sets the error severity.
    :vartype severity: str
    :ivar source: Gets or sets the error source.
    :vartype source: str
    :ivar creation_time: Gets or sets the error creation time.
    :vartype creation_time: ~datetime.datetime
    :ivar is_customer_resolvable: Gets or sets a value indicating whether the error is customer
     resolvable.
    :vartype is_customer_resolvable: bool
    :ivar summary: Gets or sets the error summary.
    :vartype summary: str
    :ivar message: Gets or sets the error message.
    :vartype message: str
    :ivar causes: Gets or sets possible causes of the error.
    :vartype causes: str
    :ivar recommendation: Gets or sets recommended action to resolve the error.
    :vartype recommendation: str
    """

    affected_resource_type: Optional[str] = rest_field(
        name="affectedResourceType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the type of affected resource type."""
    affected_resource_correlation_ids: Optional[List[str]] = rest_field(
        name="affectedResourceCorrelationIds", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the list of affected resource correlation Ids. This can be used to uniquely
     identify the count of items affected by a specific category and severity as well as count of
     item affected by an specific issue."""
    child_errors: Optional[List["_models.InnerHealthErrorModel"]] = rest_field(
        name="childErrors", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets a list of child health errors associated with this error."""
    code: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets the error code."""
    health_category: Optional[str] = rest_field(name="healthCategory", visibility=["read"])
    """Gets or sets the health category."""
    category: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets the error category."""
    severity: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets the error severity."""
    source: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets the error source."""
    creation_time: Optional[datetime.datetime] = rest_field(name="creationTime", visibility=["read"], format="rfc3339")
    """Gets or sets the error creation time."""
    is_customer_resolvable: Optional[bool] = rest_field(name="isCustomerResolvable", visibility=["read"])
    """Gets or sets a value indicating whether the error is customer resolvable."""
    summary: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets the error summary."""
    message: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets the error message."""
    causes: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets possible causes of the error."""
    recommendation: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets recommended action to resolve the error."""

    @overload
    def __init__(
        self,
        *,
        affected_resource_type: Optional[str] = None,
        affected_resource_correlation_ids: Optional[List[str]] = None,
        child_errors: Optional[List["_models.InnerHealthErrorModel"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HyperVMigrateFabricModelCustomProperties(FabricModelCustomProperties, discriminator="HyperVMigrate"):
    """HyperV migrate fabric model custom properties.

    :ivar hyper_v_site_id: Gets or sets the ARM Id of the HyperV site. Required.
    :vartype hyper_v_site_id: str
    :ivar fabric_resource_id: Gets or sets the fabric resource Id.
    :vartype fabric_resource_id: str
    :ivar fabric_container_id: Gets or sets the fabric container Id.
    :vartype fabric_container_id: str
    :ivar migration_solution_id: Gets or sets the migration solution ARM Id. Required.
    :vartype migration_solution_id: str
    :ivar migration_hub_uri: Gets or sets the migration hub Uri.
    :vartype migration_hub_uri: str
    :ivar instance_type: Gets or sets the instance type. Required. Default value is
     "HyperVMigrate".
    :vartype instance_type: str
    """

    hyper_v_site_id: str = rest_field(name="hyperVSiteId", visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the ARM Id of the HyperV site. Required."""
    fabric_resource_id: Optional[str] = rest_field(name="fabricResourceId", visibility=["read"])
    """Gets or sets the fabric resource Id."""
    fabric_container_id: Optional[str] = rest_field(name="fabricContainerId", visibility=["read"])
    """Gets or sets the fabric container Id."""
    migration_solution_id: str = rest_field(
        name="migrationSolutionId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the migration solution ARM Id. Required."""
    migration_hub_uri: Optional[str] = rest_field(name="migrationHubUri", visibility=["read"])
    """Gets or sets the migration hub Uri."""
    instance_type: Literal["HyperVMigrate"] = rest_discriminator(name="instanceType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Gets or sets the instance type. Required. Default value is \"HyperVMigrate\"."""

    @overload
    def __init__(
        self,
        *,
        hyper_v_site_id: str,
        migration_solution_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, instance_type="HyperVMigrate", **kwargs)


class HyperVToAzStackHCIDiskInput(_Model):
    """HyperVToAzStack disk input.

    :ivar disk_id: Gets or sets the disk Id. Required.
    :vartype disk_id: str
    :ivar storage_container_id: Gets or sets the target storage account ARM Id.
    :vartype storage_container_id: str
    :ivar is_dynamic: Gets or sets a value indicating whether dynamic sizing is enabled on the
     virtual hard disk.
    :vartype is_dynamic: bool
    :ivar disk_size_gb: Gets or sets the disk size in GB. Required.
    :vartype disk_size_gb: int
    :ivar disk_file_format: Gets or sets the type of the virtual hard disk, vhd or vhdx. Required.
    :vartype disk_file_format: str
    :ivar is_os_disk: Gets or sets a value indicating whether disk is os disk. Required.
    :vartype is_os_disk: bool
    :ivar disk_block_size: Gets or sets a value of disk block size.
    :vartype disk_block_size: int
    :ivar disk_logical_sector_size: Gets or sets a value of disk logical sector size.
    :vartype disk_logical_sector_size: int
    :ivar disk_physical_sector_size: Gets or sets a value of disk physical sector size.
    :vartype disk_physical_sector_size: int
    :ivar disk_identifier: Gets or sets a value of disk identifier.
    :vartype disk_identifier: str
    :ivar disk_controller: Disk controller.
    :vartype disk_controller:
     ~azure.mgmt.recoveryservicesdatareplication.models.DiskControllerInputs
    """

    disk_id: str = rest_field(name="diskId", visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the disk Id. Required."""
    storage_container_id: Optional[str] = rest_field(
        name="storageContainerId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the target storage account ARM Id."""
    is_dynamic: Optional[bool] = rest_field(
        name="isDynamic", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets a value indicating whether dynamic sizing is enabled on the virtual hard disk."""
    disk_size_gb: int = rest_field(name="diskSizeGB", visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the disk size in GB. Required."""
    disk_file_format: str = rest_field(
        name="diskFileFormat", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the type of the virtual hard disk, vhd or vhdx. Required."""
    is_os_disk: bool = rest_field(name="isOsDisk", visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets a value indicating whether disk is os disk. Required."""
    disk_block_size: Optional[int] = rest_field(
        name="diskBlockSize", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets a value of disk block size."""
    disk_logical_sector_size: Optional[int] = rest_field(
        name="diskLogicalSectorSize", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets a value of disk logical sector size."""
    disk_physical_sector_size: Optional[int] = rest_field(
        name="diskPhysicalSectorSize", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets a value of disk physical sector size."""
    disk_identifier: Optional[str] = rest_field(
        name="diskIdentifier", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets a value of disk identifier."""
    disk_controller: Optional["_models.DiskControllerInputs"] = rest_field(
        name="diskController", visibility=["read", "create", "update", "delete", "query"]
    )
    """Disk controller."""

    @overload
    def __init__(
        self,
        *,
        disk_id: str,
        disk_size_gb: int,
        disk_file_format: str,
        is_os_disk: bool,
        storage_container_id: Optional[str] = None,
        is_dynamic: Optional[bool] = None,
        disk_block_size: Optional[int] = None,
        disk_logical_sector_size: Optional[int] = None,
        disk_physical_sector_size: Optional[int] = None,
        disk_identifier: Optional[str] = None,
        disk_controller: Optional["_models.DiskControllerInputs"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HyperVToAzStackHCIEventModelCustomProperties(
    EventModelCustomProperties, discriminator="HyperVToAzStackHCI"
):  # pylint: disable=name-too-long
    """HyperV to  AzStackHCI event model custom properties. This class provides provider specific
    details for events of type DataContract.HealthEvents.HealthEventType.ProtectedItemHealth and
    DataContract.HealthEvents.HealthEventType.AgentHealth.

    :ivar event_source_friendly_name: Gets or sets the friendly name of the source which has raised
     this health event.
    :vartype event_source_friendly_name: str
    :ivar protected_item_friendly_name: Gets or sets the protected item friendly name.
    :vartype protected_item_friendly_name: str
    :ivar source_appliance_name: Gets or sets the source appliance name.
    :vartype source_appliance_name: str
    :ivar target_appliance_name: Gets or sets the source target name.
    :vartype target_appliance_name: str
    :ivar server_type: Gets or sets the server type.
    :vartype server_type: str
    :ivar instance_type: Gets or sets the instance type. Required. Default value is
     "HyperVToAzStackHCI".
    :vartype instance_type: str
    """

    event_source_friendly_name: Optional[str] = rest_field(name="eventSourceFriendlyName", visibility=["read"])
    """Gets or sets the friendly name of the source which has raised this health event."""
    protected_item_friendly_name: Optional[str] = rest_field(name="protectedItemFriendlyName", visibility=["read"])
    """Gets or sets the protected item friendly name."""
    source_appliance_name: Optional[str] = rest_field(name="sourceApplianceName", visibility=["read"])
    """Gets or sets the source appliance name."""
    target_appliance_name: Optional[str] = rest_field(name="targetApplianceName", visibility=["read"])
    """Gets or sets the source target name."""
    server_type: Optional[str] = rest_field(name="serverType", visibility=["read"])
    """Gets or sets the server type."""
    instance_type: Literal["HyperVToAzStackHCI"] = rest_discriminator(name="instanceType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Gets or sets the instance type. Required. Default value is \"HyperVToAzStackHCI\"."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, instance_type="HyperVToAzStackHCI", **kwargs)


class HyperVToAzStackHCINicInput(_Model):
    """HyperVToAzStackHCI NIC properties.

    :ivar nic_id: Gets or sets the NIC Id. Required.
    :vartype nic_id: str
    :ivar network_name: Gets or sets the network name.
    :vartype network_name: str
    :ivar target_network_id: Gets or sets the target network Id within AzStackHCI Cluster.
    :vartype target_network_id: str
    :ivar test_network_id: Gets or sets the target test network Id within AzStackHCI Cluster.
    :vartype test_network_id: str
    :ivar selection_type_for_failover: Gets or sets the selection type of the NIC. Required. Known
     values are: "NotSelected", "SelectedByUser", "SelectedByDefault", and "SelectedByUserOverride".
    :vartype selection_type_for_failover: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.VMNicSelection
    :ivar is_static_ip_migration_enabled: Gets or sets a value indicating whether static ip
     migration is enabled.
    :vartype is_static_ip_migration_enabled: bool
    :ivar is_mac_migration_enabled: Gets or sets a value indicating whether mac address migration
     is enabled.
    :vartype is_mac_migration_enabled: bool
    """

    nic_id: str = rest_field(name="nicId", visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the NIC Id. Required."""
    network_name: Optional[str] = rest_field(name="networkName", visibility=["read"])
    """Gets or sets the network name."""
    target_network_id: Optional[str] = rest_field(
        name="targetNetworkId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the target network Id within AzStackHCI Cluster."""
    test_network_id: Optional[str] = rest_field(
        name="testNetworkId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the target test network Id within AzStackHCI Cluster."""
    selection_type_for_failover: Union[str, "_models.VMNicSelection"] = rest_field(
        name="selectionTypeForFailover", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the selection type of the NIC. Required. Known values are: \"NotSelected\",
     \"SelectedByUser\", \"SelectedByDefault\", and \"SelectedByUserOverride\"."""
    is_static_ip_migration_enabled: Optional[bool] = rest_field(
        name="isStaticIpMigrationEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets a value indicating whether static ip migration is enabled."""
    is_mac_migration_enabled: Optional[bool] = rest_field(
        name="isMacMigrationEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets a value indicating whether mac address migration is enabled."""

    @overload
    def __init__(
        self,
        *,
        nic_id: str,
        selection_type_for_failover: Union[str, "_models.VMNicSelection"],
        target_network_id: Optional[str] = None,
        test_network_id: Optional[str] = None,
        is_static_ip_migration_enabled: Optional[bool] = None,
        is_mac_migration_enabled: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PlannedFailoverModelCustomProperties(_Model):
    """Planned failover model custom properties.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    HyperVToAzStackHCIPlannedFailoverModelCustomProperties,
    VMwareToAzStackHCIPlannedFailoverModelCustomProperties

    :ivar instance_type: Discriminator property for PlannedFailoverModelCustomProperties. Required.
     Default value is None.
    :vartype instance_type: str
    """

    __mapping__: Dict[str, _Model] = {}
    instance_type: str = rest_discriminator(name="instanceType")
    """Discriminator property for PlannedFailoverModelCustomProperties. Required. Default value is
     None."""

    @overload
    def __init__(
        self,
        *,
        instance_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HyperVToAzStackHCIPlannedFailoverModelCustomProperties(
    PlannedFailoverModelCustomProperties, discriminator="HyperVToAzStackHCI"
):  # pylint: disable=name-too-long
    """HyperV to AzStackHCI planned failover model custom properties.

    :ivar shutdown_source_vm: Gets or sets a value indicating whether VM needs to be shut down.
     Required.
    :vartype shutdown_source_vm: bool
    :ivar instance_type: Gets or sets the instance type. Required. Default value is
     "HyperVToAzStackHCI".
    :vartype instance_type: str
    """

    shutdown_source_vm: bool = rest_field(
        name="shutdownSourceVM", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets a value indicating whether VM needs to be shut down. Required."""
    instance_type: Literal["HyperVToAzStackHCI"] = rest_discriminator(name="instanceType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Gets or sets the instance type. Required. Default value is \"HyperVToAzStackHCI\"."""

    @overload
    def __init__(
        self,
        *,
        shutdown_source_vm: bool,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, instance_type="HyperVToAzStackHCI", **kwargs)


class PolicyModelCustomProperties(_Model):
    """Policy model custom properties.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    HyperVToAzStackHCIPolicyModelCustomProperties, VMwareToAzStackHCIPolicyModelCustomProperties

    :ivar instance_type: Discriminator property for PolicyModelCustomProperties. Required. Default
     value is None.
    :vartype instance_type: str
    """

    __mapping__: Dict[str, _Model] = {}
    instance_type: str = rest_discriminator(name="instanceType")
    """Discriminator property for PolicyModelCustomProperties. Required. Default value is None."""

    @overload
    def __init__(
        self,
        *,
        instance_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HyperVToAzStackHCIPolicyModelCustomProperties(
    PolicyModelCustomProperties, discriminator="HyperVToAzStackHCI"
):  # pylint: disable=name-too-long
    """HyperV To AzStackHCI Policy model custom properties.

    :ivar recovery_point_history_in_minutes: Gets or sets the duration in minutes until which the
     recovery points need to be stored. Required.
    :vartype recovery_point_history_in_minutes: int
    :ivar crash_consistent_frequency_in_minutes: Gets or sets the crash consistent snapshot
     frequency (in minutes). Required.
    :vartype crash_consistent_frequency_in_minutes: int
    :ivar app_consistent_frequency_in_minutes: Gets or sets the app consistent snapshot frequency
     (in minutes). Required.
    :vartype app_consistent_frequency_in_minutes: int
    :ivar instance_type: Gets or sets the instance type. Required. Default value is
     "HyperVToAzStackHCI".
    :vartype instance_type: str
    """

    recovery_point_history_in_minutes: int = rest_field(
        name="recoveryPointHistoryInMinutes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the duration in minutes until which the recovery points need to be stored.
     Required."""
    crash_consistent_frequency_in_minutes: int = rest_field(
        name="crashConsistentFrequencyInMinutes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the crash consistent snapshot frequency (in minutes). Required."""
    app_consistent_frequency_in_minutes: int = rest_field(
        name="appConsistentFrequencyInMinutes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the app consistent snapshot frequency (in minutes). Required."""
    instance_type: Literal["HyperVToAzStackHCI"] = rest_discriminator(name="instanceType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Gets or sets the instance type. Required. Default value is \"HyperVToAzStackHCI\"."""

    @overload
    def __init__(
        self,
        *,
        recovery_point_history_in_minutes: int,
        crash_consistent_frequency_in_minutes: int,
        app_consistent_frequency_in_minutes: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, instance_type="HyperVToAzStackHCI", **kwargs)


class HyperVToAzStackHCIProtectedDiskProperties(_Model):  # pylint: disable=name-too-long
    """HyperVToAzStackHCI protected disk properties.

    :ivar storage_container_id: Gets or sets the ARM Id of the storage container.
    :vartype storage_container_id: str
    :ivar storage_container_local_path: Gets or sets the local path of the storage container.
    :vartype storage_container_local_path: str
    :ivar source_disk_id: Gets or sets the source disk Id.
    :vartype source_disk_id: str
    :ivar source_disk_name: Gets or sets the source disk Name.
    :vartype source_disk_name: str
    :ivar seed_disk_name: Gets or sets the seed disk name.
    :vartype seed_disk_name: str
    :ivar test_migrate_disk_name: Gets or sets the test failover clone disk.
    :vartype test_migrate_disk_name: str
    :ivar migrate_disk_name: Gets or sets the failover clone disk.
    :vartype migrate_disk_name: str
    :ivar is_os_disk: Gets or sets a value indicating whether the disk is the OS disk.
    :vartype is_os_disk: bool
    :ivar capacity_in_bytes: Gets or sets the disk capacity in bytes.
    :vartype capacity_in_bytes: int
    :ivar is_dynamic: Gets or sets a value indicating whether dynamic sizing is enabled on the
     virtual hard disk.
    :vartype is_dynamic: bool
    :ivar disk_type: Gets or sets the disk type.
    :vartype disk_type: str
    :ivar disk_block_size: Gets or sets a value of disk block size.
    :vartype disk_block_size: int
    :ivar disk_logical_sector_size: Gets or sets a value of disk logical sector size.
    :vartype disk_logical_sector_size: int
    :ivar disk_physical_sector_size: Gets or sets a value of disk physical sector size.
    :vartype disk_physical_sector_size: int
    """

    storage_container_id: Optional[str] = rest_field(name="storageContainerId", visibility=["read"])
    """Gets or sets the ARM Id of the storage container."""
    storage_container_local_path: Optional[str] = rest_field(name="storageContainerLocalPath", visibility=["read"])
    """Gets or sets the local path of the storage container."""
    source_disk_id: Optional[str] = rest_field(name="sourceDiskId", visibility=["read"])
    """Gets or sets the source disk Id."""
    source_disk_name: Optional[str] = rest_field(name="sourceDiskName", visibility=["read"])
    """Gets or sets the source disk Name."""
    seed_disk_name: Optional[str] = rest_field(name="seedDiskName", visibility=["read"])
    """Gets or sets the seed disk name."""
    test_migrate_disk_name: Optional[str] = rest_field(name="testMigrateDiskName", visibility=["read"])
    """Gets or sets the test failover clone disk."""
    migrate_disk_name: Optional[str] = rest_field(name="migrateDiskName", visibility=["read"])
    """Gets or sets the failover clone disk."""
    is_os_disk: Optional[bool] = rest_field(name="isOsDisk", visibility=["read"])
    """Gets or sets a value indicating whether the disk is the OS disk."""
    capacity_in_bytes: Optional[int] = rest_field(name="capacityInBytes", visibility=["read"])
    """Gets or sets the disk capacity in bytes."""
    is_dynamic: Optional[bool] = rest_field(name="isDynamic", visibility=["read"])
    """Gets or sets a value indicating whether dynamic sizing is enabled on the virtual hard disk."""
    disk_type: Optional[str] = rest_field(name="diskType", visibility=["read"])
    """Gets or sets the disk type."""
    disk_block_size: Optional[int] = rest_field(name="diskBlockSize", visibility=["read"])
    """Gets or sets a value of disk block size."""
    disk_logical_sector_size: Optional[int] = rest_field(name="diskLogicalSectorSize", visibility=["read"])
    """Gets or sets a value of disk logical sector size."""
    disk_physical_sector_size: Optional[int] = rest_field(name="diskPhysicalSectorSize", visibility=["read"])
    """Gets or sets a value of disk physical sector size."""


class ProtectedItemModelCustomProperties(_Model):
    """Protected item model custom properties.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    HyperVToAzStackHCIProtectedItemModelCustomProperties,
    VMwareToAzStackHCIProtectedItemModelCustomProperties

    :ivar instance_type: Discriminator property for ProtectedItemModelCustomProperties. Required.
     Default value is None.
    :vartype instance_type: str
    """

    __mapping__: Dict[str, _Model] = {}
    instance_type: str = rest_discriminator(name="instanceType")
    """Discriminator property for ProtectedItemModelCustomProperties. Required. Default value is None."""

    @overload
    def __init__(
        self,
        *,
        instance_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HyperVToAzStackHCIProtectedItemModelCustomProperties(
    ProtectedItemModelCustomProperties, discriminator="HyperVToAzStackHCI"
):  # pylint: disable=name-too-long
    """HyperV to AzStackHCI Protected item model custom properties.

    :ivar active_location: Gets or sets the location of the protected item. Known values are:
     "Primary" and "Recovery".
    :vartype active_location: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.ProtectedItemActiveLocation
    :ivar target_hci_cluster_id: Gets or sets the Target HCI Cluster ARM Id. Required.
    :vartype target_hci_cluster_id: str
    :ivar target_arc_cluster_custom_location_id: Gets or sets the Target Arc Cluster Custom
     Location ARM Id. Required.
    :vartype target_arc_cluster_custom_location_id: str
    :ivar target_az_stack_hci_cluster_name: Gets or sets the Target AzStackHCI cluster name.
    :vartype target_az_stack_hci_cluster_name: str
    :ivar fabric_discovery_machine_id: Gets or sets the ARM Id of the discovered machine. Required.
    :vartype fabric_discovery_machine_id: str
    :ivar disks_to_include: Gets or sets the list of disks to replicate. Required.
    :vartype disks_to_include:
     list[~azure.mgmt.recoveryservicesdatareplication.models.HyperVToAzStackHCIDiskInput]
    :ivar nics_to_include: Gets or sets the list of VM NIC to replicate. Required.
    :vartype nics_to_include:
     list[~azure.mgmt.recoveryservicesdatareplication.models.HyperVToAzStackHCINicInput]
    :ivar source_vm_name: Gets or sets the source VM display name.
    :vartype source_vm_name: str
    :ivar source_cpu_cores: Gets or sets the source VM CPU cores.
    :vartype source_cpu_cores: int
    :ivar source_memory_in_mega_bytes: Gets or sets the source VM ram memory size in megabytes.
    :vartype source_memory_in_mega_bytes: float
    :ivar target_vm_name: Gets or sets the target VM display name.
    :vartype target_vm_name: str
    :ivar target_resource_group_id: Gets or sets the target resource group ARM Id. Required.
    :vartype target_resource_group_id: str
    :ivar storage_container_id: Gets or sets the target storage container ARM Id. Required.
    :vartype storage_container_id: str
    :ivar hyper_v_generation: Gets or sets the hypervisor generation of the virtual machine.
     Required.
    :vartype hyper_v_generation: str
    :ivar target_network_id: Gets or sets the target network Id within AzStackHCI Cluster.
    :vartype target_network_id: str
    :ivar test_network_id: Gets or sets the target test network Id within AzStackHCI Cluster.
    :vartype test_network_id: str
    :ivar target_cpu_cores: Gets or sets the target CPU cores.
    :vartype target_cpu_cores: int
    :ivar is_dynamic_ram: Gets or sets a value indicating whether memory is dynamical.
    :vartype is_dynamic_ram: bool
    :ivar dynamic_memory_config: Protected item dynamic memory config.
    :vartype dynamic_memory_config:
     ~azure.mgmt.recoveryservicesdatareplication.models.ProtectedItemDynamicMemoryConfig
    :ivar target_memory_in_mega_bytes: Gets or sets the target memory in mega-bytes.
    :vartype target_memory_in_mega_bytes: int
    :ivar run_as_account_id: Gets or sets the Run As account Id. Required.
    :vartype run_as_account_id: str
    :ivar source_fabric_agent_name: Gets or sets the source fabric agent name. Required.
    :vartype source_fabric_agent_name: str
    :ivar target_fabric_agent_name: Gets or sets the target fabric agent name. Required.
    :vartype target_fabric_agent_name: str
    :ivar source_appliance_name: Gets or sets the source appliance name.
    :vartype source_appliance_name: str
    :ivar target_appliance_name: Gets or sets the target appliance name.
    :vartype target_appliance_name: str
    :ivar os_type: Gets or sets the type of the OS.
    :vartype os_type: str
    :ivar os_name: Gets or sets the name of the OS.
    :vartype os_name: str
    :ivar firmware_type: Gets or sets the firmware type.
    :vartype firmware_type: str
    :ivar target_location: Gets or sets the target location.
    :vartype target_location: str
    :ivar custom_location_region: Gets or sets the location of Azure Arc HCI custom location
     resource. Required.
    :vartype custom_location_region: str
    :ivar failover_recovery_point_id: Gets or sets the recovery point Id to which the VM was failed
     over.
    :vartype failover_recovery_point_id: str
    :ivar last_recovery_point_received: Gets or sets the last recovery point received time.
    :vartype last_recovery_point_received: ~datetime.datetime
    :ivar last_recovery_point_id: Gets or sets the last recovery point Id.
    :vartype last_recovery_point_id: str
    :ivar initial_replication_progress_percentage: Gets or sets the initial replication progress
     percentage. This is calculated based on total bytes processed for all disks in the source VM.
    :vartype initial_replication_progress_percentage: int
    :ivar resync_progress_percentage: Gets or sets the resync progress percentage. This is
     calculated based on total bytes processed for all disks in the source VM.
    :vartype resync_progress_percentage: int
    :ivar protected_disks: Gets or sets the list of protected disks.
    :vartype protected_disks:
     list[~azure.mgmt.recoveryservicesdatareplication.models.HyperVToAzStackHCIProtectedDiskProperties]
    :ivar protected_nics: Gets or sets the VM NIC details.
    :vartype protected_nics:
     list[~azure.mgmt.recoveryservicesdatareplication.models.HyperVToAzStackHCIProtectedNicProperties]
    :ivar target_vm_bios_id: Gets or sets the BIOS Id of the target AzStackHCI VM.
    :vartype target_vm_bios_id: str
    :ivar last_replication_update_time: Gets or sets the latest timestamp that replication status
     is updated.
    :vartype last_replication_update_time: ~datetime.datetime
    :ivar instance_type: Gets or sets the instance type. Required. Default value is
     "HyperVToAzStackHCI".
    :vartype instance_type: str
    """

    active_location: Optional[Union[str, "_models.ProtectedItemActiveLocation"]] = rest_field(
        name="activeLocation", visibility=["read"]
    )
    """Gets or sets the location of the protected item. Known values are: \"Primary\" and
     \"Recovery\"."""
    target_hci_cluster_id: str = rest_field(
        name="targetHciClusterId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the Target HCI Cluster ARM Id. Required."""
    target_arc_cluster_custom_location_id: str = rest_field(
        name="targetArcClusterCustomLocationId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the Target Arc Cluster Custom Location ARM Id. Required."""
    target_az_stack_hci_cluster_name: Optional[str] = rest_field(
        name="targetAzStackHciClusterName", visibility=["read"]
    )
    """Gets or sets the Target AzStackHCI cluster name."""
    fabric_discovery_machine_id: str = rest_field(
        name="fabricDiscoveryMachineId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the ARM Id of the discovered machine. Required."""
    disks_to_include: List["_models.HyperVToAzStackHCIDiskInput"] = rest_field(
        name="disksToInclude", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the list of disks to replicate. Required."""
    nics_to_include: List["_models.HyperVToAzStackHCINicInput"] = rest_field(
        name="nicsToInclude", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the list of VM NIC to replicate. Required."""
    source_vm_name: Optional[str] = rest_field(name="sourceVmName", visibility=["read"])
    """Gets or sets the source VM display name."""
    source_cpu_cores: Optional[int] = rest_field(name="sourceCpuCores", visibility=["read"])
    """Gets or sets the source VM CPU cores."""
    source_memory_in_mega_bytes: Optional[float] = rest_field(name="sourceMemoryInMegaBytes", visibility=["read"])
    """Gets or sets the source VM ram memory size in megabytes."""
    target_vm_name: Optional[str] = rest_field(
        name="targetVmName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the target VM display name."""
    target_resource_group_id: str = rest_field(
        name="targetResourceGroupId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the target resource group ARM Id. Required."""
    storage_container_id: str = rest_field(
        name="storageContainerId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the target storage container ARM Id. Required."""
    hyper_v_generation: str = rest_field(
        name="hyperVGeneration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the hypervisor generation of the virtual machine. Required."""
    target_network_id: Optional[str] = rest_field(
        name="targetNetworkId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the target network Id within AzStackHCI Cluster."""
    test_network_id: Optional[str] = rest_field(
        name="testNetworkId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the target test network Id within AzStackHCI Cluster."""
    target_cpu_cores: Optional[int] = rest_field(
        name="targetCpuCores", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the target CPU cores."""
    is_dynamic_ram: Optional[bool] = rest_field(
        name="isDynamicRam", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets a value indicating whether memory is dynamical."""
    dynamic_memory_config: Optional["_models.ProtectedItemDynamicMemoryConfig"] = rest_field(
        name="dynamicMemoryConfig", visibility=["read", "create", "update", "delete", "query"]
    )
    """Protected item dynamic memory config."""
    target_memory_in_mega_bytes: Optional[int] = rest_field(
        name="targetMemoryInMegaBytes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the target memory in mega-bytes."""
    run_as_account_id: str = rest_field(
        name="runAsAccountId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the Run As account Id. Required."""
    source_fabric_agent_name: str = rest_field(
        name="sourceFabricAgentName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the source fabric agent name. Required."""
    target_fabric_agent_name: str = rest_field(
        name="targetFabricAgentName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the target fabric agent name. Required."""
    source_appliance_name: Optional[str] = rest_field(name="sourceApplianceName", visibility=["read"])
    """Gets or sets the source appliance name."""
    target_appliance_name: Optional[str] = rest_field(name="targetApplianceName", visibility=["read"])
    """Gets or sets the target appliance name."""
    os_type: Optional[str] = rest_field(name="osType", visibility=["read"])
    """Gets or sets the type of the OS."""
    os_name: Optional[str] = rest_field(name="osName", visibility=["read"])
    """Gets or sets the name of the OS."""
    firmware_type: Optional[str] = rest_field(name="firmwareType", visibility=["read"])
    """Gets or sets the firmware type."""
    target_location: Optional[str] = rest_field(name="targetLocation", visibility=["read"])
    """Gets or sets the target location."""
    custom_location_region: str = rest_field(
        name="customLocationRegion", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the location of Azure Arc HCI custom location resource. Required."""
    failover_recovery_point_id: Optional[str] = rest_field(name="failoverRecoveryPointId", visibility=["read"])
    """Gets or sets the recovery point Id to which the VM was failed over."""
    last_recovery_point_received: Optional[datetime.datetime] = rest_field(
        name="lastRecoveryPointReceived", visibility=["read"], format="rfc3339"
    )
    """Gets or sets the last recovery point received time."""
    last_recovery_point_id: Optional[str] = rest_field(name="lastRecoveryPointId", visibility=["read"])
    """Gets or sets the last recovery point Id."""
    initial_replication_progress_percentage: Optional[int] = rest_field(
        name="initialReplicationProgressPercentage", visibility=["read"]
    )
    """Gets or sets the initial replication progress percentage. This is calculated based on total
     bytes processed for all disks in the source VM."""
    resync_progress_percentage: Optional[int] = rest_field(name="resyncProgressPercentage", visibility=["read"])
    """Gets or sets the resync progress percentage. This is calculated based on total bytes processed
     for all disks in the source VM."""
    protected_disks: Optional[List["_models.HyperVToAzStackHCIProtectedDiskProperties"]] = rest_field(
        name="protectedDisks", visibility=["read"]
    )
    """Gets or sets the list of protected disks."""
    protected_nics: Optional[List["_models.HyperVToAzStackHCIProtectedNicProperties"]] = rest_field(
        name="protectedNics", visibility=["read"]
    )
    """Gets or sets the VM NIC details."""
    target_vm_bios_id: Optional[str] = rest_field(name="targetVmBiosId", visibility=["read"])
    """Gets or sets the BIOS Id of the target AzStackHCI VM."""
    last_replication_update_time: Optional[datetime.datetime] = rest_field(
        name="lastReplicationUpdateTime", visibility=["read"], format="rfc3339"
    )
    """Gets or sets the latest timestamp that replication status is updated."""
    instance_type: Literal["HyperVToAzStackHCI"] = rest_discriminator(name="instanceType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Gets or sets the instance type. Required. Default value is \"HyperVToAzStackHCI\"."""

    @overload
    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        target_hci_cluster_id: str,
        target_arc_cluster_custom_location_id: str,
        fabric_discovery_machine_id: str,
        disks_to_include: List["_models.HyperVToAzStackHCIDiskInput"],
        nics_to_include: List["_models.HyperVToAzStackHCINicInput"],
        target_resource_group_id: str,
        storage_container_id: str,
        hyper_v_generation: str,
        run_as_account_id: str,
        source_fabric_agent_name: str,
        target_fabric_agent_name: str,
        custom_location_region: str,
        target_vm_name: Optional[str] = None,
        target_network_id: Optional[str] = None,
        test_network_id: Optional[str] = None,
        target_cpu_cores: Optional[int] = None,
        is_dynamic_ram: Optional[bool] = None,
        dynamic_memory_config: Optional["_models.ProtectedItemDynamicMemoryConfig"] = None,
        target_memory_in_mega_bytes: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, instance_type="HyperVToAzStackHCI", **kwargs)


class ProtectedItemModelCustomPropertiesUpdate(_Model):
    """Protected item model custom properties.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    HyperVToAzStackHCIProtectedItemModelCustomPropertiesUpdate,
    VMwareToAzStackHCIProtectedItemModelCustomPropertiesUpdate

    :ivar instance_type: Discriminator property for ProtectedItemModelCustomPropertiesUpdate.
     Required. Default value is None.
    :vartype instance_type: str
    """

    __mapping__: Dict[str, _Model] = {}
    instance_type: str = rest_discriminator(name="instanceType")
    """Discriminator property for ProtectedItemModelCustomPropertiesUpdate. Required. Default value is
     None."""

    @overload
    def __init__(
        self,
        *,
        instance_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HyperVToAzStackHCIProtectedItemModelCustomPropertiesUpdate(
    ProtectedItemModelCustomPropertiesUpdate, discriminator="HyperVToAzStackHCI"
):  # pylint: disable=name-too-long
    """HyperV to AzStackHCI Protected item model custom properties.

    :ivar nics_to_include: Gets or sets the list of VM NIC to replicate.
    :vartype nics_to_include:
     list[~azure.mgmt.recoveryservicesdatareplication.models.HyperVToAzStackHCINicInput]
    :ivar target_cpu_cores: Gets or sets the target CPU cores.
    :vartype target_cpu_cores: int
    :ivar is_dynamic_ram: Gets or sets a value indicating whether memory is dynamical.
    :vartype is_dynamic_ram: bool
    :ivar dynamic_memory_config: Protected item dynamic memory config.
    :vartype dynamic_memory_config:
     ~azure.mgmt.recoveryservicesdatareplication.models.ProtectedItemDynamicMemoryConfig
    :ivar target_memory_in_mega_bytes: Gets or sets the target memory in mega-bytes.
    :vartype target_memory_in_mega_bytes: int
    :ivar instance_type: Gets or sets the instance type. Required. Default value is
     "HyperVToAzStackHCI".
    :vartype instance_type: str
    :ivar os_type: Gets or sets the type of the OS.
    :vartype os_type: str
    """

    nics_to_include: Optional[List["_models.HyperVToAzStackHCINicInput"]] = rest_field(
        name="nicsToInclude", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the list of VM NIC to replicate."""
    target_cpu_cores: Optional[int] = rest_field(
        name="targetCpuCores", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the target CPU cores."""
    is_dynamic_ram: Optional[bool] = rest_field(
        name="isDynamicRam", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets a value indicating whether memory is dynamical."""
    dynamic_memory_config: Optional["_models.ProtectedItemDynamicMemoryConfig"] = rest_field(
        name="dynamicMemoryConfig", visibility=["read", "create", "update", "delete", "query"]
    )
    """Protected item dynamic memory config."""
    target_memory_in_mega_bytes: Optional[int] = rest_field(
        name="targetMemoryInMegaBytes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the target memory in mega-bytes."""
    instance_type: Literal["HyperVToAzStackHCI"] = rest_discriminator(name="instanceType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Gets or sets the instance type. Required. Default value is \"HyperVToAzStackHCI\"."""
    os_type: Optional[str] = rest_field(name="osType", visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the type of the OS."""

    @overload
    def __init__(
        self,
        *,
        nics_to_include: Optional[List["_models.HyperVToAzStackHCINicInput"]] = None,
        target_cpu_cores: Optional[int] = None,
        is_dynamic_ram: Optional[bool] = None,
        dynamic_memory_config: Optional["_models.ProtectedItemDynamicMemoryConfig"] = None,
        target_memory_in_mega_bytes: Optional[int] = None,
        os_type: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, instance_type="HyperVToAzStackHCI", **kwargs)


class HyperVToAzStackHCIProtectedNicProperties(_Model):
    """HyperVToAzStackHCI NIC properties.

    :ivar nic_id: Gets or sets the NIC Id.
    :vartype nic_id: str
    :ivar mac_address: Gets or sets the NIC mac address.
    :vartype mac_address: str
    :ivar network_name: Gets or sets the network name.
    :vartype network_name: str
    :ivar target_network_id: Gets or sets the target network Id within AzStackHCI Cluster.
    :vartype target_network_id: str
    :ivar test_network_id: Gets or sets the target test network Id within AzStackHCI Cluster.
    :vartype test_network_id: str
    :ivar selection_type_for_failover: Gets or sets the selection type of the NIC. Known values
     are: "NotSelected", "SelectedByUser", "SelectedByDefault", and "SelectedByUserOverride".
    :vartype selection_type_for_failover: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.VMNicSelection
    """

    nic_id: Optional[str] = rest_field(name="nicId", visibility=["read"])
    """Gets or sets the NIC Id."""
    mac_address: Optional[str] = rest_field(name="macAddress", visibility=["read"])
    """Gets or sets the NIC mac address."""
    network_name: Optional[str] = rest_field(name="networkName", visibility=["read"])
    """Gets or sets the network name."""
    target_network_id: Optional[str] = rest_field(name="targetNetworkId", visibility=["read"])
    """Gets or sets the target network Id within AzStackHCI Cluster."""
    test_network_id: Optional[str] = rest_field(name="testNetworkId", visibility=["read"])
    """Gets or sets the target test network Id within AzStackHCI Cluster."""
    selection_type_for_failover: Optional[Union[str, "_models.VMNicSelection"]] = rest_field(
        name="selectionTypeForFailover", visibility=["read"]
    )
    """Gets or sets the selection type of the NIC. Known values are: \"NotSelected\",
     \"SelectedByUser\", \"SelectedByDefault\", and \"SelectedByUserOverride\"."""


class RecoveryPointModelCustomProperties(_Model):
    """Recovery point model custom properties.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    HyperVToAzStackHCIRecoveryPointModelCustomProperties,
    VMwareToAzStackHCIRecoveryPointModelCustomProperties

    :ivar instance_type: Discriminator property for RecoveryPointModelCustomProperties. Required.
     Default value is None.
    :vartype instance_type: str
    """

    __mapping__: Dict[str, _Model] = {}
    instance_type: str = rest_discriminator(name="instanceType")
    """Discriminator property for RecoveryPointModelCustomProperties. Required. Default value is None."""

    @overload
    def __init__(
        self,
        *,
        instance_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HyperVToAzStackHCIRecoveryPointModelCustomProperties(
    RecoveryPointModelCustomProperties, discriminator="HyperVToAzStackHCI"
):  # pylint: disable=name-too-long
    """HyperV to AzStackHCI recovery point model custom properties.

    :ivar disk_ids: Gets or sets the list of the disk Ids.
    :vartype disk_ids: list[str]
    :ivar instance_type: Gets or sets the instance type. Required. Default value is
     "HyperVToAzStackHCI".
    :vartype instance_type: str
    """

    disk_ids: Optional[List[str]] = rest_field(name="diskIds", visibility=["read"])
    """Gets or sets the list of the disk Ids."""
    instance_type: Literal["HyperVToAzStackHCI"] = rest_discriminator(name="instanceType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Gets or sets the instance type. Required. Default value is \"HyperVToAzStackHCI\"."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, instance_type="HyperVToAzStackHCI", **kwargs)


class ReplicationExtensionModelCustomProperties(_Model):  # pylint: disable=name-too-long
    """Replication extension model custom properties.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    HyperVToAzStackHCIReplicationExtensionModelCustomProperties,
    VMwareToAzStackHCIReplicationExtensionModelCustomProperties

    :ivar instance_type: Discriminator property for ReplicationExtensionModelCustomProperties.
     Required. Default value is None.
    :vartype instance_type: str
    """

    __mapping__: Dict[str, _Model] = {}
    instance_type: str = rest_discriminator(name="instanceType")
    """Discriminator property for ReplicationExtensionModelCustomProperties. Required. Default value
     is None."""

    @overload
    def __init__(
        self,
        *,
        instance_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HyperVToAzStackHCIReplicationExtensionModelCustomProperties(
    ReplicationExtensionModelCustomProperties, discriminator="HyperVToAzStackHCI"
):  # pylint: disable=name-too-long
    """HyperV to AzStackHCI Replication extension model custom properties.

    :ivar hyper_v_fabric_arm_id: Gets or sets the ARM Id of the source HyperV fabric. Required.
    :vartype hyper_v_fabric_arm_id: str
    :ivar hyper_v_site_id: Gets or sets the ARM Id of the HyperV site.
    :vartype hyper_v_site_id: str
    :ivar az_stack_hci_fabric_arm_id: Gets or sets the ARM Id of the target AzStackHCI fabric.
     Required.
    :vartype az_stack_hci_fabric_arm_id: str
    :ivar az_stack_hci_site_id: Gets or sets the ARM Id of the AzStackHCI site.
    :vartype az_stack_hci_site_id: str
    :ivar storage_account_id: Gets or sets the storage account Id.
    :vartype storage_account_id: str
    :ivar storage_account_sas_secret_name: Gets or sets the Sas Secret of storage account.
    :vartype storage_account_sas_secret_name: str
    :ivar asr_service_uri: Gets or sets the Uri of ASR.
    :vartype asr_service_uri: str
    :ivar rcm_service_uri: Gets or sets the Uri of Rcm.
    :vartype rcm_service_uri: str
    :ivar gateway_service_uri: Gets or sets the Uri of Gateway.
    :vartype gateway_service_uri: str
    :ivar source_gateway_service_id: Gets or sets the gateway service Id of source.
    :vartype source_gateway_service_id: str
    :ivar target_gateway_service_id: Gets or sets the gateway service Id of target.
    :vartype target_gateway_service_id: str
    :ivar source_storage_container_name: Gets or sets the source storage container name.
    :vartype source_storage_container_name: str
    :ivar target_storage_container_name: Gets or sets the target storage container name.
    :vartype target_storage_container_name: str
    :ivar resource_location: Gets or sets the resource location.
    :vartype resource_location: str
    :ivar subscription_id: Gets or sets the subscription.
    :vartype subscription_id: str
    :ivar resource_group: Gets or sets the resource group.
    :vartype resource_group: str
    :ivar instance_type: Gets or sets the instance type. Required. Default value is
     "HyperVToAzStackHCI".
    :vartype instance_type: str
    """

    hyper_v_fabric_arm_id: str = rest_field(
        name="hyperVFabricArmId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the ARM Id of the source HyperV fabric. Required."""
    hyper_v_site_id: Optional[str] = rest_field(name="hyperVSiteId", visibility=["read"])
    """Gets or sets the ARM Id of the HyperV site."""
    az_stack_hci_fabric_arm_id: str = rest_field(
        name="azStackHciFabricArmId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the ARM Id of the target AzStackHCI fabric. Required."""
    az_stack_hci_site_id: Optional[str] = rest_field(name="azStackHciSiteId", visibility=["read"])
    """Gets or sets the ARM Id of the AzStackHCI site."""
    storage_account_id: Optional[str] = rest_field(
        name="storageAccountId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the storage account Id."""
    storage_account_sas_secret_name: Optional[str] = rest_field(
        name="storageAccountSasSecretName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the Sas Secret of storage account."""
    asr_service_uri: Optional[str] = rest_field(name="asrServiceUri", visibility=["read"])
    """Gets or sets the Uri of ASR."""
    rcm_service_uri: Optional[str] = rest_field(name="rcmServiceUri", visibility=["read"])
    """Gets or sets the Uri of Rcm."""
    gateway_service_uri: Optional[str] = rest_field(name="gatewayServiceUri", visibility=["read"])
    """Gets or sets the Uri of Gateway."""
    source_gateway_service_id: Optional[str] = rest_field(name="sourceGatewayServiceId", visibility=["read"])
    """Gets or sets the gateway service Id of source."""
    target_gateway_service_id: Optional[str] = rest_field(name="targetGatewayServiceId", visibility=["read"])
    """Gets or sets the gateway service Id of target."""
    source_storage_container_name: Optional[str] = rest_field(name="sourceStorageContainerName", visibility=["read"])
    """Gets or sets the source storage container name."""
    target_storage_container_name: Optional[str] = rest_field(name="targetStorageContainerName", visibility=["read"])
    """Gets or sets the target storage container name."""
    resource_location: Optional[str] = rest_field(name="resourceLocation", visibility=["read"])
    """Gets or sets the resource location."""
    subscription_id: Optional[str] = rest_field(name="subscriptionId", visibility=["read"])
    """Gets or sets the subscription."""
    resource_group: Optional[str] = rest_field(name="resourceGroup", visibility=["read"])
    """Gets or sets the resource group."""
    instance_type: Literal["HyperVToAzStackHCI"] = rest_discriminator(name="instanceType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Gets or sets the instance type. Required. Default value is \"HyperVToAzStackHCI\"."""

    @overload
    def __init__(
        self,
        *,
        hyper_v_fabric_arm_id: str,
        az_stack_hci_fabric_arm_id: str,
        storage_account_id: Optional[str] = None,
        storage_account_sas_secret_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, instance_type="HyperVToAzStackHCI", **kwargs)


class IdentityModel(_Model):
    """Identity model.

    :ivar tenant_id: Gets or sets the tenant Id of the SPN with which fabric agent communicates to
     service. Required.
    :vartype tenant_id: str
    :ivar application_id: Gets or sets the client/application Id of the SPN with which fabric agent
     communicates to service. Required.
    :vartype application_id: str
    :ivar object_id: Gets or sets the object Id of the SPN with which fabric agent communicates to
     service. Required.
    :vartype object_id: str
    :ivar audience: Gets or sets the audience of the SPN with which fabric agent communicates to
     service. Required.
    :vartype audience: str
    :ivar aad_authority: Gets or sets the authority of the SPN with which fabric agent communicates
     to service. Required.
    :vartype aad_authority: str
    """

    tenant_id: str = rest_field(name="tenantId", visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the tenant Id of the SPN with which fabric agent communicates to service.
     Required."""
    application_id: str = rest_field(name="applicationId", visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the client/application Id of the SPN with which fabric agent communicates to
     service. Required."""
    object_id: str = rest_field(name="objectId", visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the object Id of the SPN with which fabric agent communicates to service.
     Required."""
    audience: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the audience of the SPN with which fabric agent communicates to service. Required."""
    aad_authority: str = rest_field(name="aadAuthority", visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the authority of the SPN with which fabric agent communicates to service.
     Required."""

    @overload
    def __init__(
        self,
        *,
        tenant_id: str,
        application_id: str,
        object_id: str,
        audience: str,
        aad_authority: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InnerHealthErrorModel(_Model):
    """Inner health error model.

    :ivar code: Gets or sets the error code.
    :vartype code: str
    :ivar health_category: Gets or sets the health category.
    :vartype health_category: str
    :ivar category: Gets or sets the error category.
    :vartype category: str
    :ivar severity: Gets or sets the error severity.
    :vartype severity: str
    :ivar source: Gets or sets the error source.
    :vartype source: str
    :ivar creation_time: Gets or sets the error creation time.
    :vartype creation_time: ~datetime.datetime
    :ivar is_customer_resolvable: Gets or sets a value indicating whether the error is customer
     resolvable.
    :vartype is_customer_resolvable: bool
    :ivar summary: Gets or sets the error summary.
    :vartype summary: str
    :ivar message: Gets or sets the error message.
    :vartype message: str
    :ivar causes: Gets or sets possible causes of the error.
    :vartype causes: str
    :ivar recommendation: Gets or sets recommended action to resolve the error.
    :vartype recommendation: str
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets the error code."""
    health_category: Optional[str] = rest_field(name="healthCategory", visibility=["read"])
    """Gets or sets the health category."""
    category: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets the error category."""
    severity: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets the error severity."""
    source: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets the error source."""
    creation_time: Optional[datetime.datetime] = rest_field(name="creationTime", visibility=["read"], format="rfc3339")
    """Gets or sets the error creation time."""
    is_customer_resolvable: Optional[bool] = rest_field(name="isCustomerResolvable", visibility=["read"])
    """Gets or sets a value indicating whether the error is customer resolvable."""
    summary: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets the error summary."""
    message: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets the error message."""
    causes: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets possible causes of the error."""
    recommendation: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets recommended action to resolve the error."""


class JobModel(ProxyResource):
    """Job model.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.recoveryservicesdatareplication.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.recoveryservicesdatareplication.models.JobModelProperties
    """

    properties: Optional["_models.JobModelProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.JobModelProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class JobModelCustomPropertiesAffectedObjectDetails(_Model):  # pylint: disable=name-too-long
    """JobModelCustomPropertiesAffectedObjectDetails.

    :ivar description:
    :vartype description: str
    :ivar type: Default value is "object".
    :vartype type: str
    """

    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    type: Optional[Literal["object"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Default value is \"object\"."""

    @overload
    def __init__(
        self,
        *,
        description: Optional[str] = None,
        type: Optional[Literal["object"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class JobModelProperties(_Model):
    """Job model properties.

    :ivar display_name: Gets or sets the friendly display name.
    :vartype display_name: str
    :ivar state: Gets or sets the job state. Known values are: "Pending", "Started", "Cancelling",
     "Succeeded", "Failed", "Cancelled", "CompletedWithInformation", "CompletedWithWarnings", and
     "CompletedWithErrors".
    :vartype state: str or ~azure.mgmt.recoveryservicesdatareplication.models.JobState
    :ivar start_time: Gets or sets the start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Gets or sets the end time.
    :vartype end_time: ~datetime.datetime
    :ivar object_id: Gets or sets the affected object Id.
    :vartype object_id: str
    :ivar object_name: Gets or sets the affected object name.
    :vartype object_name: str
    :ivar object_internal_id: Gets or sets the affected object internal Id.
    :vartype object_internal_id: str
    :ivar object_internal_name: Gets or sets the affected object internal name.
    :vartype object_internal_name: str
    :ivar object_type: Gets or sets the object type. Known values are: "AvsDiskPool",
     "FabricAgent", "Fabric", "Policy", "ProtectedItem", "RecoveryPlan", "ReplicationExtension", and
     "Vault".
    :vartype object_type: str or ~azure.mgmt.recoveryservicesdatareplication.models.JobObjectType
    :ivar replication_provider_id: Gets or sets the replication provider.
    :vartype replication_provider_id: str
    :ivar source_fabric_provider_id: Gets or sets the source fabric provider.
    :vartype source_fabric_provider_id: str
    :ivar target_fabric_provider_id: Gets or sets the target fabric provider.
    :vartype target_fabric_provider_id: str
    :ivar allowed_actions: Gets or sets the list of allowed actions on the job.
    :vartype allowed_actions: list[str]
    :ivar activity_id: Gets or sets the job activity id.
    :vartype activity_id: str
    :ivar tasks: Gets or sets the list of tasks.
    :vartype tasks: list[~azure.mgmt.recoveryservicesdatareplication.models.TaskModel]
    :ivar errors: Gets or sets the list of errors.
    :vartype errors: list[~azure.mgmt.recoveryservicesdatareplication.models.ErrorModel]
    :ivar custom_properties: Job model custom properties. Required.
    :vartype custom_properties:
     ~azure.mgmt.recoveryservicesdatareplication.models.JobModelCustomProperties
    :ivar provisioning_state: Gets or sets the provisioning state of the job. Known values are:
     "Canceled", "Creating", "Deleting", "Deleted", "Failed", "Succeeded", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.ProvisioningState
    """

    display_name: Optional[str] = rest_field(name="displayName", visibility=["read"])
    """Gets or sets the friendly display name."""
    state: Optional[Union[str, "_models.JobState"]] = rest_field(visibility=["read"])
    """Gets or sets the job state. Known values are: \"Pending\", \"Started\", \"Cancelling\",
     \"Succeeded\", \"Failed\", \"Cancelled\", \"CompletedWithInformation\",
     \"CompletedWithWarnings\", and \"CompletedWithErrors\"."""
    start_time: Optional[datetime.datetime] = rest_field(name="startTime", visibility=["read"], format="rfc3339")
    """Gets or sets the start time."""
    end_time: Optional[datetime.datetime] = rest_field(name="endTime", visibility=["read"], format="rfc3339")
    """Gets or sets the end time."""
    object_id: Optional[str] = rest_field(name="objectId", visibility=["read"])
    """Gets or sets the affected object Id."""
    object_name: Optional[str] = rest_field(name="objectName", visibility=["read"])
    """Gets or sets the affected object name."""
    object_internal_id: Optional[str] = rest_field(name="objectInternalId", visibility=["read"])
    """Gets or sets the affected object internal Id."""
    object_internal_name: Optional[str] = rest_field(name="objectInternalName", visibility=["read"])
    """Gets or sets the affected object internal name."""
    object_type: Optional[Union[str, "_models.JobObjectType"]] = rest_field(name="objectType", visibility=["read"])
    """Gets or sets the object type. Known values are: \"AvsDiskPool\", \"FabricAgent\", \"Fabric\",
     \"Policy\", \"ProtectedItem\", \"RecoveryPlan\", \"ReplicationExtension\", and \"Vault\"."""
    replication_provider_id: Optional[str] = rest_field(name="replicationProviderId", visibility=["read"])
    """Gets or sets the replication provider."""
    source_fabric_provider_id: Optional[str] = rest_field(name="sourceFabricProviderId", visibility=["read"])
    """Gets or sets the source fabric provider."""
    target_fabric_provider_id: Optional[str] = rest_field(name="targetFabricProviderId", visibility=["read"])
    """Gets or sets the target fabric provider."""
    allowed_actions: Optional[List[str]] = rest_field(name="allowedActions", visibility=["read"])
    """Gets or sets the list of allowed actions on the job."""
    activity_id: Optional[str] = rest_field(name="activityId", visibility=["read"])
    """Gets or sets the job activity id."""
    tasks: Optional[List["_models.TaskModel"]] = rest_field(visibility=["read"])
    """Gets or sets the list of tasks."""
    errors: Optional[List["_models.ErrorModel"]] = rest_field(visibility=["read"])
    """Gets or sets the list of errors."""
    custom_properties: "_models.JobModelCustomProperties" = rest_field(
        name="customProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Job model custom properties. Required."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Gets or sets the provisioning state of the job. Known values are: \"Canceled\", \"Creating\",
     \"Deleting\", \"Deleted\", \"Failed\", \"Succeeded\", and \"Updating\"."""

    @overload
    def __init__(
        self,
        *,
        custom_properties: "_models.JobModelCustomProperties",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedServiceIdentity(_Model):
    """Managed service identity (system assigned and/or user assigned identities).

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The type of managed identity assigned to this resource. Required. Known values are:
     "None", "SystemAssigned", "UserAssigned", and "SystemAssigned,UserAssigned".
    :vartype type: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The identities assigned to this resource by the user.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.recoveryservicesdatareplication.models.UserAssignedIdentity]
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The service principal ID of the system assigned identity. This property will only be provided
     for a system assigned identity."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read"])
    """The tenant ID of the system assigned identity. This property will only be provided for a system
     assigned identity."""
    type: Union[str, "_models.ManagedServiceIdentityType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of managed identity assigned to this resource. Required. Known values are: \"None\",
     \"SystemAssigned\", \"UserAssigned\", and \"SystemAssigned,UserAssigned\"."""
    user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = rest_field(
        name="userAssignedIdentities", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identities assigned to this resource by the user."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Operation(_Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.recoveryservicesdatareplication.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.recoveryservicesdatareplication.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.recoveryservicesdatareplication.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType", visibility=["read"])
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_Model):
    """Localized display information for and operation.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class OperationStatus(_Model):
    """Defines the operation status.

    :ivar id: Gets or sets the Id.
    :vartype id: str
    :ivar name: Gets or sets the operation name.
    :vartype name: str
    :ivar status: Gets or sets the status of the operation. ARM expects the terminal status to be
     one of Succeeded/ Failed/ Canceled. All other values imply that the operation is still running.
    :vartype status: str
    :ivar start_time: Gets or sets the start time.
    :vartype start_time: str
    :ivar end_time: Gets or sets the end time.
    :vartype end_time: str
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the Id."""
    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the operation name."""
    status: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the status of the operation. ARM expects the terminal status to be one of
     Succeeded/ Failed/ Canceled. All other values imply that the operation is still running."""
    start_time: Optional[str] = rest_field(name="startTime", visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the start time."""
    end_time: Optional[str] = rest_field(name="endTime", visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the end time."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        status: Optional[str] = None,
        start_time: Optional[str] = None,
        end_time: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PlannedFailoverModel(_Model):
    """Planned failover model.

    :ivar properties: Planned failover model properties. Required.
    :vartype properties:
     ~azure.mgmt.recoveryservicesdatareplication.models.PlannedFailoverModelProperties
    """

    properties: "_models.PlannedFailoverModelProperties" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Planned failover model properties. Required."""

    @overload
    def __init__(
        self,
        *,
        properties: "_models.PlannedFailoverModelProperties",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PlannedFailoverModelProperties(_Model):
    """Planned failover model properties.

    :ivar custom_properties: Planned failover model custom properties. Required.
    :vartype custom_properties:
     ~azure.mgmt.recoveryservicesdatareplication.models.PlannedFailoverModelCustomProperties
    """

    custom_properties: "_models.PlannedFailoverModelCustomProperties" = rest_field(
        name="customProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Planned failover model custom properties. Required."""

    @overload
    def __init__(
        self,
        *,
        custom_properties: "_models.PlannedFailoverModelCustomProperties",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PolicyModel(ProxyResource):
    """Policy model.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.recoveryservicesdatareplication.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.recoveryservicesdatareplication.models.PolicyModelProperties
    """

    properties: Optional["_models.PolicyModelProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.PolicyModelProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PolicyModelProperties(_Model):
    """Policy model properties.

    :ivar provisioning_state: Gets or sets the provisioning state of the policy. Known values are:
     "Canceled", "Creating", "Deleting", "Deleted", "Failed", "Succeeded", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.ProvisioningState
    :ivar custom_properties: Policy model custom properties. Required.
    :vartype custom_properties:
     ~azure.mgmt.recoveryservicesdatareplication.models.PolicyModelCustomProperties
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Gets or sets the provisioning state of the policy. Known values are: \"Canceled\",
     \"Creating\", \"Deleting\", \"Deleted\", \"Failed\", \"Succeeded\", and \"Updating\"."""
    custom_properties: "_models.PolicyModelCustomProperties" = rest_field(
        name="customProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Policy model custom properties. Required."""

    @overload
    def __init__(
        self,
        *,
        custom_properties: "_models.PolicyModelCustomProperties",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateEndpoint(_Model):
    """Represent private Endpoint network resource that is linked to the Private Endpoint connection.

    :ivar id: Gets or sets the id.
    :vartype id: str
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the id."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateEndpointConnection(ProxyResource):
    """Represents private endpoint connection.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.recoveryservicesdatareplication.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties:
     ~azure.mgmt.recoveryservicesdatareplication.models.PrivateEndpointConnectionResponseProperties
    """

    properties: Optional["_models.PrivateEndpointConnectionResponseProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.PrivateEndpointConnectionResponseProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateEndpointConnectionProxy(ProxyResource):
    """Represents private endpoint connection proxy request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.recoveryservicesdatareplication.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties:
     ~azure.mgmt.recoveryservicesdatareplication.models.PrivateEndpointConnectionProxyProperties
    :ivar etag: Gets or sets ETag.
    :vartype etag: str
    """

    properties: Optional["_models.PrivateEndpointConnectionProxyProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    etag: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets ETag."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.PrivateEndpointConnectionProxyProperties"] = None,
        etag: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateEndpointConnectionProxyProperties(_Model):
    """Represents private endpoint connection proxy request.

    :ivar provisioning_state: Gets or sets the provisioning state of the private endpoint
     connection proxy. Known values are: "Canceled", "Creating", "Deleting", "Deleted", "Failed",
     "Succeeded", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.ProvisioningState
    :ivar remote_private_endpoint: Represent remote private endpoint information for the private
     endpoint connection proxy.
    :vartype remote_private_endpoint:
     ~azure.mgmt.recoveryservicesdatareplication.models.RemotePrivateEndpoint
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Gets or sets the provisioning state of the private endpoint connection proxy. Known values are:
     \"Canceled\", \"Creating\", \"Deleting\", \"Deleted\", \"Failed\", \"Succeeded\", and
     \"Updating\"."""
    remote_private_endpoint: Optional["_models.RemotePrivateEndpoint"] = rest_field(
        name="remotePrivateEndpoint", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represent remote private endpoint information for the private endpoint connection proxy."""

    @overload
    def __init__(
        self,
        *,
        remote_private_endpoint: Optional["_models.RemotePrivateEndpoint"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateEndpointConnectionResponseProperties(_Model):  # pylint: disable=name-too-long
    """Represents Private endpoint connection response properties.

    :ivar provisioning_state: Gets or sets provisioning state of the private endpoint connection.
     Known values are: "Canceled", "Creating", "Deleting", "Deleted", "Failed", "Succeeded", and
     "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.ProvisioningState
    :ivar private_endpoint: Represent private Endpoint network resource that is linked to the
     Private Endpoint connection.
    :vartype private_endpoint: ~azure.mgmt.recoveryservicesdatareplication.models.PrivateEndpoint
    :ivar private_link_service_connection_state: Represents Private link service connection state.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.recoveryservicesdatareplication.models.PrivateLinkServiceConnectionState
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Gets or sets provisioning state of the private endpoint connection. Known values are:
     \"Canceled\", \"Creating\", \"Deleting\", \"Deleted\", \"Failed\", \"Succeeded\", and
     \"Updating\"."""
    private_endpoint: Optional["_models.PrivateEndpoint"] = rest_field(
        name="privateEndpoint", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represent private Endpoint network resource that is linked to the Private Endpoint connection."""
    private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = rest_field(
        name="privateLinkServiceConnectionState", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents Private link service connection state."""

    @overload
    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateLinkResource(ProxyResource):
    """Represents private link resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.recoveryservicesdatareplication.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties:
     ~azure.mgmt.recoveryservicesdatareplication.models.PrivateLinkResourceProperties
    """

    properties: Optional["_models.PrivateLinkResourceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.PrivateLinkResourceProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateLinkResourceProperties(_Model):
    """Represents private link resource properties.

    :ivar group_id: Gets or sets the group id.
    :vartype group_id: str
    :ivar required_members: Gets or sets the required member. This translates to how many Private
     IPs should be created for each privately linkable resource.
    :vartype required_members: list[str]
    :ivar required_zone_names: Gets or sets the private DNS zone names.
    :vartype required_zone_names: list[str]
    :ivar provisioning_state: Gets or sets the provisioning state of the private link resource.
     Known values are: "Canceled", "Creating", "Deleting", "Deleted", "Failed", "Succeeded", and
     "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.ProvisioningState
    """

    group_id: Optional[str] = rest_field(name="groupId", visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the group id."""
    required_members: Optional[List[str]] = rest_field(
        name="requiredMembers", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the required member. This translates to how many Private IPs should be created for
     each privately linkable resource."""
    required_zone_names: Optional[List[str]] = rest_field(
        name="requiredZoneNames", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the private DNS zone names."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Gets or sets the provisioning state of the private link resource. Known values are:
     \"Canceled\", \"Creating\", \"Deleting\", \"Deleted\", \"Failed\", \"Succeeded\", and
     \"Updating\"."""

    @overload
    def __init__(
        self,
        *,
        group_id: Optional[str] = None,
        required_members: Optional[List[str]] = None,
        required_zone_names: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateLinkServiceConnection(_Model):
    """Represents of an NRP private link service connection.

    :ivar name: Gets or sets private link service connection name.
    :vartype name: str
    :ivar group_ids: Gets or sets group ids.
    :vartype group_ids: list[str]
    :ivar request_message: Gets or sets the request message for the private link service
     connection.
    :vartype request_message: str
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets private link service connection name."""
    group_ids: Optional[List[str]] = rest_field(
        name="groupIds", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets group ids."""
    request_message: Optional[str] = rest_field(
        name="requestMessage", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the request message for the private link service connection."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        group_ids: Optional[List[str]] = None,
        request_message: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateLinkServiceConnectionState(_Model):
    """Represents Private link service connection state.

    :ivar status: Gets or sets the status. Known values are: "Approved", "Disconnected", "Pending",
     and "Rejected".
    :vartype status: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.PrivateEndpointConnectionStatus
    :ivar description: Gets or sets description.
    :vartype description: str
    :ivar actions_required: Gets or sets actions required.
    :vartype actions_required: str
    """

    status: Optional[Union[str, "_models.PrivateEndpointConnectionStatus"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the status. Known values are: \"Approved\", \"Disconnected\", \"Pending\", and
     \"Rejected\"."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets description."""
    actions_required: Optional[str] = rest_field(
        name="actionsRequired", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets actions required."""

    @overload
    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateEndpointConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateLinkServiceProxy(_Model):
    """Represents NRP private link service proxy.

    :ivar id: Gets or sets private link service proxy id.
    :vartype id: str
    :ivar remote_private_link_service_connection_state: Represents Private link service connection
     state.
    :vartype remote_private_link_service_connection_state:
     ~azure.mgmt.recoveryservicesdatareplication.models.PrivateLinkServiceConnectionState
    :ivar remote_private_endpoint_connection: Represent remote private endpoint connection.
    :vartype remote_private_endpoint_connection:
     ~azure.mgmt.recoveryservicesdatareplication.models.RemotePrivateEndpointConnection
    :ivar group_connectivity_information: Gets or sets group connectivity information.
    :vartype group_connectivity_information:
     list[~azure.mgmt.recoveryservicesdatareplication.models.GroupConnectivityInformation]
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets private link service proxy id."""
    remote_private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = rest_field(
        name="remotePrivateLinkServiceConnectionState", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents Private link service connection state."""
    remote_private_endpoint_connection: Optional["_models.RemotePrivateEndpointConnection"] = rest_field(
        name="remotePrivateEndpointConnection", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represent remote private endpoint connection."""
    group_connectivity_information: Optional[List["_models.GroupConnectivityInformation"]] = rest_field(
        name="groupConnectivityInformation", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets group connectivity information."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        remote_private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = None,
        remote_private_endpoint_connection: Optional["_models.RemotePrivateEndpointConnection"] = None,
        group_connectivity_information: Optional[List["_models.GroupConnectivityInformation"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ProtectedItemDynamicMemoryConfig(_Model):
    """Protected item dynamic memory config.

    :ivar maximum_memory_in_mega_bytes: Gets or sets maximum memory in MB. Required.
    :vartype maximum_memory_in_mega_bytes: int
    :ivar minimum_memory_in_mega_bytes: Gets or sets minimum memory in MB. Required.
    :vartype minimum_memory_in_mega_bytes: int
    :ivar target_memory_buffer_percentage: Gets or sets target memory buffer in %. Required.
    :vartype target_memory_buffer_percentage: int
    """

    maximum_memory_in_mega_bytes: int = rest_field(
        name="maximumMemoryInMegaBytes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets maximum memory in MB. Required."""
    minimum_memory_in_mega_bytes: int = rest_field(
        name="minimumMemoryInMegaBytes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets minimum memory in MB. Required."""
    target_memory_buffer_percentage: int = rest_field(
        name="targetMemoryBufferPercentage", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets target memory buffer in %. Required."""

    @overload
    def __init__(
        self,
        *,
        maximum_memory_in_mega_bytes: int,
        minimum_memory_in_mega_bytes: int,
        target_memory_buffer_percentage: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ProtectedItemJobProperties(_Model):
    """Protected item job properties.

    :ivar scenario_name: Gets or sets protection scenario name.
    :vartype scenario_name: str
    :ivar id: Gets or sets job Id.
    :vartype id: str
    :ivar name: Gets or sets job name.
    :vartype name: str
    :ivar display_name: Gets or sets the job friendly display name.
    :vartype display_name: str
    :ivar state: Gets or sets job state.
    :vartype state: str
    :ivar start_time: Gets or sets start time of the job.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Gets or sets end time of the job.
    :vartype end_time: ~datetime.datetime
    """

    scenario_name: Optional[str] = rest_field(name="scenarioName", visibility=["read"])
    """Gets or sets protection scenario name."""
    id: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets job Id."""
    name: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets job name."""
    display_name: Optional[str] = rest_field(name="displayName", visibility=["read"])
    """Gets or sets the job friendly display name."""
    state: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets job state."""
    start_time: Optional[datetime.datetime] = rest_field(name="startTime", visibility=["read"], format="rfc3339")
    """Gets or sets start time of the job."""
    end_time: Optional[datetime.datetime] = rest_field(name="endTime", visibility=["read"], format="rfc3339")
    """Gets or sets end time of the job."""


class ProtectedItemModel(ProxyResource):
    """Protected item model.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.recoveryservicesdatareplication.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties:
     ~azure.mgmt.recoveryservicesdatareplication.models.ProtectedItemModelProperties
    """

    properties: Optional["_models.ProtectedItemModelProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ProtectedItemModelProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ProtectedItemModelProperties(_Model):
    """Protected item model properties.

    :ivar policy_name: Gets or sets the policy name. Required.
    :vartype policy_name: str
    :ivar replication_extension_name: Gets or sets the replication extension name. Required.
    :vartype replication_extension_name: str
    :ivar correlation_id: Gets or sets the protected item correlation Id.
    :vartype correlation_id: str
    :ivar provisioning_state: Gets or sets the provisioning state of the fabric agent. Known values
     are: "Canceled", "Creating", "Deleting", "Deleted", "Failed", "Succeeded", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.ProvisioningState
    :ivar protection_state: Gets or sets the protection state. Known values are:
     "UnprotectedStatesBegin", "EnablingProtection", "EnablingFailed", "DisablingProtection",
     "MarkedForDeletion", "DisablingFailed", "UnprotectedStatesEnd",
     "InitialReplicationStatesBegin", "InitialReplicationInProgress",
     "InitialReplicationCompletedOnPrimary", "InitialReplicationCompletedOnRecovery",
     "InitialReplicationFailed", "InitialReplicationStatesEnd", "ProtectedStatesBegin", "Protected",
     "ProtectedStatesEnd", "PlannedFailoverTransitionStatesBegin", "PlannedFailoverInitiated",
     "PlannedFailoverCompleting", "PlannedFailoverCompleted", "PlannedFailoverFailed",
     "PlannedFailoverCompletionFailed", "PlannedFailoverTransitionStatesEnd",
     "UnplannedFailoverTransitionStatesBegin", "UnplannedFailoverInitiated",
     "UnplannedFailoverCompleting", "UnplannedFailoverCompleted", "UnplannedFailoverFailed",
     "UnplannedFailoverCompletionFailed", "UnplannedFailoverTransitionStatesEnd",
     "CommitFailoverStatesBegin", "CommitFailoverInProgressOnPrimary",
     "CommitFailoverInProgressOnRecovery", "CommitFailoverCompleted",
     "CommitFailoverFailedOnPrimary", "CommitFailoverFailedOnRecovery", "CommitFailoverStatesEnd",
     "CancelFailoverStatesBegin", "CancelFailoverInProgressOnPrimary",
     "CancelFailoverInProgressOnRecovery", "CancelFailoverFailedOnPrimary",
     "CancelFailoverFailedOnRecovery", "CancelFailoverStatesEnd", "ChangeRecoveryPointStatesBegin",
     "ChangeRecoveryPointInitiated", "ChangeRecoveryPointCompleted", "ChangeRecoveryPointFailed",
     "ChangeRecoveryPointStatesEnd", "ReprotectStatesBegin", "ReprotectInitiated",
     "ReprotectFailed", and "ReprotectStatesEnd".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.ProtectionState
    :ivar protection_state_description: Gets or sets the protection state description.
    :vartype protection_state_description: str
    :ivar test_failover_state: Gets or sets the test failover state. Known values are: "None",
     "TestFailoverInitiated", "TestFailoverCompleting", "TestFailoverCompleted",
     "TestFailoverFailed", "TestFailoverCompletionFailed", "TestFailoverCleanupInitiated",
     "TestFailoverCleanupCompleting", and "MarkedForDeletion".
    :vartype test_failover_state: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.TestFailoverState
    :ivar test_failover_state_description: Gets or sets the Test failover state description.
    :vartype test_failover_state_description: str
    :ivar resynchronization_state: Gets or sets the resynchronization state. Known values are:
     "None", "ResynchronizationInitiated", "ResynchronizationCompleted", and
     "ResynchronizationFailed".
    :vartype resynchronization_state: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.ResynchronizationState
    :ivar fabric_object_id: Gets or sets the fabric object Id.
    :vartype fabric_object_id: str
    :ivar fabric_object_name: Gets or sets the fabric object name.
    :vartype fabric_object_name: str
    :ivar source_fabric_provider_id: Gets or sets the source fabric provider Id.
    :vartype source_fabric_provider_id: str
    :ivar target_fabric_provider_id: Gets or sets the target fabric provider Id.
    :vartype target_fabric_provider_id: str
    :ivar fabric_id: Gets or sets the fabric Id.
    :vartype fabric_id: str
    :ivar target_fabric_id: Gets or sets the target fabric Id.
    :vartype target_fabric_id: str
    :ivar fabric_agent_id: Gets or sets the fabric agent Id.
    :vartype fabric_agent_id: str
    :ivar target_fabric_agent_id: Gets or sets the target fabric agent Id.
    :vartype target_fabric_agent_id: str
    :ivar resync_required: Gets or sets a value indicating whether resynchronization is required or
     not.
    :vartype resync_required: bool
    :ivar last_successful_planned_failover_time: Gets or sets the Last successful planned failover
     time.
    :vartype last_successful_planned_failover_time: ~datetime.datetime
    :ivar last_successful_unplanned_failover_time: Gets or sets the Last successful unplanned
     failover time.
    :vartype last_successful_unplanned_failover_time: ~datetime.datetime
    :ivar last_successful_test_failover_time: Gets or sets the Last successful test failover time.
    :vartype last_successful_test_failover_time: ~datetime.datetime
    :ivar current_job: Gets or sets the current scenario.
    :vartype current_job:
     ~azure.mgmt.recoveryservicesdatareplication.models.ProtectedItemJobProperties
    :ivar allowed_jobs: Gets or sets the allowed scenarios on the protected item.
    :vartype allowed_jobs: list[str]
    :ivar last_failed_enable_protection_job: Gets or sets the last failed enabled protection job.
    :vartype last_failed_enable_protection_job:
     ~azure.mgmt.recoveryservicesdatareplication.models.ProtectedItemJobProperties
    :ivar last_failed_planned_failover_job: Gets or sets the last failed planned failover job.
    :vartype last_failed_planned_failover_job:
     ~azure.mgmt.recoveryservicesdatareplication.models.ProtectedItemJobProperties
    :ivar last_test_failover_job: Gets or sets the last test failover job.
    :vartype last_test_failover_job:
     ~azure.mgmt.recoveryservicesdatareplication.models.ProtectedItemJobProperties
    :ivar replication_health: Gets or sets protected item replication health. Known values are:
     "Normal", "Warning", and "Critical".
    :vartype replication_health: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.HealthStatus
    :ivar health_errors: Gets or sets the list of health errors.
    :vartype health_errors:
     list[~azure.mgmt.recoveryservicesdatareplication.models.HealthErrorModel]
    :ivar custom_properties: Protected item model custom properties. Required.
    :vartype custom_properties:
     ~azure.mgmt.recoveryservicesdatareplication.models.ProtectedItemModelCustomProperties
    """

    policy_name: str = rest_field(name="policyName", visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the policy name. Required."""
    replication_extension_name: str = rest_field(
        name="replicationExtensionName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the replication extension name. Required."""
    correlation_id: Optional[str] = rest_field(name="correlationId", visibility=["read"])
    """Gets or sets the protected item correlation Id."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Gets or sets the provisioning state of the fabric agent. Known values are: \"Canceled\",
     \"Creating\", \"Deleting\", \"Deleted\", \"Failed\", \"Succeeded\", and \"Updating\"."""
    protection_state: Optional[Union[str, "_models.ProtectionState"]] = rest_field(
        name="protectionState", visibility=["read"]
    )
    """Gets or sets the protection state. Known values are: \"UnprotectedStatesBegin\",
     \"EnablingProtection\", \"EnablingFailed\", \"DisablingProtection\", \"MarkedForDeletion\",
     \"DisablingFailed\", \"UnprotectedStatesEnd\", \"InitialReplicationStatesBegin\",
     \"InitialReplicationInProgress\", \"InitialReplicationCompletedOnPrimary\",
     \"InitialReplicationCompletedOnRecovery\", \"InitialReplicationFailed\",
     \"InitialReplicationStatesEnd\", \"ProtectedStatesBegin\", \"Protected\",
     \"ProtectedStatesEnd\", \"PlannedFailoverTransitionStatesBegin\", \"PlannedFailoverInitiated\",
     \"PlannedFailoverCompleting\", \"PlannedFailoverCompleted\", \"PlannedFailoverFailed\",
     \"PlannedFailoverCompletionFailed\", \"PlannedFailoverTransitionStatesEnd\",
     \"UnplannedFailoverTransitionStatesBegin\", \"UnplannedFailoverInitiated\",
     \"UnplannedFailoverCompleting\", \"UnplannedFailoverCompleted\", \"UnplannedFailoverFailed\",
     \"UnplannedFailoverCompletionFailed\", \"UnplannedFailoverTransitionStatesEnd\",
     \"CommitFailoverStatesBegin\", \"CommitFailoverInProgressOnPrimary\",
     \"CommitFailoverInProgressOnRecovery\", \"CommitFailoverCompleted\",
     \"CommitFailoverFailedOnPrimary\", \"CommitFailoverFailedOnRecovery\",
     \"CommitFailoverStatesEnd\", \"CancelFailoverStatesBegin\",
     \"CancelFailoverInProgressOnPrimary\", \"CancelFailoverInProgressOnRecovery\",
     \"CancelFailoverFailedOnPrimary\", \"CancelFailoverFailedOnRecovery\",
     \"CancelFailoverStatesEnd\", \"ChangeRecoveryPointStatesBegin\",
     \"ChangeRecoveryPointInitiated\", \"ChangeRecoveryPointCompleted\",
     \"ChangeRecoveryPointFailed\", \"ChangeRecoveryPointStatesEnd\", \"ReprotectStatesBegin\",
     \"ReprotectInitiated\", \"ReprotectFailed\", and \"ReprotectStatesEnd\"."""
    protection_state_description: Optional[str] = rest_field(name="protectionStateDescription", visibility=["read"])
    """Gets or sets the protection state description."""
    test_failover_state: Optional[Union[str, "_models.TestFailoverState"]] = rest_field(
        name="testFailoverState", visibility=["read"]
    )
    """Gets or sets the test failover state. Known values are: \"None\", \"TestFailoverInitiated\",
     \"TestFailoverCompleting\", \"TestFailoverCompleted\", \"TestFailoverFailed\",
     \"TestFailoverCompletionFailed\", \"TestFailoverCleanupInitiated\",
     \"TestFailoverCleanupCompleting\", and \"MarkedForDeletion\"."""
    test_failover_state_description: Optional[str] = rest_field(
        name="testFailoverStateDescription", visibility=["read"]
    )
    """Gets or sets the Test failover state description."""
    resynchronization_state: Optional[Union[str, "_models.ResynchronizationState"]] = rest_field(
        name="resynchronizationState", visibility=["read"]
    )
    """Gets or sets the resynchronization state. Known values are: \"None\",
     \"ResynchronizationInitiated\", \"ResynchronizationCompleted\", and
     \"ResynchronizationFailed\"."""
    fabric_object_id: Optional[str] = rest_field(name="fabricObjectId", visibility=["read"])
    """Gets or sets the fabric object Id."""
    fabric_object_name: Optional[str] = rest_field(name="fabricObjectName", visibility=["read"])
    """Gets or sets the fabric object name."""
    source_fabric_provider_id: Optional[str] = rest_field(name="sourceFabricProviderId", visibility=["read"])
    """Gets or sets the source fabric provider Id."""
    target_fabric_provider_id: Optional[str] = rest_field(name="targetFabricProviderId", visibility=["read"])
    """Gets or sets the target fabric provider Id."""
    fabric_id: Optional[str] = rest_field(name="fabricId", visibility=["read"])
    """Gets or sets the fabric Id."""
    target_fabric_id: Optional[str] = rest_field(name="targetFabricId", visibility=["read"])
    """Gets or sets the target fabric Id."""
    fabric_agent_id: Optional[str] = rest_field(name="fabricAgentId", visibility=["read"])
    """Gets or sets the fabric agent Id."""
    target_fabric_agent_id: Optional[str] = rest_field(name="targetFabricAgentId", visibility=["read"])
    """Gets or sets the target fabric agent Id."""
    resync_required: Optional[bool] = rest_field(name="resyncRequired", visibility=["read"])
    """Gets or sets a value indicating whether resynchronization is required or not."""
    last_successful_planned_failover_time: Optional[datetime.datetime] = rest_field(
        name="lastSuccessfulPlannedFailoverTime", visibility=["read"], format="rfc3339"
    )
    """Gets or sets the Last successful planned failover time."""
    last_successful_unplanned_failover_time: Optional[datetime.datetime] = rest_field(
        name="lastSuccessfulUnplannedFailoverTime", visibility=["read"], format="rfc3339"
    )
    """Gets or sets the Last successful unplanned failover time."""
    last_successful_test_failover_time: Optional[datetime.datetime] = rest_field(
        name="lastSuccessfulTestFailoverTime", visibility=["read"], format="rfc3339"
    )
    """Gets or sets the Last successful test failover time."""
    current_job: Optional["_models.ProtectedItemJobProperties"] = rest_field(name="currentJob", visibility=["read"])
    """Gets or sets the current scenario."""
    allowed_jobs: Optional[List[str]] = rest_field(name="allowedJobs", visibility=["read"])
    """Gets or sets the allowed scenarios on the protected item."""
    last_failed_enable_protection_job: Optional["_models.ProtectedItemJobProperties"] = rest_field(
        name="lastFailedEnableProtectionJob", visibility=["read"]
    )
    """Gets or sets the last failed enabled protection job."""
    last_failed_planned_failover_job: Optional["_models.ProtectedItemJobProperties"] = rest_field(
        name="lastFailedPlannedFailoverJob", visibility=["read"]
    )
    """Gets or sets the last failed planned failover job."""
    last_test_failover_job: Optional["_models.ProtectedItemJobProperties"] = rest_field(
        name="lastTestFailoverJob", visibility=["read"]
    )
    """Gets or sets the last test failover job."""
    replication_health: Optional[Union[str, "_models.HealthStatus"]] = rest_field(
        name="replicationHealth", visibility=["read"]
    )
    """Gets or sets protected item replication health. Known values are: \"Normal\", \"Warning\", and
     \"Critical\"."""
    health_errors: Optional[List["_models.HealthErrorModel"]] = rest_field(name="healthErrors", visibility=["read"])
    """Gets or sets the list of health errors."""
    custom_properties: "_models.ProtectedItemModelCustomProperties" = rest_field(
        name="customProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Protected item model custom properties. Required."""

    @overload
    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        policy_name: str,
        replication_extension_name: str,
        custom_properties: "_models.ProtectedItemModelCustomProperties",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ProtectedItemModelPropertiesUpdate(_Model):
    """Protected item model properties update.

    :ivar custom_properties: Protected item model custom properties update.
    :vartype custom_properties:
     ~azure.mgmt.recoveryservicesdatareplication.models.ProtectedItemModelCustomPropertiesUpdate
    """

    custom_properties: Optional["_models.ProtectedItemModelCustomPropertiesUpdate"] = rest_field(
        name="customProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Protected item model custom properties update."""

    @overload
    def __init__(
        self,
        *,
        custom_properties: Optional["_models.ProtectedItemModelCustomPropertiesUpdate"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ProtectedItemModelUpdate(_Model):
    """Protected item model update.

    :ivar properties: Protected item model properties.
    :vartype properties:
     ~azure.mgmt.recoveryservicesdatareplication.models.ProtectedItemModelPropertiesUpdate
    :ivar id: Gets or sets the Id of the resource.
    :vartype id: str
    :ivar name: Gets or sets the name of the resource.
    :vartype name: str
    :ivar type: Gets or sets the type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.recoveryservicesdatareplication.models.SystemData
    """

    properties: Optional["_models.ProtectedItemModelPropertiesUpdate"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Protected item model properties."""
    id: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets the Id of the resource."""
    name: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets the name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets the type of the resource."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Metadata pertaining to creation and last modification of the resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ProtectedItemModelPropertiesUpdate"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RecoveryPointModel(ProxyResource):
    """Recovery point model.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.recoveryservicesdatareplication.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties:
     ~azure.mgmt.recoveryservicesdatareplication.models.RecoveryPointModelProperties
    """

    properties: Optional["_models.RecoveryPointModelProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.RecoveryPointModelProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RecoveryPointModelProperties(_Model):
    """Recovery point model properties.

    :ivar recovery_point_time: Gets or sets the recovery point time. Required.
    :vartype recovery_point_time: ~datetime.datetime
    :ivar recovery_point_type: Gets or sets the recovery point type. Required. Known values are:
     "ApplicationConsistent" and "CrashConsistent".
    :vartype recovery_point_type: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.RecoveryPointType
    :ivar custom_properties: Recovery point model custom properties. Required.
    :vartype custom_properties:
     ~azure.mgmt.recoveryservicesdatareplication.models.RecoveryPointModelCustomProperties
    :ivar provisioning_state: Gets or sets the provisioning state of the recovery point item. Known
     values are: "Canceled", "Creating", "Deleting", "Deleted", "Failed", "Succeeded", and
     "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.ProvisioningState
    """

    recovery_point_time: datetime.datetime = rest_field(
        name="recoveryPointTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Gets or sets the recovery point time. Required."""
    recovery_point_type: Union[str, "_models.RecoveryPointType"] = rest_field(
        name="recoveryPointType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the recovery point type. Required. Known values are: \"ApplicationConsistent\" and
     \"CrashConsistent\"."""
    custom_properties: "_models.RecoveryPointModelCustomProperties" = rest_field(
        name="customProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Recovery point model custom properties. Required."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Gets or sets the provisioning state of the recovery point item. Known values are: \"Canceled\",
     \"Creating\", \"Deleting\", \"Deleted\", \"Failed\", \"Succeeded\", and \"Updating\"."""

    @overload
    def __init__(
        self,
        *,
        recovery_point_time: datetime.datetime,
        recovery_point_type: Union[str, "_models.RecoveryPointType"],
        custom_properties: "_models.RecoveryPointModelCustomProperties",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RemotePrivateEndpoint(_Model):
    """Represent remote private endpoint information for the private endpoint connection proxy.

    :ivar id: Gets or sets private link service proxy id. Required.
    :vartype id: str
    :ivar private_link_service_connections: Gets or sets the list of Private Link Service
     Connections and gets populated for Auto approval flow.
    :vartype private_link_service_connections:
     list[~azure.mgmt.recoveryservicesdatareplication.models.PrivateLinkServiceConnection]
    :ivar manual_private_link_service_connections: Gets or sets the list of Manual Private Link
     Service Connections and gets populated for Manual approval flow.
    :vartype manual_private_link_service_connections:
     list[~azure.mgmt.recoveryservicesdatareplication.models.PrivateLinkServiceConnection]
    :ivar private_link_service_proxies: Gets or sets the list of private link service proxies.
    :vartype private_link_service_proxies:
     list[~azure.mgmt.recoveryservicesdatareplication.models.PrivateLinkServiceProxy]
    :ivar connection_details: Gets or sets the list of Connection Details. This is the connection
     details for private endpoint.
    :vartype connection_details:
     list[~azure.mgmt.recoveryservicesdatareplication.models.ConnectionDetails]
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets private link service proxy id. Required."""
    private_link_service_connections: Optional[List["_models.PrivateLinkServiceConnection"]] = rest_field(
        name="privateLinkServiceConnections", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the list of Private Link Service Connections and gets populated for Auto approval
     flow."""
    manual_private_link_service_connections: Optional[List["_models.PrivateLinkServiceConnection"]] = rest_field(
        name="manualPrivateLinkServiceConnections", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the list of Manual Private Link Service Connections and gets populated for Manual
     approval flow."""
    private_link_service_proxies: Optional[List["_models.PrivateLinkServiceProxy"]] = rest_field(
        name="privateLinkServiceProxies", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the list of private link service proxies."""
    connection_details: Optional[List["_models.ConnectionDetails"]] = rest_field(
        name="connectionDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the list of Connection Details. This is the connection details for private
     endpoint."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        private_link_service_connections: Optional[List["_models.PrivateLinkServiceConnection"]] = None,
        manual_private_link_service_connections: Optional[List["_models.PrivateLinkServiceConnection"]] = None,
        private_link_service_proxies: Optional[List["_models.PrivateLinkServiceProxy"]] = None,
        connection_details: Optional[List["_models.ConnectionDetails"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RemotePrivateEndpointConnection(_Model):
    """Represent remote private endpoint connection.

    :ivar id: Gets or sets the remote private endpoint connection id.
    :vartype id: str
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the remote private endpoint connection id."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ReplicationExtensionModel(ProxyResource):
    """Replication extension model.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.recoveryservicesdatareplication.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties:
     ~azure.mgmt.recoveryservicesdatareplication.models.ReplicationExtensionModelProperties
    """

    properties: Optional["_models.ReplicationExtensionModelProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ReplicationExtensionModelProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ReplicationExtensionModelProperties(_Model):
    """Replication extension model properties.

    :ivar provisioning_state: Gets or sets the provisioning state of the replication extension.
     Known values are: "Canceled", "Creating", "Deleting", "Deleted", "Failed", "Succeeded", and
     "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.ProvisioningState
    :ivar custom_properties: Replication extension model custom properties. Required.
    :vartype custom_properties:
     ~azure.mgmt.recoveryservicesdatareplication.models.ReplicationExtensionModelCustomProperties
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Gets or sets the provisioning state of the replication extension. Known values are:
     \"Canceled\", \"Creating\", \"Deleting\", \"Deleted\", \"Failed\", \"Succeeded\", and
     \"Updating\"."""
    custom_properties: "_models.ReplicationExtensionModelCustomProperties" = rest_field(
        name="customProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Replication extension model custom properties. Required."""

    @overload
    def __init__(
        self,
        *,
        custom_properties: "_models.ReplicationExtensionModelCustomProperties",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StorageContainerProperties(_Model):
    """Storage container properties.

    :ivar name: Gets or sets the Name. Required.
    :vartype name: str
    :ivar cluster_shared_volume_path: Gets or sets the ClusterSharedVolumePath. Required.
    :vartype cluster_shared_volume_path: str
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the Name. Required."""
    cluster_shared_volume_path: str = rest_field(
        name="clusterSharedVolumePath", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the ClusterSharedVolumePath. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        cluster_shared_volume_path: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TaskModel(_Model):
    """Task model.

    :ivar task_name: Gets or sets the task name.
    :vartype task_name: str
    :ivar state: Gets or sets the task state. Known values are: "Pending", "Started", "Succeeded",
     "Failed", "Cancelled", and "Skipped".
    :vartype state: str or ~azure.mgmt.recoveryservicesdatareplication.models.TaskState
    :ivar start_time: Gets or sets the start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Gets or sets the end time.
    :vartype end_time: ~datetime.datetime
    :ivar custom_properties: Task model custom properties.
    :vartype custom_properties:
     ~azure.mgmt.recoveryservicesdatareplication.models.TaskModelCustomProperties
    :ivar children_jobs: Gets or sets the list of children job models.
    :vartype children_jobs: list[~azure.mgmt.recoveryservicesdatareplication.models.JobModel]
    """

    task_name: Optional[str] = rest_field(name="taskName", visibility=["read"])
    """Gets or sets the task name."""
    state: Optional[Union[str, "_models.TaskState"]] = rest_field(visibility=["read"])
    """Gets or sets the task state. Known values are: \"Pending\", \"Started\", \"Succeeded\",
     \"Failed\", \"Cancelled\", and \"Skipped\"."""
    start_time: Optional[datetime.datetime] = rest_field(name="startTime", visibility=["read"], format="rfc3339")
    """Gets or sets the start time."""
    end_time: Optional[datetime.datetime] = rest_field(name="endTime", visibility=["read"], format="rfc3339")
    """Gets or sets the end time."""
    custom_properties: Optional["_models.TaskModelCustomProperties"] = rest_field(
        name="customProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Task model custom properties."""
    children_jobs: Optional[List["_models.JobModel"]] = rest_field(
        name="childrenJobs", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the list of children job models."""

    @overload
    def __init__(
        self,
        *,
        custom_properties: Optional["_models.TaskModelCustomProperties"] = None,
        children_jobs: Optional[List["_models.JobModel"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TaskModelCustomProperties(_Model):
    """Task model custom properties.

    :ivar instance_type: Gets or sets the instance type. Required.
    :vartype instance_type: str
    """

    instance_type: str = rest_field(name="instanceType", visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the instance type. Required."""

    @overload
    def __init__(
        self,
        *,
        instance_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TestFailoverCleanupJobModelCustomProperties(
    JobModelCustomProperties, discriminator="TestFailoverCleanupJobDetails"
):  # pylint: disable=name-too-long
    """Test failover cleanup job model custom properties.

    :ivar affected_object_details: Gets or sets any custom properties of the affected object.
    :vartype affected_object_details:
     ~azure.mgmt.recoveryservicesdatareplication.models.JobModelCustomPropertiesAffectedObjectDetails
    :ivar comments: Gets or sets the test failover cleanup comments.
    :vartype comments: str
    :ivar instance_type: Gets or sets the instance type. Required. Default value is
     "TestFailoverCleanupJobDetails".
    :vartype instance_type: str
    """

    comments: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets the test failover cleanup comments."""
    instance_type: Literal["TestFailoverCleanupJobDetails"] = rest_discriminator(name="instanceType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Gets or sets the instance type. Required. Default value is \"TestFailoverCleanupJobDetails\"."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, instance_type="TestFailoverCleanupJobDetails", **kwargs)


class TestFailoverJobModelCustomProperties(JobModelCustomProperties, discriminator="TestFailoverJobDetails"):
    """Test failover job model custom properties.

    :ivar affected_object_details: Gets or sets any custom properties of the affected object.
    :vartype affected_object_details:
     ~azure.mgmt.recoveryservicesdatareplication.models.JobModelCustomPropertiesAffectedObjectDetails
    :ivar protected_item_details: Gets or sets the test VM details.
    :vartype protected_item_details:
     list[~azure.mgmt.recoveryservicesdatareplication.models.FailoverProtectedItemProperties]
    :ivar instance_type: Gets or sets the instance type. Required. Default value is
     "TestFailoverJobDetails".
    :vartype instance_type: str
    """

    protected_item_details: Optional[List["_models.FailoverProtectedItemProperties"]] = rest_field(
        name="protectedItemDetails", visibility=["read"]
    )
    """Gets or sets the test VM details."""
    instance_type: Literal["TestFailoverJobDetails"] = rest_discriminator(name="instanceType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Gets or sets the instance type. Required. Default value is \"TestFailoverJobDetails\"."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, instance_type="TestFailoverJobDetails", **kwargs)


class UserAssignedIdentity(_Model):
    """User assigned identity properties.

    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    """

    client_id: Optional[str] = rest_field(name="clientId", visibility=["read"])
    """The client ID of the assigned identity."""
    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal ID of the assigned identity."""


class VaultIdentityModel(_Model):
    """Vault model.

    :ivar type: Gets or sets the identityType which can be either SystemAssigned or None. Required.
     Known values are: "None", "SystemAssigned", and "UserAssigned".
    :vartype type: str or ~azure.mgmt.recoveryservicesdatareplication.models.VaultIdentityType
    :ivar principal_id: Gets or sets the object ID of the service principal object for the managed
     identity that is used to grant role-based access to an Azure resource.
    :vartype principal_id: str
    :ivar tenant_id: Gets or sets a Globally Unique Identifier (GUID) that represents the Azure AD
     tenant where the resource is now a member.
    :vartype tenant_id: str
    """

    type: Union[str, "_models.VaultIdentityType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the identityType which can be either SystemAssigned or None. Required. Known
     values are: \"None\", \"SystemAssigned\", and \"UserAssigned\"."""
    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """Gets or sets the object ID of the service principal object for the managed identity that is
     used to grant role-based access to an Azure resource."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read"])
    """Gets or sets a Globally Unique Identifier (GUID) that represents the Azure AD tenant where the
     resource is now a member."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.VaultIdentityType"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VaultModel(TrackedResource):
    """Vault model.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.recoveryservicesdatareplication.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.recoveryservicesdatareplication.models.VaultModelProperties
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.recoveryservicesdatareplication.models.ManagedServiceIdentity
    """

    properties: Optional["_models.VaultModelProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    identity: Optional["_models.ManagedServiceIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed service identities assigned to this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.VaultModelProperties"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VaultModelProperties(_Model):
    """Vault properties.

    :ivar provisioning_state: Gets or sets the provisioning state of the vault. Known values are:
     "Canceled", "Creating", "Deleting", "Deleted", "Failed", "Succeeded", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.ProvisioningState
    :ivar service_resource_id: Gets or sets the service resource Id.
    :vartype service_resource_id: str
    :ivar vault_type: Gets or sets the type of vault. Known values are: "DisasterRecovery" and
     "Migrate".
    :vartype vault_type: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.ReplicationVaultType
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Gets or sets the provisioning state of the vault. Known values are: \"Canceled\", \"Creating\",
     \"Deleting\", \"Deleted\", \"Failed\", \"Succeeded\", and \"Updating\"."""
    service_resource_id: Optional[str] = rest_field(name="serviceResourceId", visibility=["read"])
    """Gets or sets the service resource Id."""
    vault_type: Optional[Union[str, "_models.ReplicationVaultType"]] = rest_field(
        name="vaultType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the type of vault. Known values are: \"DisasterRecovery\" and \"Migrate\"."""

    @overload
    def __init__(
        self,
        *,
        vault_type: Optional[Union[str, "_models.ReplicationVaultType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VaultModelUpdate(_Model):
    """Vault model update.

    :ivar tags: Gets or sets the resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: Vault properties.
    :vartype properties: ~azure.mgmt.recoveryservicesdatareplication.models.VaultModelProperties
    :ivar identity: Vault identity.
    :vartype identity: ~azure.mgmt.recoveryservicesdatareplication.models.VaultIdentityModel
    :ivar id: Gets or sets the Id of the resource.
    :vartype id: str
    :ivar name: Gets or sets the name of the resource.
    :vartype name: str
    :ivar type: Gets or sets the type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.recoveryservicesdatareplication.models.SystemData
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the resource tags."""
    properties: Optional["_models.VaultModelProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Vault properties."""
    identity: Optional["_models.VaultIdentityModel"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Vault identity."""
    id: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets the Id of the resource."""
    name: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets the name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets the type of the resource."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Metadata pertaining to creation and last modification of the resource."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.VaultModelProperties"] = None,
        identity: Optional["_models.VaultIdentityModel"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VMwareFabricAgentModelCustomProperties(FabricAgentModelCustomProperties, discriminator="VMware"):
    """VMware fabric agent model custom properties.

    :ivar bios_id: Gets or sets the BIOS Id of the fabric agent machine. Required.
    :vartype bios_id: str
    :ivar mars_authentication_identity: Identity model. Required.
    :vartype mars_authentication_identity:
     ~azure.mgmt.recoveryservicesdatareplication.models.IdentityModel
    :ivar instance_type: Gets or sets the instance type. Required. Default value is "VMware".
    :vartype instance_type: str
    """

    bios_id: str = rest_field(name="biosId", visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the BIOS Id of the fabric agent machine. Required."""
    mars_authentication_identity: "_models.IdentityModel" = rest_field(
        name="marsAuthenticationIdentity", visibility=["read", "create", "update", "delete", "query"]
    )
    """Identity model. Required."""
    instance_type: Literal["VMware"] = rest_discriminator(name="instanceType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Gets or sets the instance type. Required. Default value is \"VMware\"."""

    @overload
    def __init__(
        self,
        *,
        bios_id: str,
        mars_authentication_identity: "_models.IdentityModel",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, instance_type="VMware", **kwargs)


class VMwareMigrateFabricModelCustomProperties(FabricModelCustomProperties, discriminator="VMwareMigrate"):
    """VMware migrate fabric model custom properties.

    :ivar vmware_site_id: Gets or sets the ARM Id of the VMware site. Required.
    :vartype vmware_site_id: str
    :ivar migration_solution_id: Gets or sets the ARM Id of the migration solution. Required.
    :vartype migration_solution_id: str
    :ivar instance_type: Gets or sets the instance type. Required. Default value is
     "VMwareMigrate".
    :vartype instance_type: str
    """

    vmware_site_id: str = rest_field(name="vmwareSiteId", visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the ARM Id of the VMware site. Required."""
    migration_solution_id: str = rest_field(
        name="migrationSolutionId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the ARM Id of the migration solution. Required."""
    instance_type: Literal["VMwareMigrate"] = rest_discriminator(name="instanceType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Gets or sets the instance type. Required. Default value is \"VMwareMigrate\"."""

    @overload
    def __init__(
        self,
        *,
        vmware_site_id: str,
        migration_solution_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, instance_type="VMwareMigrate", **kwargs)


class VMwareToAzStackHCIDiskInput(_Model):
    """VMwareToAzStack disk input.

    :ivar disk_id: Gets or sets the disk Id. Required.
    :vartype disk_id: str
    :ivar storage_container_id: Gets or sets the target storage account ARM Id.
    :vartype storage_container_id: str
    :ivar is_dynamic: Gets or sets a value indicating whether dynamic sizing is enabled on the
     virtual hard disk.
    :vartype is_dynamic: bool
    :ivar disk_size_gb: Gets or sets the disk size in GB. Required.
    :vartype disk_size_gb: int
    :ivar disk_file_format: Gets or sets the type of the virtual hard disk, vhd or vhdx. Required.
    :vartype disk_file_format: str
    :ivar is_os_disk: Gets or sets a value indicating whether disk is os disk. Required.
    :vartype is_os_disk: bool
    :ivar disk_block_size: Gets or sets a value of disk block size.
    :vartype disk_block_size: int
    :ivar disk_logical_sector_size: Gets or sets a value of disk logical sector size.
    :vartype disk_logical_sector_size: int
    :ivar disk_physical_sector_size: Gets or sets a value of disk physical sector size.
    :vartype disk_physical_sector_size: int
    :ivar disk_identifier: Gets or sets a value of disk identifier.
    :vartype disk_identifier: str
    :ivar disk_controller: Disk controller.
    :vartype disk_controller:
     ~azure.mgmt.recoveryservicesdatareplication.models.DiskControllerInputs
    """

    disk_id: str = rest_field(name="diskId", visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the disk Id. Required."""
    storage_container_id: Optional[str] = rest_field(
        name="storageContainerId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the target storage account ARM Id."""
    is_dynamic: Optional[bool] = rest_field(
        name="isDynamic", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets a value indicating whether dynamic sizing is enabled on the virtual hard disk."""
    disk_size_gb: int = rest_field(name="diskSizeGB", visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the disk size in GB. Required."""
    disk_file_format: str = rest_field(
        name="diskFileFormat", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the type of the virtual hard disk, vhd or vhdx. Required."""
    is_os_disk: bool = rest_field(name="isOsDisk", visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets a value indicating whether disk is os disk. Required."""
    disk_block_size: Optional[int] = rest_field(
        name="diskBlockSize", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets a value of disk block size."""
    disk_logical_sector_size: Optional[int] = rest_field(
        name="diskLogicalSectorSize", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets a value of disk logical sector size."""
    disk_physical_sector_size: Optional[int] = rest_field(
        name="diskPhysicalSectorSize", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets a value of disk physical sector size."""
    disk_identifier: Optional[str] = rest_field(
        name="diskIdentifier", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets a value of disk identifier."""
    disk_controller: Optional["_models.DiskControllerInputs"] = rest_field(
        name="diskController", visibility=["read", "create", "update", "delete", "query"]
    )
    """Disk controller."""

    @overload
    def __init__(
        self,
        *,
        disk_id: str,
        disk_size_gb: int,
        disk_file_format: str,
        is_os_disk: bool,
        storage_container_id: Optional[str] = None,
        is_dynamic: Optional[bool] = None,
        disk_block_size: Optional[int] = None,
        disk_logical_sector_size: Optional[int] = None,
        disk_physical_sector_size: Optional[int] = None,
        disk_identifier: Optional[str] = None,
        disk_controller: Optional["_models.DiskControllerInputs"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VMwareToAzStackHCIEventModelCustomProperties(
    EventModelCustomProperties, discriminator="VMwareToAzStackHCI"
):  # pylint: disable=name-too-long
    """VMware to  AzStackHCI event model custom properties. This class provides provider specific
    details for events of type DataContract.HealthEvents.HealthEventType.ProtectedItemHealth and
    DataContract.HealthEvents.HealthEventType.AgentHealth.

    :ivar event_source_friendly_name: Gets or sets the friendly name of the source which has raised
     this health event.
    :vartype event_source_friendly_name: str
    :ivar protected_item_friendly_name: Gets or sets the protected item friendly name.
    :vartype protected_item_friendly_name: str
    :ivar source_appliance_name: Gets or sets the source appliance name.
    :vartype source_appliance_name: str
    :ivar target_appliance_name: Gets or sets the source target name.
    :vartype target_appliance_name: str
    :ivar server_type: Gets or sets the server type.
    :vartype server_type: str
    :ivar instance_type: Gets or sets the instance type. Required. Default value is
     "VMwareToAzStackHCI".
    :vartype instance_type: str
    """

    event_source_friendly_name: Optional[str] = rest_field(name="eventSourceFriendlyName", visibility=["read"])
    """Gets or sets the friendly name of the source which has raised this health event."""
    protected_item_friendly_name: Optional[str] = rest_field(name="protectedItemFriendlyName", visibility=["read"])
    """Gets or sets the protected item friendly name."""
    source_appliance_name: Optional[str] = rest_field(name="sourceApplianceName", visibility=["read"])
    """Gets or sets the source appliance name."""
    target_appliance_name: Optional[str] = rest_field(name="targetApplianceName", visibility=["read"])
    """Gets or sets the source target name."""
    server_type: Optional[str] = rest_field(name="serverType", visibility=["read"])
    """Gets or sets the server type."""
    instance_type: Literal["VMwareToAzStackHCI"] = rest_discriminator(name="instanceType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Gets or sets the instance type. Required. Default value is \"VMwareToAzStackHCI\"."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, instance_type="VMwareToAzStackHCI", **kwargs)


class VMwareToAzStackHCINicInput(_Model):
    """VMwareToAzStackHCI NIC properties.

    :ivar nic_id: Gets or sets the NIC Id. Required.
    :vartype nic_id: str
    :ivar label: Gets or sets the NIC label. Required.
    :vartype label: str
    :ivar network_name: Gets or sets the network name.
    :vartype network_name: str
    :ivar target_network_id: Gets or sets the target network Id within AzStackHCI Cluster.
    :vartype target_network_id: str
    :ivar test_network_id: Gets or sets the target test network Id within AzStackHCI Cluster.
    :vartype test_network_id: str
    :ivar selection_type_for_failover: Gets or sets the selection type of the NIC. Required. Known
     values are: "NotSelected", "SelectedByUser", "SelectedByDefault", and "SelectedByUserOverride".
    :vartype selection_type_for_failover: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.VMNicSelection
    :ivar is_static_ip_migration_enabled: Gets or sets a value indicating whether static ip
     migration is enabled.
    :vartype is_static_ip_migration_enabled: bool
    :ivar is_mac_migration_enabled: Gets or sets a value indicating whether mac address migration
     is enabled.
    :vartype is_mac_migration_enabled: bool
    """

    nic_id: str = rest_field(name="nicId", visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the NIC Id. Required."""
    label: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the NIC label. Required."""
    network_name: Optional[str] = rest_field(name="networkName", visibility=["read"])
    """Gets or sets the network name."""
    target_network_id: Optional[str] = rest_field(
        name="targetNetworkId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the target network Id within AzStackHCI Cluster."""
    test_network_id: Optional[str] = rest_field(
        name="testNetworkId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the target test network Id within AzStackHCI Cluster."""
    selection_type_for_failover: Union[str, "_models.VMNicSelection"] = rest_field(
        name="selectionTypeForFailover", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the selection type of the NIC. Required. Known values are: \"NotSelected\",
     \"SelectedByUser\", \"SelectedByDefault\", and \"SelectedByUserOverride\"."""
    is_static_ip_migration_enabled: Optional[bool] = rest_field(
        name="isStaticIpMigrationEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets a value indicating whether static ip migration is enabled."""
    is_mac_migration_enabled: Optional[bool] = rest_field(
        name="isMacMigrationEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets a value indicating whether mac address migration is enabled."""

    @overload
    def __init__(
        self,
        *,
        nic_id: str,
        label: str,
        selection_type_for_failover: Union[str, "_models.VMNicSelection"],
        target_network_id: Optional[str] = None,
        test_network_id: Optional[str] = None,
        is_static_ip_migration_enabled: Optional[bool] = None,
        is_mac_migration_enabled: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VMwareToAzStackHCIPlannedFailoverModelCustomProperties(
    PlannedFailoverModelCustomProperties, discriminator="VMwareToAzStackHCI"
):  # pylint: disable=name-too-long
    """VMware to AzStackHCI planned failover model custom properties.

    :ivar shutdown_source_vm: Gets or sets a value indicating whether VM needs to be shut down.
     Required.
    :vartype shutdown_source_vm: bool
    :ivar instance_type: Gets or sets the instance type. Required. Default value is
     "VMwareToAzStackHCI".
    :vartype instance_type: str
    """

    shutdown_source_vm: bool = rest_field(
        name="shutdownSourceVM", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets a value indicating whether VM needs to be shut down. Required."""
    instance_type: Literal["VMwareToAzStackHCI"] = rest_discriminator(name="instanceType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Gets or sets the instance type. Required. Default value is \"VMwareToAzStackHCI\"."""

    @overload
    def __init__(
        self,
        *,
        shutdown_source_vm: bool,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, instance_type="VMwareToAzStackHCI", **kwargs)


class VMwareToAzStackHCIPolicyModelCustomProperties(
    PolicyModelCustomProperties, discriminator="VMwareToAzStackHCI"
):  # pylint: disable=name-too-long
    """VMware To AzStackHCI Policy model custom properties.

    :ivar recovery_point_history_in_minutes: Gets or sets the duration in minutes until which the
     recovery points need to be stored. Required.
    :vartype recovery_point_history_in_minutes: int
    :ivar crash_consistent_frequency_in_minutes: Gets or sets the crash consistent snapshot
     frequency (in minutes). Required.
    :vartype crash_consistent_frequency_in_minutes: int
    :ivar app_consistent_frequency_in_minutes: Gets or sets the app consistent snapshot frequency
     (in minutes). Required.
    :vartype app_consistent_frequency_in_minutes: int
    :ivar instance_type: Gets or sets the instance type. Required. Default value is
     "VMwareToAzStackHCI".
    :vartype instance_type: str
    """

    recovery_point_history_in_minutes: int = rest_field(
        name="recoveryPointHistoryInMinutes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the duration in minutes until which the recovery points need to be stored.
     Required."""
    crash_consistent_frequency_in_minutes: int = rest_field(
        name="crashConsistentFrequencyInMinutes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the crash consistent snapshot frequency (in minutes). Required."""
    app_consistent_frequency_in_minutes: int = rest_field(
        name="appConsistentFrequencyInMinutes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the app consistent snapshot frequency (in minutes). Required."""
    instance_type: Literal["VMwareToAzStackHCI"] = rest_discriminator(name="instanceType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Gets or sets the instance type. Required. Default value is \"VMwareToAzStackHCI\"."""

    @overload
    def __init__(
        self,
        *,
        recovery_point_history_in_minutes: int,
        crash_consistent_frequency_in_minutes: int,
        app_consistent_frequency_in_minutes: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, instance_type="VMwareToAzStackHCI", **kwargs)


class VMwareToAzStackHCIProtectedDiskProperties(_Model):  # pylint: disable=name-too-long
    """VMwareToAzStackHCI protected disk properties.

    :ivar storage_container_id: Gets or sets the ARM Id of the storage container.
    :vartype storage_container_id: str
    :ivar storage_container_local_path: Gets or sets the local path of the storage container.
    :vartype storage_container_local_path: str
    :ivar source_disk_id: Gets or sets the source disk Id.
    :vartype source_disk_id: str
    :ivar source_disk_name: Gets or sets the source disk Name.
    :vartype source_disk_name: str
    :ivar seed_disk_name: Gets or sets the seed disk name.
    :vartype seed_disk_name: str
    :ivar test_migrate_disk_name: Gets or sets the test failover clone disk.
    :vartype test_migrate_disk_name: str
    :ivar migrate_disk_name: Gets or sets the failover clone disk.
    :vartype migrate_disk_name: str
    :ivar is_os_disk: Gets or sets a value indicating whether the disk is the OS disk.
    :vartype is_os_disk: bool
    :ivar capacity_in_bytes: Gets or sets the disk capacity in bytes.
    :vartype capacity_in_bytes: int
    :ivar is_dynamic: Gets or sets a value indicating whether dynamic sizing is enabled on the
     virtual hard disk.
    :vartype is_dynamic: bool
    :ivar disk_type: Gets or sets the disk type.
    :vartype disk_type: str
    :ivar disk_block_size: Gets or sets a value of disk block size.
    :vartype disk_block_size: int
    :ivar disk_logical_sector_size: Gets or sets a value of disk logical sector size.
    :vartype disk_logical_sector_size: int
    :ivar disk_physical_sector_size: Gets or sets a value of disk physical sector size.
    :vartype disk_physical_sector_size: int
    """

    storage_container_id: Optional[str] = rest_field(name="storageContainerId", visibility=["read"])
    """Gets or sets the ARM Id of the storage container."""
    storage_container_local_path: Optional[str] = rest_field(name="storageContainerLocalPath", visibility=["read"])
    """Gets or sets the local path of the storage container."""
    source_disk_id: Optional[str] = rest_field(name="sourceDiskId", visibility=["read"])
    """Gets or sets the source disk Id."""
    source_disk_name: Optional[str] = rest_field(name="sourceDiskName", visibility=["read"])
    """Gets or sets the source disk Name."""
    seed_disk_name: Optional[str] = rest_field(name="seedDiskName", visibility=["read"])
    """Gets or sets the seed disk name."""
    test_migrate_disk_name: Optional[str] = rest_field(name="testMigrateDiskName", visibility=["read"])
    """Gets or sets the test failover clone disk."""
    migrate_disk_name: Optional[str] = rest_field(name="migrateDiskName", visibility=["read"])
    """Gets or sets the failover clone disk."""
    is_os_disk: Optional[bool] = rest_field(name="isOsDisk", visibility=["read"])
    """Gets or sets a value indicating whether the disk is the OS disk."""
    capacity_in_bytes: Optional[int] = rest_field(name="capacityInBytes", visibility=["read"])
    """Gets or sets the disk capacity in bytes."""
    is_dynamic: Optional[bool] = rest_field(name="isDynamic", visibility=["read"])
    """Gets or sets a value indicating whether dynamic sizing is enabled on the virtual hard disk."""
    disk_type: Optional[str] = rest_field(name="diskType", visibility=["read"])
    """Gets or sets the disk type."""
    disk_block_size: Optional[int] = rest_field(name="diskBlockSize", visibility=["read"])
    """Gets or sets a value of disk block size."""
    disk_logical_sector_size: Optional[int] = rest_field(name="diskLogicalSectorSize", visibility=["read"])
    """Gets or sets a value of disk logical sector size."""
    disk_physical_sector_size: Optional[int] = rest_field(name="diskPhysicalSectorSize", visibility=["read"])
    """Gets or sets a value of disk physical sector size."""


class VMwareToAzStackHCIProtectedItemModelCustomProperties(
    ProtectedItemModelCustomProperties, discriminator="VMwareToAzStackHCI"
):  # pylint: disable=name-too-long
    """VMware to AzStackHCI Protected item model custom properties.

    :ivar active_location: Gets or sets the location of the protected item. Known values are:
     "Primary" and "Recovery".
    :vartype active_location: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.ProtectedItemActiveLocation
    :ivar target_hci_cluster_id: Gets or sets the Target HCI Cluster ARM Id. Required.
    :vartype target_hci_cluster_id: str
    :ivar target_arc_cluster_custom_location_id: Gets or sets the Target Arc Cluster Custom
     Location ARM Id. Required.
    :vartype target_arc_cluster_custom_location_id: str
    :ivar target_az_stack_hci_cluster_name: Gets or sets the Target AzStackHCI cluster name.
    :vartype target_az_stack_hci_cluster_name: str
    :ivar storage_container_id: Gets or sets the target storage container ARM Id. Required.
    :vartype storage_container_id: str
    :ivar target_resource_group_id: Gets or sets the target resource group ARM Id. Required.
    :vartype target_resource_group_id: str
    :ivar target_location: Gets or sets the target location.
    :vartype target_location: str
    :ivar custom_location_region: Gets or sets the location of Azure Arc HCI custom location
     resource. Required.
    :vartype custom_location_region: str
    :ivar disks_to_include: Gets or sets the list of disks to replicate. Required.
    :vartype disks_to_include:
     list[~azure.mgmt.recoveryservicesdatareplication.models.VMwareToAzStackHCIDiskInput]
    :ivar nics_to_include: Gets or sets the list of VM NIC to replicate. Required.
    :vartype nics_to_include:
     list[~azure.mgmt.recoveryservicesdatareplication.models.VMwareToAzStackHCINicInput]
    :ivar protected_disks: Gets or sets the list of protected disks.
    :vartype protected_disks:
     list[~azure.mgmt.recoveryservicesdatareplication.models.VMwareToAzStackHCIProtectedDiskProperties]
    :ivar protected_nics: Gets or sets the VM NIC details.
    :vartype protected_nics:
     list[~azure.mgmt.recoveryservicesdatareplication.models.VMwareToAzStackHCIProtectedNicProperties]
    :ivar target_vm_bios_id: Gets or sets the BIOS Id of the target AzStackHCI VM.
    :vartype target_vm_bios_id: str
    :ivar target_vm_name: Gets or sets the target VM display name.
    :vartype target_vm_name: str
    :ivar hyper_v_generation: Gets or sets the hypervisor generation of the virtual machine
     possible values are 1,2. Required.
    :vartype hyper_v_generation: str
    :ivar target_network_id: Gets or sets the target network Id within AzStackHCI Cluster.
    :vartype target_network_id: str
    :ivar test_network_id: Gets or sets the target test network Id within AzStackHCI Cluster.
    :vartype test_network_id: str
    :ivar target_cpu_cores: Gets or sets the target CPU cores.
    :vartype target_cpu_cores: int
    :ivar is_dynamic_ram: Gets or sets a value indicating whether memory is dynamical.
    :vartype is_dynamic_ram: bool
    :ivar dynamic_memory_config: Protected item dynamic memory config.
    :vartype dynamic_memory_config:
     ~azure.mgmt.recoveryservicesdatareplication.models.ProtectedItemDynamicMemoryConfig
    :ivar target_memory_in_mega_bytes: Gets or sets the target memory in mega-bytes.
    :vartype target_memory_in_mega_bytes: int
    :ivar os_type: Gets or sets the type of the OS.
    :vartype os_type: str
    :ivar os_name: Gets or sets the name of the OS.
    :vartype os_name: str
    :ivar firmware_type: Gets or sets the firmware type.
    :vartype firmware_type: str
    :ivar fabric_discovery_machine_id: Gets or sets the ARM Id of the discovered machine. Required.
    :vartype fabric_discovery_machine_id: str
    :ivar source_vm_name: Gets or sets the source VM display name.
    :vartype source_vm_name: str
    :ivar source_cpu_cores: Gets or sets the source VM CPU cores.
    :vartype source_cpu_cores: int
    :ivar source_memory_in_mega_bytes: Gets or sets the source VM ram memory size in megabytes.
    :vartype source_memory_in_mega_bytes: float
    :ivar run_as_account_id: Gets or sets the run as account Id. Required.
    :vartype run_as_account_id: str
    :ivar source_fabric_agent_name: Gets or sets the source fabric agent name. Required.
    :vartype source_fabric_agent_name: str
    :ivar target_fabric_agent_name: Gets or sets the target fabric agent name. Required.
    :vartype target_fabric_agent_name: str
    :ivar source_appliance_name: Gets or sets the source appliance name.
    :vartype source_appliance_name: str
    :ivar target_appliance_name: Gets or sets the target appliance name.
    :vartype target_appliance_name: str
    :ivar failover_recovery_point_id: Gets or sets the recovery point Id to which the VM was failed
     over.
    :vartype failover_recovery_point_id: str
    :ivar last_recovery_point_received: Gets or sets the last recovery point received time.
    :vartype last_recovery_point_received: ~datetime.datetime
    :ivar last_recovery_point_id: Gets or sets the last recovery point Id.
    :vartype last_recovery_point_id: str
    :ivar initial_replication_progress_percentage: Gets or sets the initial replication progress
     percentage. This is calculated based on total bytes processed for all disks in the source VM.
    :vartype initial_replication_progress_percentage: int
    :ivar migration_progress_percentage: Gets or sets the migration progress percentage.
    :vartype migration_progress_percentage: int
    :ivar resume_progress_percentage: Gets or sets the resume progress percentage.
    :vartype resume_progress_percentage: int
    :ivar resync_progress_percentage: Gets or sets the resync progress percentage. This is
     calculated based on total bytes processed for all disks in the source VM.
    :vartype resync_progress_percentage: int
    :ivar resync_retry_count: Gets or sets the resync retry count.
    :vartype resync_retry_count: int
    :ivar resync_required: Gets or sets a value indicating whether resync is required.
    :vartype resync_required: bool
    :ivar resync_state: Gets or sets the resync state. Known values are: "None",
     "PreparedForResynchronization", and "StartedResynchronization".
    :vartype resync_state: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.VMwareToAzureMigrateResyncState
    :ivar perform_auto_resync: Gets or sets a value indicating whether auto resync is to be done.
    :vartype perform_auto_resync: bool
    :ivar resume_retry_count: Gets or sets the resume retry count.
    :vartype resume_retry_count: int
    :ivar last_replication_update_time: Gets or sets the latest timestamp that replication status
     is updated.
    :vartype last_replication_update_time: ~datetime.datetime
    :ivar instance_type: Gets or sets the instance type. Required. Default value is
     "VMwareToAzStackHCI".
    :vartype instance_type: str
    """

    active_location: Optional[Union[str, "_models.ProtectedItemActiveLocation"]] = rest_field(
        name="activeLocation", visibility=["read"]
    )
    """Gets or sets the location of the protected item. Known values are: \"Primary\" and
     \"Recovery\"."""
    target_hci_cluster_id: str = rest_field(
        name="targetHciClusterId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the Target HCI Cluster ARM Id. Required."""
    target_arc_cluster_custom_location_id: str = rest_field(
        name="targetArcClusterCustomLocationId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the Target Arc Cluster Custom Location ARM Id. Required."""
    target_az_stack_hci_cluster_name: Optional[str] = rest_field(
        name="targetAzStackHciClusterName", visibility=["read"]
    )
    """Gets or sets the Target AzStackHCI cluster name."""
    storage_container_id: str = rest_field(
        name="storageContainerId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the target storage container ARM Id. Required."""
    target_resource_group_id: str = rest_field(
        name="targetResourceGroupId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the target resource group ARM Id. Required."""
    target_location: Optional[str] = rest_field(name="targetLocation", visibility=["read"])
    """Gets or sets the target location."""
    custom_location_region: str = rest_field(
        name="customLocationRegion", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the location of Azure Arc HCI custom location resource. Required."""
    disks_to_include: List["_models.VMwareToAzStackHCIDiskInput"] = rest_field(
        name="disksToInclude", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the list of disks to replicate. Required."""
    nics_to_include: List["_models.VMwareToAzStackHCINicInput"] = rest_field(
        name="nicsToInclude", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the list of VM NIC to replicate. Required."""
    protected_disks: Optional[List["_models.VMwareToAzStackHCIProtectedDiskProperties"]] = rest_field(
        name="protectedDisks", visibility=["read"]
    )
    """Gets or sets the list of protected disks."""
    protected_nics: Optional[List["_models.VMwareToAzStackHCIProtectedNicProperties"]] = rest_field(
        name="protectedNics", visibility=["read"]
    )
    """Gets or sets the VM NIC details."""
    target_vm_bios_id: Optional[str] = rest_field(name="targetVmBiosId", visibility=["read"])
    """Gets or sets the BIOS Id of the target AzStackHCI VM."""
    target_vm_name: Optional[str] = rest_field(
        name="targetVmName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the target VM display name."""
    hyper_v_generation: str = rest_field(
        name="hyperVGeneration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the hypervisor generation of the virtual machine possible values are 1,2.
     Required."""
    target_network_id: Optional[str] = rest_field(
        name="targetNetworkId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the target network Id within AzStackHCI Cluster."""
    test_network_id: Optional[str] = rest_field(
        name="testNetworkId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the target test network Id within AzStackHCI Cluster."""
    target_cpu_cores: Optional[int] = rest_field(
        name="targetCpuCores", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the target CPU cores."""
    is_dynamic_ram: Optional[bool] = rest_field(
        name="isDynamicRam", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets a value indicating whether memory is dynamical."""
    dynamic_memory_config: Optional["_models.ProtectedItemDynamicMemoryConfig"] = rest_field(
        name="dynamicMemoryConfig", visibility=["read", "create", "update", "delete", "query"]
    )
    """Protected item dynamic memory config."""
    target_memory_in_mega_bytes: Optional[int] = rest_field(
        name="targetMemoryInMegaBytes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the target memory in mega-bytes."""
    os_type: Optional[str] = rest_field(name="osType", visibility=["read"])
    """Gets or sets the type of the OS."""
    os_name: Optional[str] = rest_field(name="osName", visibility=["read"])
    """Gets or sets the name of the OS."""
    firmware_type: Optional[str] = rest_field(name="firmwareType", visibility=["read"])
    """Gets or sets the firmware type."""
    fabric_discovery_machine_id: str = rest_field(
        name="fabricDiscoveryMachineId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the ARM Id of the discovered machine. Required."""
    source_vm_name: Optional[str] = rest_field(name="sourceVmName", visibility=["read"])
    """Gets or sets the source VM display name."""
    source_cpu_cores: Optional[int] = rest_field(name="sourceCpuCores", visibility=["read"])
    """Gets or sets the source VM CPU cores."""
    source_memory_in_mega_bytes: Optional[float] = rest_field(name="sourceMemoryInMegaBytes", visibility=["read"])
    """Gets or sets the source VM ram memory size in megabytes."""
    run_as_account_id: str = rest_field(
        name="runAsAccountId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the run as account Id. Required."""
    source_fabric_agent_name: str = rest_field(
        name="sourceFabricAgentName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the source fabric agent name. Required."""
    target_fabric_agent_name: str = rest_field(
        name="targetFabricAgentName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the target fabric agent name. Required."""
    source_appliance_name: Optional[str] = rest_field(name="sourceApplianceName", visibility=["read"])
    """Gets or sets the source appliance name."""
    target_appliance_name: Optional[str] = rest_field(name="targetApplianceName", visibility=["read"])
    """Gets or sets the target appliance name."""
    failover_recovery_point_id: Optional[str] = rest_field(name="failoverRecoveryPointId", visibility=["read"])
    """Gets or sets the recovery point Id to which the VM was failed over."""
    last_recovery_point_received: Optional[datetime.datetime] = rest_field(
        name="lastRecoveryPointReceived", visibility=["read"], format="rfc3339"
    )
    """Gets or sets the last recovery point received time."""
    last_recovery_point_id: Optional[str] = rest_field(name="lastRecoveryPointId", visibility=["read"])
    """Gets or sets the last recovery point Id."""
    initial_replication_progress_percentage: Optional[int] = rest_field(
        name="initialReplicationProgressPercentage", visibility=["read"]
    )
    """Gets or sets the initial replication progress percentage. This is calculated based on total
     bytes processed for all disks in the source VM."""
    migration_progress_percentage: Optional[int] = rest_field(name="migrationProgressPercentage", visibility=["read"])
    """Gets or sets the migration progress percentage."""
    resume_progress_percentage: Optional[int] = rest_field(name="resumeProgressPercentage", visibility=["read"])
    """Gets or sets the resume progress percentage."""
    resync_progress_percentage: Optional[int] = rest_field(name="resyncProgressPercentage", visibility=["read"])
    """Gets or sets the resync progress percentage. This is calculated based on total bytes processed
     for all disks in the source VM."""
    resync_retry_count: Optional[int] = rest_field(name="resyncRetryCount", visibility=["read"])
    """Gets or sets the resync retry count."""
    resync_required: Optional[bool] = rest_field(name="resyncRequired", visibility=["read"])
    """Gets or sets a value indicating whether resync is required."""
    resync_state: Optional[Union[str, "_models.VMwareToAzureMigrateResyncState"]] = rest_field(
        name="resyncState", visibility=["read"]
    )
    """Gets or sets the resync state. Known values are: \"None\", \"PreparedForResynchronization\",
     and \"StartedResynchronization\"."""
    perform_auto_resync: Optional[bool] = rest_field(
        name="performAutoResync", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets a value indicating whether auto resync is to be done."""
    resume_retry_count: Optional[int] = rest_field(name="resumeRetryCount", visibility=["read"])
    """Gets or sets the resume retry count."""
    last_replication_update_time: Optional[datetime.datetime] = rest_field(
        name="lastReplicationUpdateTime", visibility=["read"], format="rfc3339"
    )
    """Gets or sets the latest timestamp that replication status is updated."""
    instance_type: Literal["VMwareToAzStackHCI"] = rest_discriminator(name="instanceType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Gets or sets the instance type. Required. Default value is \"VMwareToAzStackHCI\"."""

    @overload
    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        target_hci_cluster_id: str,
        target_arc_cluster_custom_location_id: str,
        storage_container_id: str,
        target_resource_group_id: str,
        custom_location_region: str,
        disks_to_include: List["_models.VMwareToAzStackHCIDiskInput"],
        nics_to_include: List["_models.VMwareToAzStackHCINicInput"],
        hyper_v_generation: str,
        fabric_discovery_machine_id: str,
        run_as_account_id: str,
        source_fabric_agent_name: str,
        target_fabric_agent_name: str,
        target_vm_name: Optional[str] = None,
        target_network_id: Optional[str] = None,
        test_network_id: Optional[str] = None,
        target_cpu_cores: Optional[int] = None,
        is_dynamic_ram: Optional[bool] = None,
        dynamic_memory_config: Optional["_models.ProtectedItemDynamicMemoryConfig"] = None,
        target_memory_in_mega_bytes: Optional[int] = None,
        perform_auto_resync: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, instance_type="VMwareToAzStackHCI", **kwargs)


class VMwareToAzStackHCIProtectedItemModelCustomPropertiesUpdate(
    ProtectedItemModelCustomPropertiesUpdate, discriminator="VMwareToAzStackHCI"
):  # pylint: disable=name-too-long
    """VMware to AzStackHCI Protected item model custom properties.

    :ivar nics_to_include: Gets or sets the list of VM NIC to replicate.
    :vartype nics_to_include:
     list[~azure.mgmt.recoveryservicesdatareplication.models.VMwareToAzStackHCINicInput]
    :ivar target_cpu_cores: Gets or sets the target CPU cores.
    :vartype target_cpu_cores: int
    :ivar is_dynamic_ram: Gets or sets a value indicating whether memory is dynamical.
    :vartype is_dynamic_ram: bool
    :ivar dynamic_memory_config: Protected item dynamic memory config.
    :vartype dynamic_memory_config:
     ~azure.mgmt.recoveryservicesdatareplication.models.ProtectedItemDynamicMemoryConfig
    :ivar target_memory_in_mega_bytes: Gets or sets the target memory in mega-bytes.
    :vartype target_memory_in_mega_bytes: int
    :ivar instance_type: Gets or sets the instance type. Required. Default value is
     "VMwareToAzStackHCI".
    :vartype instance_type: str
    :ivar os_type: Gets or sets the type of the OS.
    :vartype os_type: str
    """

    nics_to_include: Optional[List["_models.VMwareToAzStackHCINicInput"]] = rest_field(
        name="nicsToInclude", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the list of VM NIC to replicate."""
    target_cpu_cores: Optional[int] = rest_field(
        name="targetCpuCores", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the target CPU cores."""
    is_dynamic_ram: Optional[bool] = rest_field(
        name="isDynamicRam", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets a value indicating whether memory is dynamical."""
    dynamic_memory_config: Optional["_models.ProtectedItemDynamicMemoryConfig"] = rest_field(
        name="dynamicMemoryConfig", visibility=["read", "create", "update", "delete", "query"]
    )
    """Protected item dynamic memory config."""
    target_memory_in_mega_bytes: Optional[int] = rest_field(
        name="targetMemoryInMegaBytes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the target memory in mega-bytes."""
    instance_type: Literal["VMwareToAzStackHCI"] = rest_discriminator(name="instanceType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Gets or sets the instance type. Required. Default value is \"VMwareToAzStackHCI\"."""
    os_type: Optional[str] = rest_field(name="osType", visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the type of the OS."""

    @overload
    def __init__(
        self,
        *,
        nics_to_include: Optional[List["_models.VMwareToAzStackHCINicInput"]] = None,
        target_cpu_cores: Optional[int] = None,
        is_dynamic_ram: Optional[bool] = None,
        dynamic_memory_config: Optional["_models.ProtectedItemDynamicMemoryConfig"] = None,
        target_memory_in_mega_bytes: Optional[int] = None,
        os_type: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, instance_type="VMwareToAzStackHCI", **kwargs)


class VMwareToAzStackHCIProtectedNicProperties(_Model):
    """VMwareToAzStackHCI NIC properties.

    :ivar nic_id: Gets or sets the NIC Id.
    :vartype nic_id: str
    :ivar mac_address: Gets or sets the NIC mac address.
    :vartype mac_address: str
    :ivar label: Gets or sets the NIC label.
    :vartype label: str
    :ivar is_primary_nic: Gets or sets a value indicating whether this is the primary NIC.
    :vartype is_primary_nic: bool
    :ivar network_name: Gets or sets the network name.
    :vartype network_name: str
    :ivar target_network_id: Gets or sets the target network Id within AzStackHCI Cluster.
    :vartype target_network_id: str
    :ivar test_network_id: Gets or sets the target test network Id within AzStackHCI Cluster.
    :vartype test_network_id: str
    :ivar selection_type_for_failover: Gets or sets the selection type of the NIC. Known values
     are: "NotSelected", "SelectedByUser", "SelectedByDefault", and "SelectedByUserOverride".
    :vartype selection_type_for_failover: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.VMNicSelection
    """

    nic_id: Optional[str] = rest_field(name="nicId", visibility=["read"])
    """Gets or sets the NIC Id."""
    mac_address: Optional[str] = rest_field(name="macAddress", visibility=["read"])
    """Gets or sets the NIC mac address."""
    label: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets the NIC label."""
    is_primary_nic: Optional[bool] = rest_field(
        name="isPrimaryNic", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets a value indicating whether this is the primary NIC."""
    network_name: Optional[str] = rest_field(name="networkName", visibility=["read"])
    """Gets or sets the network name."""
    target_network_id: Optional[str] = rest_field(name="targetNetworkId", visibility=["read"])
    """Gets or sets the target network Id within AzStackHCI Cluster."""
    test_network_id: Optional[str] = rest_field(name="testNetworkId", visibility=["read"])
    """Gets or sets the target test network Id within AzStackHCI Cluster."""
    selection_type_for_failover: Optional[Union[str, "_models.VMNicSelection"]] = rest_field(
        name="selectionTypeForFailover", visibility=["read"]
    )
    """Gets or sets the selection type of the NIC. Known values are: \"NotSelected\",
     \"SelectedByUser\", \"SelectedByDefault\", and \"SelectedByUserOverride\"."""

    @overload
    def __init__(
        self,
        *,
        is_primary_nic: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VMwareToAzStackHCIRecoveryPointModelCustomProperties(
    RecoveryPointModelCustomProperties, discriminator="VMwareToAzStackHCIRecoveryPointModelCustomProperties"
):  # pylint: disable=name-too-long
    """VMware to AzStackHCI recovery point model custom properties.

    :ivar disk_ids: Gets or sets the list of the disk Ids.
    :vartype disk_ids: list[str]
    :ivar instance_type: Gets or sets the instance type. Required. Default value is
     "VMwareToAzStackHCIRecoveryPointModelCustomProperties".
    :vartype instance_type: str
    """

    disk_ids: Optional[List[str]] = rest_field(name="diskIds", visibility=["read"])
    """Gets or sets the list of the disk Ids."""
    instance_type: Literal["VMwareToAzStackHCIRecoveryPointModelCustomProperties"] = rest_discriminator(name="instanceType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Gets or sets the instance type. Required. Default value is
     \"VMwareToAzStackHCIRecoveryPointModelCustomProperties\"."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, instance_type="VMwareToAzStackHCIRecoveryPointModelCustomProperties", **kwargs)


class VMwareToAzStackHCIReplicationExtensionModelCustomProperties(
    ReplicationExtensionModelCustomProperties, discriminator="VMwareToAzStackHCI"
):  # pylint: disable=name-too-long
    """VMware to AzStackHCI Replication extension model custom properties.

    :ivar vmware_fabric_arm_id: Gets or sets the ARM Id of the source VMware fabric. Required.
    :vartype vmware_fabric_arm_id: str
    :ivar vmware_site_id: Gets or sets the ARM Id of the VMware site.
    :vartype vmware_site_id: str
    :ivar az_stack_hci_fabric_arm_id: Gets or sets the ARM Id of the target AzStackHCI fabric.
     Required.
    :vartype az_stack_hci_fabric_arm_id: str
    :ivar az_stack_hci_site_id: Gets or sets the ARM Id of the AzStackHCI site.
    :vartype az_stack_hci_site_id: str
    :ivar storage_account_id: Gets or sets the storage account Id.
    :vartype storage_account_id: str
    :ivar storage_account_sas_secret_name: Gets or sets the Sas Secret of storage account.
    :vartype storage_account_sas_secret_name: str
    :ivar asr_service_uri: Gets or sets the Uri of ASR.
    :vartype asr_service_uri: str
    :ivar rcm_service_uri: Gets or sets the Uri of Rcm.
    :vartype rcm_service_uri: str
    :ivar gateway_service_uri: Gets or sets the Uri of Gateway.
    :vartype gateway_service_uri: str
    :ivar source_gateway_service_id: Gets or sets the gateway service Id of source.
    :vartype source_gateway_service_id: str
    :ivar target_gateway_service_id: Gets or sets the gateway service Id of target.
    :vartype target_gateway_service_id: str
    :ivar source_storage_container_name: Gets or sets the source storage container name.
    :vartype source_storage_container_name: str
    :ivar target_storage_container_name: Gets or sets the target storage container name.
    :vartype target_storage_container_name: str
    :ivar resource_location: Gets or sets the resource location.
    :vartype resource_location: str
    :ivar subscription_id: Gets or sets the subscription.
    :vartype subscription_id: str
    :ivar resource_group: Gets or sets the resource group.
    :vartype resource_group: str
    :ivar instance_type: Gets or sets the instance type. Required. Default value is
     "VMwareToAzStackHCI".
    :vartype instance_type: str
    """

    vmware_fabric_arm_id: str = rest_field(
        name="vmwareFabricArmId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the ARM Id of the source VMware fabric. Required."""
    vmware_site_id: Optional[str] = rest_field(name="vmwareSiteId", visibility=["read"])
    """Gets or sets the ARM Id of the VMware site."""
    az_stack_hci_fabric_arm_id: str = rest_field(
        name="azStackHciFabricArmId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the ARM Id of the target AzStackHCI fabric. Required."""
    az_stack_hci_site_id: Optional[str] = rest_field(name="azStackHciSiteId", visibility=["read"])
    """Gets or sets the ARM Id of the AzStackHCI site."""
    storage_account_id: Optional[str] = rest_field(
        name="storageAccountId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the storage account Id."""
    storage_account_sas_secret_name: Optional[str] = rest_field(
        name="storageAccountSasSecretName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the Sas Secret of storage account."""
    asr_service_uri: Optional[str] = rest_field(name="asrServiceUri", visibility=["read"])
    """Gets or sets the Uri of ASR."""
    rcm_service_uri: Optional[str] = rest_field(name="rcmServiceUri", visibility=["read"])
    """Gets or sets the Uri of Rcm."""
    gateway_service_uri: Optional[str] = rest_field(name="gatewayServiceUri", visibility=["read"])
    """Gets or sets the Uri of Gateway."""
    source_gateway_service_id: Optional[str] = rest_field(name="sourceGatewayServiceId", visibility=["read"])
    """Gets or sets the gateway service Id of source."""
    target_gateway_service_id: Optional[str] = rest_field(name="targetGatewayServiceId", visibility=["read"])
    """Gets or sets the gateway service Id of target."""
    source_storage_container_name: Optional[str] = rest_field(name="sourceStorageContainerName", visibility=["read"])
    """Gets or sets the source storage container name."""
    target_storage_container_name: Optional[str] = rest_field(name="targetStorageContainerName", visibility=["read"])
    """Gets or sets the target storage container name."""
    resource_location: Optional[str] = rest_field(name="resourceLocation", visibility=["read"])
    """Gets or sets the resource location."""
    subscription_id: Optional[str] = rest_field(name="subscriptionId", visibility=["read"])
    """Gets or sets the subscription."""
    resource_group: Optional[str] = rest_field(name="resourceGroup", visibility=["read"])
    """Gets or sets the resource group."""
    instance_type: Literal["VMwareToAzStackHCI"] = rest_discriminator(name="instanceType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Gets or sets the instance type. Required. Default value is \"VMwareToAzStackHCI\"."""

    @overload
    def __init__(
        self,
        *,
        vmware_fabric_arm_id: str,
        az_stack_hci_fabric_arm_id: str,
        storage_account_id: Optional[str] = None,
        storage_account_sas_secret_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, instance_type="VMwareToAzStackHCI", **kwargs)
