# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.eventhub.aio import EventHubManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestEventHubManagementNamespacesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(EventHubManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_namespaces_list(self, resource_group):
        response = self.client.namespaces.list(
            api_version="2022-01-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_namespaces_list_by_resource_group(self, resource_group):
        response = self.client.namespaces.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2022-01-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_namespaces_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.namespaces.begin_create_or_update(
                resource_group_name=resource_group.name,
                namespace_name="str",
                parameters={
                    "alternateName": "str",
                    "clusterArmId": "str",
                    "createdAt": "2020-02-20 00:00:00",
                    "disableLocalAuth": bool,
                    "encryption": {
                        "keySource": "Microsoft.KeyVault",
                        "keyVaultProperties": [
                            {
                                "identity": {"userAssignedIdentity": "str"},
                                "keyName": "str",
                                "keyVaultUri": "str",
                                "keyVersion": "str",
                            }
                        ],
                        "requireInfrastructureEncryption": bool,
                    },
                    "id": "str",
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "isAutoInflateEnabled": bool,
                    "kafkaEnabled": bool,
                    "location": "str",
                    "maximumThroughputUnits": 0,
                    "metricId": "str",
                    "minimumTlsVersion": "str",
                    "name": "str",
                    "privateEndpointConnections": [
                        {
                            "id": "str",
                            "location": "str",
                            "name": "str",
                            "privateEndpoint": {"id": "str"},
                            "privateLinkServiceConnectionState": {"description": "str", "status": "str"},
                            "provisioningState": "str",
                            "systemData": {
                                "createdAt": "2020-02-20 00:00:00",
                                "createdBy": "str",
                                "createdByType": "str",
                                "lastModifiedAt": "2020-02-20 00:00:00",
                                "lastModifiedBy": "str",
                                "lastModifiedByType": "str",
                            },
                            "type": "str",
                        }
                    ],
                    "provisioningState": "str",
                    "publicNetworkAccess": "Enabled",
                    "serviceBusEndpoint": "str",
                    "sku": {"name": "str", "capacity": 0, "tier": "str"},
                    "status": "str",
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                    "updatedAt": "2020-02-20 00:00:00",
                    "zoneRedundant": bool,
                },
                api_version="2022-01-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_namespaces_begin_delete(self, resource_group):
        response = await (
            await self.client.namespaces.begin_delete(
                resource_group_name=resource_group.name,
                namespace_name="str",
                api_version="2022-01-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_namespaces_get(self, resource_group):
        response = await self.client.namespaces.get(
            resource_group_name=resource_group.name,
            namespace_name="str",
            api_version="2022-01-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_namespaces_update(self, resource_group):
        response = await self.client.namespaces.update(
            resource_group_name=resource_group.name,
            namespace_name="str",
            parameters={
                "alternateName": "str",
                "clusterArmId": "str",
                "createdAt": "2020-02-20 00:00:00",
                "disableLocalAuth": bool,
                "encryption": {
                    "keySource": "Microsoft.KeyVault",
                    "keyVaultProperties": [
                        {
                            "identity": {"userAssignedIdentity": "str"},
                            "keyName": "str",
                            "keyVaultUri": "str",
                            "keyVersion": "str",
                        }
                    ],
                    "requireInfrastructureEncryption": bool,
                },
                "id": "str",
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "isAutoInflateEnabled": bool,
                "kafkaEnabled": bool,
                "location": "str",
                "maximumThroughputUnits": 0,
                "metricId": "str",
                "minimumTlsVersion": "str",
                "name": "str",
                "privateEndpointConnections": [
                    {
                        "id": "str",
                        "location": "str",
                        "name": "str",
                        "privateEndpoint": {"id": "str"},
                        "privateLinkServiceConnectionState": {"description": "str", "status": "str"},
                        "provisioningState": "str",
                        "systemData": {
                            "createdAt": "2020-02-20 00:00:00",
                            "createdBy": "str",
                            "createdByType": "str",
                            "lastModifiedAt": "2020-02-20 00:00:00",
                            "lastModifiedBy": "str",
                            "lastModifiedByType": "str",
                        },
                        "type": "str",
                    }
                ],
                "provisioningState": "str",
                "publicNetworkAccess": "Enabled",
                "serviceBusEndpoint": "str",
                "sku": {"name": "str", "capacity": 0, "tier": "str"},
                "status": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
                "updatedAt": "2020-02-20 00:00:00",
                "zoneRedundant": bool,
            },
            api_version="2022-01-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_namespaces_create_or_update_network_rule_set(self, resource_group):
        response = await self.client.namespaces.create_or_update_network_rule_set(
            resource_group_name=resource_group.name,
            namespace_name="str",
            parameters={
                "defaultAction": "str",
                "id": "str",
                "ipRules": [{"action": "str", "ipMask": "str"}],
                "location": "str",
                "name": "str",
                "publicNetworkAccess": "Enabled",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "trustedServiceAccessEnabled": bool,
                "type": "str",
                "virtualNetworkRules": [{"ignoreMissingVnetServiceEndpoint": bool, "subnet": {"id": "str"}}],
            },
            api_version="2022-01-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_namespaces_get_network_rule_set(self, resource_group):
        response = await self.client.namespaces.get_network_rule_set(
            resource_group_name=resource_group.name,
            namespace_name="str",
            api_version="2022-01-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_namespaces_list_network_rule_set(self, resource_group):
        response = await self.client.namespaces.list_network_rule_set(
            resource_group_name=resource_group.name,
            namespace_name="str",
            api_version="2022-01-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_namespaces_list_authorization_rules(self, resource_group):
        response = self.client.namespaces.list_authorization_rules(
            resource_group_name=resource_group.name,
            namespace_name="str",
            api_version="2022-01-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_namespaces_create_or_update_authorization_rule(self, resource_group):
        response = await self.client.namespaces.create_or_update_authorization_rule(
            resource_group_name=resource_group.name,
            namespace_name="str",
            authorization_rule_name="str",
            parameters={
                "id": "str",
                "location": "str",
                "name": "str",
                "rights": ["str"],
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2022-01-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_namespaces_delete_authorization_rule(self, resource_group):
        response = await self.client.namespaces.delete_authorization_rule(
            resource_group_name=resource_group.name,
            namespace_name="str",
            authorization_rule_name="str",
            api_version="2022-01-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_namespaces_get_authorization_rule(self, resource_group):
        response = await self.client.namespaces.get_authorization_rule(
            resource_group_name=resource_group.name,
            namespace_name="str",
            authorization_rule_name="str",
            api_version="2022-01-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_namespaces_list_keys(self, resource_group):
        response = await self.client.namespaces.list_keys(
            resource_group_name=resource_group.name,
            namespace_name="str",
            authorization_rule_name="str",
            api_version="2022-01-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_namespaces_regenerate_keys(self, resource_group):
        response = await self.client.namespaces.regenerate_keys(
            resource_group_name=resource_group.name,
            namespace_name="str",
            authorization_rule_name="str",
            parameters={"keyType": "str", "key": "str"},
            api_version="2022-01-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_namespaces_check_name_availability(self, resource_group):
        response = await self.client.namespaces.check_name_availability(
            parameters={"name": "str"},
            api_version="2022-01-01-preview",
        )

        # please add some check logic here by yourself
        # ...
