# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.edgeorder import EdgeOrderManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.live_test_only
class TestEdgeOrderManagement(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(EdgeOrderManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_operations(self, resource_group):
        response = self.client.list_operations()
        result = [r for r in response]
        assert response

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_addresses_at_subscription_level(self, resource_group):
        response = self.client.list_addresses_at_subscription_level()
        result = [r for r in response]
        assert response

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_product_families_metadata(self, resource_group):
        response = self.client.list_product_families_metadata()
        result = [r for r in response]
        assert response

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_order_at_subscription_level(self, resource_group):
        response = self.client.list_order_at_subscription_level()
        result = [r for r in response]
        assert response

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_order_items_at_subscription_level(self, resource_group):
        response = self.client.list_order_items_at_subscription_level()
        result = [r for r in response]
        assert response

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_addresses_at_resource_group_level(self, resource_group):
        response = self.client.list_addresses_at_resource_group_level(
            resource_group_name=resource_group.name,
        )
        result = [r for r in response]
        assert result == []

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_order_at_resource_group_level(self, resource_group):
        response = self.client.list_order_at_resource_group_level(
            resource_group_name=resource_group.name,
        )
        result = [r for r in response]
        assert result == []

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_order_items_at_resource_group_level(self, resource_group):
        response = self.client.list_order_items_at_resource_group_level(
            resource_group_name=resource_group.name,
        )
        result = [r for r in response]
        assert response
