# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class Resource(_Model):
    """Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.computerecommender.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class ProxyResource(Resource):
    """Proxy Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.computerecommender.models.SystemData
    """


class ComputeDiagnosticBase(ProxyResource):
    """Contains metadata of a diagnostic type.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.computerecommender.models.SystemData
    :ivar properties: Contains additional properties of a diagnostic.
    :vartype properties: ~azure.mgmt.computerecommender.models.DiagnosticProperties
    """

    properties: Optional["_models.DiagnosticProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Contains additional properties of a diagnostic."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.DiagnosticProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DiagnosticProperties(_Model):
    """Contains additional properties of a diagnostic.

    :ivar supported_resource_types: Describes what are the supported resource types for a
     diagnostic.
    :vartype supported_resource_types: list[str]
    """

    supported_resource_types: Optional[list[str]] = rest_field(
        name="supportedResourceTypes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Describes what are the supported resource types for a diagnostic."""

    @overload
    def __init__(
        self,
        *,
        supported_resource_types: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.computerecommender.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.computerecommender.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[list["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.computerecommender.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Operation(_Model):
    """REST API Operation.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.computerecommender.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.computerecommender.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.computerecommender.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType", visibility=["read"])
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_Model):
    """Localized display information for and operation.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class PlacementScore(_Model):
    """The spot placement score for sku/region/zone combination.

    :ivar sku: The resource's CRP virtual machine SKU size.
    :vartype sku: str
    :ivar region: The region.
    :vartype region: str
    :ivar availability_zone: The availability zone.
    :vartype availability_zone: str
    :ivar score: A placement score indicating the likelihood of successfully allocating the
     specified Spot VM(s), as well as the expected lifetimes of the Spot VM(s) after allocation.
    :vartype score: str
    :ivar is_quota_available: Whether the desired quota is available.
    :vartype is_quota_available: bool
    """

    sku: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The resource's CRP virtual machine SKU size."""
    region: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The region."""
    availability_zone: Optional[str] = rest_field(
        name="availabilityZone", visibility=["read", "create", "update", "delete", "query"]
    )
    """The availability zone."""
    score: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A placement score indicating the likelihood of successfully allocating the specified Spot
     VM(s), as well as the expected lifetimes of the Spot VM(s) after allocation."""
    is_quota_available: Optional[bool] = rest_field(
        name="isQuotaAvailable", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether the desired quota is available."""

    @overload
    def __init__(
        self,
        *,
        sku: Optional[str] = None,
        region: Optional[str] = None,
        availability_zone: Optional[str] = None,
        score: Optional[str] = None,
        is_quota_available: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResourceSize(_Model):
    """SpotPlacementRecommender API response.

    :ivar sku: The resource's CRP virtual machine SKU size.
    :vartype sku: str
    """

    sku: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The resource's CRP virtual machine SKU size."""

    @overload
    def __init__(
        self,
        *,
        sku: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SpotPlacementScoresInput(_Model):
    """SpotPlacementScores API Input.

    :ivar desired_locations: The desired regions.
    :vartype desired_locations: list[str]
    :ivar desired_sizes: The desired virtual machine SKU sizes.
    :vartype desired_sizes: list[~azure.mgmt.computerecommender.models.ResourceSize]
    :ivar desired_count: Desired instance count per region/zone based on the scope.
    :vartype desired_count: int
    :ivar availability_zones: Defines if the scope is zonal or regional.
    :vartype availability_zones: bool
    """

    desired_locations: Optional[list[str]] = rest_field(
        name="desiredLocations", visibility=["read", "create", "update", "delete", "query"]
    )
    """The desired regions."""
    desired_sizes: Optional[list["_models.ResourceSize"]] = rest_field(
        name="desiredSizes", visibility=["read", "create", "update", "delete", "query"]
    )
    """The desired virtual machine SKU sizes."""
    desired_count: Optional[int] = rest_field(
        name="desiredCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Desired instance count per region/zone based on the scope."""
    availability_zones: Optional[bool] = rest_field(
        name="availabilityZones", visibility=["read", "create", "update", "delete", "query"]
    )
    """Defines if the scope is zonal or regional."""

    @overload
    def __init__(
        self,
        *,
        desired_locations: Optional[list[str]] = None,
        desired_sizes: Optional[list["_models.ResourceSize"]] = None,
        desired_count: Optional[int] = None,
        availability_zones: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SpotPlacementScoresResponse(_Model):
    """SpotPlacementScores API response.

    :ivar desired_locations: The desired regions.
    :vartype desired_locations: list[str]
    :ivar desired_sizes: The desired virtual machine SKU sizes.
    :vartype desired_sizes: list[~azure.mgmt.computerecommender.models.ResourceSize]
    :ivar desired_count: Desired instance count per region/zone based on the scope.
    :vartype desired_count: int
    :ivar availability_zones: Defines if the scope is zonal or regional.
    :vartype availability_zones: bool
    :ivar placement_scores: A placement score indicating the likelihood of successfully allocating
     the specified Spot VM(s), as well as the expected lifetimes of the Spot VM(s) after allocation.
    :vartype placement_scores: list[~azure.mgmt.computerecommender.models.PlacementScore]
    """

    desired_locations: Optional[list[str]] = rest_field(
        name="desiredLocations", visibility=["read", "create", "update", "delete", "query"]
    )
    """The desired regions."""
    desired_sizes: Optional[list["_models.ResourceSize"]] = rest_field(
        name="desiredSizes", visibility=["read", "create", "update", "delete", "query"]
    )
    """The desired virtual machine SKU sizes."""
    desired_count: Optional[int] = rest_field(
        name="desiredCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Desired instance count per region/zone based on the scope."""
    availability_zones: Optional[bool] = rest_field(
        name="availabilityZones", visibility=["read", "create", "update", "delete", "query"]
    )
    """Defines if the scope is zonal or regional."""
    placement_scores: Optional[list["_models.PlacementScore"]] = rest_field(
        name="placementScores", visibility=["read", "create", "update", "delete", "query"]
    )
    """A placement score indicating the likelihood of successfully allocating the specified Spot
     VM(s), as well as the expected lifetimes of the Spot VM(s) after allocation."""

    @overload
    def __init__(
        self,
        *,
        desired_locations: Optional[list[str]] = None,
        desired_sizes: Optional[list["_models.ResourceSize"]] = None,
        desired_count: Optional[int] = None,
        availability_zones: Optional[bool] = None,
        placement_scores: Optional[list["_models.PlacementScore"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.computerecommender.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.computerecommender.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
