# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.authorization.aio import AuthorizationManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAuthorizationManagementRoleEligibilityScheduleRequestsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(AuthorizationManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_role_eligibility_schedule_requests_create(self, resource_group):
        response = await self.client.role_eligibility_schedule_requests.create(
            scope="str",
            role_eligibility_schedule_request_name="str",
            parameters={
                "approvalId": "str",
                "condition": "str",
                "conditionVersion": "str",
                "createdOn": "2020-02-20 00:00:00",
                "expandedProperties": {
                    "principal": {"displayName": "str", "email": "str", "id": "str", "type": "str"},
                    "roleDefinition": {"displayName": "str", "id": "str", "type": "str"},
                    "scope": {"displayName": "str", "id": "str", "type": "str"},
                },
                "id": "str",
                "justification": "str",
                "name": "str",
                "principalId": "str",
                "principalType": "str",
                "requestType": "str",
                "requestorId": "str",
                "roleDefinitionId": "str",
                "scheduleInfo": {
                    "expiration": {"duration": "str", "endDateTime": "2020-02-20 00:00:00", "type": "str"},
                    "startDateTime": "2020-02-20 00:00:00",
                },
                "scope": "str",
                "status": "str",
                "targetRoleEligibilityScheduleId": "str",
                "targetRoleEligibilityScheduleInstanceId": "str",
                "ticketInfo": {"ticketNumber": "str", "ticketSystem": "str"},
                "type": "str",
            },
            api_version="2024-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_role_eligibility_schedule_requests_get(self, resource_group):
        response = await self.client.role_eligibility_schedule_requests.get(
            scope="str",
            role_eligibility_schedule_request_name="str",
            api_version="2024-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_role_eligibility_schedule_requests_list_for_scope(self, resource_group):
        response = self.client.role_eligibility_schedule_requests.list_for_scope(
            scope="str",
            api_version="2024-09-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_role_eligibility_schedule_requests_cancel(self, resource_group):
        response = await self.client.role_eligibility_schedule_requests.cancel(
            scope="str",
            role_eligibility_schedule_request_name="str",
            api_version="2024-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_role_eligibility_schedule_requests_validate(self, resource_group):
        response = await self.client.role_eligibility_schedule_requests.validate(
            scope="str",
            role_eligibility_schedule_request_name="str",
            parameters={
                "approvalId": "str",
                "condition": "str",
                "conditionVersion": "str",
                "createdOn": "2020-02-20 00:00:00",
                "expandedProperties": {
                    "principal": {"displayName": "str", "email": "str", "id": "str", "type": "str"},
                    "roleDefinition": {"displayName": "str", "id": "str", "type": "str"},
                    "scope": {"displayName": "str", "id": "str", "type": "str"},
                },
                "id": "str",
                "justification": "str",
                "name": "str",
                "principalId": "str",
                "principalType": "str",
                "requestType": "str",
                "requestorId": "str",
                "roleDefinitionId": "str",
                "scheduleInfo": {
                    "expiration": {"duration": "str", "endDateTime": "2020-02-20 00:00:00", "type": "str"},
                    "startDateTime": "2020-02-20 00:00:00",
                },
                "scope": "str",
                "status": "str",
                "targetRoleEligibilityScheduleId": "str",
                "targetRoleEligibilityScheduleInstanceId": "str",
                "ticketInfo": {"ticketNumber": "str", "ticketSystem": "str"},
                "type": "str",
            },
            api_version="2024-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...
