# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Awaitable, Optional, TYPE_CHECKING, cast
from typing_extensions import Self

from azure.core.pipeline import policies
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.settings import settings
from azure.mgmt.core import AsyncARMPipelineClient
from azure.mgmt.core.policies import AsyncARMAutoResourceProviderRegistrationPolicy
from azure.mgmt.core.tools import get_arm_endpoints

from .. import models as _models
from .._utils.serialization import Deserializer, Serializer
from ._configuration import WebSiteManagementClientConfiguration
from .operations import (
    AppServiceCertificateOrdersOperations,
    AppServiceEnvironmentsOperations,
    AppServicePlansOperations,
    CertificateOrdersDiagnosticsOperations,
    CertificateRegistrationProviderOperations,
    CertificatesOperations,
    DeletedWebAppsOperations,
    DiagnosticsOperations,
    DomainRegistrationProviderOperations,
    DomainsOperations,
    GetUsagesInLocationOperations,
    GlobalOperations,
    KubeEnvironmentsOperations,
    ProviderOperations,
    RecommendationsOperations,
    ResourceHealthMetadataOperations,
    SiteCertificatesOperations,
    StaticSitesOperations,
    TopLevelDomainsOperations,
    WebAppsOperations,
    WorkflowRunActionRepetitionsOperations,
    WorkflowRunActionRepetitionsRequestHistoriesOperations,
    WorkflowRunActionScopeRepetitionsOperations,
    WorkflowRunActionsOperations,
    WorkflowRunsOperations,
    WorkflowTriggerHistoriesOperations,
    WorkflowTriggersOperations,
    WorkflowVersionsOperations,
    WorkflowsOperations,
    _WebSiteManagementClientOperationsMixin,
)

if TYPE_CHECKING:
    from azure.core import AzureClouds
    from azure.core.credentials_async import AsyncTokenCredential


class WebSiteManagementClient(
    _WebSiteManagementClientOperationsMixin
):  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """AppService Management Client.

    :ivar app_service_environments: AppServiceEnvironmentsOperations operations
    :vartype app_service_environments:
     azure.mgmt.web.aio.operations.AppServiceEnvironmentsOperations
    :ivar app_service_plans: AppServicePlansOperations operations
    :vartype app_service_plans: azure.mgmt.web.aio.operations.AppServicePlansOperations
    :ivar certificates: CertificatesOperations operations
    :vartype certificates: azure.mgmt.web.aio.operations.CertificatesOperations
    :ivar deleted_web_apps: DeletedWebAppsOperations operations
    :vartype deleted_web_apps: azure.mgmt.web.aio.operations.DeletedWebAppsOperations
    :ivar diagnostics: DiagnosticsOperations operations
    :vartype diagnostics: azure.mgmt.web.aio.operations.DiagnosticsOperations
    :ivar global_operations: GlobalOperations operations
    :vartype global_operations: azure.mgmt.web.aio.operations.GlobalOperations
    :ivar kube_environments: KubeEnvironmentsOperations operations
    :vartype kube_environments: azure.mgmt.web.aio.operations.KubeEnvironmentsOperations
    :ivar provider: ProviderOperations operations
    :vartype provider: azure.mgmt.web.aio.operations.ProviderOperations
    :ivar recommendations: RecommendationsOperations operations
    :vartype recommendations: azure.mgmt.web.aio.operations.RecommendationsOperations
    :ivar resource_health_metadata: ResourceHealthMetadataOperations operations
    :vartype resource_health_metadata:
     azure.mgmt.web.aio.operations.ResourceHealthMetadataOperations
    :ivar get_usages_in_location: GetUsagesInLocationOperations operations
    :vartype get_usages_in_location: azure.mgmt.web.aio.operations.GetUsagesInLocationOperations
    :ivar site_certificates: SiteCertificatesOperations operations
    :vartype site_certificates: azure.mgmt.web.aio.operations.SiteCertificatesOperations
    :ivar static_sites: StaticSitesOperations operations
    :vartype static_sites: azure.mgmt.web.aio.operations.StaticSitesOperations
    :ivar web_apps: WebAppsOperations operations
    :vartype web_apps: azure.mgmt.web.aio.operations.WebAppsOperations
    :ivar workflows: WorkflowsOperations operations
    :vartype workflows: azure.mgmt.web.aio.operations.WorkflowsOperations
    :ivar workflow_runs: WorkflowRunsOperations operations
    :vartype workflow_runs: azure.mgmt.web.aio.operations.WorkflowRunsOperations
    :ivar workflow_run_actions: WorkflowRunActionsOperations operations
    :vartype workflow_run_actions: azure.mgmt.web.aio.operations.WorkflowRunActionsOperations
    :ivar workflow_run_action_repetitions: WorkflowRunActionRepetitionsOperations operations
    :vartype workflow_run_action_repetitions:
     azure.mgmt.web.aio.operations.WorkflowRunActionRepetitionsOperations
    :ivar workflow_run_action_repetitions_request_histories:
     WorkflowRunActionRepetitionsRequestHistoriesOperations operations
    :vartype workflow_run_action_repetitions_request_histories:
     azure.mgmt.web.aio.operations.WorkflowRunActionRepetitionsRequestHistoriesOperations
    :ivar workflow_run_action_scope_repetitions: WorkflowRunActionScopeRepetitionsOperations
     operations
    :vartype workflow_run_action_scope_repetitions:
     azure.mgmt.web.aio.operations.WorkflowRunActionScopeRepetitionsOperations
    :ivar workflow_triggers: WorkflowTriggersOperations operations
    :vartype workflow_triggers: azure.mgmt.web.aio.operations.WorkflowTriggersOperations
    :ivar workflow_trigger_histories: WorkflowTriggerHistoriesOperations operations
    :vartype workflow_trigger_histories:
     azure.mgmt.web.aio.operations.WorkflowTriggerHistoriesOperations
    :ivar workflow_versions: WorkflowVersionsOperations operations
    :vartype workflow_versions: azure.mgmt.web.aio.operations.WorkflowVersionsOperations
    :ivar app_service_certificate_orders: AppServiceCertificateOrdersOperations operations
    :vartype app_service_certificate_orders:
     azure.mgmt.web.aio.operations.AppServiceCertificateOrdersOperations
    :ivar certificate_orders_diagnostics: CertificateOrdersDiagnosticsOperations operations
    :vartype certificate_orders_diagnostics:
     azure.mgmt.web.aio.operations.CertificateOrdersDiagnosticsOperations
    :ivar certificate_registration_provider: CertificateRegistrationProviderOperations operations
    :vartype certificate_registration_provider:
     azure.mgmt.web.aio.operations.CertificateRegistrationProviderOperations
    :ivar domain_registration_provider: DomainRegistrationProviderOperations operations
    :vartype domain_registration_provider:
     azure.mgmt.web.aio.operations.DomainRegistrationProviderOperations
    :ivar domains: DomainsOperations operations
    :vartype domains: azure.mgmt.web.aio.operations.DomainsOperations
    :ivar top_level_domains: TopLevelDomainsOperations operations
    :vartype top_level_domains: azure.mgmt.web.aio.operations.TopLevelDomainsOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: Your Azure subscription ID. This is a GUID-formatted string (e.g.
     00000000-0000-0000-0000-000000000000). Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is None.
    :type base_url: str
    :keyword cloud_setting: The cloud setting for which to get the ARM endpoint. Default value is
     None.
    :paramtype cloud_setting: ~azure.core.AzureClouds
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        base_url: Optional[str] = None,
        *,
        cloud_setting: Optional["AzureClouds"] = None,
        **kwargs: Any
    ) -> None:
        _cloud = cloud_setting or settings.current.azure_cloud  # type: ignore
        _endpoints = get_arm_endpoints(_cloud)
        if not base_url:
            base_url = _endpoints["resource_manager"]
        credential_scopes = kwargs.pop("credential_scopes", _endpoints["credential_scopes"])
        self._config = WebSiteManagementClientConfiguration(
            credential=credential,
            subscription_id=subscription_id,
            cloud_setting=cloud_setting,
            credential_scopes=credential_scopes,
            **kwargs
        )

        _policies = kwargs.pop("policies", None)
        if _policies is None:
            _policies = [
                policies.RequestIdPolicy(**kwargs),
                self._config.headers_policy,
                self._config.user_agent_policy,
                self._config.proxy_policy,
                policies.ContentDecodePolicy(**kwargs),
                AsyncARMAutoResourceProviderRegistrationPolicy(),
                self._config.redirect_policy,
                self._config.retry_policy,
                self._config.authentication_policy,
                self._config.custom_hook_policy,
                self._config.logging_policy,
                policies.DistributedTracingPolicy(**kwargs),
                policies.SensitiveHeaderCleanupPolicy(**kwargs) if self._config.redirect_policy else None,
                self._config.http_logging_policy,
            ]
        self._client: AsyncARMPipelineClient = AsyncARMPipelineClient(
            base_url=cast(str, base_url), policies=_policies, **kwargs
        )

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.app_service_environments = AppServiceEnvironmentsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.app_service_plans = AppServicePlansOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.certificates = CertificatesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.deleted_web_apps = DeletedWebAppsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.diagnostics = DiagnosticsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.global_operations = GlobalOperations(self._client, self._config, self._serialize, self._deserialize)
        self.kube_environments = KubeEnvironmentsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.provider = ProviderOperations(self._client, self._config, self._serialize, self._deserialize)
        self.recommendations = RecommendationsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.resource_health_metadata = ResourceHealthMetadataOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.get_usages_in_location = GetUsagesInLocationOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.site_certificates = SiteCertificatesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.static_sites = StaticSitesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.web_apps = WebAppsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.workflows = WorkflowsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.workflow_runs = WorkflowRunsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.workflow_run_actions = WorkflowRunActionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workflow_run_action_repetitions = WorkflowRunActionRepetitionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workflow_run_action_repetitions_request_histories = WorkflowRunActionRepetitionsRequestHistoriesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workflow_run_action_scope_repetitions = WorkflowRunActionScopeRepetitionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workflow_triggers = WorkflowTriggersOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workflow_trigger_histories = WorkflowTriggerHistoriesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workflow_versions = WorkflowVersionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.app_service_certificate_orders = AppServiceCertificateOrdersOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.certificate_orders_diagnostics = CertificateOrdersDiagnosticsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.certificate_registration_provider = CertificateRegistrationProviderOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.domain_registration_provider = DomainRegistrationProviderOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.domains = DomainsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.top_level_domains = TopLevelDomainsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )

    def _send_request(
        self, request: HttpRequest, *, stream: bool = False, **kwargs: Any
    ) -> Awaitable[AsyncHttpResponse]:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = await client._send_request(request)
        <AsyncHttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.AsyncHttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, stream=stream, **kwargs)  # type: ignore

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> Self:
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details: Any) -> None:
        await self._client.__aexit__(*exc_details)
