# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.apimanagement import ApiManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestApiManagementWorkspaceDiagnosticOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ApiManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workspace_diagnostic_list_by_workspace(self, resource_group):
        response = self.client.workspace_diagnostic.list_by_workspace(
            resource_group_name=resource_group.name,
            service_name="str",
            workspace_id="str",
            api_version="2024-05-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workspace_diagnostic_get_entity_tag(self, resource_group):
        response = self.client.workspace_diagnostic.get_entity_tag(
            resource_group_name=resource_group.name,
            service_name="str",
            workspace_id="str",
            diagnostic_id="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workspace_diagnostic_get(self, resource_group):
        response = self.client.workspace_diagnostic.get(
            resource_group_name=resource_group.name,
            service_name="str",
            workspace_id="str",
            diagnostic_id="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workspace_diagnostic_create_or_update(self, resource_group):
        response = self.client.workspace_diagnostic.create_or_update(
            resource_group_name=resource_group.name,
            service_name="str",
            workspace_id="str",
            diagnostic_id="str",
            parameters={
                "alwaysLog": "str",
                "backend": {
                    "request": {
                        "body": {"bytes": 0},
                        "dataMasking": {
                            "headers": [{"mode": "str", "value": "str"}],
                            "queryParams": [{"mode": "str", "value": "str"}],
                        },
                        "headers": ["str"],
                    },
                    "response": {
                        "body": {"bytes": 0},
                        "dataMasking": {
                            "headers": [{"mode": "str", "value": "str"}],
                            "queryParams": [{"mode": "str", "value": "str"}],
                        },
                        "headers": ["str"],
                    },
                },
                "frontend": {
                    "request": {
                        "body": {"bytes": 0},
                        "dataMasking": {
                            "headers": [{"mode": "str", "value": "str"}],
                            "queryParams": [{"mode": "str", "value": "str"}],
                        },
                        "headers": ["str"],
                    },
                    "response": {
                        "body": {"bytes": 0},
                        "dataMasking": {
                            "headers": [{"mode": "str", "value": "str"}],
                            "queryParams": [{"mode": "str", "value": "str"}],
                        },
                        "headers": ["str"],
                    },
                },
                "httpCorrelationProtocol": "str",
                "id": "str",
                "logClientIp": bool,
                "loggerId": "str",
                "metrics": bool,
                "name": "str",
                "operationNameFormat": "str",
                "sampling": {"percentage": 0.0, "samplingType": "str"},
                "type": "str",
                "verbosity": "str",
            },
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workspace_diagnostic_update(self, resource_group):
        response = self.client.workspace_diagnostic.update(
            resource_group_name=resource_group.name,
            service_name="str",
            workspace_id="str",
            diagnostic_id="str",
            if_match="str",
            parameters={
                "alwaysLog": "str",
                "backend": {
                    "request": {
                        "body": {"bytes": 0},
                        "dataMasking": {
                            "headers": [{"mode": "str", "value": "str"}],
                            "queryParams": [{"mode": "str", "value": "str"}],
                        },
                        "headers": ["str"],
                    },
                    "response": {
                        "body": {"bytes": 0},
                        "dataMasking": {
                            "headers": [{"mode": "str", "value": "str"}],
                            "queryParams": [{"mode": "str", "value": "str"}],
                        },
                        "headers": ["str"],
                    },
                },
                "frontend": {
                    "request": {
                        "body": {"bytes": 0},
                        "dataMasking": {
                            "headers": [{"mode": "str", "value": "str"}],
                            "queryParams": [{"mode": "str", "value": "str"}],
                        },
                        "headers": ["str"],
                    },
                    "response": {
                        "body": {"bytes": 0},
                        "dataMasking": {
                            "headers": [{"mode": "str", "value": "str"}],
                            "queryParams": [{"mode": "str", "value": "str"}],
                        },
                        "headers": ["str"],
                    },
                },
                "httpCorrelationProtocol": "str",
                "id": "str",
                "logClientIp": bool,
                "loggerId": "str",
                "metrics": bool,
                "name": "str",
                "operationNameFormat": "str",
                "sampling": {"percentage": 0.0, "samplingType": "str"},
                "type": "str",
                "verbosity": "str",
            },
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workspace_diagnostic_delete(self, resource_group):
        response = self.client.workspace_diagnostic.delete(
            resource_group_name=resource_group.name,
            service_name="str",
            workspace_id="str",
            diagnostic_id="str",
            if_match="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...
