# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Action that should be applied."""

    ADD_ACTION_GROUPS = "AddActionGroups"
    REMOVE_ALL_ACTION_GROUPS = "RemoveAllActionGroups"


class AlertModificationEvent(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Reason for the modification."""

    ALERT_CREATED = "AlertCreated"
    STATE_CHANGE = "StateChange"
    MONITOR_CONDITION_CHANGE = "MonitorConditionChange"
    SEVERITY_CHANGE = "SeverityChange"
    ACTION_RULE_TRIGGERED = "ActionRuleTriggered"
    ACTION_RULE_SUPPRESSED = "ActionRuleSuppressed"
    ACTIONS_TRIGGERED = "ActionsTriggered"
    ACTIONS_SUPPRESSED = "ActionsSuppressed"
    ACTIONS_FAILED = "ActionsFailed"


class AlertsSortByFields(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AlertsSortByFields."""

    NAME = "name"
    SEVERITY = "severity"
    ALERT_STATE = "alertState"
    MONITOR_CONDITION = "monitorCondition"
    TARGET_RESOURCE = "targetResource"
    TARGET_RESOURCE_NAME = "targetResourceName"
    TARGET_RESOURCE_GROUP = "targetResourceGroup"
    TARGET_RESOURCE_TYPE = "targetResourceType"
    START_DATE_TIME = "startDateTime"
    LAST_MODIFIED_DATE_TIME = "lastModifiedDateTime"


class AlertsSummaryGroupByFields(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AlertsSummaryGroupByFields."""

    SEVERITY = "severity"
    ALERT_STATE = "alertState"
    MONITOR_CONDITION = "monitorCondition"
    MONITOR_SERVICE = "monitorService"
    SIGNAL_TYPE = "signalType"
    ALERT_RULE = "alertRule"


class AlertState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AlertState."""

    NEW = "New"
    ACKNOWLEDGED = "Acknowledged"
    CLOSED = "Closed"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class DaysOfWeek(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Days of week."""

    SUNDAY = "Sunday"
    MONDAY = "Monday"
    TUESDAY = "Tuesday"
    WEDNESDAY = "Wednesday"
    THURSDAY = "Thursday"
    FRIDAY = "Friday"
    SATURDAY = "Saturday"


class Field(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Field for a given condition."""

    SEVERITY = "Severity"
    MONITOR_SERVICE = "MonitorService"
    MONITOR_CONDITION = "MonitorCondition"
    SIGNAL_TYPE = "SignalType"
    TARGET_RESOURCE_TYPE = "TargetResourceType"
    TARGET_RESOURCE = "TargetResource"
    TARGET_RESOURCE_GROUP = "TargetResourceGroup"
    ALERT_RULE_ID = "AlertRuleId"
    ALERT_RULE_NAME = "AlertRuleName"
    DESCRIPTION = "Description"
    ALERT_CONTEXT = "AlertContext"


class Identifier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Identifier."""

    MONITOR_SERVICE_LIST = "MonitorServiceList"


class MetadataIdentifier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Identification of the information to be retrieved by API call."""

    MONITOR_SERVICE_LIST = "MonitorServiceList"


class MonitorCondition(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """MonitorCondition."""

    FIRED = "Fired"
    RESOLVED = "Resolved"


class MonitorService(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """MonitorService."""

    APPLICATION_INSIGHTS = "Application Insights"
    ACTIVITY_LOG_ADMINISTRATIVE = "ActivityLog Administrative"
    ACTIVITY_LOG_SECURITY = "ActivityLog Security"
    ACTIVITY_LOG_RECOMMENDATION = "ActivityLog Recommendation"
    ACTIVITY_LOG_POLICY = "ActivityLog Policy"
    ACTIVITY_LOG_AUTOSCALE = "ActivityLog Autoscale"
    LOG_ANALYTICS = "Log Analytics"
    NAGIOS = "Nagios"
    PLATFORM = "Platform"
    SCOM = "SCOM"
    SERVICE_HEALTH = "ServiceHealth"
    SMART_DETECTOR = "SmartDetector"
    VM_INSIGHTS = "VM Insights"
    ZABBIX = "Zabbix"


class Operator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Operator for a given condition."""

    EQUALS = "Equals"
    NOT_EQUALS = "NotEquals"
    CONTAINS = "Contains"
    DOES_NOT_CONTAIN = "DoesNotContain"


class RecurrenceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies when the recurrence should be applied."""

    DAILY = "Daily"
    WEEKLY = "Weekly"
    MONTHLY = "Monthly"


class Severity(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Severity."""

    SEV0 = "Sev0"
    SEV1 = "Sev1"
    SEV2 = "Sev2"
    SEV3 = "Sev3"
    SEV4 = "Sev4"


class SignalType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of signal the alert is based on, which could be metrics, logs or activity logs."""

    METRIC = "Metric"
    LOG = "Log"
    UNKNOWN = "Unknown"


class SmartGroupModificationEvent(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Reason for the modification."""

    SMART_GROUP_CREATED = "SmartGroupCreated"
    STATE_CHANGE = "StateChange"
    ALERT_ADDED = "AlertAdded"
    ALERT_REMOVED = "AlertRemoved"


class SmartGroupsSortByFields(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SmartGroupsSortByFields."""

    ALERTS_COUNT = "alertsCount"
    STATE = "state"
    SEVERITY = "severity"
    START_DATE_TIME = "startDateTime"
    LAST_MODIFIED_DATE_TIME = "lastModifiedDateTime"


class SortOrder(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SortOrder."""

    ASC = "asc"
    DESC = "desc"


class State(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Smart group state."""

    NEW = "New"
    ACKNOWLEDGED = "Acknowledged"
    CLOSED = "Closed"


class TimeRange(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """TimeRange."""

    ONE_H = "1h"
    ONE_D = "1d"
    SEVEN_D = "7d"
    THIRTY_D = "30d"
