# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AtlasTermAssignmentStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status for term assignment."""

    DISCOVERED = "DISCOVERED"
    """The status is discovered."""
    PROPOSED = "PROPOSED"
    """The status is proposed."""
    IMPORTED = "IMPORTED"
    """The status is imported."""
    VALIDATED = "VALIDATED"
    """The status is validated."""
    DEPRECATED = "DEPRECATED"
    """The status is deprecated."""
    OBSOLETE = "OBSOLETE"
    """The status is obsolete."""
    OTHER = "OTHER"
    """Other status."""


class AtlasTermRelationshipStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status for atlas term relationship."""

    DRAFT = "DRAFT"
    """draft"""
    ACTIVE = "ACTIVE"
    """active"""
    DEPRECATED = "DEPRECATED"
    """deprecated"""
    OBSOLETE = "OBSOLETE"
    """obsolete"""
    OTHER = "OTHER"
    """other"""


class BusinessAttributeUpdateBehavior(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum for business attribute update behavior."""

    IGNORE = "ignore"
    """Ignore the business attribute payload for update."""
    REPLACE = "replace"
    """Replace all the business attributes using the payload."""
    MERGE = "merge"
    """Merge the business attributes. Business attributes will not be updated if not provided."""


class CardinalityValue(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Cardinality."""

    SINGLE = "SINGLE"
    """single"""
    LIST = "LIST"
    """list"""
    SET = "SET"
    """set"""


class EntityStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status - can be active or deleted."""

    ACTIVE = "ACTIVE"
    """The status is active."""
    DELETED = "DELETED"
    """The status is deleted."""


class ImportStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status for import."""

    SUCCESS = "SUCCESS"
    """Success"""
    FAILED = "FAILED"
    """Failed"""


class LineageDirection(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Lineage direction."""

    INPUT = "INPUT"
    """input"""
    OUTPUT = "OUTPUT"
    """output"""
    BOTH = "BOTH"
    """both"""


class RelationshipCategory(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Relationship Category."""

    ASSOCIATION = "ASSOCIATION"
    """association"""
    AGGREGATION = "AGGREGATION"
    """aggregation"""
    COMPOSITION = "COMPOSITION"
    """composition"""


class RoundingMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Rounding Mode."""

    UP = "UP"
    """up"""
    DOWN = "DOWN"
    """down"""
    CEILING = "CEILING"
    """ceiling"""
    FLOOR = "FLOOR"
    """floor"""
    HALF_UP = "HALF_UP"
    """half up"""
    HALF_DOWN = "HALF_DOWN"
    """half down"""
    HALF_EVEN = "HALF_EVEN"
    """half even"""
    UNNECESSARY = "UNNECESSARY"
    """unnecessary"""


class SearchSortOrder(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Search sort order."""

    ASCEND = "asc"
    """Use ascending order for sorting"""
    DESCEND = "desc"
    """Use descending order for sorting"""


class SortType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type for sorting."""

    NONE = "NONE"
    """No sorting order"""
    ASCEND = "ASC"
    """Use ascending order for sorting"""
    DESCEND = "DESC"
    """Use descending order for sorting"""


class StatusAtlasRelationship(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status for atlas relationship."""

    ACTIVE = "ACTIVE"
    """active"""
    DELETED = "DELETED"
    """deleted"""


class TermStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status for term."""

    DRAFT = "Draft"
    """draft"""
    APPROVED = "Approved"
    """approved"""
    ALERT = "Alert"
    """alert"""
    EXPIRED = "Expired"
    """expired"""


class TypeCategory(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type Category."""

    PRIMITIVE = "PRIMITIVE"
    """primitive"""
    OBJECT_ID_TYPE = "OBJECT_ID_TYPE"
    """object id type"""
    ENUM = "ENUM"
    """enum"""
    STRUCT = "STRUCT"
    """struct"""
    CLASSIFICATION = "CLASSIFICATION"
    """classification"""
    ENTITY = "ENTITY"
    """entity"""
    ARRAY = "ARRAY"
    """array"""
    MAP = "MAP"
    """map"""
    RELATIONSHIP = "RELATIONSHIP"
    """relationship"""
    TERM_TEMPLATE = "TERM_TEMPLATE"
    """term template"""
