# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.monitor import MonitorManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestMonitorManagementActionGroupsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(MonitorManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_action_groups_create_or_update(self, resource_group):
        response = self.client.action_groups.create_or_update(
            resource_group_name=resource_group.name,
            action_group_name="str",
            action_group={
                "location": "str",
                "armRoleReceivers": [{"name": "str", "roleId": "str", "useCommonAlertSchema": False}],
                "automationRunbookReceivers": [
                    {
                        "automationAccountId": "str",
                        "isGlobalRunbook": bool,
                        "runbookName": "str",
                        "webhookResourceId": "str",
                        "name": "str",
                        "serviceUri": "str",
                        "useCommonAlertSchema": False,
                    }
                ],
                "azureAppPushReceivers": [{"emailAddress": "str", "name": "str"}],
                "azureFunctionReceivers": [
                    {
                        "functionAppResourceId": "str",
                        "functionName": "str",
                        "httpTriggerUrl": "str",
                        "name": "str",
                        "useCommonAlertSchema": False,
                    }
                ],
                "emailReceivers": [
                    {"emailAddress": "str", "name": "str", "status": "str", "useCommonAlertSchema": False}
                ],
                "enabled": True,
                "eventHubReceivers": [
                    {
                        "eventHubName": "str",
                        "eventHubNameSpace": "str",
                        "name": "str",
                        "subscriptionId": "str",
                        "tenantId": "str",
                        "useCommonAlertSchema": False,
                    }
                ],
                "groupShortName": "str",
                "id": "str",
                "itsmReceivers": [
                    {
                        "connectionId": "str",
                        "name": "str",
                        "region": "str",
                        "ticketConfiguration": "str",
                        "workspaceId": "str",
                    }
                ],
                "logicAppReceivers": [
                    {"callbackUrl": "str", "name": "str", "resourceId": "str", "useCommonAlertSchema": False}
                ],
                "name": "str",
                "smsReceivers": [{"countryCode": "str", "name": "str", "phoneNumber": "str", "status": "str"}],
                "tags": {"str": "str"},
                "type": "str",
                "voiceReceivers": [{"countryCode": "str", "name": "str", "phoneNumber": "str"}],
                "webhookReceivers": [
                    {
                        "name": "str",
                        "serviceUri": "str",
                        "identifierUri": "str",
                        "objectId": "str",
                        "tenantId": "str",
                        "useAadAuth": False,
                        "useCommonAlertSchema": False,
                    }
                ],
            },
            api_version="2022-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_action_groups_get(self, resource_group):
        response = self.client.action_groups.get(
            resource_group_name=resource_group.name,
            action_group_name="str",
            api_version="2022-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_action_groups_delete(self, resource_group):
        response = self.client.action_groups.delete(
            resource_group_name=resource_group.name,
            action_group_name="str",
            api_version="2022-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_action_groups_update(self, resource_group):
        response = self.client.action_groups.update(
            resource_group_name=resource_group.name,
            action_group_name="str",
            action_group_patch={"enabled": True, "tags": {"str": "str"}},
            api_version="2022-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_action_groups_begin_post_test_notifications(self, resource_group):
        response = self.client.action_groups.begin_post_test_notifications(
            notification_request={
                "alertType": "str",
                "armRoleReceivers": [{"name": "str", "roleId": "str", "useCommonAlertSchema": False}],
                "automationRunbookReceivers": [
                    {
                        "automationAccountId": "str",
                        "isGlobalRunbook": bool,
                        "runbookName": "str",
                        "webhookResourceId": "str",
                        "name": "str",
                        "serviceUri": "str",
                        "useCommonAlertSchema": False,
                    }
                ],
                "azureAppPushReceivers": [{"emailAddress": "str", "name": "str"}],
                "azureFunctionReceivers": [
                    {
                        "functionAppResourceId": "str",
                        "functionName": "str",
                        "httpTriggerUrl": "str",
                        "name": "str",
                        "useCommonAlertSchema": False,
                    }
                ],
                "emailReceivers": [
                    {"emailAddress": "str", "name": "str", "status": "str", "useCommonAlertSchema": False}
                ],
                "eventHubReceivers": [
                    {
                        "eventHubName": "str",
                        "eventHubNameSpace": "str",
                        "name": "str",
                        "subscriptionId": "str",
                        "tenantId": "str",
                        "useCommonAlertSchema": False,
                    }
                ],
                "itsmReceivers": [
                    {
                        "connectionId": "str",
                        "name": "str",
                        "region": "str",
                        "ticketConfiguration": "str",
                        "workspaceId": "str",
                    }
                ],
                "logicAppReceivers": [
                    {"callbackUrl": "str", "name": "str", "resourceId": "str", "useCommonAlertSchema": False}
                ],
                "smsReceivers": [{"countryCode": "str", "name": "str", "phoneNumber": "str", "status": "str"}],
                "voiceReceivers": [{"countryCode": "str", "name": "str", "phoneNumber": "str"}],
                "webhookReceivers": [
                    {
                        "name": "str",
                        "serviceUri": "str",
                        "identifierUri": "str",
                        "objectId": "str",
                        "tenantId": "str",
                        "useAadAuth": False,
                        "useCommonAlertSchema": False,
                    }
                ],
            },
            api_version="2022-06-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_action_groups_begin_create_notifications_at_resource_group_level(self, resource_group):
        response = self.client.action_groups.begin_create_notifications_at_resource_group_level(
            resource_group_name=resource_group.name,
            notification_request={
                "alertType": "str",
                "armRoleReceivers": [{"name": "str", "roleId": "str", "useCommonAlertSchema": False}],
                "automationRunbookReceivers": [
                    {
                        "automationAccountId": "str",
                        "isGlobalRunbook": bool,
                        "runbookName": "str",
                        "webhookResourceId": "str",
                        "name": "str",
                        "serviceUri": "str",
                        "useCommonAlertSchema": False,
                    }
                ],
                "azureAppPushReceivers": [{"emailAddress": "str", "name": "str"}],
                "azureFunctionReceivers": [
                    {
                        "functionAppResourceId": "str",
                        "functionName": "str",
                        "httpTriggerUrl": "str",
                        "name": "str",
                        "useCommonAlertSchema": False,
                    }
                ],
                "emailReceivers": [
                    {"emailAddress": "str", "name": "str", "status": "str", "useCommonAlertSchema": False}
                ],
                "eventHubReceivers": [
                    {
                        "eventHubName": "str",
                        "eventHubNameSpace": "str",
                        "name": "str",
                        "subscriptionId": "str",
                        "tenantId": "str",
                        "useCommonAlertSchema": False,
                    }
                ],
                "itsmReceivers": [
                    {
                        "connectionId": "str",
                        "name": "str",
                        "region": "str",
                        "ticketConfiguration": "str",
                        "workspaceId": "str",
                    }
                ],
                "logicAppReceivers": [
                    {"callbackUrl": "str", "name": "str", "resourceId": "str", "useCommonAlertSchema": False}
                ],
                "smsReceivers": [{"countryCode": "str", "name": "str", "phoneNumber": "str", "status": "str"}],
                "voiceReceivers": [{"countryCode": "str", "name": "str", "phoneNumber": "str"}],
                "webhookReceivers": [
                    {
                        "name": "str",
                        "serviceUri": "str",
                        "identifierUri": "str",
                        "objectId": "str",
                        "tenantId": "str",
                        "useAadAuth": False,
                        "useCommonAlertSchema": False,
                    }
                ],
            },
            api_version="2022-06-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_action_groups_begin_create_notifications_at_action_group_resource_level(self, resource_group):
        response = self.client.action_groups.begin_create_notifications_at_action_group_resource_level(
            resource_group_name=resource_group.name,
            action_group_name="str",
            notification_request={
                "alertType": "str",
                "armRoleReceivers": [{"name": "str", "roleId": "str", "useCommonAlertSchema": False}],
                "automationRunbookReceivers": [
                    {
                        "automationAccountId": "str",
                        "isGlobalRunbook": bool,
                        "runbookName": "str",
                        "webhookResourceId": "str",
                        "name": "str",
                        "serviceUri": "str",
                        "useCommonAlertSchema": False,
                    }
                ],
                "azureAppPushReceivers": [{"emailAddress": "str", "name": "str"}],
                "azureFunctionReceivers": [
                    {
                        "functionAppResourceId": "str",
                        "functionName": "str",
                        "httpTriggerUrl": "str",
                        "name": "str",
                        "useCommonAlertSchema": False,
                    }
                ],
                "emailReceivers": [
                    {"emailAddress": "str", "name": "str", "status": "str", "useCommonAlertSchema": False}
                ],
                "eventHubReceivers": [
                    {
                        "eventHubName": "str",
                        "eventHubNameSpace": "str",
                        "name": "str",
                        "subscriptionId": "str",
                        "tenantId": "str",
                        "useCommonAlertSchema": False,
                    }
                ],
                "itsmReceivers": [
                    {
                        "connectionId": "str",
                        "name": "str",
                        "region": "str",
                        "ticketConfiguration": "str",
                        "workspaceId": "str",
                    }
                ],
                "logicAppReceivers": [
                    {"callbackUrl": "str", "name": "str", "resourceId": "str", "useCommonAlertSchema": False}
                ],
                "smsReceivers": [{"countryCode": "str", "name": "str", "phoneNumber": "str", "status": "str"}],
                "voiceReceivers": [{"countryCode": "str", "name": "str", "phoneNumber": "str"}],
                "webhookReceivers": [
                    {
                        "name": "str",
                        "serviceUri": "str",
                        "identifierUri": "str",
                        "objectId": "str",
                        "tenantId": "str",
                        "useAadAuth": False,
                        "useCommonAlertSchema": False,
                    }
                ],
            },
            api_version="2022-06-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_action_groups_get_test_notifications(self, resource_group):
        response = self.client.action_groups.get_test_notifications(
            notification_id="str",
            api_version="2022-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_action_groups_get_test_notifications_at_resource_group_level(self, resource_group):
        response = self.client.action_groups.get_test_notifications_at_resource_group_level(
            resource_group_name=resource_group.name,
            notification_id="str",
            api_version="2022-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_action_groups_get_test_notifications_at_action_group_resource_level(self, resource_group):
        response = self.client.action_groups.get_test_notifications_at_action_group_resource_level(
            resource_group_name=resource_group.name,
            action_group_name="str",
            notification_id="str",
            api_version="2022-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_action_groups_list_by_subscription_id(self, resource_group):
        response = self.client.action_groups.list_by_subscription_id(
            api_version="2022-06-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_action_groups_list_by_resource_group(self, resource_group):
        response = self.client.action_groups.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2022-06-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_action_groups_enable_receiver(self, resource_group):
        response = self.client.action_groups.enable_receiver(
            resource_group_name=resource_group.name,
            action_group_name="str",
            enable_request={"receiverName": "str"},
            api_version="2022-06-01",
        )

        # please add some check logic here by yourself
        # ...
