'''OpenGL extension AMD.vertex_shader_tessellator

This module customises the behaviour of the 
OpenGL.raw.GL.AMD.vertex_shader_tessellator to provide a more 
Python-friendly API

Overview (from the spec)
	
	The vertex shader tessellator gives new flexibility to the shader
	author to shade at a tessellated vertex, rather than just at a
	provided vertex.
	
	In unextended vertex shading, the built-in attributes such as
	gl_Vertex, gl_Normal, and gl_MultiTexcoord0, together with the
	user defined attributes, are system provided values which are
	initialized prior to vertex shader invocation.
	
	With vertex shading tessellation, additional vertex shader special 
	values are available:
	
	    ivec3 gl_VertexTriangleIndex; // indices of the three control
	                                  // points for the vertex
	    vec3 gl_BarycentricCoord;     // barycentric coordinates
	                                  // of the vertex
	
	i o
	  |\
	  | \
	  *--*
	  |\ |\
	  | \| \
	  *--*--*
	  |\ |\ |\
	  | \| \| \
	j o--*--*--o k
	
	Figure 1  A Tessellated Triangle
	o = control point (and tessellated vertex)
	* = tessellated vertex
	
	    ivec4 gl_VertexQuadIndex;   // indices for the four control
	                                // points for the vertex
	    vec2 gl_UVCoord;            // UV coordinates of the vertex
	
	i o--*--*--o k
	  |\ |\ |\ | 
	  | \| \| \|
	  *--*--*--*
	  |\ |\ |\ | 
	  | \| \| \|
	  *--*--*--*
	  |\ |\ |\ | 
	  | \| \| \|
	j o--*--*--o l
	
	Figure 2  A Tessellated Quad
	o = control point (and tessellated vertex)
	* = tessellated vertex
	
	When this extension is enabled, conventional built-in attributes
	and user defined attributes are uninitialized.  The shader writer
	is responsible for explicitly fetching all other vertex data either
	from textures, uniform buffers, or vertex buffers.
	
	The shader writer is further responsible for interpolating 
	the vertex data at the given barycentric coordinates or uv
	coordinates of the vertex.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/AMD/vertex_shader_tessellator.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.AMD.vertex_shader_tessellator import *
from OpenGL.raw.GL.AMD.vertex_shader_tessellator import _EXTENSION_NAME

def glInitVertexShaderTessellatorAMD():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION