#ifndef _ekext_saturate_h
#define _ekext_saturate_h

#include "m_pd.h"
#include <math.h>

#if PD_FLOATSIZE == 32
# define FABS fabsf
#else
# define FABS fabs
#endif

#ifndef SATURATE_LIMIT
# define SATURATE_LIMIT 0.99999
#endif

static inline t_float saturate( t_float input ) { //clamp without branching
  static const t_float _limit = SATURATE_LIMIT;
  t_float x1 = FABS( input + _limit );
  t_float x2 = FABS( input - _limit );
  return 0.5 * (x1 - x2);
}

#endif /* _ekext_saturate_h */
