/* ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  Christiam Camacho
 *
 */

/** @file matrix_freq_ratios.c
 *  Definitions for various scoring matrices' frequency ratios.
 */
    
#include "matrix_freq_ratios.h"
#include "blast_psi_priv.h"


/** Underlying frequency ratios for BLOSUM45 */
static const double BLOSUM45_FREQRATIOS[BLASTAA_SIZE][BLASTAA_SIZE] =
{{0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00},
 {0.00000000e+00, 2.95043377e+00, 7.34701741e-01, 8.00397827e-01,
  6.88936672e-01, 8.25164920e-01, 5.87357723e-01, 1.08031132e+00,
  6.54086288e-01, 7.46806187e-01, 7.86209397e-01, 7.12370041e-01,
  8.21348665e-01, 7.89043130e-01, 7.08569419e-01, 8.66678731e-01,
  6.99695540e-01, 1.30031418e+00, 1.00058530e+00, 1.00992663e+00,
  5.65442334e-01, 7.50000000e-01, 6.38727873e-01, 8.41025176e-01,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 7.26064996e-01},
 {0.00000000e+00, 7.34701741e-01, 3.25946658e+00, 6.00232275e-01,
  3.59386786e+00, 1.30000108e+00, 4.95670856e-01, 8.85913772e-01,
  1.08769141e+00, 4.96979579e-01, 1.02264352e+00, 4.72210752e-01,
  5.80058073e-01, 2.86239890e+00, 6.85801186e-01, 9.91862879e-01,
  8.29088221e-01, 1.05297301e+00, 9.85207016e-01, 5.20111147e-01,
  3.80841719e-01, 7.50000000e-01, 6.27051284e-01, 1.18227759e+00,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 4.82061098e-01},
 {0.00000000e+00, 8.00397827e-01, 6.00232275e-01, 1.70900872e+01,
  5.32858023e-01, 5.45353890e-01, 6.01657157e-01, 5.56827599e-01,
  4.90637659e-01, 5.42801532e-01, 5.46735291e-01, 6.72663401e-01,
  6.03730225e-01, 6.80232381e-01, 4.11520916e-01, 4.86216592e-01,
  4.71814444e-01, 7.96941950e-01, 8.21766666e-01, 7.14771712e-01,
  3.33596922e-01, 7.50000000e-01, 4.88896599e-01, 5.22760621e-01,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 6.21018471e-01},
 {0.00000000e+00, 6.88936672e-01, 3.59386786e+00, 5.32858023e-01,
  5.35580571e+00, 1.64256912e+00, 4.31018420e-01, 7.40433725e-01,
  9.76205497e-01, 4.40334375e-01, 9.41681214e-01, 4.62523949e-01,
  4.94422549e-01, 1.50174498e+00, 7.24041930e-01, 9.57667486e-01,
  7.71179788e-01, 9.29413105e-01, 8.76125496e-01, 4.93585385e-01,
  3.73386452e-01, 7.50000000e-01, 6.44927232e-01, 1.38090402e+00,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 4.53699350e-01},
 {0.00000000e+00, 8.25164920e-01, 1.30000108e+00, 5.45353890e-01,
  1.64256912e+00, 3.87327599e+00, 4.97795679e-01, 5.76408577e-01,
  9.61718230e-01, 4.85270933e-01, 1.27686825e+00, 5.70784073e-01,
  6.14865688e-01, 8.93236200e-01, 9.10746443e-01, 1.53097375e+00,
  1.01074883e+00, 9.12113764e-01, 8.32873235e-01, 5.55160304e-01,
  5.19337483e-01, 7.50000000e-01, 6.16552718e-01, 2.97840479e+00,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 5.36776244e-01},
 {0.00000000e+00, 5.87357723e-01, 4.95670856e-01, 6.01657157e-01,
  4.31018420e-01, 4.97795679e-01, 5.74817622e+00, 4.80346092e-01,
  6.79103477e-01, 1.06375667e+00, 5.29188869e-01, 1.30295859e+00,
  1.06255416e+00, 5.72439082e-01, 4.51176385e-01, 4.43558969e-01,
  5.89537777e-01, 6.09495403e-01, 7.16103747e-01, 9.52475503e-01,
  1.35493791e+00, 7.50000000e-01, 2.18456832e+00, 4.77074668e-01,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 1.20783008e+00},
 {0.00000000e+00, 1.08031132e+00, 8.85913772e-01, 5.56827599e-01,
  7.40433725e-01, 5.76408577e-01, 4.80346092e-01, 5.07068525e+00,
  6.62087167e-01, 4.16341047e-01, 6.77879412e-01, 4.50091586e-01,
  5.84692214e-01, 1.05865660e+00, 7.02165561e-01, 6.87007231e-01,
  5.70228460e-01, 1.05800656e+00, 6.92819008e-01, 4.79214700e-01,
  5.91296285e-01, 7.50000000e-01, 5.49197180e-01, 6.18662539e-01,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 4.36669292e-01},
 {0.00000000e+00, 6.54086288e-01, 1.08769141e+00, 4.90637659e-01,
  9.76205497e-01, 9.61718230e-01, 6.79103477e-01, 6.62087167e-01,
  9.51252809e+00, 4.53313059e-01, 8.90272071e-01, 6.69868446e-01,
  9.18088604e-01, 1.22006964e+00, 6.61223470e-01, 1.15049417e+00,
  9.73045615e-01, 8.54331847e-01, 7.06245757e-01, 4.56693295e-01,
  4.51816356e-01, 7.50000000e-01, 1.47204221e+00, 1.03383965e+00,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 5.83746261e-01},
 {0.00000000e+00, 7.46806187e-01, 4.96979579e-01, 5.42801532e-01,
  4.40334375e-01, 4.85270933e-01, 1.06375667e+00, 4.16341047e-01,
  4.53313059e-01, 3.23256769e+00, 5.32316397e-01, 1.59618413e+00,
  1.45527106e+00, 5.64240025e-01, 6.09639867e-01, 5.77938325e-01,
  4.88387978e-01, 6.18410187e-01, 8.47505386e-01, 2.17596400e+00,
  5.64907506e-01, 7.50000000e-01, 9.06458192e-01, 5.20674297e-01,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 2.24695958e+00},
 {0.00000000e+00, 7.86209397e-01, 1.02264352e+00, 5.46735291e-01,
  9.41681214e-01, 1.27686825e+00, 5.29188869e-01, 6.77879412e-01,
  8.90272071e-01, 5.32316397e-01, 3.32707189e+00, 5.53563636e-01,
  7.37955763e-01, 1.11877807e+00, 7.81202774e-01, 1.33004839e+00,
  1.94261316e+00, 8.89937552e-01, 8.84562104e-01, 5.91651856e-01,
  5.61572955e-01, 7.50000000e-01, 7.37107274e-01, 1.29718560e+00,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 5.45113795e-01},
 {0.00000000e+00, 7.12370041e-01, 4.72210752e-01, 6.72663401e-01,
  4.62523949e-01, 5.70784073e-01, 1.30295859e+00, 4.50091586e-01,
  6.69868446e-01, 1.59618413e+00, 5.53563636e-01, 2.99708655e+00,
  1.73144954e+00, 4.83712850e-01, 4.77913692e-01, 6.42028706e-01,
  6.01135200e-01, 5.55659969e-01, 7.80723755e-01, 1.33363845e+00,
  6.70858407e-01, 7.50000000e-01, 9.65090110e-01, 5.98002922e-01,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 2.43995990e+00},
 {0.00000000e+00, 8.21348665e-01, 5.80058073e-01, 6.03730225e-01,
  4.94422549e-01, 6.14865688e-01, 1.06255416e+00, 5.84692214e-01,
  9.18088604e-01, 1.45527106e+00, 7.37955763e-01, 1.73144954e+00,
  4.11411354e+00, 6.81741591e-01, 6.43682874e-01, 9.40467390e-01,
  7.75906233e-01, 6.60370266e-01, 8.60449567e-01, 1.23582796e+00,
  6.34345311e-01, 7.50000000e-01, 1.02316322e+00, 7.39261071e-01,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 1.62161577e+00},
 {0.00000000e+00, 7.89043130e-01, 2.86239890e+00, 6.80232381e-01,
  1.50174498e+00, 8.93236200e-01, 5.72439082e-01, 1.05865660e+00,
  1.22006964e+00, 5.64240025e-01, 1.11877807e+00, 4.83712850e-01,
  6.81741591e-01, 4.47803773e+00, 6.40394172e-01, 1.03246645e+00,
  8.97848625e-01, 1.19968790e+00, 1.11473028e+00, 5.51607804e-01,
  3.89694095e-01, 7.50000000e-01, 6.05825405e-01, 9.46428796e-01,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 5.15737804e-01},
 {0.00000000e+00, 7.08569419e-01, 6.85801186e-01, 4.11520916e-01,
  7.24041930e-01, 9.10746443e-01, 4.51176385e-01, 7.02165561e-01,
  6.61223470e-01, 6.09639867e-01, 7.81202774e-01, 4.77913692e-01,
  6.43682874e-01, 6.40394172e-01, 8.81911509e+00, 7.15515810e-01,
  5.81631739e-01, 7.49733904e-01, 8.56242933e-01, 5.40037335e-01,
  5.25005050e-01, 7.50000000e-01, 4.78832406e-01, 8.36159027e-01,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 5.30300041e-01},
 {0.00000000e+00, 8.66678731e-01, 9.91862879e-01, 4.86216592e-01,
  9.57667486e-01, 1.53097375e+00, 4.43558969e-01, 6.87007231e-01,
  1.15049417e+00, 5.77938325e-01, 1.33004839e+00, 6.42028706e-01,
  9.40467390e-01, 1.03246645e+00, 7.15515810e-01, 4.40728842e+00,
  1.32912854e+00, 1.09183956e+00, 7.80601862e-01, 5.47266398e-01,
  6.45177884e-01, 7.50000000e-01, 8.29182983e-01, 2.62986317e+00,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 6.16540522e-01},
 {0.00000000e+00, 6.99695540e-01, 8.29088221e-01, 4.71814444e-01,
  7.71179788e-01, 1.01074883e+00, 5.89537777e-01, 5.70228460e-01,
  9.73045615e-01, 4.88387978e-01, 1.94261316e+00, 6.01135200e-01,
  7.75906233e-01, 8.97848625e-01, 5.81631739e-01, 1.32912854e+00,
  4.74702063e+00, 7.99048209e-01, 7.15164318e-01, 5.77699501e-01,
  5.80165842e-01, 7.50000000e-01, 8.07446927e-01, 1.13238507e+00,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 5.56296615e-01},
 {0.00000000e+00, 1.30031418e+00, 1.05297301e+00, 7.96941950e-01,
  9.29413105e-01, 9.12113764e-01, 6.09495403e-01, 1.05800656e+00,
  8.54331847e-01, 6.18410187e-01, 8.89937552e-01, 5.55659969e-01,
  6.60370266e-01, 1.19968790e+00, 7.49733904e-01, 1.09183956e+00,
  7.99048209e-01, 2.78188630e+00, 1.47248598e+00, 7.27836330e-01,
  4.28363793e-01, 7.50000000e-01, 7.05878947e-01, 9.80777594e-01,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 5.80615182e-01},
 {0.00000000e+00, 1.00058530e+00, 9.85207016e-01, 8.21766666e-01,
  8.76125496e-01, 8.32873235e-01, 7.16103747e-01, 6.92819008e-01,
  7.06245757e-01, 8.47505386e-01, 8.84562104e-01, 7.80723755e-01,
  8.60449567e-01, 1.11473028e+00, 8.56242933e-01, 7.80601862e-01,
  7.15164318e-01, 1.47248598e+00, 3.13871529e+00, 1.04019697e+00,
  4.54128072e-01, 7.50000000e-01, 7.43457494e-01, 8.12903077e-01,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 8.07282226e-01},
 {0.00000000e+00, 1.00992663e+00, 5.20111147e-01, 7.14771712e-01,
  4.93585385e-01, 5.55160304e-01, 9.52475503e-01, 4.79214700e-01,
  4.56693295e-01, 2.17596400e+00, 5.91651856e-01, 1.33363845e+00,
  1.23582796e+00, 5.51607804e-01, 5.40037335e-01, 5.47266398e-01,
  5.77699501e-01, 7.27836330e-01, 1.04019697e+00, 2.87075890e+00,
  4.73320057e-01, 7.50000000e-01, 8.09252575e-01, 5.52144455e-01,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 1.66862396e+00},
 {0.00000000e+00, 5.65442334e-01, 3.80841719e-01, 3.33596922e-01,
  3.73386452e-01, 5.19337483e-01, 1.35493791e+00, 5.91296285e-01,
  4.51816356e-01, 5.64907506e-01, 5.61572955e-01, 6.70858407e-01,
  6.34345311e-01, 3.89694095e-01, 5.25005050e-01, 6.45177884e-01,
  5.80165842e-01, 4.28363793e-01, 4.54128072e-01, 4.73320057e-01,
  2.97023509e+01, 7.50000000e-01, 1.80096028e+00, 5.67414520e-01,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 6.28722660e-01},
 {0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 7.50000000e-01},
 {0.00000000e+00, 6.38727873e-01, 6.27051284e-01, 4.88896599e-01,
  6.44927232e-01, 6.16552718e-01, 2.18456832e+00, 5.49197180e-01,
  1.47204221e+00, 9.06458192e-01, 7.37107274e-01, 9.65090110e-01,
  1.02316322e+00, 6.05825405e-01, 4.78832406e-01, 8.29182983e-01,
  8.07446927e-01, 7.05878947e-01, 7.43457494e-01, 8.09252575e-01,
  1.80096028e+00, 7.50000000e-01, 5.75351902e+00, 6.97787623e-01,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 9.41772708e-01},
 {0.00000000e+00, 8.41025176e-01, 1.18227759e+00, 5.22760621e-01,
  1.38090402e+00, 2.97840479e+00, 4.77074668e-01, 6.18662539e-01,
  1.03383965e+00, 5.20674297e-01, 1.29718560e+00, 5.98002922e-01,
  7.39261071e-01, 9.46428796e-01, 8.36159027e-01, 2.62986317e+00,
  1.13238507e+00, 9.80777594e-01, 8.12903077e-01, 5.52144455e-01,
  5.67414520e-01, 7.50000000e-01, 6.97787623e-01, 2.84524527e+00,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 5.67250003e-01},
 {0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 7.50000000e-01},
 {0.00000000e+00, 2.90000000e-01, 2.90000000e-01, 2.90000000e-01,
  2.90000000e-01, 2.90000000e-01, 2.90000000e-01, 2.90000000e-01,
  2.90000000e-01, 2.90000000e-01, 2.90000000e-01, 2.90000000e-01,
  2.90000000e-01, 2.90000000e-01, 2.90000000e-01, 2.90000000e-01,
  2.90000000e-01, 2.90000000e-01, 2.90000000e-01, 2.90000000e-01,
  2.90000000e-01, 2.90000000e-01, 2.90000000e-01, 2.90000000e-01,
  2.90000000e-01, 1.33300000e+00, 2.90000000e-01, 2.90000000e-01},
 {0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 7.50000000e-01},
 {0.00000000e+00, 7.26064996e-01, 4.82061098e-01, 6.21018471e-01,
  4.53699350e-01, 5.36776244e-01, 1.20783008e+00, 4.36669292e-01,
  5.83746261e-01, 2.24695958e+00, 5.45113795e-01, 2.43995990e+00,
  1.62161577e+00, 5.15737804e-01, 5.30300041e-01, 6.16540522e-01,
  5.56296615e-01, 5.80615182e-01, 8.07282226e-01, 1.66862396e+00,
  6.28722660e-01, 7.50000000e-01, 9.41772708e-01, 5.67250003e-01,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 2.36320536e+00}};


/** Underlying frequency ratios for BLOSUM50 */
static const double BLOSUM50_FREQRATIOS[BLASTAA_SIZE][BLASTAA_SIZE] =
{{0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00},
 {0.00000000e+00, 3.27354473e+00, 6.87168642e-01, 8.87624875e-01,
  6.59704230e-01, 7.97359654e-01, 5.46298170e-01, 1.10130683e+00,
  6.41220589e-01, 7.15157692e-01, 7.47622201e-01, 6.56954186e-01,
  8.53472686e-01, 7.19514908e-01, 7.14770771e-01, 8.19913708e-01,
  6.68351460e-01, 1.36359270e+00, 9.67331593e-01, 9.81625416e-01,
  4.63560176e-01, 7.50000000e-01, 5.96400452e-01, 8.05980349e-01,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 6.80310043e-01},
 {0.00000000e+00, 6.87168642e-01, 3.67565906e+00, 5.07294595e-01,
  4.02052534e+00, 1.31892999e+00, 3.83849184e-01, 8.47577177e-01,
  1.11810068e+00, 4.07212168e-01, 9.68440788e-01, 3.91166888e-01,
  5.16058658e-01, 3.26949213e+00, 6.61247189e-01, 9.98204754e-01,
  7.59007679e-01, 1.06055276e+00, 9.55438618e-01, 4.46192804e-01,
  3.38571955e-01, 7.50000000e-01, 5.55905269e-01, 1.19634119e+00,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 3.97605526e-01},
 {0.00000000e+00, 8.87624875e-01, 5.07294595e-01, 1.82308935e+01,
  4.27724382e-01, 4.56030174e-01, 5.64985221e-01, 5.24350848e-01,
  5.17412429e-01, 5.87186086e-01, 4.59864212e-01, 6.50074165e-01,
  6.80946766e-01, 6.01008569e-01, 4.03060607e-01, 4.81296027e-01,
  4.27834290e-01, 8.29850973e-01, 8.17890869e-01, 8.08665030e-01,
  3.12131245e-01, 7.50000000e-01, 5.38704705e-01, 4.65687383e-01,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 6.24838486e-01},
 {0.00000000e+00, 6.59704230e-01, 4.02052534e+00, 4.27724382e-01,
  6.11147890e+00, 1.65784569e+00, 3.37276799e-01, 7.44468416e-01,
  8.83789762e-01, 3.70146565e-01, 8.90348134e-01, 3.72923686e-01,
  4.35009775e-01, 1.55790069e+00, 7.09628659e-01, 9.66997497e-01,
  6.78533894e-01, 9.21480865e-01, 8.25179634e-01, 4.31712984e-01,
  3.07050170e-01, 7.50000000e-01, 5.04473723e-01, 1.39378711e+00,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 3.71809285e-01},
 {0.00000000e+00, 7.97359654e-01, 1.31892999e+00, 4.56030174e-01,
  1.65784569e+00, 4.43735647e+00, 4.56055858e-01, 5.39909105e-01,
  9.11487897e-01, 4.15558851e-01, 1.33108575e+00, 4.78428941e-01,
  6.05096970e-01, 9.19771370e-01, 8.38805682e-01, 1.67134451e+00,
  9.76357610e-01, 8.82100970e-01, 8.19031320e-01, 4.79075838e-01,
  5.48039829e-01, 7.50000000e-01, 6.51686488e-01, 3.38012103e+00,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 4.53200481e-01},
 {0.00000000e+00, 5.46298170e-01, 3.83849184e-01, 5.64985221e-01,
  3.37276799e-01, 4.56055858e-01, 6.63625360e+00, 4.13949535e-01,
  7.54714659e-01, 9.89742646e-01, 4.44979578e-01, 1.26171801e+00,
  1.05158910e+00, 4.38699901e-01, 3.75736079e-01, 4.16967765e-01,
  4.61789222e-01, 5.52981315e-01, 5.70349305e-01, 8.59643167e-01,
  1.34807169e+00, 7.50000000e-01, 2.42442622e+00, 4.41115461e-01,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 1.15257995e+00},
 {0.00000000e+00, 1.10130683e+00, 8.47577177e-01, 5.24350848e-01,
  7.44468416e-01, 5.39909105e-01, 4.13949535e-01, 5.79218671e+00,
  6.01271290e-01, 3.70370366e-01, 6.54870319e-01, 3.76903001e-01,
  5.19438610e-01, 9.69013722e-01, 6.20168128e-01, 6.41416113e-01,
  5.16985831e-01, 9.99248542e-01, 6.36269018e-01, 4.02720033e-01,
  5.04888636e-01, 7.50000000e-01, 4.67274430e-01, 5.78707493e-01,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 3.74281590e-01},
 {0.00000000e+00, 6.41220589e-01, 1.11810068e+00, 5.17412429e-01,
  8.83789762e-01, 9.11487897e-01, 7.54714659e-01, 6.01271290e-01,
  1.04489376e+01, 4.11545408e-01, 9.45545516e-01, 5.47445792e-01,
  7.60124356e-01, 1.39406083e+00, 5.81906417e-01, 1.20911332e+00,
  9.81604707e-01, 8.22540644e-01, 6.52641826e-01, 4.13620259e-01,
  4.75002356e-01, 7.50000000e-01, 1.57000854e+00, 1.02524740e+00,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 4.92911793e-01},
 {0.00000000e+00, 7.15157692e-01, 4.07212168e-01, 5.87186086e-01,
  3.70146565e-01, 4.15558851e-01, 9.89742646e-01, 3.70370366e-01,
  4.11545408e-01, 3.41093885e+00, 4.68297844e-01, 1.69677965e+00,
  1.43810563e+00, 4.50866254e-01, 5.11210841e-01, 5.02656404e-01,
  4.35318230e-01, 5.45643330e-01, 8.60722536e-01, 2.31272269e+00,
  5.22495607e-01, 7.50000000e-01, 8.26095669e-01, 4.48849604e-01,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 2.38463611e+00},
 {0.00000000e+00, 7.47622201e-01, 9.68440788e-01, 4.59864212e-01,
  8.90348134e-01, 1.33108575e+00, 4.44979578e-01, 6.54870319e-01,
  9.45545516e-01, 4.68297844e-01, 3.88090096e+00, 4.79194854e-01,
  6.85231759e-01, 1.06041456e+00, 7.63679086e-01, 1.41855717e+00,
  2.06468049e+00, 8.92977250e-01, 8.44796364e-01, 5.22802406e-01,
  4.61593643e-01, 7.50000000e-01, 6.67754286e-01, 1.36451940e+00,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 4.74822110e-01},
 {0.00000000e+00, 6.56954186e-01, 3.91166888e-01, 6.50074165e-01,
  3.72923686e-01, 4.78428941e-01, 1.26171801e+00, 3.76903001e-01,
  5.47445792e-01, 1.69677965e+00, 4.79194854e-01, 3.32815910e+00,
  1.78991633e+00, 4.12652855e-01, 4.43674459e-01, 5.62937315e-01,
  5.54029894e-01, 5.10605044e-01, 7.59171671e-01, 1.32427289e+00,
  6.01518374e-01, 7.50000000e-01, 8.58373419e-01, 5.10730048e-01,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 2.67352044e+00},
 {0.00000000e+00, 8.53472686e-01, 5.16058658e-01, 6.80946766e-01,
  4.35009775e-01, 6.05096970e-01, 1.05158910e+00, 5.19438610e-01,
  7.60124356e-01, 1.43810563e+00, 6.85231759e-01, 1.78991633e+00,
  4.81561797e+00, 6.11514139e-01, 5.44813932e-01, 9.59915799e-01,
  6.78015272e-01, 6.82291911e-01, 8.82308943e-01, 1.21329921e+00,
  7.61522900e-01, 7.50000000e-01, 9.17831903e-01, 7.40717150e-01,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 1.64874201e+00},
 {0.00000000e+00, 7.19514908e-01, 3.26949213e+00, 6.01008569e-01,
  1.55790069e+00, 9.19771370e-01, 4.38699901e-01, 9.69013722e-01,
  1.39406083e+00, 4.50866254e-01, 1.06041456e+00, 4.12652855e-01,
  6.11514139e-01, 5.28532229e+00, 6.04265819e-01, 1.03495916e+00,
  8.53785837e-01, 1.22434496e+00, 1.10885139e+00, 4.63246441e-01,
  3.75696800e-01, 7.50000000e-01, 6.16478872e-01, 9.63798879e-01,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 4.27987098e-01},
 {0.00000000e+00, 7.14770771e-01, 6.61247189e-01, 4.03060607e-01,
  7.09628659e-01, 8.38805682e-01, 3.75736079e-01, 6.20168128e-01,
  5.81906417e-01, 5.11210841e-01, 7.63679086e-01, 4.43674459e-01,
  5.44813932e-01, 6.04265819e-01, 1.02035160e+01, 7.50499600e-01,
  5.18638945e-01, 7.59438841e-01, 7.48565360e-01, 5.24438149e-01,
  4.20092966e-01, 7.50000000e-01, 4.68173126e-01, 8.05053001e-01,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 4.70775405e-01},
 {0.00000000e+00, 8.19913708e-01, 9.98204754e-01, 4.81296027e-01,
  9.66997497e-01, 1.67134451e+00, 4.16967765e-01, 6.41416113e-01,
  1.20911332e+00, 5.02656404e-01, 1.41855717e+00, 5.62937315e-01,
  9.59915799e-01, 1.03495916e+00, 7.50499600e-01, 4.69722165e+00,
  1.35733364e+00, 1.06872445e+00, 8.10316946e-01, 5.57384267e-01,
  7.14705591e-01, 7.50000000e-01, 7.42076535e-01, 2.82790659e+00,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 5.38747839e-01},
 {0.00000000e+00, 6.68351460e-01, 7.59007679e-01, 4.27834290e-01,
  6.78533894e-01, 9.76357610e-01, 4.61789222e-01, 5.16985831e-01,
  9.81604707e-01, 4.35318230e-01, 2.06468049e+00, 5.54029894e-01,
  6.78015272e-01, 8.53785837e-01, 5.18638945e-01, 1.35733364e+00,
  5.37787401e+00, 8.04499038e-01, 7.36510915e-01, 5.12488758e-01,
  5.28823677e-01, 7.50000000e-01, 7.27125062e-01, 1.12197569e+00,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 5.06393371e-01},
 {0.00000000e+00, 1.36359270e+00, 1.06055276e+00, 8.29850973e-01,
  9.21480865e-01, 8.82100970e-01, 5.52981315e-01, 9.99248542e-01,
  8.22540644e-01, 5.45643330e-01, 8.92977250e-01, 5.10605044e-01,
  6.82291911e-01, 1.22434496e+00, 7.59438841e-01, 1.06872445e+00,
  8.04499038e-01, 3.14298812e+00, 1.49727124e+00, 6.78664919e-01,
  3.92328021e-01, 7.50000000e-01, 6.51019697e-01, 9.53432893e-01,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 5.24665180e-01},
 {0.00000000e+00, 9.67331593e-01, 9.55438618e-01, 8.17890869e-01,
  8.25179634e-01, 8.19031320e-01, 5.70349305e-01, 6.36269018e-01,
  6.52641826e-01, 8.60722536e-01, 8.44796364e-01, 7.59171671e-01,
  8.82308943e-01, 1.10885139e+00, 7.48565360e-01, 8.10316946e-01,
  7.36510915e-01, 1.49727124e+00, 3.55307500e+00, 1.05992520e+00,
  5.02669810e-01, 7.50000000e-01, 6.90730891e-01, 8.15700480e-01,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 7.99921922e-01},
 {0.00000000e+00, 9.81625416e-01, 4.46192804e-01, 8.08665030e-01,
  4.31712984e-01, 4.79075838e-01, 8.59643167e-01, 4.02720033e-01,
  4.13620259e-01, 2.31272269e+00, 5.22802406e-01, 1.32427289e+00,
  1.21329921e+00, 4.63246441e-01, 5.24438149e-01, 5.57384267e-01,
  5.12488758e-01, 6.78664919e-01, 1.05992520e+00, 3.11745700e+00,
  4.84839541e-01, 7.50000000e-01, 7.27350506e-01, 5.09007179e-01,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 1.72091725e+00},
 {0.00000000e+00, 4.63560176e-01, 3.38571955e-01, 3.12131245e-01,
  3.07050170e-01, 5.48039829e-01, 1.34807169e+00, 5.04888636e-01,
  4.75002356e-01, 5.22495607e-01, 4.61593643e-01, 6.01518374e-01,
  7.61522900e-01, 3.75696800e-01, 4.20092966e-01, 7.14705591e-01,
  5.28823677e-01, 3.92328021e-01, 5.02669810e-01, 4.84839541e-01,
  3.13609332e+01, 7.50000000e-01, 1.76515899e+00, 6.11743441e-01,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 5.69808181e-01},
 {0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 7.50000000e-01},
 {0.00000000e+00, 5.96400452e-01, 5.55905269e-01, 5.38704705e-01,
  5.04473723e-01, 6.51686488e-01, 2.42442622e+00, 4.67274430e-01,
  1.57000854e+00, 8.26095669e-01, 6.67754286e-01, 8.58373419e-01,
  9.17831903e-01, 6.16478872e-01, 4.68173126e-01, 7.42076535e-01,
  7.27125062e-01, 6.51019697e-01, 6.90730891e-01, 7.27350506e-01,
  1.76515899e+00, 7.50000000e-01, 6.89283261e+00, 6.86235710e-01,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 8.45421029e-01},
 {0.00000000e+00, 8.05980349e-01, 1.19634119e+00, 4.65687383e-01,
  1.39378711e+00, 3.38012103e+00, 4.41115461e-01, 5.78707493e-01,
  1.02524740e+00, 4.48849604e-01, 1.36451940e+00, 5.10730048e-01,
  7.40717150e-01, 9.63798879e-01, 8.05053001e-01, 2.82790659e+00,
  1.12197569e+00, 9.53432893e-01, 8.15700480e-01, 5.09007179e-01,
  6.11743441e-01, 7.50000000e-01, 6.86235710e-01, 3.16905156e+00,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 4.85898712e-01},
 {0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 7.50000000e-01},
 {0.00000000e+00, 2.90000000e-01, 2.90000000e-01, 2.90000000e-01,
  2.90000000e-01, 2.90000000e-01, 2.90000000e-01, 2.90000000e-01,
  2.90000000e-01, 2.90000000e-01, 2.90000000e-01, 2.90000000e-01,
  2.90000000e-01, 2.90000000e-01, 2.90000000e-01, 2.90000000e-01,
  2.90000000e-01, 2.90000000e-01, 2.90000000e-01, 2.90000000e-01,
  2.90000000e-01, 2.90000000e-01, 2.90000000e-01, 2.90000000e-01,
  2.90000000e-01, 1.33300000e+00, 2.90000000e-01, 2.90000000e-01},
 {0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 7.50000000e-01},
 {0.00000000e+00, 6.80310043e-01, 3.97605526e-01, 6.24838486e-01,
  3.71809285e-01, 4.53200481e-01, 1.15257995e+00, 3.74281590e-01,
  4.92911793e-01, 2.38463611e+00, 4.74822110e-01, 2.67352044e+00,
  1.64874201e+00, 4.27987098e-01, 4.70775405e-01, 5.38747839e-01,
  5.06393371e-01, 5.24665180e-01, 7.99921922e-01, 1.72091725e+00,
  5.69808181e-01, 7.50000000e-01, 8.45421029e-01, 4.85898712e-01,
  7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 2.55759716e+00}};


/** Underlying frequency ratios for BLOSUM62 */
static const double BLOSUM62_FREQRATIOS[BLASTAA_SIZE][BLASTAA_SIZE] =
{{0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00},
 {0.00000000e+00, 3.90294070e+00, 5.64459671e-01, 8.67987664e-01,
  5.44605275e-01, 7.41264113e-01, 4.64893827e-01, 1.05686961e+00,
  5.69364849e-01, 6.32481035e-01, 7.75390239e-01, 6.01945975e-01,
  7.23150342e-01, 5.88307640e-01, 7.54121369e-01, 7.56803943e-01,
  6.12698600e-01, 1.47210399e+00, 9.84401956e-01, 9.36458396e-01,
  4.16548781e-01, 7.50000000e-01, 5.42611869e-01, 7.47274948e-01,
  7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 6.14377313e-01},
 {0.00000000e+00, 5.64459671e-01, 4.43758048e+00, 3.45226274e-01,
  4.74290926e+00, 1.33503378e+00, 3.24101420e-01, 7.38524318e-01,
  9.25449581e-01, 3.33981361e-01, 8.54849426e-01, 2.97257620e-01,
  4.04640322e-01, 4.07083696e+00, 5.53838329e-01, 9.44103648e-01,
  7.02873767e-01, 1.05798620e+00, 8.26250098e-01, 3.51280513e-01,
  2.52855433e-01, 7.50000000e-01, 4.09444638e-01, 1.18382127e+00,
  7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 3.12208474e-01},
 {0.00000000e+00, 8.67987664e-01, 3.45226274e-01, 1.95765857e+01,
  3.01454345e-01, 2.85934574e-01, 4.38990118e-01, 4.20387870e-01,
  3.55049505e-01, 6.53458801e-01, 3.49128465e-01, 6.42275633e-01,
  6.11354340e-01, 3.97802620e-01, 3.79562691e-01, 3.65781531e-01,
  3.08939296e-01, 7.38415701e-01, 7.40551692e-01, 7.55844055e-01,
  4.49983903e-01, 7.50000000e-01, 4.34203398e-01, 3.16819526e-01,
  7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 6.46828489e-01},
 {0.00000000e+00, 5.44605275e-01, 4.74290926e+00, 3.01454345e-01,
  7.39792738e+00, 1.68781075e+00, 2.98969081e-01, 6.34301019e-01,
  6.78558839e-01, 3.39015407e-01, 7.84090406e-01, 2.86613046e-01,
  3.46454634e-01, 1.55385281e+00, 5.98716826e-01, 8.97081129e-01,
  5.73200024e-01, 9.13504624e-01, 6.94789868e-01, 3.36500142e-01,
  2.32102315e-01, 7.50000000e-01, 3.45683565e-01, 1.38195506e+00,
  7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 3.07946931e-01},
 {0.00000000e+00, 7.41264113e-01, 1.33503378e+00, 2.85934574e-01,
  1.68781075e+00, 5.46952608e+00, 3.30743991e-01, 4.81267655e-01,
  9.60040718e-01, 3.30522558e-01, 1.30827885e+00, 3.72873704e-01,
  5.00342289e-01, 9.11298183e-01, 6.79202587e-01, 1.90173784e+00,
  9.60797602e-01, 9.50357185e-01, 7.41425610e-01, 4.28943130e-01,
  3.74300212e-01, 7.50000000e-01, 4.96467354e-01, 4.08949895e+00,
  7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 3.55631838e-01},
 {0.00000000e+00, 4.64893827e-01, 3.24101420e-01, 4.38990118e-01,
  2.98969081e-01, 3.30743991e-01, 8.12879702e+00, 3.40640908e-01,
  6.51990521e-01, 9.45769883e-01, 3.44043119e-01, 1.15459749e+00,
  1.00437163e+00, 3.54288952e-01, 2.87444758e-01, 3.33972402e-01,
  3.80726330e-01, 4.39973597e-01, 4.81693683e-01, 7.45089738e-01,
  1.37437942e+00, 7.50000000e-01, 2.76938063e+00, 3.31992746e-01,
  7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 1.06958025e+00},
 {0.00000000e+00, 1.05686961e+00, 7.38524318e-01, 4.20387870e-01,
  6.34301019e-01, 4.81267655e-01, 3.40640908e-01, 6.87630691e+00,
  4.92966576e-01, 2.75009722e-01, 5.88871736e-01, 2.84504012e-01,
  3.95486600e-01, 8.63711406e-01, 4.77385507e-01, 5.38649627e-01,
  4.49983999e-01, 9.03596525e-01, 5.79271582e-01, 3.36954912e-01,
  4.21690355e-01, 7.50000000e-01, 3.48714366e-01, 5.03463109e-01,
  7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 2.80638726e-01},
 {0.00000000e+00, 5.69364849e-01, 9.25449581e-01, 3.55049505e-01,
  6.78558839e-01, 9.60040718e-01, 6.51990521e-01, 4.92966576e-01,
  1.35059997e+01, 3.26288125e-01, 7.78887490e-01, 3.80675486e-01,
  5.84132623e-01, 1.22200067e+00, 4.72879831e-01, 1.16798104e+00,
  9.17048021e-01, 7.36731740e-01, 5.57503254e-01, 3.39447442e-01,
  4.44088955e-01, 7.50000000e-01, 1.79790413e+00, 1.04047242e+00,
  7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 3.58533474e-01},
 {0.00000000e+00, 6.32481035e-01, 3.33981361e-01, 6.53458801e-01,
  3.39015407e-01, 3.30522558e-01, 9.45769883e-01, 2.75009722e-01,
  3.26288125e-01, 3.99792994e+00, 3.96372934e-01, 1.69443475e+00,
  1.47774450e+00, 3.27934752e-01, 3.84662860e-01, 3.82937802e-01,
  3.54751311e-01, 4.43163582e-01, 7.79816110e-01, 2.41751209e+00,
  4.08874390e-01, 7.50000000e-01, 6.30388931e-01, 3.50796872e-01,
  7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 2.63222650e+00},
 {0.00000000e+00, 7.75390239e-01, 8.54849426e-01, 3.49128465e-01,
  7.84090406e-01, 1.30827885e+00, 3.44043119e-01, 5.88871736e-01,
  7.78887490e-01, 3.96372934e-01, 4.76433717e+00, 4.28270363e-01,
  6.25302816e-01, 9.39841129e-01, 7.03774479e-01, 1.55432308e+00,
  2.07680867e+00, 9.31919141e-01, 7.92905803e-01, 4.56542720e-01,
  3.58930071e-01, 7.50000000e-01, 5.32179333e-01, 1.40344922e+00,
  7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 4.15284382e-01},
 {0.00000000e+00, 6.01945975e-01, 2.97257620e-01, 6.42275633e-01,
  2.86613046e-01, 3.72873704e-01, 1.15459749e+00, 2.84504012e-01,
  3.80675486e-01, 1.69443475e+00, 4.28270363e-01, 3.79662137e+00,
  1.99429557e+00, 3.10043276e-01, 3.71121724e-01, 4.77325586e-01,
  4.73919278e-01, 4.28893743e-01, 6.60328975e-01, 1.31423573e+00,
  5.68037074e-01, 7.50000000e-01, 6.92059423e-01, 4.13275887e-01,
  7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 2.94078574e+00},
 {0.00000000e+00, 7.23150342e-01, 4.04640322e-01, 6.11354340e-01,
  3.46454634e-01, 5.00342289e-01, 1.00437163e+00, 3.95486600e-01,
  5.84132623e-01, 1.47774450e+00, 6.25302816e-01, 1.99429557e+00,
  6.48145121e+00, 4.74529655e-01, 4.23898024e-01, 8.64250293e-01,
  6.22623369e-01, 5.98558924e-01, 7.93801616e-01, 1.26893679e+00,
  6.10296214e-01, 7.50000000e-01, 7.08364628e-01, 6.41102583e-01,
  7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 1.78399892e+00},
 {0.00000000e+00, 5.88307640e-01, 4.07083696e+00, 3.97802620e-01,
  1.55385281e+00, 9.11298183e-01, 3.54288952e-01, 8.63711406e-01,
  1.22200067e+00, 3.27934752e-01, 9.39841129e-01, 3.10043276e-01,
  4.74529655e-01, 7.09409488e+00, 4.99932836e-01, 1.00058442e+00,
  8.58630478e-01, 1.23152924e+00, 9.84152635e-01, 3.69033853e-01,
  2.77782896e-01, 7.50000000e-01, 4.86030806e-01, 9.45834265e-01,
  7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 3.17327197e-01},
 {0.00000000e+00, 7.54121369e-01, 5.53838329e-01, 3.79562691e-01,
  5.98716826e-01, 6.79202587e-01, 2.87444758e-01, 4.77385507e-01,
  4.72879831e-01, 3.84662860e-01, 7.03774479e-01, 3.71121724e-01,
  4.23898024e-01, 4.99932836e-01, 1.28375437e+01, 6.41280589e-01,
  4.81534905e-01, 7.55503259e-01, 6.88897122e-01, 4.43082984e-01,
  2.81833164e-01, 7.50000000e-01, 3.63521119e-01, 6.64534287e-01,
  7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 3.76634549e-01},
 {0.00000000e+00, 7.56803943e-01, 9.44103648e-01, 3.65781531e-01,
  8.97081129e-01, 1.90173784e+00, 3.33972402e-01, 5.38649627e-01,
  1.16798104e+00, 3.82937802e-01, 1.55432308e+00, 4.77325586e-01,
  8.64250293e-01, 1.00058442e+00, 6.41280589e-01, 6.24442175e+00,
  1.40579606e+00, 9.65555228e-01, 7.91320741e-01, 4.66777931e-01,
  5.09360272e-01, 7.50000000e-01, 6.11094097e-01, 3.58149606e+00,
  7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 4.38898727e-01},
 {0.00000000e+00, 6.12698600e-01, 7.02873767e-01, 3.08939296e-01,
  5.73200024e-01, 9.60797602e-01, 3.80726330e-01, 4.49983999e-01,
  9.17048021e-01, 3.54751311e-01, 2.07680867e+00, 4.73919278e-01,
  6.22623369e-01, 8.58630478e-01, 4.81534905e-01, 1.40579606e+00,
  6.66557707e+00, 7.67165633e-01, 6.77754679e-01, 4.20072316e-01,
  3.95102106e-01, 7.50000000e-01, 5.55965425e-01, 1.13292384e+00,
  7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 4.25403989e-01},
 {0.00000000e+00, 1.47210399e+00, 1.05798620e+00, 7.38415701e-01,
  9.13504624e-01, 9.50357185e-01, 4.39973597e-01, 9.03596525e-01,
  7.36731740e-01, 4.43163582e-01, 9.31919141e-01, 4.28893743e-01,
  5.98558924e-01, 1.23152924e+00, 7.55503259e-01, 9.65555228e-01,
  7.67165633e-01, 3.84284741e+00, 1.61392097e+00, 5.65223766e-01,
  3.85303035e-01, 7.50000000e-01, 5.57520051e-01, 9.56235816e-01,
  7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 4.34703235e-01},
 {0.00000000e+00, 9.84401956e-01, 8.26250098e-01, 7.40551692e-01,
  6.94789868e-01, 7.41425610e-01, 4.81693683e-01, 5.79271582e-01,
  5.57503254e-01, 7.79816110e-01, 7.92905803e-01, 6.60328975e-01,
  7.93801616e-01, 9.84152635e-01, 6.88897122e-01, 7.91320741e-01,
  6.77754679e-01, 1.61392097e+00, 4.83210516e+00, 9.80943005e-01,
  4.30934144e-01, 7.50000000e-01, 5.73156574e-01, 7.60725140e-01,
  7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 7.08974203e-01},
 {0.00000000e+00, 9.36458396e-01, 3.51280513e-01, 7.55844055e-01,
  3.36500142e-01, 4.28943130e-01, 7.45089738e-01, 3.36954912e-01,
  3.39447442e-01, 2.41751209e+00, 4.56542720e-01, 1.31423573e+00,
  1.26893679e+00, 3.69033853e-01, 4.43082984e-01, 4.66777931e-01,
  4.20072316e-01, 5.65223766e-01, 9.80943005e-01, 3.69215640e+00,
  3.74456332e-01, 7.50000000e-01, 6.58038693e-01, 4.43577702e-01,
  7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 1.76339815e+00},
 {0.00000000e+00, 4.16548781e-01, 2.52855433e-01, 4.49983903e-01,
  2.32102315e-01, 3.74300212e-01, 1.37437942e+00, 4.21690355e-01,
  4.44088955e-01, 4.08874390e-01, 3.58930071e-01, 5.68037074e-01,
  6.10296214e-01, 2.77782896e-01, 2.81833164e-01, 5.09360272e-01,
  3.95102106e-01, 3.85303035e-01, 4.30934144e-01, 3.74456332e-01,
  3.81077833e+01, 7.50000000e-01, 2.10980812e+00, 4.26541694e-01,
  7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 5.03239261e-01},
 {0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 7.50000000e-01},
 {0.00000000e+00, 5.42611869e-01, 4.09444638e-01, 4.34203398e-01,
  3.45683565e-01, 4.96467354e-01, 2.76938063e+00, 3.48714366e-01,
  1.79790413e+00, 6.30388931e-01, 5.32179333e-01, 6.92059423e-01,
  7.08364628e-01, 4.86030806e-01, 3.63521119e-01, 6.11094097e-01,
  5.55965425e-01, 5.57520051e-01, 5.73156574e-01, 6.58038693e-01,
  2.10980812e+00, 7.50000000e-01, 9.83220341e+00, 5.40805192e-01,
  7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 6.66952325e-01},
 {0.00000000e+00, 7.47274948e-01, 1.18382127e+00, 3.16819526e-01,
  1.38195506e+00, 4.08949895e+00, 3.31992746e-01, 5.03463109e-01,
  1.04047242e+00, 3.50796872e-01, 1.40344922e+00, 4.13275887e-01,
  6.41102583e-01, 9.45834265e-01, 6.64534287e-01, 3.58149606e+00,
  1.13292384e+00, 9.56235816e-01, 7.60725140e-01, 4.43577702e-01,
  4.26541694e-01, 7.50000000e-01, 5.40805192e-01, 3.89300249e+00,
  7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 3.87839626e-01},
 {0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 7.50000000e-01},
 {0.00000000e+00, 2.50000000e-01, 2.50000000e-01, 2.50000000e-01,
  2.50000000e-01, 2.50000000e-01, 2.50000000e-01, 2.50000000e-01,
  2.50000000e-01, 2.50000000e-01, 2.50000000e-01, 2.50000000e-01,
  2.50000000e-01, 2.50000000e-01, 2.50000000e-01, 2.50000000e-01,
  2.50000000e-01, 2.50000000e-01, 2.50000000e-01, 2.50000000e-01,
  2.50000000e-01, 2.50000000e-01, 2.50000000e-01, 2.50000000e-01,
  2.50000000e-01, 1.33300000e+00, 2.50000000e-01, 2.50000000e-01},
 {0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 7.50000000e-01},
 {0.00000000e+00, 6.14377313e-01, 3.12208474e-01, 6.46828489e-01,
  3.07946931e-01, 3.55631838e-01, 1.06958025e+00, 2.80638726e-01,
  3.58533474e-01, 2.63222650e+00, 4.15284382e-01, 2.94078574e+00,
  1.78399892e+00, 3.17327197e-01, 3.76634549e-01, 4.38898727e-01,
  4.25403989e-01, 4.34703235e-01, 7.08974203e-01, 1.76339815e+00,
  5.03239261e-01, 7.50000000e-01, 6.66952325e-01, 3.87839626e-01,
  7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 2.81516607e+00}};


/** Underlying frequency ratios for BLOSUM80 */
static const double BLOSUM80_FREQRATIOS[BLASTAA_SIZE][BLASTAA_SIZE] =
{{0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00},
 {0.00000000e+00, 4.77313697e+00, 4.77250219e-01, 7.31790935e-01,
  4.50905428e-01, 7.03141318e-01, 3.96805472e-01, 9.57108118e-01,
  5.14428496e-01, 5.43302985e-01, 7.22895459e-01, 5.04576848e-01,
  6.25509899e-01, 5.10109254e-01, 7.71095354e-01, 6.95763501e-01,
  5.55324683e-01, 1.53463504e+00, 9.79634362e-01, 8.65874830e-01,
  3.09281009e-01, 7.50000000e-01, 4.36234494e-01, 7.00327585e-01,
  7.50000000e-01, 1.40000000e-01, 7.50000000e-01, 5.20181427e-01},
 {0.00000000e+00, 4.77250219e-01, 5.36249708e+00, 2.52383415e-01,
  5.75921529e+00, 1.26868736e+00, 2.51452613e-01, 6.38679494e-01,
  8.30167261e-01, 2.33516284e-01, 7.93249084e-01, 2.20539708e-01,
  3.09639510e-01, 4.86768283e+00, 4.28138134e-01, 8.50001386e-01,
  6.08526572e-01, 9.48166786e-01, 7.43109762e-01, 2.67977796e-01,
  1.78830543e-01, 7.50000000e-01, 3.07187296e-01, 1.10900996e+00,
  7.50000000e-01, 1.40000000e-01, 7.50000000e-01, 2.25768580e-01},
 {0.00000000e+00, 7.31790935e-01, 2.52383415e-01, 2.07020176e+01,
  2.13899571e-01, 1.79625278e-01, 3.94756499e-01, 2.72055621e-01,
  2.21322329e-01, 5.81174860e-01, 2.41148280e-01, 4.92657548e-01,
  4.99414247e-01, 3.00383113e-01, 2.69170214e-01, 2.95117493e-01,
  2.32476995e-01, 5.76114817e-01, 6.01733396e-01, 6.34451252e-01,
  3.02232769e-01, 7.50000000e-01, 3.07930831e-01, 2.23671408e-01,
  7.50000000e-01, 1.40000000e-01, 7.50000000e-01, 5.28325329e-01},
 {0.00000000e+00, 4.50905428e-01, 5.75921529e+00, 2.13899571e-01,
  9.10634223e+00, 1.63552603e+00, 2.34434106e-01, 5.40654444e-01,
  5.94384672e-01, 2.14047157e-01, 6.76875328e-01, 1.97166761e-01,
  2.51946380e-01, 1.58444827e+00, 4.52407652e-01, 7.63275386e-01,
  4.76639455e-01, 7.74041684e-01, 6.10882957e-01, 2.44693975e-01,
  1.44774364e-01, 7.50000000e-01, 2.45193294e-01, 1.30286928e+00,
  7.50000000e-01, 1.40000000e-01, 7.50000000e-01, 2.03968665e-01},
 {0.00000000e+00, 7.03141318e-01, 1.26868736e+00, 1.79625278e-01,
  1.63552603e+00, 6.99475019e+00, 2.48970812e-01, 3.99359878e-01,
  9.01259830e-01, 2.64258683e-01, 1.19492933e+00, 2.75527698e-01,
  4.28576433e-01, 8.11140936e-01, 5.81414067e-01, 1.90643780e+00,
  8.31863127e-01, 8.45039731e-01, 6.85529376e-01, 3.69379335e-01,
  2.40807712e-01, 7.50000000e-01, 3.32874109e-01, 5.05418243e+00,
  7.50000000e-01, 1.40000000e-01, 7.50000000e-01, 2.70986883e-01},
 {0.00000000e+00, 3.96805472e-01, 2.51452613e-01, 3.94756499e-01,
  2.34434106e-01, 2.48970812e-01, 9.48547379e+00, 2.48796540e-01,
  5.71854758e-01, 8.40573731e-01, 2.82718808e-01, 1.11429351e+00,
  8.93330223e-01, 2.72679266e-01, 2.37160811e-01, 2.85158291e-01,
  2.87269045e-01, 3.69100895e-01, 4.45199900e-01, 6.48888163e-01,
  1.08939386e+00, 7.50000000e-01, 2.78024963e+00, 2.62771902e-01,
  7.50000000e-01, 1.40000000e-01, 7.50000000e-01, 1.00399896e+00},
 {0.00000000e+00, 9.57108118e-01, 6.38679494e-01, 2.72055621e-01,
  5.40654444e-01, 3.99359878e-01, 2.48796540e-01, 7.88244144e+00,
  3.87151686e-01, 1.84455102e-01, 4.83435068e-01, 2.10542976e-01,
  2.86067872e-01, 7.60943081e-01, 3.47300820e-01, 4.24585221e-01,
  3.77442786e-01, 7.84315177e-01, 4.92238430e-01, 2.50954947e-01,
  2.64396616e-01, 7.50000000e-01, 2.29516029e-01, 4.08980256e-01,
  7.50000000e-01, 1.40000000e-01, 7.50000000e-01, 2.00030947e-01},
 {0.00000000e+00, 5.14428496e-01, 8.30167261e-01, 2.21322329e-01,
  5.94384672e-01, 9.01259830e-01, 5.71854758e-01, 3.87151686e-01,
  1.60694674e+01, 2.57933576e-01, 7.40110055e-01, 3.14299881e-01,
  4.32076355e-01, 1.12425153e+00, 4.19656882e-01, 1.31555625e+00,
  9.25536475e-01, 6.61407005e-01, 5.39570743e-01, 2.88933760e-01,
  3.90225420e-01, 7.50000000e-01, 1.81930455e+00, 1.05926315e+00,
  7.50000000e-01, 1.40000000e-01, 7.50000000e-01, 2.91587251e-01},
 {0.00000000e+00, 5.43302985e-01, 2.33516284e-01, 5.81174860e-01,
  2.14047157e-01, 2.64258683e-01, 8.40573731e-01, 1.84455102e-01,
  2.57933576e-01, 4.86762150e+00, 3.13345237e-01, 1.66499837e+00,
  1.51247384e+00, 2.57799519e-01, 2.85790430e-01, 3.09071252e-01,
  2.99348100e-01, 3.78995471e-01, 7.00511896e-01, 2.49584558e+00,
  3.43150987e-01, 7.50000000e-01, 5.39308441e-01, 2.81349188e-01,
  7.50000000e-01, 1.40000000e-01, 7.50000000e-01, 2.95548558e+00},
 {0.00000000e+00, 7.22895459e-01, 7.93249084e-01, 2.41148280e-01,
  6.76875328e-01, 1.19492933e+00, 2.82718808e-01, 4.83435068e-01,
  7.40110055e-01, 3.13345237e-01, 6.32564527e+00, 3.56851811e-01,
  5.34403407e-01, 9.38398440e-01, 5.96694133e-01, 1.52403165e+00,
  2.19214139e+00, 8.20193974e-01, 7.35729790e-01, 3.70194033e-01,
  2.41427653e-01, 7.50000000e-01, 4.08501941e-01, 1.32044155e+00,
  7.50000000e-01, 1.40000000e-01, 7.50000000e-01, 3.39320970e-01},
 {0.00000000e+00, 5.04576848e-01, 2.20539708e-01, 4.92657548e-01,
  1.97166761e-01, 2.75527698e-01, 1.11429351e+00, 2.10542976e-01,
  3.14299881e-01, 1.66499837e+00, 3.56851811e-01, 4.46305621e+00,
  2.12274889e+00, 2.49692056e-01, 3.03099202e-01, 4.06904090e-01,
  3.62830591e-01, 3.68478686e-01, 5.60836408e-01, 1.22050154e+00,
  4.38789464e-01, 7.50000000e-01, 5.80503535e-01, 3.25631695e-01,
  7.50000000e-01, 1.40000000e-01, 7.50000000e-01, 3.33558735e+00},
 {0.00000000e+00, 6.25509899e-01, 3.09639510e-01, 4.99414247e-01,
  2.51946380e-01, 4.28576433e-01, 8.93330223e-01, 2.86067872e-01,
  4.32076355e-01, 1.51247384e+00, 5.34403407e-01, 2.12274889e+00,
  8.88346290e+00, 3.81598352e-01, 3.61925345e-01, 8.86557630e-01,
  5.05866341e-01, 4.98438721e-01, 7.57959723e-01, 1.22414515e+00,
  5.60653516e-01, 7.50000000e-01, 5.49937808e-01, 6.03240148e-01,
  7.50000000e-01, 1.40000000e-01, 7.50000000e-01, 1.87684042e+00},
 {0.00000000e+00, 5.10109254e-01, 4.86768283e+00, 3.00383113e-01,
  1.58444827e+00, 8.11140936e-01, 2.72679266e-01, 7.60943081e-01,
  1.12425153e+00, 2.57799519e-01, 9.38398440e-01, 2.49692056e-01,
  3.81598352e-01, 8.96275887e+00, 3.97867522e-01, 9.58172021e-01,
  7.73025258e-01, 1.16534759e+00, 9.08032132e-01, 2.97018980e-01,
  2.21307752e-01, 7.50000000e-01, 3.84510481e-01, 8.67215281e-01,
  7.50000000e-01, 1.40000000e-01, 7.50000000e-01, 2.52958933e-01},
 {0.00000000e+00, 7.71095354e-01, 4.28138134e-01, 2.69170214e-01,
  4.52407652e-01, 5.81414067e-01, 2.37160811e-01, 3.47300820e-01,
  4.19656882e-01, 2.85790430e-01, 5.96694133e-01, 3.03099202e-01,
  3.61925345e-01, 3.97867522e-01, 1.51545798e+01, 5.37994539e-01,
  4.45589871e-01, 6.51704179e-01, 5.60357280e-01, 3.70233083e-01,
  1.78033069e-01, 7.50000000e-01, 2.57545983e-01, 5.64854837e-01,
  7.50000000e-01, 1.40000000e-01, 7.50000000e-01, 2.96124685e-01},
 {0.00000000e+00, 6.95763501e-01, 8.50001386e-01, 2.95117493e-01,
  7.63275386e-01, 1.90643780e+00, 2.85158291e-01, 4.24585221e-01,
  1.31555625e+00, 3.09071252e-01, 1.52403165e+00, 4.06904090e-01,
  8.86557630e-01, 9.58172021e-01, 5.37994539e-01, 8.33990474e+00,
  1.39424540e+00, 8.58988713e-01, 7.24369298e-01, 4.10943414e-01,
  4.07901262e-01, 7.50000000e-01, 4.61857147e-01, 4.36001721e+00,
  7.50000000e-01, 1.40000000e-01, 7.50000000e-01, 3.67482647e-01},
 {0.00000000e+00, 5.55324683e-01, 6.08526572e-01, 2.32476995e-01,
  4.76639455e-01, 8.31863127e-01, 2.87269045e-01, 3.77442786e-01,
  9.25536475e-01, 2.99348100e-01, 2.19214139e+00, 3.62830591e-01,
  5.05866341e-01, 7.73025258e-01, 4.45589871e-01, 1.39424540e+00,
  8.24459589e+00, 6.94509540e-01, 5.98385216e-01, 3.53719047e-01,
  2.94245493e-01, 7.50000000e-01, 4.17775411e-01, 1.04634306e+00,
  7.50000000e-01, 1.40000000e-01, 7.50000000e-01, 3.37250515e-01},
 {0.00000000e+00, 1.53463504e+00, 9.48166786e-01, 5.76114817e-01,
  7.74041684e-01, 8.45039731e-01, 3.69100895e-01, 7.84315177e-01,
  6.61407005e-01, 3.78995471e-01, 8.20193974e-01, 3.68478686e-01,
  4.98438721e-01, 1.16534759e+00, 6.51704179e-01, 8.58988713e-01,
  6.94509540e-01, 5.10577131e+00, 1.66260189e+00, 4.93679246e-01,
  2.70773669e-01, 7.50000000e-01, 4.62005069e-01, 8.50359559e-01,
  7.50000000e-01, 1.40000000e-01, 7.50000000e-01, 3.72716393e-01},
 {0.00000000e+00, 9.79634362e-01, 7.43109762e-01, 6.01733396e-01,
  6.10882957e-01, 6.85529376e-01, 4.45199900e-01, 4.92238430e-01,
  5.39570743e-01, 7.00511896e-01, 7.35729790e-01, 5.60836408e-01,
  7.57959723e-01, 9.08032132e-01, 5.60357280e-01, 7.24369298e-01,
  5.98385216e-01, 1.66260189e+00, 6.20547751e+00, 8.91492247e-01,
  2.85084781e-01, 7.50000000e-01, 4.74451641e-01, 7.00342047e-01,
  7.50000000e-01, 1.40000000e-01, 7.50000000e-01, 6.17118219e-01},
 {0.00000000e+00, 8.65874830e-01, 2.67977796e-01, 6.34451252e-01,
  2.44693975e-01, 3.69379335e-01, 6.48888163e-01, 2.50954947e-01,
  2.88933760e-01, 2.49584558e+00, 3.70194033e-01, 1.22050154e+00,
  1.22414515e+00, 2.97018980e-01, 3.70233083e-01, 4.10943414e-01,
  3.53719047e-01, 4.93679246e-01, 8.91492247e-01, 4.58356287e+00,
  3.42175943e-01, 7.50000000e-01, 4.89223745e-01, 3.85230939e-01,
  7.50000000e-01, 1.40000000e-01, 7.50000000e-01, 1.73439753e+00},
 {0.00000000e+00, 3.09281009e-01, 1.78830543e-01, 3.02232769e-01,
  1.44774364e-01, 2.40807712e-01, 1.08939386e+00, 2.64396616e-01,
  3.90225420e-01, 3.43150987e-01, 2.41427653e-01, 4.38789464e-01,
  5.60653516e-01, 2.21307752e-01, 1.78033069e-01, 4.07901262e-01,
  2.94245493e-01, 2.70773669e-01, 2.85084781e-01, 3.42175943e-01,
  4.15522183e+01, 7.50000000e-01, 2.03605072e+00, 3.04533429e-01,
  7.50000000e-01, 1.40000000e-01, 7.50000000e-01, 4.00252232e-01},
 {0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 1.40000000e-01, 7.50000000e-01, 7.50000000e-01},
 {0.00000000e+00, 4.36234494e-01, 3.07187296e-01, 3.07930831e-01,
  2.45193294e-01, 3.32874109e-01, 2.78024963e+00, 2.29516029e-01,
  1.81930455e+00, 5.39308441e-01, 4.08501941e-01, 5.80503535e-01,
  5.49937808e-01, 3.84510481e-01, 2.57545983e-01, 4.61857147e-01,
  4.17775411e-01, 4.62005069e-01, 4.74451641e-01, 4.89223745e-01,
  2.03605072e+00, 7.50000000e-01, 1.21940332e+01, 3.82065335e-01,
  7.50000000e-01, 1.40000000e-01, 7.50000000e-01, 5.63904098e-01},
 {0.00000000e+00, 7.00327585e-01, 1.10900996e+00, 2.23671408e-01,
  1.30286928e+00, 5.05418243e+00, 2.62771902e-01, 4.08980256e-01,
  1.05926315e+00, 2.81349188e-01, 1.32044155e+00, 3.25631695e-01,
  6.03240148e-01, 8.67215281e-01, 5.64854837e-01, 4.36001721e+00,
  1.04634306e+00, 8.50359559e-01, 7.00342047e-01, 3.85230939e-01,
  3.04533429e-01, 7.50000000e-01, 3.82065335e-01, 4.78944345e+00,
  7.50000000e-01, 1.40000000e-01, 7.50000000e-01, 3.07788194e-01},
 {0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 1.40000000e-01, 7.50000000e-01, 7.50000000e-01},
 {0.00000000e+00, 1.40000000e-01, 1.40000000e-01, 1.40000000e-01,
  1.40000000e-01, 1.40000000e-01, 1.40000000e-01, 1.40000000e-01,
  1.40000000e-01, 1.40000000e-01, 1.40000000e-01, 1.40000000e-01,
  1.40000000e-01, 1.40000000e-01, 1.40000000e-01, 1.40000000e-01,
  1.40000000e-01, 1.40000000e-01, 1.40000000e-01, 1.40000000e-01,
  1.40000000e-01, 1.40000000e-01, 1.40000000e-01, 1.40000000e-01,
  1.40000000e-01, 1.33300000e+00, 1.40000000e-01, 1.40000000e-01},
 {0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 1.40000000e-01, 7.50000000e-01, 7.50000000e-01},
 {0.00000000e+00, 5.20181427e-01, 2.25768580e-01, 5.28325329e-01,
  2.03968665e-01, 2.70986883e-01, 1.00399896e+00, 2.00030947e-01,
  2.91587251e-01, 2.95548558e+00, 3.39320970e-01, 3.33558735e+00,
  1.87684042e+00, 2.52958933e-01, 2.96124685e-01, 3.67482647e-01,
  3.37250515e-01, 3.72716393e-01, 6.17118219e-01, 1.73439753e+00,
  4.00252232e-01, 7.50000000e-01, 5.63904098e-01, 3.07788194e-01,
  7.50000000e-01, 1.40000000e-01, 7.50000000e-01, 3.18242650e+00}};


/** Underlying frequency ratios for BLOSUM90 */
static const double BLOSUM90_FREQRATIOS[BLASTAA_SIZE][BLASTAA_SIZE] =
{{0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00},
 {0.00000000e+00, 5.49812903e+00, 4.38682591e-01, 6.69393543e-01,
  4.10593787e-01, 6.67362415e-01, 3.46907686e-01, 8.55253386e-01,
  4.61993747e-01, 4.75838329e-01, 6.64089300e-01, 4.46304927e-01,
  5.48948177e-01, 4.75350260e-01, 7.12075051e-01, 6.37043670e-01,
  5.31189855e-01, 1.45279278e+00, 9.34706358e-01, 7.93712275e-01,
  2.83637106e-01, 7.50000000e-01, 3.70274337e-01, 6.55892238e-01,
  7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 4.58271706e-01},
 {0.00000000e+00, 4.38682591e-01, 5.85593083e+00, 2.24322103e-01,
  6.24911512e+00, 1.23816514e+00, 2.14608760e-01, 5.64122407e-01,
  7.82997018e-01, 1.96621553e-01, 7.38810616e-01, 1.94127812e-01,
  2.69937418e-01, 5.34266045e+00, 3.78549747e-01, 7.81147613e-01,
  5.45762328e-01, 8.70271567e-01, 6.66528685e-01, 2.28904046e-01,
  1.42810925e-01, 7.50000000e-01, 2.77062678e-01, 1.06526643e+00,
  7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 1.95138263e-01},
 {0.00000000e+00, 6.69393543e-01, 2.24322103e-01, 2.16370056e+01,
  1.76054992e-01, 1.47039970e-01, 3.92579579e-01, 2.18182122e-01,
  1.93552170e-01, 5.20896357e-01, 2.15679622e-01, 4.25126435e-01,
  4.27104871e-01, 2.87330927e-01, 2.30151009e-01, 2.42068607e-01,
  2.06242089e-01, 5.23756471e-01, 5.48342086e-01, 5.88014943e-01,
  2.50594014e-01, 7.50000000e-01, 2.92512133e-01, 1.82991170e-01,
  7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 4.63931905e-01},
 {0.00000000e+00, 4.10593787e-01, 6.24911512e+00, 1.76054992e-01,
  9.87094836e+00, 1.61092322e+00, 1.97472144e-01, 4.84699282e-01,
  5.46208942e-01, 1.71646922e-01, 6.20942905e-01, 1.71021465e-01,
  2.15937410e-01, 1.52110375e+00, 3.99848977e-01, 6.86343892e-01,
  4.17577647e-01, 6.96691332e-01, 5.29001708e-01, 2.06199101e-01,
  1.15609648e-01, 7.50000000e-01, 2.13739536e-01, 1.26113669e+00,
  7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 1.71274897e-01},
 {0.00000000e+00, 6.67362415e-01, 1.23816514e+00, 1.47039970e-01,
  1.61092322e+00, 7.91072600e+00, 2.04920324e-01, 3.47008914e-01,
  7.72534981e-01, 2.37473636e-01, 1.07737256e+00, 2.37238651e-01,
  3.61519510e-01, 7.51559518e-01, 5.28989676e-01, 1.83144568e+00,
  7.31811567e-01, 7.59912485e-01, 6.13331345e-01, 3.33942314e-01,
  2.02669731e-01, 7.50000000e-01, 2.73296982e-01, 5.61081481e+00,
  7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 2.37333866e-01},
 {0.00000000e+00, 3.46907686e-01, 2.14608760e-01, 3.92579579e-01,
  1.97472144e-01, 2.04920324e-01, 1.05190688e+01, 1.97046381e-01,
  5.10867985e-01, 7.73236776e-01, 2.73932585e-01, 1.05058955e+00,
  8.11125795e-01, 2.36979230e-01, 2.12448013e-01, 2.80742738e-01,
  2.62210098e-01, 3.33306129e-01, 3.90547453e-01, 5.77272331e-01,
  9.82154073e-01, 7.50000000e-01, 2.77172979e+00, 2.33605433e-01,
  7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 9.38207661e-01},
 {0.00000000e+00, 8.55253386e-01, 5.64122407e-01, 2.18182122e-01,
  4.84699282e-01, 3.47008914e-01, 1.97046381e-01, 8.29576319e+00,
  3.35169505e-01, 1.51428808e-01, 4.27685370e-01, 1.83265898e-01,
  2.37360208e-01, 6.67802895e-01, 2.98989408e-01, 3.80871171e-01,
  3.28608745e-01, 7.00460225e-01, 4.00474342e-01, 2.02269779e-01,
  2.34021877e-01, 7.50000000e-01, 1.88904853e-01, 3.59819671e-01,
  7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 1.70365676e-01},
 {0.00000000e+00, 4.61993747e-01, 7.82997018e-01, 1.93552170e-01,
  5.46208942e-01, 7.72534981e-01, 5.10867985e-01, 3.35169505e-01,
  1.85636930e+01, 2.32236241e-01, 6.80230209e-01, 2.89296785e-01,
  4.06641319e-01, 1.09210477e+00, 3.99528365e-01, 1.24778653e+00,
  8.70382542e-01, 5.94270003e-01, 4.71855284e-01, 2.49881715e-01,
  3.84396440e-01, 7.50000000e-01, 1.62620965e+00, 9.52331980e-01,
  7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 2.66176152e-01},
 {0.00000000e+00, 4.75838329e-01, 1.96621553e-01, 5.20896357e-01,
  1.71646922e-01, 2.37473636e-01, 7.73236776e-01, 1.51428808e-01,
  2.32236241e-01, 5.62471003e+00, 2.84042165e-01, 1.59032509e+00,
  1.47982983e+00, 2.29223921e-01, 2.60766373e-01, 2.80218761e-01,
  2.69951432e-01, 3.32350183e-01, 6.20404233e-01, 2.47466358e+00,
  2.84494454e-01, 7.50000000e-01, 4.78737209e-01, 2.53644956e-01,
  7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 3.22503669e+00},
 {0.00000000e+00, 6.64089300e-01, 7.38810616e-01, 2.15679622e-01,
  6.20942905e-01, 1.07737256e+00, 2.73932585e-01, 4.27685370e-01,
  6.80230209e-01, 2.84042165e-01, 7.40971353e+00, 3.18645229e-01,
  5.03980900e-01, 8.92677413e-01, 5.54085013e-01, 1.48494120e+00,
  2.15988586e+00, 7.31921781e-01, 6.80549543e-01, 3.28415139e-01,
  1.74946435e-01, 7.50000000e-01, 3.46172886e-01, 1.23156378e+00,
  7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 3.04624249e-01},
 {0.00000000e+00, 4.46304927e-01, 1.94127812e-01, 4.25126435e-01,
  1.71021465e-01, 2.37238651e-01, 1.05058955e+00, 1.83265898e-01,
  2.89296785e-01, 1.59032509e+00, 3.18645229e-01, 5.03145573e+00,
  2.07702392e+00, 2.24291285e-01, 2.72188366e-01, 3.74709469e-01,
  3.26170372e-01, 3.38914311e-01, 5.07385737e-01, 1.13293282e+00,
  3.72830750e-01, 7.50000000e-01, 5.08794972e-01, 2.89246563e-01,
  7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 3.63712766e+00},
 {0.00000000e+00, 5.48948177e-01, 2.69937418e-01, 4.27104871e-01,
  2.15937410e-01, 3.61519510e-01, 8.11125795e-01, 2.37360208e-01,
  4.06641319e-01, 1.47982983e+00, 5.03980900e-01, 2.07702392e+00,
  1.13394084e+01, 3.40430076e-01, 3.16108504e-01, 8.49621832e-01,
  4.63059321e-01, 4.39100157e-01, 6.79030953e-01, 1.13727027e+00,
  4.92730381e-01, 7.50000000e-01, 4.80316866e-01, 5.46178209e-01,
  7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 1.83504401e+00},
 {0.00000000e+00, 4.75350260e-01, 5.34266045e+00, 2.87330927e-01,
  1.52110375e+00, 7.51559518e-01, 2.36979230e-01, 6.67802895e-01,
  1.09210477e+00, 2.29223921e-01, 8.92677413e-01, 2.24291285e-01,
  3.40430076e-01, 1.03313947e+01, 3.50745318e-01, 9.04906229e-01,
  7.13097098e-01, 1.09686657e+00, 8.46059068e-01, 2.58543521e-01,
  1.78320001e-01, 7.50000000e-01, 3.59725936e-01, 8.09573592e-01,
  7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 2.26289963e-01},
 {0.00000000e+00, 7.12075051e-01, 3.78549747e-01, 2.30151009e-01,
  3.99848977e-01, 5.28989676e-01, 2.12448013e-01, 2.98989408e-01,
  3.99528365e-01, 2.60766373e-01, 5.54085013e-01, 2.72188366e-01,
  3.16108504e-01, 3.50745318e-01, 1.60877707e+01, 4.86643270e-01,
  4.09306303e-01, 5.93677872e-01, 4.80576271e-01, 3.23032809e-01,
  1.74477792e-01, 7.50000000e-01, 2.13074361e-01, 5.12969199e-01,
  7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 2.67560235e-01},
 {0.00000000e+00, 6.37043670e-01, 7.81147613e-01, 2.42068607e-01,
  6.86343892e-01, 1.83144568e+00, 2.80742738e-01, 3.80871171e-01,
  1.24778653e+00, 2.80218761e-01, 1.48494120e+00, 3.74709469e-01,
  8.49621832e-01, 9.04906229e-01, 4.86643270e-01, 9.98642121e+00,
  1.25897253e+00, 7.86784913e-01, 6.71486014e-01, 3.48766905e-01,
  3.51106744e-01, 7.50000000e-01, 4.01714365e-01, 4.91663315e+00,
  7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 3.36422330e-01},
 {0.00000000e+00, 5.31189855e-01, 5.45762328e-01, 2.06242089e-01,
  4.17577647e-01, 7.31811567e-01, 2.62210098e-01, 3.28608745e-01,
  8.70382542e-01, 2.69951432e-01, 2.15988586e+00, 3.26170372e-01,
  4.63059321e-01, 7.13097098e-01, 4.09306303e-01, 1.25897253e+00,
  9.45518393e+00, 6.27094667e-01, 5.25362150e-01, 3.16415957e-01,
  2.48889195e-01, 7.50000000e-01, 3.62347797e-01, 9.31246918e-01,
  7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 3.03390753e-01},
 {0.00000000e+00, 1.45279278e+00, 8.70271567e-01, 5.23756471e-01,
  6.96691332e-01, 7.59912485e-01, 3.33306129e-01, 7.00460225e-01,
  5.94270003e-01, 3.32350183e-01, 7.31921781e-01, 3.38914311e-01,
  4.39100157e-01, 1.09686657e+00, 5.93677872e-01, 7.86784913e-01,
  6.27094667e-01, 5.99164849e+00, 1.62868240e+00, 4.49399804e-01,
  2.30316670e-01, 7.50000000e-01, 4.11583504e-01, 7.70078852e-01,
  7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 3.36254561e-01},
 {0.00000000e+00, 9.34706358e-01, 6.66528685e-01, 5.48342086e-01,
  5.29001708e-01, 6.13331345e-01, 3.90547453e-01, 4.00474342e-01,
  4.71855284e-01, 6.20404233e-01, 6.80549543e-01, 5.07385737e-01,
  6.79030953e-01, 8.46059068e-01, 4.80576271e-01, 6.71486014e-01,
  5.25362150e-01, 1.62868240e+00, 7.25868130e+00, 8.04058132e-01,
  2.27083637e-01, 7.50000000e-01, 4.20544390e-01, 6.35332398e-01,
  7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 5.53180238e-01},
 {0.00000000e+00, 7.93712275e-01, 2.28904046e-01, 5.88014943e-01,
  2.06199101e-01, 3.33942314e-01, 5.77272331e-01, 2.02269779e-01,
  2.49881715e-01, 2.47466358e+00, 3.28415139e-01, 1.13293282e+00,
  1.13727027e+00, 2.58543521e-01, 3.23032809e-01, 3.48766905e-01,
  3.16415957e-01, 4.49399804e-01, 8.04058132e-01, 5.31607752e+00,
  2.99756311e-01, 7.50000000e-01, 4.04621372e-01, 3.39550748e-01,
  7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 1.67659508e+00},
 {0.00000000e+00, 2.83637106e-01, 1.42810925e-01, 2.50594014e-01,
  1.15609648e-01, 2.02669731e-01, 9.82154073e-01, 2.34021877e-01,
  3.84396440e-01, 2.84494454e-01, 1.74946435e-01, 3.72830750e-01,
  4.92730381e-01, 1.78320001e-01, 1.74477792e-01, 3.51106744e-01,
  2.48889195e-01, 2.30316670e-01, 2.27083637e-01, 2.99756311e-01,
  4.26750567e+01, 7.50000000e-01, 1.77446682e+00, 2.58826370e-01,
  7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 3.37037347e-01},
 {0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 7.50000000e-01},
 {0.00000000e+00, 3.70274337e-01, 2.77062678e-01, 2.92512133e-01,
  2.13739536e-01, 2.73296982e-01, 2.77172979e+00, 1.88904853e-01,
  1.62620965e+00, 4.78737209e-01, 3.46172886e-01, 5.08794972e-01,
  4.80316866e-01, 3.59725936e-01, 2.13074361e-01, 4.01714365e-01,
  3.62347797e-01, 4.11583504e-01, 4.20544390e-01, 4.04621372e-01,
  1.77446682e+00, 7.50000000e-01, 1.36090374e+01, 3.21879801e-01,
  7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 4.96615724e-01},
 {0.00000000e+00, 6.55892238e-01, 1.06526643e+00, 1.82991170e-01,
  1.26113669e+00, 5.61081481e+00, 2.33605433e-01, 3.59819671e-01,
  9.52331980e-01, 2.53644956e-01, 1.23156378e+00, 2.89246563e-01,
  5.46178209e-01, 8.09573592e-01, 5.12969199e-01, 4.91663315e+00,
  9.31246918e-01, 7.70078852e-01, 6.35332398e-01, 3.39550748e-01,
  2.58826370e-01, 7.50000000e-01, 3.21879801e-01, 5.34819225e+00,
  7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 2.74820979e-01},
 {0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 7.50000000e-01},
 {0.00000000e+00, 1.20000000e-01, 1.20000000e-01, 1.20000000e-01,
  1.20000000e-01, 1.20000000e-01, 1.20000000e-01, 1.20000000e-01,
  1.20000000e-01, 1.20000000e-01, 1.20000000e-01, 1.20000000e-01,
  1.20000000e-01, 1.20000000e-01, 1.20000000e-01, 1.20000000e-01,
  1.20000000e-01, 1.20000000e-01, 1.20000000e-01, 1.20000000e-01,
  1.20000000e-01, 1.20000000e-01, 1.20000000e-01, 1.20000000e-01,
  1.20000000e-01, 1.33300000e+00, 1.20000000e-01, 1.20000000e-01},
 {0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 7.50000000e-01},
 {0.00000000e+00, 4.58271706e-01, 1.95138263e-01, 4.63931905e-01,
  1.71274897e-01, 2.37333866e-01, 9.38207661e-01, 1.70365676e-01,
  2.66176152e-01, 3.22503669e+00, 3.04624249e-01, 3.63712766e+00,
  1.83504401e+00, 2.26289963e-01, 2.67560235e-01, 3.36422330e-01,
  3.03390753e-01, 3.36254561e-01, 5.53180238e-01, 1.67659508e+00,
  3.37037347e-01, 7.50000000e-01, 4.96615724e-01, 2.74820979e-01,
  7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 3.47015056e+00}};


/** Underlying frequency ratios for PAM30 */
static const double PAM30_FREQRATIOS[BLASTAA_SIZE][BLASTAA_SIZE] =
{{0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00},
 {0.00000000e+00, 7.78912912e+00, 3.02026381e-01, 1.07971742e-01,
  3.16807704e-01, 4.53014491e-01, 5.67768414e-02, 5.75744366e-01,
  8.33329143e-02, 1.98631007e-01, 9.54324770e-02, 1.15281887e-01,
  1.89338526e-01, 2.84890839e-01, 5.93402017e-01, 2.35344432e-01,
  9.10275603e-02, 8.75340369e-01, 8.27084092e-01, 4.77504036e-01,
  9.76867708e-03, 7.50000000e-01, 6.99222384e-02, 3.58158006e-01,
  7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 1.40431646e-01},
 {0.00000000e+00, 3.02026381e-01, 8.11766307e+00, 1.52757717e-02,
  8.45582330e+00, 1.47233532e+00, 2.69459344e-02, 3.37867839e-01,
  6.63755159e-01, 1.25827363e-01, 4.40914175e-01, 4.89221062e-02,
  3.39137767e-02, 7.72564409e+00, 1.02509984e-01, 3.67813095e-01,
  8.23817770e-02, 6.03773710e-01, 3.53305100e-01, 6.71234492e-02,
  3.23783774e-02, 7.50000000e-01, 1.13742904e-01, 9.91005473e-01,
  7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 7.21274943e-02},
 {0.00000000e+00, 1.07971742e-01, 1.52757717e-02, 2.75882699e+01,
  7.71413760e-03, 7.86819951e-03, 1.16056875e-02, 4.15734061e-02,
  7.76695875e-02, 1.19064797e-01, 7.78302876e-03, 6.02160155e-03,
  9.46008155e-03, 2.40417467e-02, 6.32617140e-02, 8.13944094e-03,
  6.80179741e-02, 3.79110970e-01, 6.77518036e-02, 1.32369559e-01,
  4.67559620e-03, 7.50000000e-01, 2.57579768e-01, 7.98640138e-03,
  7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 4.01312493e-02},
 {0.00000000e+00, 3.16807704e-01, 8.45582330e+00, 7.71413760e-03,
  1.42349183e+01, 2.34246282e+00, 6.53544516e-03, 3.26331184e-01,
  2.71287596e-01, 7.98669838e-02, 2.19798242e-01, 1.38483017e-02,
  2.29035955e-02, 1.75629226e+00, 6.80928461e-02, 4.27289142e-01,
  2.95026156e-02, 2.86012439e-01, 1.99709663e-01, 6.47860871e-02,
  5.42804139e-03, 7.50000000e-01, 1.97046510e-02, 1.50786644e+00,
  7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 3.37687752e-02},
 {0.00000000e+00, 4.53014491e-01, 1.47233532e+00, 7.86819951e-03,
  2.34246282e+00, 1.36624533e+01, 7.86638136e-03, 2.31589040e-01,
  1.81505594e-01, 1.49736909e-01, 2.26119978e-01, 4.27891596e-02,
  9.24578171e-02, 4.63622671e-01, 1.53529752e-01, 1.50713628e+00,
  4.28627549e-02, 2.25474962e-01, 1.30340902e-01, 1.09854687e-01,
  3.23568839e-03, 7.50000000e-01, 5.65446816e-02, 8.36539662e+00,
  7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 7.50595678e-02},
 {0.00000000e+00, 5.67768414e-02, 2.69459344e-02, 1.16056875e-02,
  6.53544516e-03, 7.86638136e-03, 2.14068164e+01, 4.44753676e-02,
  1.31584637e-01, 4.73011553e-01, 8.55473177e-03, 4.15676862e-01,
  2.49857403e-01, 5.06072009e-02, 3.56716332e-02, 1.12390799e-02,
  4.18628794e-02, 1.13897780e-01, 5.14073961e-02, 6.66400959e-02,
  2.13219283e-01, 7.50000000e-01, 1.78617980e+00, 9.33613946e-03,
  7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 4.32977029e-01},
 {0.00000000e+00, 5.75744366e-01, 3.37867839e-01, 4.15734061e-02,
  3.26331184e-01, 2.31589040e-01, 4.44753676e-02, 9.31368857e+00,
  4.78871557e-02, 2.41395424e-02, 8.59403011e-02, 2.78096704e-02,
  5.67940501e-02, 3.51241937e-01, 1.21951553e-01, 9.44408638e-02,
  3.97493058e-02, 5.52895766e-01, 1.35075690e-01, 1.48994667e-01,
  5.68401675e-03, 7.50000000e-01, 9.25861867e-03, 1.71822465e-01,
  7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 2.67022462e-02},
 {0.00000000e+00, 8.33329143e-02, 6.63755159e-01, 7.76695875e-02,
  2.71287596e-01, 1.81505594e-01, 1.31584637e-01, 4.78871557e-02,
  2.29276353e+01, 4.36863126e-02, 1.19631443e-01, 1.23251186e-01,
  2.78547216e-02, 1.11873100e+00, 2.47982049e-01, 1.35964891e+00,
  5.86952720e-01, 1.31501535e-01, 8.61653901e-02, 1.14978024e-01,
  8.12035191e-02, 7.50000000e-01, 3.23746871e-01, 6.94918113e-01,
  7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 9.92432853e-02},
 {0.00000000e+00, 1.98631007e-01, 1.25827363e-01, 1.19064797e-01,
  7.98669838e-02, 1.49736909e-01, 4.73011553e-01, 2.41395424e-02,
  4.36863126e-02, 1.86346064e+01, 1.27210180e-01, 6.43409762e-01,
  7.92524183e-01, 1.79107849e-01, 5.32543187e-02, 7.03383168e-02,
  1.58533228e-01, 9.68805230e-02, 4.44355269e-01, 1.93788392e+00,
  9.23811792e-03, 7.50000000e-01, 1.18573178e-01, 1.15136508e-01,
  7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 6.07207247e+00},
 {0.00000000e+00, 9.54324770e-02, 4.40914175e-01, 7.78302876e-03,
  2.19798242e-01, 2.26119978e-01, 8.55473177e-03, 8.59403011e-02,
  1.19631443e-01, 1.27210180e-01, 9.98780825e+00, 6.07412260e-02,
  5.62560724e-01, 6.97247226e-01, 1.06485246e-01, 3.84266618e-01,
  1.11121735e+00, 2.59857530e-01, 3.36316040e-01, 4.62631009e-02,
  1.75142268e-02, 7.50000000e-01, 4.16645387e-02, 2.95037286e-01,
  7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 8.07975645e-02},
 {0.00000000e+00, 1.15281887e-01, 4.89221062e-02, 6.02160155e-03,
  1.38483017e-02, 4.27891596e-02, 4.15676862e-01, 2.78096704e-02,
  1.23251186e-01, 6.43409762e-01, 6.07412260e-02, 1.00194105e+01,
  1.24218990e+00, 8.95821132e-02, 9.04970355e-02, 1.84988987e-01,
  5.31753716e-02, 5.83025512e-02, 1.02884887e-01, 4.62744892e-01,
  1.27405990e-01, 7.50000000e-01, 9.50388211e-02, 1.04757148e-01,
  7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 7.19029657e+00},
 {0.00000000e+00, 1.89338526e-01, 3.39137767e-02, 9.46008155e-03,
  2.29035955e-02, 9.24578171e-02, 2.49857403e-01, 5.67940501e-02,
  2.78547216e-02, 7.92524183e-01, 5.62560724e-01, 1.24218990e+00,
  4.65953079e+01, 4.66775487e-02, 6.48026667e-02, 2.71732304e-01,
  2.43002286e-01, 1.60899996e-01, 2.62669188e-01, 6.30878126e-01,
  1.29243603e-02, 7.50000000e-01, 2.12719960e-02, 1.70582240e-01,
  7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 1.10650779e+00},
 {0.00000000e+00, 2.84890839e-01, 7.72564409e+00, 2.40417467e-02,
  1.75629226e+00, 4.63622671e-01, 5.06072009e-02, 3.51241937e-01,
  1.11873100e+00, 1.79107849e-01, 6.97247226e-01, 8.95821132e-02,
  4.66775487e-02, 1.46457342e+01, 1.42408737e-01, 2.98864303e-01,
  1.43682999e-01, 9.72144796e-01, 5.31363673e-01, 6.98330827e-02,
  6.36210916e-02, 7.50000000e-01, 2.22758622e-01, 3.91824098e-01,
  7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 1.16595604e-01},
 {0.00000000e+00, 5.93402017e-01, 1.02509984e-01, 6.32617140e-02,
  6.80928461e-02, 1.53529752e-01, 3.56716332e-02, 1.21951553e-01,
  2.47982049e-01, 5.32543187e-02, 1.06485246e-01, 9.04970355e-02,
  6.48026667e-02, 1.42408737e-01, 1.58088136e+01, 3.76066261e-01,
  2.69813309e-01, 5.70573606e-01, 2.40194503e-01, 1.40453450e-01,
  9.02230244e-03, 7.50000000e-01, 9.80486654e-03, 2.50506944e-01,
  7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 7.92594202e-02},
 {0.00000000e+00, 2.35344432e-01, 3.67813095e-01, 8.13944094e-03,
  4.27289142e-01, 1.50713628e+00, 1.12390799e-02, 9.44408638e-02,
  1.35964891e+00, 7.03383168e-02, 3.84266618e-01, 1.84988987e-01,
  2.71732304e-01, 2.98864303e-01, 3.76066261e-01, 1.81380436e+01,
  5.84920778e-01, 1.67743101e-01, 1.50331260e-01, 1.02742037e-01,
  1.20726953e-02, 7.50000000e-01, 1.69239569e-02, 8.75457039e+00,
  7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 1.50394300e-01},
 {0.00000000e+00, 9.10275603e-02, 8.23817770e-02, 6.80179741e-02,
  2.95026156e-02, 4.28627549e-02, 4.18628794e-02, 3.97493058e-02,
  5.86952720e-01, 1.58533228e-01, 1.11121735e+00, 5.31753716e-02,
  2.43002286e-01, 1.43682999e-01, 2.69813309e-01, 5.84920778e-01,
  1.89240175e+01, 3.54610075e-01, 1.06409795e-01, 7.42726505e-02,
  5.17051285e-01, 7.50000000e-01, 3.01584225e-02, 2.79081365e-01,
  7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 8.49660454e-02},
 {0.00000000e+00, 8.75340369e-01, 6.03773710e-01, 3.79110970e-01,
  2.86012439e-01, 2.25474962e-01, 1.13897780e-01, 5.52895766e-01,
  1.31501535e-01, 9.68805230e-02, 2.59857530e-01, 5.83025512e-02,
  1.60899996e-01, 9.72144796e-01, 5.70573606e-01, 1.67743101e-01,
  3.54610075e-01, 9.02800848e+00, 1.14463515e+00, 1.17807053e-01,
  1.79210510e-01, 7.50000000e-01, 9.65415148e-02, 2.00316511e-01,
  7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 6.99430663e-02},
 {0.00000000e+00, 8.27084092e-01, 3.53305100e-01, 6.77518036e-02,
  1.99709663e-01, 1.30340902e-01, 5.14073961e-02, 1.35075690e-01,
  8.61653901e-02, 4.44355269e-01, 3.36316040e-01, 1.02884887e-01,
  2.62669188e-01, 5.31363673e-01, 2.40194503e-01, 1.50331260e-01,
  1.06409795e-01, 1.14463515e+00, 1.16950751e+01, 3.90871695e-01,
  1.25703039e-02, 7.50000000e-01, 1.11995399e-01, 1.39052321e-01,
  7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 2.05920141e-01},
 {0.00000000e+00, 4.77504036e-01, 6.71234492e-02, 1.32369559e-01,
  6.47860871e-02, 1.09854687e-01, 6.66400959e-02, 1.48994667e-01,
  1.14978024e-01, 1.93788392e+00, 4.62631009e-02, 4.62744892e-01,
  6.30878126e-01, 6.98330827e-02, 1.40453450e-01, 1.02742037e-01,
  7.42726505e-02, 1.17807053e-01, 3.90871695e-01, 1.16090589e+01,
  5.05672115e-03, 7.50000000e-01, 8.04763342e-02, 1.06755129e-01,
  7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 9.07853260e-01},
 {0.00000000e+00, 9.76867708e-03, 3.23783774e-02, 4.67559620e-03,
  5.42804139e-03, 3.23568839e-03, 2.13219283e-01, 5.68401675e-03,
  8.12035191e-02, 9.23811792e-03, 1.75142268e-02, 1.27405990e-01,
  1.29243603e-02, 6.36210916e-02, 9.02230244e-03, 1.20726953e-02,
  5.17051285e-01, 1.79210510e-01, 1.25703039e-02, 5.05672115e-03,
  8.86903633e+01, 7.50000000e-01, 1.73378233e-01, 7.08668846e-03,
  7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 9.17500230e-02},
 {0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 7.50000000e-01},
 {0.00000000e+00, 6.99222384e-02, 1.13742904e-01, 2.57579768e-01,
  1.97046510e-02, 5.65446816e-02, 1.78617980e+00, 9.25861867e-03,
  3.23746871e-01, 1.18573178e-01, 4.16645387e-02, 9.50388211e-02,
  2.12719960e-02, 2.22758622e-01, 9.80486654e-03, 1.69239569e-02,
  3.01584225e-02, 9.65415148e-02, 1.11995399e-01, 8.04763342e-02,
  1.73378233e-01, 7.50000000e-01, 2.84454162e+01, 3.92787209e-02,
  7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 1.02140077e-01},
 {0.00000000e+00, 3.58158006e-01, 9.91005473e-01, 7.98640138e-03,
  1.50786644e+00, 8.36539662e+00, 9.33613946e-03, 1.71822465e-01,
  6.94918113e-01, 1.15136508e-01, 2.95037286e-01, 1.04757148e-01,
  1.70582240e-01, 3.91824098e-01, 2.50506944e-01, 8.75457039e+00,
  2.79081365e-01, 2.00316511e-01, 1.39052321e-01, 1.06755129e-01,
  7.08668846e-03, 7.50000000e-01, 3.92787209e-02, 8.53499117e+00,
  7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 1.07889016e-01},
 {0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 7.50000000e-01},
 {0.00000000e+00, 3.00000000e-03, 3.00000000e-03, 3.00000000e-03,
  3.00000000e-03, 3.00000000e-03, 3.00000000e-03, 3.00000000e-03,
  3.00000000e-03, 3.00000000e-03, 3.00000000e-03, 3.00000000e-03,
  3.00000000e-03, 3.00000000e-03, 3.00000000e-03, 3.00000000e-03,
  3.00000000e-03, 3.00000000e-03, 3.00000000e-03, 3.00000000e-03,
  3.00000000e-03, 3.00000000e-03, 3.00000000e-03, 3.00000000e-03,
  3.00000000e-03, 1.33300000e+00, 3.00000000e-03, 3.00000000e-03},
 {0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 7.50000000e-01},
 {0.00000000e+00, 1.40431646e-01, 7.21274943e-02, 4.01312493e-02,
  3.37687752e-02, 7.50595678e-02, 4.32977029e-01, 2.67022462e-02,
  9.92432853e-02, 6.07207247e+00, 8.07975645e-02, 7.19029657e+00,
  1.10650779e+00, 1.16595604e-01, 7.92594202e-02, 1.50394300e-01,
  8.49660454e-02, 6.99430663e-02, 2.05920141e-01, 9.07853260e-01,
  9.17500230e-02, 7.50000000e-01, 1.02140077e-01, 1.07889016e-01,
  7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 6.85288369e+00}};


/** Underlying frequency ratios for PAM70 */
static const double PAM70_FREQRATIOS[BLASTAA_SIZE][BLASTAA_SIZE] =
{{0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00},
 {0.00000000e+00, 4.89972946e+00, 6.04638890e-01, 2.42067963e-01,
  6.18433760e-01, 7.71213936e-01, 1.34833512e-01, 1.01498720e+00,
  2.21390981e-01, 4.34566961e-01, 2.49319770e-01, 2.49736666e-01,
  3.75829845e-01, 5.88646912e-01, 1.03045017e+00, 4.65602795e-01,
  2.26934456e-01, 1.34964157e+00, 1.32707297e+00, 8.08640731e-01,
  4.32618091e-02, 7.50000000e-01, 1.54222102e-01, 6.38034395e-01,
  7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 3.05507349e-01},
 {0.00000000e+00, 6.04638890e-01, 5.42142610e+00, 6.60540784e-02,
  5.88929014e+00, 2.24885858e+00, 7.88958522e-02, 6.48829213e-01,
  1.09845328e+00, 2.52789787e-01, 7.77906911e-01, 1.19715714e-01,
  1.39730820e-01, 4.87904539e+00, 2.73736473e-01, 7.90138593e-01,
  2.53425041e-01, 9.54703234e-01, 6.53688648e-01, 1.85063408e-01,
  7.80441148e-02, 7.50000000e-01, 2.23329473e-01, 1.61317606e+00,
  7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 1.59869478e-01},
 {0.00000000e+00, 2.42067963e-01, 6.60540784e-02, 2.48333286e+01,
  3.97130183e-02, 3.87120726e-02, 5.48382532e-02, 1.15679023e-01,
  1.64834856e-01, 2.46442788e-01, 3.83065039e-02, 3.01944614e-02,
  4.42379868e-02, 9.65904773e-02, 1.58823055e-01, 3.93861754e-02,
  1.51302811e-01, 6.65193229e-01, 1.86417892e-01, 2.74442219e-01,
  2.22251459e-02, 7.50000000e-01, 5.23320532e-01, 3.90058338e-02,
  7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 9.54452197e-02},
 {0.00000000e+00, 6.18433760e-01, 5.88929014e+00, 3.97130183e-02,
  8.89965209e+00, 3.35659301e+00, 3.36340414e-02, 6.39387415e-01,
  5.99746161e-01, 1.93031482e-01, 4.83846284e-01, 6.35580693e-02,
  1.03502951e-01, 2.39946804e+00, 2.12686642e-01, 9.22524100e-01,
  1.38560979e-01, 5.99713481e-01, 4.42110174e-01, 1.72922381e-01,
  2.64171458e-02, 7.50000000e-01, 7.98817496e-02, 2.29587193e+00,
  7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 1.02625370e-01},
 {0.00000000e+00, 7.71213936e-01, 2.24885858e+00, 3.87120726e-02,
  3.35659301e+00, 8.65385421e+00, 3.82398528e-02, 4.91841782e-01,
  4.80150693e-01, 2.83623924e-01, 4.66181910e-01, 1.17487568e-01,
  2.12426533e-01, 9.64695360e-01, 3.47480663e-01, 2.25815498e+00,
  1.78914910e-01, 4.78627630e-01, 3.38114944e-01, 2.46972907e-01,
  1.89756038e-02, 7.50000000e-01, 1.19141830e-01, 5.86672974e+00,
  7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 1.67617543e-01},
 {0.00000000e+00, 1.34833512e-01, 7.88958522e-02, 5.48382532e-02,
  3.36340414e-02, 3.82398528e-02, 1.74546228e+01, 1.00136016e-01,
  2.76577280e-01, 8.45971180e-01, 4.12894272e-02, 8.23804865e-01,
  5.08442478e-01, 1.31366508e-01, 8.91727264e-02, 5.25046736e-02,
  9.93639027e-02, 2.15603624e-01, 1.37600314e-01, 2.07856659e-01,
  4.52242030e-01, 7.50000000e-01, 3.37849562e+00, 4.44561913e-02,
  7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 8.30493328e-01},
 {0.00000000e+00, 1.01498720e+00, 6.48829213e-01, 1.15679023e-01,
  6.39387415e-01, 4.91841782e-01, 1.00136016e-01, 7.30864335e+00,
  1.45138751e-01, 1.07004308e-01, 2.09861286e-01, 8.09786598e-02,
  1.44276056e-01, 6.59774806e-01, 3.08399509e-01, 2.37177521e-01,
  1.22086776e-01, 9.64187863e-01, 3.70424893e-01, 3.12986176e-01,
  2.68996967e-02, 7.50000000e-01, 4.37757319e-02, 3.80863925e-01,
  7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 8.88316375e-02},
 {0.00000000e+00, 2.21390981e-01, 1.09845328e+00, 1.64834856e-01,
  5.99746161e-01, 4.80150693e-01, 2.76577280e-01, 1.45138751e-01,
  1.64223829e+01, 1.39752446e-01, 3.35085062e-01, 2.59072609e-01,
  1.22395235e-01, 1.67658945e+00, 4.92867985e-01, 2.18832010e+00,
  1.05779530e+00, 3.26721114e-01, 2.30266854e-01, 2.33270842e-01,
  1.86063506e-01, 7.50000000e-01, 6.11386658e-01, 1.22453853e+00,
  7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 2.23068949e-01},
 {0.00000000e+00, 4.34566961e-01, 2.52789787e-01, 2.46442788e-01,
  1.93031482e-01, 2.83623924e-01, 8.45971180e-01, 1.07004308e-01,
  1.39752446e-01, 1.17505537e+01, 2.66278255e-01, 1.19239531e+00,
  1.36908981e+00, 3.22065793e-01, 1.59577365e-01, 1.89299534e-01,
  3.01479599e-01, 2.53646367e-01, 7.61111058e-01, 3.00374358e+00,
  4.36969076e-02, 7.50000000e-01, 2.80489781e-01, 2.42519143e-01,
  7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 4.37821344e+00},
 {0.00000000e+00, 2.49319770e-01, 7.77906911e-01, 3.83065039e-02,
  4.83846284e-01, 4.66181910e-01, 4.12894272e-02, 2.09861286e-01,
  3.35085062e-01, 2.66278255e-01, 7.61026217e+00, 1.52754534e-01,
  9.47937549e-01, 1.11880255e+00, 2.56118662e-01, 7.21669881e-01,
  1.93666556e+00, 5.20459614e-01, 6.20196625e-01, 1.38845936e-01,
  7.91911207e-02, 7.50000000e-01, 1.00771644e-01, 5.77518724e-01,
  7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 1.87009175e-01},
 {0.00000000e+00, 2.49736666e-01, 1.19715714e-01, 3.01944614e-02,
  6.35580693e-02, 1.17487568e-01, 8.23804865e-01, 8.09786598e-02,
  2.59072609e-01, 1.19239531e+00, 1.52754534e-01, 8.22843955e+00,
  2.12939550e+00, 1.84817584e-01, 1.98778178e-01, 3.50784854e-01,
  1.37359422e-01, 1.48574310e-01, 2.40326213e-01, 9.08401895e-01,
  2.67168548e-01, 7.50000000e-01, 2.38980900e-01, 2.19154102e-01,
  7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 6.10538395e+00},
 {0.00000000e+00, 3.75829845e-01, 1.39730820e-01, 4.42379868e-02,
  1.03502951e-01, 2.12426533e-01, 5.08442478e-01, 1.44276056e-01,
  1.22395235e-01, 1.36908981e+00, 9.47937549e-01, 2.12939550e+00,
  2.85861616e+01, 1.81728699e-01, 1.75926195e-01, 4.86044449e-01,
  4.88080973e-01, 3.18976045e-01, 4.97701201e-01, 1.13284160e+00,
  5.97810639e-02, 7.50000000e-01, 9.73038916e-02, 3.31664034e-01,
  7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 1.89998090e+00},
 {0.00000000e+00, 5.88646912e-01, 4.87904539e+00, 9.65904773e-02,
  2.39946804e+00, 9.64695360e-01, 1.31366508e-01, 6.59774806e-01,
  1.67658945e+00, 3.22065793e-01, 1.11880255e+00, 1.84817584e-01,
  1.81728699e-01, 7.75354485e+00, 3.44509706e-01, 6.36668056e-01,
  3.86583495e-01, 1.36623218e+00, 8.98965212e-01, 1.99138136e-01,
  1.37893708e-01, 7.50000000e-01, 3.89624106e-01, 8.21747280e-01,
  7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 2.26230851e-01},
 {0.00000000e+00, 1.03045017e+00, 2.73736473e-01, 1.58823055e-01,
  2.12686642e-01, 3.47480663e-01, 8.91727264e-02, 3.08399509e-01,
  4.92867985e-01, 1.59577365e-01, 2.56118662e-01, 1.98778178e-01,
  1.75926195e-01, 3.44509706e-01, 1.18714088e+01, 6.84263791e-01,
  5.26778639e-01, 9.79291808e-01, 5.30644206e-01, 3.07279290e-01,
  4.18182164e-02, 7.50000000e-01, 4.66910129e-02, 4.94244365e-01,
  7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 1.86949727e-01},
 {0.00000000e+00, 4.65602795e-01, 7.90138593e-01, 3.93861754e-02,
  9.22524100e-01, 2.25815498e+00, 5.25046736e-02, 2.37177521e-01,
  2.18832010e+00, 1.89299534e-01, 7.21669881e-01, 3.50784854e-01,
  4.86044449e-01, 6.36668056e-01, 6.84263791e-01, 1.14706864e+01,
  1.02361055e+00, 3.73519396e-01, 3.29322200e-01, 2.32053434e-01,
  5.49721446e-02, 7.50000000e-01, 7.38645866e-02, 6.27280154e+00,
  7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 3.02058283e-01},
 {0.00000000e+00, 2.26934456e-01, 2.53425041e-01, 1.51302811e-01,
  1.38560979e-01, 1.78914910e-01, 9.93639027e-02, 1.22086776e-01,
  1.05779530e+00, 3.01479599e-01, 1.93666556e+00, 1.37359422e-01,
  4.88080973e-01, 3.86583495e-01, 5.26778639e-01, 1.02361055e+00,
  1.36584013e+01, 6.10010848e-01, 2.83658630e-01, 1.75829089e-01,
  9.90780192e-01, 7.50000000e-01, 8.59463892e-02, 5.47017256e-01,
  7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 1.86881035e-01},
 {0.00000000e+00, 1.34964157e+00, 9.54703234e-01, 6.65193229e-01,
  5.99713481e-01, 4.78627630e-01, 2.15603624e-01, 9.64187863e-01,
  3.26721114e-01, 2.53646367e-01, 5.20459614e-01, 1.48574310e-01,
  3.18976045e-01, 1.36623218e+00, 9.79291808e-01, 3.73519396e-01,
  6.10010848e-01, 5.20445832e+00, 1.69490837e+00, 3.03324606e-01,
  3.23868004e-01, 7.50000000e-01, 2.08076540e-01, 4.32823454e-01,
  7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 1.80278747e-01},
 {0.00000000e+00, 1.32707297e+00, 6.53688648e-01, 1.86417892e-01,
  4.42110174e-01, 3.38114944e-01, 1.37600314e-01, 3.70424893e-01,
  2.30266854e-01, 7.61111058e-01, 6.20196625e-01, 2.40326213e-01,
  4.97701201e-01, 8.98965212e-01, 5.30644206e-01, 3.29322200e-01,
  2.83658630e-01, 1.69490837e+00, 7.33707214e+00, 7.18561720e-01,
  5.45397612e-02, 7.50000000e-01, 2.27833757e-01, 3.34283233e-01,
  7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 3.97467804e-01},
 {0.00000000e+00, 8.08640731e-01, 1.85063408e-01, 2.74442219e-01,
  1.72922381e-01, 2.46972907e-01, 2.07856659e-01, 3.12986176e-01,
  2.33270842e-01, 3.00374358e+00, 1.38845936e-01, 9.08401895e-01,
  1.13284160e+00, 1.99138136e-01, 3.07279290e-01, 2.32053434e-01,
  1.75829089e-01, 3.03324606e-01, 7.18561720e-01, 8.21110545e+00,
  2.66588959e-02, 7.50000000e-01, 1.80843519e-01, 2.40471284e-01,
  7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 1.54065018e+00},
 {0.00000000e+00, 4.32618091e-02, 7.80441148e-02, 2.22251459e-02,
  2.64171458e-02, 1.89756038e-02, 4.52242030e-01, 2.68996967e-02,
  1.86063506e-01, 4.36969076e-02, 7.91911207e-02, 2.67168548e-01,
  5.97810639e-02, 1.37893708e-01, 4.18182164e-02, 5.49721446e-02,
  9.90780192e-01, 3.23868004e-01, 5.45397612e-02, 2.66588959e-02,
  8.06167129e+01, 7.50000000e-01, 3.76692625e-01, 3.46622138e-02,
  7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 1.99738227e-01},
 {0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 7.50000000e-01},
 {0.00000000e+00, 1.54222102e-01, 2.23329473e-01, 5.23320532e-01,
  7.98817496e-02, 1.19141830e-01, 3.37849562e+00, 4.37757319e-02,
  6.11386658e-01, 2.80489781e-01, 1.00771644e-01, 2.38980900e-01,
  9.73038916e-02, 3.89624106e-01, 4.66910129e-02, 7.38645866e-02,
  8.59463892e-02, 2.08076540e-01, 2.27833757e-01, 1.80843519e-01,
  3.76692625e-01, 7.50000000e-01, 2.31438270e+01, 9.94108657e-02,
  7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 2.51505787e-01},
 {0.00000000e+00, 6.38034395e-01, 1.61317606e+00, 3.90058338e-02,
  2.29587193e+00, 5.86672974e+00, 4.44561913e-02, 3.80863925e-01,
  1.22453853e+00, 2.42519143e-01, 5.77518724e-01, 2.19154102e-01,
  3.31664034e-01, 8.21747280e-01, 4.94244365e-01, 6.27280154e+00,
  5.47017256e-01, 4.32823454e-01, 3.34283233e-01, 2.40471284e-01,
  3.46622138e-02, 7.50000000e-01, 9.94108657e-02, 6.04368813e+00,
  7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 2.26204268e-01},
 {0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 7.50000000e-01},
 {0.00000000e+00, 2.00000000e-02, 2.00000000e-02, 2.00000000e-02,
  2.00000000e-02, 2.00000000e-02, 2.00000000e-02, 2.00000000e-02,
  2.00000000e-02, 2.00000000e-02, 2.00000000e-02, 2.00000000e-02,
  2.00000000e-02, 2.00000000e-02, 2.00000000e-02, 2.00000000e-02,
  2.00000000e-02, 2.00000000e-02, 2.00000000e-02, 2.00000000e-02,
  2.00000000e-02, 2.00000000e-02, 2.00000000e-02, 2.00000000e-02,
  2.00000000e-02, 1.33300000e+00, 2.00000000e-02, 2.00000000e-02},
 {0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 7.50000000e-01},
 {0.00000000e+00, 3.05507349e-01, 1.59869478e-01, 9.54452197e-02,
  1.02625370e-01, 1.67617543e-01, 8.30493328e-01, 8.88316375e-02,
  2.23068949e-01, 4.37821344e+00, 1.87009175e-01, 6.10538395e+00,
  1.89998090e+00, 2.26230851e-01, 1.86949727e-01, 3.02058283e-01,
  1.86881035e-01, 1.80278747e-01, 3.97467804e-01, 1.54065018e+00,
  1.99738227e-01, 7.50000000e-01, 2.51505787e-01, 2.26204268e-01,
  7.50000000e-01, 2.00000000e-02, 7.50000000e-01, 5.58422761e+00}};


/** Underlying frequency ratios for PAM250 */
static const double PAM250_FREQRATIOS[BLASTAA_SIZE][BLASTAA_SIZE] =
{{0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
  0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00},
 {0.00000000e+00, 1.51578006e+00, 1.05606466e+00, 6.26687137e-01,
  1.07002228e+00, 1.07474947e+00, 4.46290560e-01, 1.33923306e+00,
  7.32178470e-01, 8.88728816e-01, 7.66227814e-01, 6.46341735e-01,
  7.70359541e-01, 1.03988401e+00, 1.29408826e+00, 9.03456780e-01,
  7.00798809e-01, 1.28966428e+00, 1.31725380e+00, 1.04499203e+00,
  2.63609841e-01, 7.50000000e-01, 4.49686798e-01, 1.00010336e+00,
  7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 7.19479599e-01},
 {0.00000000e+00, 1.05606466e+00, 1.84257846e+00, 3.65113184e-01,
  2.05195422e+00, 1.82470118e+00, 3.54071966e-01, 1.11918465e+00,
  1.29683470e+00, 6.16970770e-01, 1.13010166e+00, 4.52559218e-01,
  6.04775077e-01, 1.59985542e+00, 8.46142888e-01, 1.33890747e+00,
  8.61808201e-01, 1.11706882e+00, 1.03197349e+00, 6.37811920e-01,
  2.96793416e-01, 7.50000000e-01, 4.85608019e-01, 1.61300149e+00,
  7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 5.02168751e-01},
 {0.00000000e+00, 6.26687137e-01, 3.65113184e-01, 1.56285624e+01,
  3.06772262e-01, 2.94964746e-01, 3.70976416e-01, 4.59297624e-01,
  4.51836855e-01, 5.87603719e-01, 2.86099293e-01, 2.47791243e-01,
  2.99408166e-01, 4.32746060e-01, 5.27421501e-01, 2.89534285e-01,
  4.30504374e-01, 9.89678273e-01, 6.01385571e-01, 6.38902701e-01,
  1.68818010e-01, 7.50000000e-01, 1.07830459e+00, 2.92598254e-01,
  7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 3.50326241e-01},
 {0.00000000e+00, 1.07002228e+00, 2.05195422e+00, 3.06772262e-01,
  2.43292288e+00, 2.19715052e+00, 2.73911818e-01, 1.14726861e+00,
  1.17343465e+00, 5.79909835e-01, 1.01987501e+00, 3.98183329e-01,
  5.48083233e-01, 1.61030872e+00, 8.05577240e-01, 1.46152937e+00,
  7.42874842e-01, 1.06886174e+00, 9.67471640e-01, 6.11601820e-01,
  2.12712296e-01, 7.50000000e-01, 3.69025897e-01, 1.87658077e+00,
  7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 4.53017475e-01},
 {0.00000000e+00, 1.07474947e+00, 1.82470118e+00, 2.94964746e-01,
  2.19715052e+00, 2.41404373e+00, 2.87098831e-01, 1.04389169e+00,
  1.16525001e+00, 6.26339428e-01, 9.87756703e-01, 4.63568053e-01,
  6.13603630e-01, 1.39293185e+00, 8.79669521e-01, 1.77158803e+00,
  7.82149443e-01, 9.98597151e-01, 9.13853001e-01, 6.60440693e-01,
  2.00637717e-01, 7.50000000e-01, 3.71943861e-01, 2.13407372e+00,
  7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 5.12682678e-01},
 {0.00000000e+00, 4.46290560e-01, 3.54071966e-01, 3.70976416e-01,
  2.73911818e-01, 2.87098831e-01, 8.02764197e+00, 3.32339414e-01,
  6.59545216e-01, 1.26203255e+00, 2.98137999e-01, 1.51752623e+00,
  1.04274830e+00, 4.46999215e-01, 3.50828021e-01, 3.43119584e-01,
  3.58749728e-01, 4.78353203e-01, 4.88459165e-01, 7.66309017e-01,
  1.07668873e+00, 7.50000000e-01, 4.97590308e+00, 3.11511613e-01,
  7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 1.44043358e+00},
 {0.00000000e+00, 1.33923306e+00, 1.11918465e+00, 4.59297624e-01,
  1.14726861e+00, 1.04389169e+00, 3.32339414e-01, 2.99056680e+00,
  6.15552047e-01, 5.57103314e-01, 6.78509416e-01, 3.94686522e-01,
  5.25369171e-01, 1.08662777e+00, 8.94077901e-01, 7.57447784e-01,
  5.54986868e-01, 1.27845679e+00, 9.98770702e-01, 7.34634729e-01,
  2.00363838e-01, 7.50000000e-01, 2.99613619e-01, 9.19064864e-01,
  7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 4.43694156e-01},
 {0.00000000e+00, 7.32178470e-01, 1.29683470e+00, 4.51836855e-01,
  1.17343465e+00, 1.16525001e+00, 6.59545216e-01, 6.15552047e-01,
  4.47513035e+00, 5.70614299e-01, 9.90160946e-01, 6.20055020e-01,
  6.09441413e-01, 1.43988866e+00, 9.46471632e-01, 1.96194975e+00,
  1.43036819e+00, 8.30226277e-01, 7.40733381e-01, 5.96692220e-01,
  5.44285116e-01, 7.50000000e-01, 9.78877039e-01, 1.51243666e+00,
  7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 6.05136779e-01},
 {0.00000000e+00, 8.88728816e-01, 6.16970770e-01, 5.87603719e-01,
  5.79909835e-01, 6.26339428e-01, 1.26203255e+00, 5.57103314e-01,
  5.70614299e-01, 2.83022396e+00, 6.40800116e-01, 1.74919442e+00,
  1.64986005e+00, 6.59934398e-01, 6.27243837e-01, 6.25316723e-01,
  6.29014923e-01, 7.22513707e-01, 1.01665478e+00, 2.33821719e+00,
  3.02670201e-01, 7.50000000e-01, 7.99863687e-01, 6.25893752e-01,
  7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 2.07538421e+00},
 {0.00000000e+00, 7.66227814e-01, 1.13010166e+00, 2.86099293e-01,
  1.01987501e+00, 9.87756703e-01, 2.98137999e-01, 6.78509416e-01,
  9.90160946e-01, 6.40800116e-01, 2.92620120e+00, 5.18814877e-01,
  1.09961986e+00, 1.25788411e+00, 7.70516817e-01, 1.18387275e+00,
  2.18168472e+00, 9.61645918e-01, 9.95647751e-01, 5.70096500e-01,
  4.50323287e-01, 7.50000000e-01, 3.59829368e-01, 1.07322036e+00,
  7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 5.55622697e-01},
 {0.00000000e+00, 6.46341735e-01, 4.52559218e-01, 2.47791243e-01,
  3.98183329e-01, 4.63568053e-01, 1.51752623e+00, 3.94686522e-01,
  6.20055020e-01, 1.74919442e+00, 5.18814877e-01, 3.92994485e+00,
  2.33771776e+00, 5.15595552e-01, 5.56038228e-01, 6.65507525e-01,
  5.01008003e-01, 5.24107036e-01, 6.77040993e-01, 1.53178711e+00,
  6.46886104e-01, 7.50000000e-01, 8.14904569e-01, 5.51569446e-01,
  7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 3.27192533e+00},
 {0.00000000e+00, 7.70359541e-01, 6.04775077e-01, 2.99408166e-01,
  5.48083233e-01, 6.13603630e-01, 1.04274830e+00, 5.25369171e-01,
  6.09441413e-01, 1.64986005e+00, 1.09961986e+00, 2.33771776e+00,
  4.40351686e+00, 6.70496227e-01, 6.21012433e-01, 7.95710012e-01,
  9.04471250e-01, 6.98581457e-01, 8.73067477e-01, 1.51039751e+00,
  3.74941590e-01, 7.50000000e-01, 5.67675865e-01, 6.92962139e-01,
  7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 2.13016362e+00},
 {0.00000000e+00, 1.03988401e+00, 1.59985542e+00, 4.32746060e-01,
  1.61030872e+00, 1.39293185e+00, 4.46999215e-01, 1.08662777e+00,
  1.43988866e+00, 6.59934398e-01, 1.25788411e+00, 5.15595552e-01,
  6.70496227e-01, 1.58773724e+00, 8.93169424e-01, 1.19675558e+00,
  9.99684066e-01, 1.17295383e+00, 1.10674855e+00, 6.68196499e-01,
  3.94266130e-01, 7.50000000e-01, 6.20758168e-01, 1.30744195e+00,
  7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 5.59148347e-01},
 {0.00000000e+00, 1.29408826e+00, 8.46142888e-01, 5.27421501e-01,
  8.05577240e-01, 8.79669521e-01, 3.50828021e-01, 8.94077901e-01,
  9.46471632e-01, 6.27243837e-01, 7.70516817e-01, 5.56038228e-01,
  6.21012433e-01, 8.93169424e-01, 3.84141803e+00, 1.05550534e+00,
  9.60208581e-01, 1.24349521e+00, 1.07552180e+00, 7.58279920e-01,
  2.75343404e-01, 7.50000000e-01, 3.20901839e-01, 9.56295438e-01,
  7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 5.77523805e-01},
 {0.00000000e+00, 9.03456780e-01, 1.33890747e+00, 2.89534285e-01,
  1.46152937e+00, 1.77158803e+00, 3.43119584e-01, 7.57447784e-01,
  1.96194975e+00, 6.25316723e-01, 1.18387275e+00, 6.65507525e-01,
  7.95710012e-01, 1.19675558e+00, 1.05550534e+00, 2.54088209e+00,
  1.33504131e+00, 8.89983529e-01, 8.32948914e-01, 6.49448913e-01,
  3.35176014e-01, 7.50000000e-01, 3.94549334e-01, 2.10683180e+00,
  7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 6.53380354e-01},
 {0.00000000e+00, 7.00798809e-01, 8.61808201e-01, 4.30504374e-01,
  7.42874842e-01, 7.82149443e-01, 3.58749728e-01, 5.54986868e-01,
  1.43036819e+00, 6.29014923e-01, 2.18168472e+00, 5.01008003e-01,
  9.04471250e-01, 9.99684066e-01, 9.60208581e-01, 1.33504131e+00,
  4.07760419e+00, 9.28286966e-01, 8.20208528e-01, 5.61449723e-01,
  1.65111328e+00, 7.50000000e-01, 3.78768704e-01, 1.02308924e+00,
  7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 5.39632804e-01},
 {0.00000000e+00, 1.28966428e+00, 1.11706882e+00, 9.89678273e-01,
  1.06886174e+00, 9.98597151e-01, 4.78353203e-01, 1.27845679e+00,
  8.30226277e-01, 7.22513707e-01, 9.61645918e-01, 5.24107036e-01,
  6.98581457e-01, 1.17295383e+00, 1.24349521e+00, 8.89983529e-01,
  9.28286966e-01, 1.44062735e+00, 1.36207698e+00, 7.99071364e-01,
  5.65535441e-01, 7.50000000e-01, 5.19882078e-01, 9.51265394e-01,
  7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 5.83974254e-01},
 {0.00000000e+00, 1.31725380e+00, 1.03197349e+00, 6.01385571e-01,
  9.67471640e-01, 9.13853001e-01, 4.88459165e-01, 9.98770702e-01,
  7.40733381e-01, 1.01665478e+00, 9.95647751e-01, 6.77040993e-01,
  8.73067477e-01, 1.10674855e+00, 1.07552180e+00, 8.32948914e-01,
  8.20208528e-01, 1.36207698e+00, 1.80640078e+00, 1.06764169e+00,
  3.05841935e-01, 7.50000000e-01, 5.30232118e-01, 8.78596534e-01,
  7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 7.79516037e-01},
 {0.00000000e+00, 1.04499203e+00, 6.37811920e-01, 6.38902701e-01,
  6.11601820e-01, 6.60440693e-01, 7.66309017e-01, 7.34634729e-01,
  5.96692220e-01, 2.33821719e+00, 5.70096500e-01, 1.53178711e+00,
  1.51039751e+00, 6.68196499e-01, 7.58279920e-01, 6.49448913e-01,
  5.61449723e-01, 7.99071364e-01, 1.06764169e+00, 2.69825619e+00,
  2.36794202e-01, 7.50000000e-01, 5.65836205e-01, 6.55650683e-01,
  7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 1.77511928e+00},
 {0.00000000e+00, 2.63609841e-01, 2.96793416e-01, 1.68818010e-01,
  2.12712296e-01, 2.00637717e-01, 1.07668873e+00, 2.00363838e-01,
  5.44285116e-01, 3.02670201e-01, 4.50323287e-01, 6.46886104e-01,
  3.74941590e-01, 3.94266130e-01, 2.75343404e-01, 3.35176014e-01,
  1.65111328e+00, 5.65535441e-01, 3.05841935e-01, 2.36794202e-01,
  5.26606678e+01, 7.50000000e-01, 9.69642510e-01, 2.59266956e-01,
  7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 5.43022417e-01},
 {0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 7.50000000e-01},
 {0.00000000e+00, 4.49686798e-01, 4.85608019e-01, 1.07830459e+00,
  3.69025897e-01, 3.71943861e-01, 4.97590308e+00, 2.99613619e-01,
  9.78877039e-01, 7.99863687e-01, 3.59829368e-01, 8.14904569e-01,
  5.67675865e-01, 6.20758168e-01, 3.20901839e-01, 3.94549334e-01,
  3.78768704e-01, 5.19882078e-01, 5.30232118e-01, 5.65836205e-01,
  9.69642510e-01, 7.50000000e-01, 1.03387565e+01, 3.81794898e-01,
  7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 8.10366134e-01},
 {0.00000000e+00, 1.00010336e+00, 1.61300149e+00, 2.92598254e-01,
  1.87658077e+00, 2.13407372e+00, 3.11511613e-01, 9.19064864e-01,
  1.51243666e+00, 6.25893752e-01, 1.07322036e+00, 5.51569446e-01,
  6.92962139e-01, 1.30744195e+00, 9.56295438e-01, 2.10683180e+00,
  1.02308924e+00, 9.51265394e-01, 8.78596534e-01, 6.55650683e-01,
  2.59266956e-01, 7.50000000e-01, 3.81794898e-01, 2.12220220e+00,
  7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 5.73996058e-01},
 {0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 7.50000000e-01},
 {0.00000000e+00, 1.70000000e-01, 1.70000000e-01, 1.70000000e-01,
  1.70000000e-01, 1.70000000e-01, 1.70000000e-01, 1.70000000e-01,
  1.70000000e-01, 1.70000000e-01, 1.70000000e-01, 1.70000000e-01,
  1.70000000e-01, 1.70000000e-01, 1.70000000e-01, 1.70000000e-01,
  1.70000000e-01, 1.70000000e-01, 1.70000000e-01, 1.70000000e-01,
  1.70000000e-01, 1.70000000e-01, 1.70000000e-01, 1.70000000e-01,
  1.70000000e-01, 1.33300000e+00, 1.70000000e-01, 1.70000000e-01},
 {0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
  7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 7.50000000e-01},
 {0.00000000e+00, 7.19479599e-01, 5.02168751e-01, 3.50326241e-01,
  4.53017475e-01, 5.12682678e-01, 1.44043358e+00, 4.43694156e-01,
  6.05136779e-01, 2.07538421e+00, 5.55622697e-01, 3.27192533e+00,
  2.13016362e+00, 5.59148347e-01, 5.77523805e-01, 6.53380354e-01,
  5.39632804e-01, 5.83974254e-01, 7.79516037e-01, 1.77511928e+00,
  5.43022417e-01, 7.50000000e-01, 8.10366134e-01, 5.73996058e-01,
  7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 2.91088108e+00}};


/** Additional bit scale multiplier for BLOSUM62_20A matrix */
#define BLOSUM62_20A_SCALE_MULTIPLIER 0.9666
/** Additional bit scale multiplier for BLOSUM62_20B matrix */
#define BLOSUM62_20B_SCALE_MULTIPLIER 0.9344

SFreqRatios*
_PSIMatrixFrequencyRatiosNew(const char* matrix_name)
{
    unsigned int i, j;          /* loop indices */
    SFreqRatios* retval = NULL; /* the return value */

    ASSERT(matrix_name);

    retval = (SFreqRatios*) malloc(sizeof(SFreqRatios));
    if ( !retval ) {
        return NULL;
    }

    retval->data = (double**) _PSIAllocateMatrix(BLASTAA_SIZE, BLASTAA_SIZE, 
                                                 sizeof(double));
    if ( !retval->data ) {
        return _PSIMatrixFrequencyRatiosFree(retval);
    }

    if ( !strcasecmp(matrix_name, "BLOSUM62") ||
         !strcasecmp(matrix_name, "BLOSUM62_20")) {
        for (i = 0; i < BLASTAA_SIZE; i++) {
            for (j = 0; j < BLASTAA_SIZE; j++) {
                retval->data[i][j] = BLOSUM62_FREQRATIOS[i][j];
            }
        }
        retval->bit_scale_factor = 2;
    } else if ( !strcasecmp(matrix_name, "BLOSUM62_20A")) {
        for (i = 0; i < BLASTAA_SIZE; i++) {
            for (j = 0; j < BLASTAA_SIZE; j++) {
                retval->data[i][j] = 
                    BLOSUM62_20A_SCALE_MULTIPLIER * BLOSUM62_FREQRATIOS[i][j];
            }
        }
        retval->bit_scale_factor = 2;
    } else if ( !strcasecmp(matrix_name, "BLOSUM62_20B")) {
        for (i = 0; i < BLASTAA_SIZE; i++) {
            for (j = 0; j < BLASTAA_SIZE; j++) {
                retval->data[i][j] =
                    BLOSUM62_20B_SCALE_MULTIPLIER * BLOSUM62_FREQRATIOS[i][j];
            }
        }
        retval->bit_scale_factor = 2;
    } else if ( !strcasecmp(matrix_name, "BLOSUM45") ) {
        for (i = 0; i < BLASTAA_SIZE; i++) {
            for (j = 0; j < BLASTAA_SIZE; j++) {
                retval->data[i][j] = BLOSUM45_FREQRATIOS[i][j];
            }
        }
        retval->bit_scale_factor = 3;
    } else if ( !strcasecmp(matrix_name, "BLOSUM80") ) {
        for (i = 0; i < BLASTAA_SIZE; i++) {
            for (j = 0; j < BLASTAA_SIZE; j++) {
                retval->data[i][j] = BLOSUM80_FREQRATIOS[i][j];
            }
        }
        retval->bit_scale_factor = 2;
    } else if ( !strcasecmp(matrix_name, "BLOSUM50") ) {
        for (i = 0; i < BLASTAA_SIZE; i++) {
            for (j = 0; j < BLASTAA_SIZE; j++) {
                retval->data[i][j] = BLOSUM50_FREQRATIOS[i][j];
            }
        }
        retval->bit_scale_factor = 2;
    } else if ( !strcasecmp(matrix_name, "BLOSUM90") ) {
        for (i = 0; i < BLASTAA_SIZE; i++) {
            for (j = 0; j < BLASTAA_SIZE; j++) {
                retval->data[i][j] = BLOSUM90_FREQRATIOS[i][j];
            }
        }
        retval->bit_scale_factor = 2;
    } else if ( !strcasecmp(matrix_name, "PAM30") ) {
        for (i = 0; i < BLASTAA_SIZE; i++) {
            for (j = 0; j < BLASTAA_SIZE; j++) {
                retval->data[i][j] = PAM30_FREQRATIOS[i][j];
            }
        }
        retval->bit_scale_factor = 2;
    } else if ( !strcasecmp(matrix_name, "PAM70") ) {
        for (i = 0; i < BLASTAA_SIZE; i++) {
            for (j = 0; j < BLASTAA_SIZE; j++) {
                retval->data[i][j] = PAM70_FREQRATIOS[i][j];
            }
        }
        retval->bit_scale_factor = 2;
    } else if ( !strcasecmp(matrix_name, "PAM250") ) {
        for (i = 0; i < BLASTAA_SIZE; i++) {
            for (j = 0; j < BLASTAA_SIZE; j++) {
                retval->data[i][j] = PAM250_FREQRATIOS[i][j];
            }
        }
        retval->bit_scale_factor = 2;
    } else {
        retval = _PSIMatrixFrequencyRatiosFree(retval);
    }

    return retval;
}

SFreqRatios*
_PSIMatrixFrequencyRatiosFree(SFreqRatios* freq_ratios)
{
    if ( !freq_ratios )
        return NULL;

    if (freq_ratios->data) {
        _PSIDeallocateMatrix((void**) freq_ratios->data, BLASTAA_SIZE);
    }

    sfree(freq_ratios);
    return NULL;
}
