//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/vmwarecloudsimple/armvmwarecloudsimple"
	"net/http"
	"net/url"
	"regexp"
)

// PrivateCloudsServer is a fake server for instances of the armvmwarecloudsimple.PrivateCloudsClient type.
type PrivateCloudsServer struct {
	// Get is the fake for method PrivateCloudsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, pcName string, regionID string, options *armvmwarecloudsimple.PrivateCloudsClientGetOptions) (resp azfake.Responder[armvmwarecloudsimple.PrivateCloudsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method PrivateCloudsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(regionID string, options *armvmwarecloudsimple.PrivateCloudsClientListOptions) (resp azfake.PagerResponder[armvmwarecloudsimple.PrivateCloudsClientListResponse])
}

// NewPrivateCloudsServerTransport creates a new instance of PrivateCloudsServerTransport with the provided implementation.
// The returned PrivateCloudsServerTransport instance is connected to an instance of armvmwarecloudsimple.PrivateCloudsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPrivateCloudsServerTransport(srv *PrivateCloudsServer) *PrivateCloudsServerTransport {
	return &PrivateCloudsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armvmwarecloudsimple.PrivateCloudsClientListResponse]](),
	}
}

// PrivateCloudsServerTransport connects instances of armvmwarecloudsimple.PrivateCloudsClient to instances of PrivateCloudsServer.
// Don't use this type directly, use NewPrivateCloudsServerTransport instead.
type PrivateCloudsServerTransport struct {
	srv          *PrivateCloudsServer
	newListPager *tracker[azfake.PagerResponder[armvmwarecloudsimple.PrivateCloudsClientListResponse]]
}

// Do implements the policy.Transporter interface for PrivateCloudsServerTransport.
func (p *PrivateCloudsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PrivateCloudsClient.Get":
		resp, err = p.dispatchGet(req)
	case "PrivateCloudsClient.NewListPager":
		resp, err = p.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PrivateCloudsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if p.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.VMwareCloudSimple/locations/(?P<regionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateClouds/(?P<pcName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	pcNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("pcName")])
	if err != nil {
		return nil, err
	}
	regionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("regionId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Get(req.Context(), pcNameParam, regionIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PrivateCloud, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PrivateCloudsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := p.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.VMwareCloudSimple/locations/(?P<regionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateClouds`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		regionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("regionId")])
		if err != nil {
			return nil, err
		}
		resp := p.srv.NewListPager(regionIDParam, nil)
		newListPager = &resp
		p.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armvmwarecloudsimple.PrivateCloudsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		p.newListPager.remove(req)
	}
	return resp, nil
}
