//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/virtualmachineimagebuilder/armvirtualmachineimagebuilder/v2"
	"net/http"
	"net/url"
	"regexp"
)

// TriggersServer is a fake server for instances of the armvirtualmachineimagebuilder.TriggersClient type.
type TriggersServer struct {
	// BeginCreateOrUpdate is the fake for method TriggersClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, imageTemplateName string, triggerName string, parameters armvirtualmachineimagebuilder.Trigger, options *armvirtualmachineimagebuilder.TriggersClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armvirtualmachineimagebuilder.TriggersClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method TriggersClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, imageTemplateName string, triggerName string, options *armvirtualmachineimagebuilder.TriggersClientBeginDeleteOptions) (resp azfake.PollerResponder[armvirtualmachineimagebuilder.TriggersClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method TriggersClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, imageTemplateName string, triggerName string, options *armvirtualmachineimagebuilder.TriggersClientGetOptions) (resp azfake.Responder[armvirtualmachineimagebuilder.TriggersClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByImageTemplatePager is the fake for method TriggersClient.NewListByImageTemplatePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByImageTemplatePager func(resourceGroupName string, imageTemplateName string, options *armvirtualmachineimagebuilder.TriggersClientListByImageTemplateOptions) (resp azfake.PagerResponder[armvirtualmachineimagebuilder.TriggersClientListByImageTemplateResponse])
}

// NewTriggersServerTransport creates a new instance of TriggersServerTransport with the provided implementation.
// The returned TriggersServerTransport instance is connected to an instance of armvirtualmachineimagebuilder.TriggersClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewTriggersServerTransport(srv *TriggersServer) *TriggersServerTransport {
	return &TriggersServerTransport{
		srv:                         srv,
		beginCreateOrUpdate:         newTracker[azfake.PollerResponder[armvirtualmachineimagebuilder.TriggersClientCreateOrUpdateResponse]](),
		beginDelete:                 newTracker[azfake.PollerResponder[armvirtualmachineimagebuilder.TriggersClientDeleteResponse]](),
		newListByImageTemplatePager: newTracker[azfake.PagerResponder[armvirtualmachineimagebuilder.TriggersClientListByImageTemplateResponse]](),
	}
}

// TriggersServerTransport connects instances of armvirtualmachineimagebuilder.TriggersClient to instances of TriggersServer.
// Don't use this type directly, use NewTriggersServerTransport instead.
type TriggersServerTransport struct {
	srv                         *TriggersServer
	beginCreateOrUpdate         *tracker[azfake.PollerResponder[armvirtualmachineimagebuilder.TriggersClientCreateOrUpdateResponse]]
	beginDelete                 *tracker[azfake.PollerResponder[armvirtualmachineimagebuilder.TriggersClientDeleteResponse]]
	newListByImageTemplatePager *tracker[azfake.PagerResponder[armvirtualmachineimagebuilder.TriggersClientListByImageTemplateResponse]]
}

// Do implements the policy.Transporter interface for TriggersServerTransport.
func (t *TriggersServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "TriggersClient.BeginCreateOrUpdate":
		resp, err = t.dispatchBeginCreateOrUpdate(req)
	case "TriggersClient.BeginDelete":
		resp, err = t.dispatchBeginDelete(req)
	case "TriggersClient.Get":
		resp, err = t.dispatchGet(req)
	case "TriggersClient.NewListByImageTemplatePager":
		resp, err = t.dispatchNewListByImageTemplatePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (t *TriggersServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if t.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := t.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.VirtualMachineImages/imageTemplates/(?P<imageTemplateName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/triggers/(?P<triggerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armvirtualmachineimagebuilder.Trigger](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		imageTemplateNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("imageTemplateName")])
		if err != nil {
			return nil, err
		}
		triggerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("triggerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := t.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, imageTemplateNameParam, triggerNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		t.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		t.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		t.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (t *TriggersServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if t.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := t.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.VirtualMachineImages/imageTemplates/(?P<imageTemplateName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/triggers/(?P<triggerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		imageTemplateNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("imageTemplateName")])
		if err != nil {
			return nil, err
		}
		triggerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("triggerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := t.srv.BeginDelete(req.Context(), resourceGroupNameParam, imageTemplateNameParam, triggerNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		t.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		t.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		t.beginDelete.remove(req)
	}

	return resp, nil
}

func (t *TriggersServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if t.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.VirtualMachineImages/imageTemplates/(?P<imageTemplateName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/triggers/(?P<triggerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	imageTemplateNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("imageTemplateName")])
	if err != nil {
		return nil, err
	}
	triggerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("triggerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.Get(req.Context(), resourceGroupNameParam, imageTemplateNameParam, triggerNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Trigger, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (t *TriggersServerTransport) dispatchNewListByImageTemplatePager(req *http.Request) (*http.Response, error) {
	if t.srv.NewListByImageTemplatePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByImageTemplatePager not implemented")}
	}
	newListByImageTemplatePager := t.newListByImageTemplatePager.get(req)
	if newListByImageTemplatePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.VirtualMachineImages/imageTemplates/(?P<imageTemplateName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/triggers`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		imageTemplateNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("imageTemplateName")])
		if err != nil {
			return nil, err
		}
		resp := t.srv.NewListByImageTemplatePager(resourceGroupNameParam, imageTemplateNameParam, nil)
		newListByImageTemplatePager = &resp
		t.newListByImageTemplatePager.add(req, newListByImageTemplatePager)
		server.PagerResponderInjectNextLinks(newListByImageTemplatePager, req, func(page *armvirtualmachineimagebuilder.TriggersClientListByImageTemplateResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByImageTemplatePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		t.newListByImageTemplatePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByImageTemplatePager) {
		t.newListByImageTemplatePager.remove(req)
	}
	return resp, nil
}
