//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsql_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/DatabaseSqlVulnerabilityAssessmentScanRecordsListByDatabase.json
func ExampleDatabaseSQLVulnerabilityAssessmentScansClient_NewListBySQLVulnerabilityAssessmentsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDatabaseSQLVulnerabilityAssessmentScansClient().NewListBySQLVulnerabilityAssessmentsPager("vulnerabilityassessmenttest-4711", "vulnerabilityassessmenttest-6411", "testdb", armsql.VulnerabilityAssessmentNameDefault, nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.VulnerabilityAssessmentScanRecordForSQLListResult = armsql.VulnerabilityAssessmentScanRecordForSQLListResult{
		// 	Value: []*armsql.VulnerabilityAssessmentScanRecordForSQL{
		// 		{
		// 			Name: to.Ptr("scan001"),
		// 			Type: to.Ptr("Microsoft.Sql/servers/databases/sqlVulnerabilityAssessments/scans"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityassessmenttest-4711/providers/Microsoft.Sql/servers/vulnerabilityassessmenttest-6411/databases/testdb/sqlVulnerabilityAssessments/default/scans/scan001"),
		// 			Properties: &armsql.VulnerabilityAssessmentScanRecordForSQLProperties{
		// 				Database: to.Ptr("testdb"),
		// 				EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-23T06:49:00.723Z"); return t}()),
		// 				HighSeverityFailedRulesCount: to.Ptr[int32](3),
		// 				IsBaselineApplied: to.Ptr(false),
		// 				LastScanTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-23T06:49:00.645Z"); return t}()),
		// 				LowSeverityFailedRulesCount: to.Ptr[int32](1),
		// 				MediumSeverityFailedRulesCount: to.Ptr[int32](2),
		// 				ScanID: to.Ptr("scan001"),
		// 				Server: to.Ptr("vulnerabilityassessmenttest-6411"),
		// 				SQLVersion: to.Ptr("15.0.2000"),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-23T06:49:00.645Z"); return t}()),
		// 				State: to.Ptr(armsql.VulnerabilityAssessmentScanStateFailed),
		// 				TotalFailedRulesCount: to.Ptr[int32](6),
		// 				TotalPassedRulesCount: to.Ptr[int32](20),
		// 				TotalRulesCount: to.Ptr[int32](26),
		// 				TriggerType: to.Ptr(armsql.VulnerabilityAssessmentScanTriggerTypeRecurring),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("scan001"),
		// 			Type: to.Ptr("Microsoft.Sql/servers/databases/sqlVulnerabilityAssessments/scans"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityassessmenttest-4711/providers/Microsoft.Sql/servers/vulnerabilityassessmenttest-6411/databases/testdb/sqlVulnerabilityAssessments/default/scans/scan002"),
		// 			Properties: &armsql.VulnerabilityAssessmentScanRecordForSQLProperties{
		// 				Database: to.Ptr("testdb"),
		// 				EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-23T06:49:00.723Z"); return t}()),
		// 				HighSeverityFailedRulesCount: to.Ptr[int32](3),
		// 				IsBaselineApplied: to.Ptr(false),
		// 				LastScanTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-23T06:49:00.645Z"); return t}()),
		// 				LowSeverityFailedRulesCount: to.Ptr[int32](1),
		// 				MediumSeverityFailedRulesCount: to.Ptr[int32](2),
		// 				ScanID: to.Ptr("scan002"),
		// 				Server: to.Ptr("vulnerabilityassessmenttest-6411"),
		// 				SQLVersion: to.Ptr("15.0.2000"),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-23T06:49:00.645Z"); return t}()),
		// 				State: to.Ptr(armsql.VulnerabilityAssessmentScanStateFailed),
		// 				TotalFailedRulesCount: to.Ptr[int32](6),
		// 				TotalPassedRulesCount: to.Ptr[int32](20),
		// 				TotalRulesCount: to.Ptr[int32](26),
		// 				TriggerType: to.Ptr(armsql.VulnerabilityAssessmentScanTriggerTypeRecurring),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("scan001"),
		// 			Type: to.Ptr("Microsoft.Sql/servers/databases/sqlVulnerabilityAssessments/scans"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityassessmenttest-4711/providers/Microsoft.Sql/servers/vulnerabilityassessmenttest-6411/databases/testdb/sqlVulnerabilityAssessments/default/scans/scan003"),
		// 			Properties: &armsql.VulnerabilityAssessmentScanRecordForSQLProperties{
		// 				Database: to.Ptr("testdb"),
		// 				EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-23T06:49:00.723Z"); return t}()),
		// 				HighSeverityFailedRulesCount: to.Ptr[int32](3),
		// 				IsBaselineApplied: to.Ptr(false),
		// 				LastScanTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-23T06:49:00.645Z"); return t}()),
		// 				LowSeverityFailedRulesCount: to.Ptr[int32](1),
		// 				MediumSeverityFailedRulesCount: to.Ptr[int32](2),
		// 				ScanID: to.Ptr("scan003"),
		// 				Server: to.Ptr("vulnerabilityassessmenttest-6411"),
		// 				SQLVersion: to.Ptr("15.0.2000"),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-23T06:49:00.645Z"); return t}()),
		// 				State: to.Ptr(armsql.VulnerabilityAssessmentScanStateFailed),
		// 				TotalFailedRulesCount: to.Ptr[int32](6),
		// 				TotalPassedRulesCount: to.Ptr[int32](20),
		// 				TotalRulesCount: to.Ptr[int32](26),
		// 				TriggerType: to.Ptr(armsql.VulnerabilityAssessmentScanTriggerTypeRecurring),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/DatabaseSqlVulnerabilityAssessmentScan.json
func ExampleDatabaseSQLVulnerabilityAssessmentScansClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDatabaseSQLVulnerabilityAssessmentScansClient().Get(ctx, "vulnerabilityassessmenttest-4711", "vulnerabilityassessmenttest-6411", "testdb", armsql.VulnerabilityAssessmentNameDefault, "scan001", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VulnerabilityAssessmentScanRecordForSQL = armsql.VulnerabilityAssessmentScanRecordForSQL{
	// 	Name: to.Ptr("scan001"),
	// 	Type: to.Ptr("Microsoft.Sql/servers/databases/sqlVulnerabilityAssessments/scans"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityassessmenttest-4711/providers/Microsoft.Sql/servers/vulnerabilityassessmenttest-6411/databases/testdb/sqlVulnerabilityAssessments/default/scans/scan001"),
	// 	Properties: &armsql.VulnerabilityAssessmentScanRecordForSQLProperties{
	// 		Database: to.Ptr("testdb"),
	// 		EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-23T06:49:00.723Z"); return t}()),
	// 		HighSeverityFailedRulesCount: to.Ptr[int32](3),
	// 		IsBaselineApplied: to.Ptr(false),
	// 		LastScanTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-23T06:49:00.645Z"); return t}()),
	// 		LowSeverityFailedRulesCount: to.Ptr[int32](1),
	// 		MediumSeverityFailedRulesCount: to.Ptr[int32](2),
	// 		ScanID: to.Ptr("scan001"),
	// 		Server: to.Ptr("vulnerabilityassessmenttest-6411"),
	// 		SQLVersion: to.Ptr("15.0.2000"),
	// 		StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-23T06:49:00.645Z"); return t}()),
	// 		State: to.Ptr(armsql.VulnerabilityAssessmentScanStateFailed),
	// 		TotalFailedRulesCount: to.Ptr[int32](6),
	// 		TotalPassedRulesCount: to.Ptr[int32](20),
	// 		TotalRulesCount: to.Ptr[int32](26),
	// 		TriggerType: to.Ptr(armsql.VulnerabilityAssessmentScanTriggerTypeRecurring),
	// 	},
	// }
}
