"""
This type stub file was generated by pyright.
"""

from typing import Callable
from typing import Literal
from typing import Optional
from typing import TypeVar
from typing import Union

import datetime
from collections.abc import Iterable

from winrt.windows.ui.notifications import ToastDismissedEventArgs
from winrt.windows.ui.notifications import ToastFailedEventArgs

from .events import ToastActivatedEventArgs
from .toast_audio import ToastAudio
from .wrappers import ToastButton
from .wrappers import ToastDisplayImage
from .wrappers import ToastDuration
from .wrappers import ToastInputSelectionBox
from .wrappers import ToastInputTextBox
from .wrappers import ToastProgressBar
from .wrappers import ToastScenario
from .wrappers import ToastSystemButton

ToastInput = TypeVar("ToastInput", ToastInputTextBox, ToastInputSelectionBox)

class Toast:
    audio: Optional[ToastAudio]
    duration: Literal[ToastDuration.Default, ToastDuration.Long, ToastDuration.Short]
    expiration_time: Optional[datetime.datetime]
    group: Optional[str]
    scenario: ToastScenario
    suppress_popup: bool
    timestamp: Optional[datetime.datetime]
    progress_bar: Optional[ToastProgressBar]
    attribution_text: Optional[str]
    on_activated: Optional[Callable[[ToastActivatedEventArgs], None]]
    on_dismissed: Optional[Callable[[ToastDismissedEventArgs], None]]
    on_failed: Optional[Callable[[ToastFailedEventArgs], None]]
    actions: list[Union[ToastButton, ToastSystemButton]]
    images: list[ToastDisplayImage]
    inputs: list[ToastInput]
    text_fields: list[Optional[str]]
    tag: str
    updates: int
    _launch_action: Optional[str]
    def __init__(
        self,
        text_fields: Union[
            list[Optional[str]], tuple[Optional[str]], set[Optional[str]]
        ] = ...,
        audio: Optional[ToastAudio] = ...,
        duration: ToastDuration = ...,
        expiration_time: Optional[datetime.datetime] = ...,
        group: Optional[str] = ...,
        launch_action: Optional[str] = ...,
        progress_bar: Optional[ToastProgressBar] = ...,
        attribution_text: Optional[str] = ...,
        scenario: ToastScenario = ...,
        suppress_popup: bool = ...,
        timestamp: Optional[datetime.datetime] = ...,
        on_activated: Optional[Callable[[ToastActivatedEventArgs], None]] = ...,
        on_dismissed: Optional[Callable[[ToastDismissedEventArgs], None]] = ...,
        on_failed: Optional[Callable[[ToastFailedEventArgs], None]] = ...,
        actions: Iterable[Union[ToastButton, ToastSystemButton]] = ...,
        images: Iterable[ToastDisplayImage] = ...,
        inputs: Iterable[ToastInput] = ...,
    ) -> None:
        """
        Initialise a toast

        :param actions: Iterable of actions to add; see :meth:`AddAction`
        :type actions: Iterable[Union[ToastButton, ToastSystemButton]]
        :param images: See :meth:`AddImage`
        :type images: Iterable[ToastDisplayImage]
        :param inputs: See :meth:`AddInput`
        :type inputs: Iterable[ToastInput]
        """
        ...

    def __eq__(self, other) -> bool: ...
    def __repr__(self):  # -> str:
        ...
    def AddAction(self, action: Union[ToastButton, ToastSystemButton]) -> None:
        """
        Add an action to the action list. For example, if you're setting up a reminder,
        you would use 'action=remindlater&date=2020-01-20' as arguments. Maximum of five.

        :type action: Union[ToastButton, ToastSystemButton]
        """
        ...

    def AddImage(self, image: ToastDisplayImage) -> None:
        """
        Adds an the image that will be displayed on the toast.
        If using WindowsToaster, a maximum of two (one as the logo and one hero) images will work.

        :param image: :class:`ToastDisplayImage` to display in the toast
        """
        ...

    def AddInput(self, toast_input: ToastInput) -> None:
        """
        Adds an input field to the notification. It will be supplied as user_input of type ValueSet in on_activated

        :param toast_input: :class:`ToastInput` to display in the toast
        """
        ...

    @property
    def launch_action(self) -> Optional[str]:
        """Protocol to launch when the toast is clicked"""
        ...

    @launch_action.setter
    def launch_action(self, value: Optional[str]):  # -> None:
        ...
    def clone(self) -> Toast:
        """
        Clone the current toast and return the new one

        :return: A deep copy of the toast
        :rtype: Toast
        """
        ...
