// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file rpc_typesPubSubTypes.hpp
 * This header file contains the declaration of the serialization functions.
 *
 * This file was generated by the tool fastddsgen.
 */


#ifndef FAST_DDS_GENERATED__EPROSIMA_FASTDDS_DDS_RPC_RPC_TYPES_PUBSUBTYPES_HPP
#define FAST_DDS_GENERATED__EPROSIMA_FASTDDS_DDS_RPC_RPC_TYPES_PUBSUBTYPES_HPP

#include <fastdds/dds/core/policy/QosPolicies.hpp>
#include <fastdds/dds/topic/TopicDataType.hpp>
#include <fastdds/rtps/common/InstanceHandle.hpp>
#include <fastdds/rtps/common/SerializedPayload.hpp>
#include <fastdds/utils/md5.hpp>

#include "rpc_types.hpp"


#if !defined(FASTDDS_GEN_API_VER) || (FASTDDS_GEN_API_VER != 3)
#error \
    Generated rpc_types is not compatible with current installed Fast DDS. Please, regenerate it with fastddsgen.
#endif  // FASTDDS_GEN_API_VER

namespace eprosima {

namespace fastdds {

namespace dds {


typedef std::array<uint8_t, 12> GuidPrefix_t;

#ifndef SWIG
namespace detail {

template<typename Tag, typename Tag::type M>
struct EntityId_t_rob
{
    friend constexpr typename Tag::type get(
            Tag)
    {
        return M;
    }

};

struct EntityId_t_f
{
    typedef uint8_t EntityId_t::* type;
    friend constexpr type get(
            EntityId_t_f);
};

template struct EntityId_t_rob<EntityId_t_f, &EntityId_t::m_entityKind>;

template <typename T, typename Tag>
inline size_t constexpr EntityId_t_offset_of()
{
    return ((::size_t) &reinterpret_cast<char const volatile&>((((T*)0)->*get(Tag()))));
}

} // namespace detail
#endif // ifndef SWIG


/*!
 * @brief This class represents the TopicDataType of the type EntityId_t defined by the user in the IDL file.
 * @ingroup rpc_types
 */
class EntityId_tPubSubType : public eprosima::fastdds::dds::TopicDataType
{
public:

    typedef EntityId_t type;

    eProsima_user_DllExport EntityId_tPubSubType();

    eProsima_user_DllExport ~EntityId_tPubSubType() override;

    eProsima_user_DllExport bool serialize(
            const void* const data,
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool deserialize(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            void* data) override;

    eProsima_user_DllExport uint32_t calculate_serialized_size(
            const void* const data,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool compute_key(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport bool compute_key(
            const void* const data,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport void* create_data() override;

    eProsima_user_DllExport void delete_data(
            void* data) override;

    //Register TypeObject representation in Fast DDS TypeObjectRegistry
    eProsima_user_DllExport void register_type_object_representation() override;

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED
    eProsima_user_DllExport inline bool is_bounded() const override
    {
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

    eProsima_user_DllExport inline bool is_plain(
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) const override
    {
        if (data_representation == eprosima::fastdds::dds::DataRepresentationId_t::XCDR2_DATA_REPRESENTATION)
        {
            return is_plain_xcdrv2_impl();
        }
        else
        {
            return is_plain_xcdrv1_impl();
        }
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

#ifdef TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE
    eProsima_user_DllExport inline bool construct_sample(
            void* memory) const override
    {
        new (memory) EntityId_t();
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE

private:

    eprosima::fastdds::MD5 md5_;
    unsigned char* key_buffer_;


    static constexpr bool is_plain_xcdrv1_impl()
    {
        return 4ULL ==
               (detail::EntityId_t_offset_of<EntityId_t, detail::EntityId_t_f>() +
               sizeof(uint8_t));
    }

    static constexpr bool is_plain_xcdrv2_impl()
    {
        return 4ULL ==
               (detail::EntityId_t_offset_of<EntityId_t, detail::EntityId_t_f>() +
               sizeof(uint8_t));
    }

};

#ifndef SWIG
namespace detail {

template<typename Tag, typename Tag::type M>
struct GUID_t_rob
{
    friend constexpr typename Tag::type get(
            Tag)
    {
        return M;
    }

};

struct GUID_t_f
{
    typedef eprosima::fastdds::dds::EntityId_t GUID_t::* type;
    friend constexpr type get(
            GUID_t_f);
};

template struct GUID_t_rob<GUID_t_f, &GUID_t::m_entityId>;

template <typename T, typename Tag>
inline size_t constexpr GUID_t_offset_of()
{
    return ((::size_t) &reinterpret_cast<char const volatile&>((((T*)0)->*get(Tag()))));
}

} // namespace detail
#endif // ifndef SWIG


/*!
 * @brief This class represents the TopicDataType of the type GUID_t defined by the user in the IDL file.
 * @ingroup rpc_types
 */
class GUID_tPubSubType : public eprosima::fastdds::dds::TopicDataType
{
public:

    typedef GUID_t type;

    eProsima_user_DllExport GUID_tPubSubType();

    eProsima_user_DllExport ~GUID_tPubSubType() override;

    eProsima_user_DllExport bool serialize(
            const void* const data,
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool deserialize(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            void* data) override;

    eProsima_user_DllExport uint32_t calculate_serialized_size(
            const void* const data,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool compute_key(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport bool compute_key(
            const void* const data,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport void* create_data() override;

    eProsima_user_DllExport void delete_data(
            void* data) override;

    //Register TypeObject representation in Fast DDS TypeObjectRegistry
    eProsima_user_DllExport void register_type_object_representation() override;

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED
    eProsima_user_DllExport inline bool is_bounded() const override
    {
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

    eProsima_user_DllExport inline bool is_plain(
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) const override
    {
        if (data_representation == eprosima::fastdds::dds::DataRepresentationId_t::XCDR2_DATA_REPRESENTATION)
        {
            return is_plain_xcdrv2_impl();
        }
        else
        {
            return is_plain_xcdrv1_impl();
        }
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

#ifdef TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE
    eProsima_user_DllExport inline bool construct_sample(
            void* memory) const override
    {
        new (memory) GUID_t();
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE

private:

    eprosima::fastdds::MD5 md5_;
    unsigned char* key_buffer_;


    static constexpr bool is_plain_xcdrv1_impl()
    {
        return 16ULL ==
               (detail::GUID_t_offset_of<GUID_t, detail::GUID_t_f>() +
               sizeof(eprosima::fastdds::dds::EntityId_t));
    }

    static constexpr bool is_plain_xcdrv2_impl()
    {
        return 16ULL ==
               (detail::GUID_t_offset_of<GUID_t, detail::GUID_t_f>() +
               sizeof(eprosima::fastdds::dds::EntityId_t));
    }

};

#ifndef SWIG
namespace detail {

template<typename Tag, typename Tag::type M>
struct SequenceNumber_t_rob
{
    friend constexpr typename Tag::type get(
            Tag)
    {
        return M;
    }

};

struct SequenceNumber_t_f
{
    typedef uint32_t SequenceNumber_t::* type;
    friend constexpr type get(
            SequenceNumber_t_f);
};

template struct SequenceNumber_t_rob<SequenceNumber_t_f, &SequenceNumber_t::m_low>;

template <typename T, typename Tag>
inline size_t constexpr SequenceNumber_t_offset_of()
{
    return ((::size_t) &reinterpret_cast<char const volatile&>((((T*)0)->*get(Tag()))));
}

} // namespace detail
#endif // ifndef SWIG


/*!
 * @brief This class represents the TopicDataType of the type SequenceNumber_t defined by the user in the IDL file.
 * @ingroup rpc_types
 */
class SequenceNumber_tPubSubType : public eprosima::fastdds::dds::TopicDataType
{
public:

    typedef SequenceNumber_t type;

    eProsima_user_DllExport SequenceNumber_tPubSubType();

    eProsima_user_DllExport ~SequenceNumber_tPubSubType() override;

    eProsima_user_DllExport bool serialize(
            const void* const data,
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool deserialize(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            void* data) override;

    eProsima_user_DllExport uint32_t calculate_serialized_size(
            const void* const data,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool compute_key(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport bool compute_key(
            const void* const data,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport void* create_data() override;

    eProsima_user_DllExport void delete_data(
            void* data) override;

    //Register TypeObject representation in Fast DDS TypeObjectRegistry
    eProsima_user_DllExport void register_type_object_representation() override;

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED
    eProsima_user_DllExport inline bool is_bounded() const override
    {
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

    eProsima_user_DllExport inline bool is_plain(
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) const override
    {
        if (data_representation == eprosima::fastdds::dds::DataRepresentationId_t::XCDR2_DATA_REPRESENTATION)
        {
            return is_plain_xcdrv2_impl();
        }
        else
        {
            return is_plain_xcdrv1_impl();
        }
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

#ifdef TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE
    eProsima_user_DllExport inline bool construct_sample(
            void* memory) const override
    {
        new (memory) SequenceNumber_t();
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE

private:

    eprosima::fastdds::MD5 md5_;
    unsigned char* key_buffer_;


    static constexpr bool is_plain_xcdrv1_impl()
    {
        return 8ULL ==
               (detail::SequenceNumber_t_offset_of<SequenceNumber_t, detail::SequenceNumber_t_f>() +
               sizeof(uint32_t));
    }

    static constexpr bool is_plain_xcdrv2_impl()
    {
        return 8ULL ==
               (detail::SequenceNumber_t_offset_of<SequenceNumber_t, detail::SequenceNumber_t_f>() +
               sizeof(uint32_t));
    }

};

#ifndef SWIG
namespace detail {

template<typename Tag, typename Tag::type M>
struct SampleIdentity_rob
{
    friend constexpr typename Tag::type get(
            Tag)
    {
        return M;
    }

};

struct SampleIdentity_f
{
    typedef eprosima::fastdds::dds::SequenceNumber_t SampleIdentity::* type;
    friend constexpr type get(
            SampleIdentity_f);
};

template struct SampleIdentity_rob<SampleIdentity_f, &SampleIdentity::m_sequence_number>;

template <typename T, typename Tag>
inline size_t constexpr SampleIdentity_offset_of()
{
    return ((::size_t) &reinterpret_cast<char const volatile&>((((T*)0)->*get(Tag()))));
}

} // namespace detail
#endif // ifndef SWIG


/*!
 * @brief This class represents the TopicDataType of the type SampleIdentity defined by the user in the IDL file.
 * @ingroup rpc_types
 */
class SampleIdentityPubSubType : public eprosima::fastdds::dds::TopicDataType
{
public:

    typedef SampleIdentity type;

    eProsima_user_DllExport SampleIdentityPubSubType();

    eProsima_user_DllExport ~SampleIdentityPubSubType() override;

    eProsima_user_DllExport bool serialize(
            const void* const data,
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool deserialize(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            void* data) override;

    eProsima_user_DllExport uint32_t calculate_serialized_size(
            const void* const data,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool compute_key(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport bool compute_key(
            const void* const data,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport void* create_data() override;

    eProsima_user_DllExport void delete_data(
            void* data) override;

    //Register TypeObject representation in Fast DDS TypeObjectRegistry
    eProsima_user_DllExport void register_type_object_representation() override;

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED
    eProsima_user_DllExport inline bool is_bounded() const override
    {
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

    eProsima_user_DllExport inline bool is_plain(
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) const override
    {
        if (data_representation == eprosima::fastdds::dds::DataRepresentationId_t::XCDR2_DATA_REPRESENTATION)
        {
            return is_plain_xcdrv2_impl();
        }
        else
        {
            return is_plain_xcdrv1_impl();
        }
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

#ifdef TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE
    eProsima_user_DllExport inline bool construct_sample(
            void* memory) const override
    {
        new (memory) SampleIdentity();
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE

private:

    eprosima::fastdds::MD5 md5_;
    unsigned char* key_buffer_;


    static constexpr bool is_plain_xcdrv1_impl()
    {
        return 24ULL ==
               (detail::SampleIdentity_offset_of<SampleIdentity, detail::SampleIdentity_f>() +
               sizeof(eprosima::fastdds::dds::SequenceNumber_t));
    }

    static constexpr bool is_plain_xcdrv2_impl()
    {
        return 24ULL ==
               (detail::SampleIdentity_offset_of<SampleIdentity, detail::SampleIdentity_f>() +
               sizeof(eprosima::fastdds::dds::SequenceNumber_t));
    }

};
namespace rpc
{
    typedef uint8_t UnknownOperation;
    typedef uint8_t UnknownException;
    typedef uint8_t UnusedMember;
    typedef eprosima::fastcdr::fixed_string<255> InstanceName;

    /*!
     * @brief This class represents the TopicDataType of the type RequestHeader defined by the user in the IDL file.
     * @ingroup rpc_types
     */
    class RequestHeaderPubSubType : public eprosima::fastdds::dds::TopicDataType
    {
    public:

        typedef RequestHeader type;

        eProsima_user_DllExport RequestHeaderPubSubType();

        eProsima_user_DllExport ~RequestHeaderPubSubType() override;

        eProsima_user_DllExport bool serialize(
                const void* const data,
                eprosima::fastdds::rtps::SerializedPayload_t& payload,
                eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

        eProsima_user_DllExport bool deserialize(
                eprosima::fastdds::rtps::SerializedPayload_t& payload,
                void* data) override;

        eProsima_user_DllExport uint32_t calculate_serialized_size(
                const void* const data,
                eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

        eProsima_user_DllExport bool compute_key(
                eprosima::fastdds::rtps::SerializedPayload_t& payload,
                eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
                bool force_md5 = false) override;

        eProsima_user_DllExport bool compute_key(
                const void* const data,
                eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
                bool force_md5 = false) override;

        eProsima_user_DllExport void* create_data() override;

        eProsima_user_DllExport void delete_data(
                void* data) override;

        //Register TypeObject representation in Fast DDS TypeObjectRegistry
        eProsima_user_DllExport void register_type_object_representation() override;

    #ifdef TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED
        eProsima_user_DllExport inline bool is_bounded() const override
        {
            return true;
        }

    #endif  // TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED

    #ifdef TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

        eProsima_user_DllExport inline bool is_plain(
                eprosima::fastdds::dds::DataRepresentationId_t data_representation) const override
        {
            static_cast<void>(data_representation);
            return false;
        }

    #endif  // TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

    #ifdef TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE
        eProsima_user_DllExport inline bool construct_sample(
                void* memory) const override
        {
            static_cast<void>(memory);
            return false;
        }

    #endif  // TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE

    private:

        eprosima::fastdds::MD5 md5_;
        unsigned char* key_buffer_;

    };

    #ifndef SWIG
    namespace detail {

    template<typename Tag, typename Tag::type M>
    struct ReplyHeader_rob
    {
        friend constexpr typename Tag::type get(
                Tag)
        {
            return M;
        }

    };

    struct ReplyHeader_f
    {
        typedef eprosima::fastdds::dds::rpc::RemoteExceptionCode_t ReplyHeader::* type;
        friend constexpr type get(
                ReplyHeader_f);
    };

    template struct ReplyHeader_rob<ReplyHeader_f, &ReplyHeader::m_remoteEx>;

    template <typename T, typename Tag>
    inline size_t constexpr ReplyHeader_offset_of()
    {
        return ((::size_t) &reinterpret_cast<char const volatile&>((((T*)0)->*get(Tag()))));
    }

    } // namespace detail
    #endif // ifndef SWIG


    /*!
     * @brief This class represents the TopicDataType of the type ReplyHeader defined by the user in the IDL file.
     * @ingroup rpc_types
     */
    class ReplyHeaderPubSubType : public eprosima::fastdds::dds::TopicDataType
    {
    public:

        typedef ReplyHeader type;

        eProsima_user_DllExport ReplyHeaderPubSubType();

        eProsima_user_DllExport ~ReplyHeaderPubSubType() override;

        eProsima_user_DllExport bool serialize(
                const void* const data,
                eprosima::fastdds::rtps::SerializedPayload_t& payload,
                eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

        eProsima_user_DllExport bool deserialize(
                eprosima::fastdds::rtps::SerializedPayload_t& payload,
                void* data) override;

        eProsima_user_DllExport uint32_t calculate_serialized_size(
                const void* const data,
                eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

        eProsima_user_DllExport bool compute_key(
                eprosima::fastdds::rtps::SerializedPayload_t& payload,
                eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
                bool force_md5 = false) override;

        eProsima_user_DllExport bool compute_key(
                const void* const data,
                eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
                bool force_md5 = false) override;

        eProsima_user_DllExport void* create_data() override;

        eProsima_user_DllExport void delete_data(
                void* data) override;

        //Register TypeObject representation in Fast DDS TypeObjectRegistry
        eProsima_user_DllExport void register_type_object_representation() override;

    #ifdef TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED
        eProsima_user_DllExport inline bool is_bounded() const override
        {
            return true;
        }

    #endif  // TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED

    #ifdef TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

        eProsima_user_DllExport inline bool is_plain(
                eprosima::fastdds::dds::DataRepresentationId_t data_representation) const override
        {
            if (data_representation == eprosima::fastdds::dds::DataRepresentationId_t::XCDR2_DATA_REPRESENTATION)
            {
                return is_plain_xcdrv2_impl();
            }
            else
            {
                return is_plain_xcdrv1_impl();
            }
        }

    #endif  // TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

    #ifdef TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE
        eProsima_user_DllExport inline bool construct_sample(
                void* memory) const override
        {
            new (memory) ReplyHeader();
            return true;
        }

    #endif  // TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE

    private:

        eprosima::fastdds::MD5 md5_;
        unsigned char* key_buffer_;


        static constexpr bool is_plain_xcdrv1_impl()
        {
            return 28ULL ==
                   (detail::ReplyHeader_offset_of<ReplyHeader, detail::ReplyHeader_f>() +
                   sizeof(eprosima::fastdds::dds::rpc::RemoteExceptionCode_t));
        }

        static constexpr bool is_plain_xcdrv2_impl()
        {
            return 28ULL ==
                   (detail::ReplyHeader_offset_of<ReplyHeader, detail::ReplyHeader_f>() +
                   sizeof(eprosima::fastdds::dds::rpc::RemoteExceptionCode_t));
        }

    };
} // namespace rpc

} // namespace dds

} // namespace fastdds

} // namespace eprosima


#endif // FAST_DDS_GENERATED__EPROSIMA_FASTDDS_DDS_RPC_RPC_TYPES_PUBSUBTYPES_HPP

