#!/usr/bin/python3
"""
Library  handling for Fortran  dh_fortran_lib

Copyright (C) 2025 Alastair McKinstry <mckinstry@debian.org>
Released under the GPL-3 Gnu Public License.
"""

import os
import sys
import click
import logging
from subprocess import check_output


sys.path.append("/usr/share/dh-python/")
from dhpython import debhelper

log = logging.getLogger("dhfortran")

srcdir = "debian/tmp"
if "SOURCEDIR" in os.environ:
    srcdir = os.environ["SOURCEDIR"]

flavor = None
if "FLAVOR" in os.environ:
    flavor = os.environ["FLAVOR"]


def get_soname(libfile: str) -> str:
    """Helper: get soname from library"""
    res = check_output(["objdump", "-p", libfile])
    breakpoint()


def get_preferred(flavor):
    # TODO. What if none?
    if "PREFERRED" in os.environ:
        return os.environ["PREFERRED"]
    else:
        match get_abi_vendor(flavor):
            case "gfortran":
                return "gfortran14"
            case "flang":
                return "flang19"
            case "lfortran":
                return "lfortran"
            case _:
                return "gfortran"


def process_static_lib(tmpdir, orig_libname, filename):
    """what to do for a static library"""
    flibdir = XXX
    dest = f"{tmpdir}/{flibdir}/{filename}"
    if os.exists(dest):
        log.debug(f"DEBUG: {dest} already exists")
        # Flavor from where ? env? if set
        pref = get_preferred(flavor)
        if os.environ["FLAVOR"] != preferred:
            return
        log.debug(f"Installing {flavor} as new {dest}")
    # doit("cp","--reflink=auto","-a",orig_libname,dest)
    return (doit, ["cp", "--reflink=auto", "-a", orig_libname, dest])


def compute_abs_dest(srcdir, libname, target_dest) -> str:
    """Compute the target_dest as an absolute path"""
    log.debug(f"compute_dest {srcdir} {libname} {target_dest}")

    flibdir = TODO
    if target_dest is not None:
        if target_dest.startswith("/"):
            return target_dest
        else:
            return f"{flibdir}/{target_dest}"
    else:
        return flibdir


@click.command()
@click.option("--flavor")
@click.option("--preferred")
@click.option("--sourcedir")
@click.option("--no-orig-library")
@click.option("--no-create-in-sourcedir")
def dh_fortran_lib(
    libs=None,
    flavor=None,
    preferred=None,
    sourcedir=None,
    no_orig_library=None,
    no_create_in_sourcedir=None,
):
    """Install libs in appropriate directory"""

    # We need either flavor to be set, or FC
    if flavor is None:
        if "FC" not in os.environ:
            raise Exception(
                "Either --flavor is set, or FC is defined in the environment"
            )
