# Copyright © The Debusine Developers
# See the AUTHORS file at the top-level directory of this distribution
#
# This file is part of Debusine. It is subject to the license terms
# in the LICENSE file found in the top-level directory of this
# distribution. No part of Debusine, including this file, may be copied,
# modified, propagated, or distributed except according to the terms
# contained in the LICENSE file.

"""Unit tests for the NoopWorkflow class."""

from debusine.server.workflows import NoopWorkflow
from debusine.server.workflows.models import BaseWorkflowData
from debusine.server.workflows.tests.helpers import WorkflowTestBase


class NoopWorkflowTests(WorkflowTestBase[NoopWorkflow]):
    """Unit tests for NoopWorkflow class."""

    def test_create(self) -> None:
        """Test instantiating a NoopWorkflow."""
        wr = self.playground.create_workflow(task_name="noop")
        wf = self.get_workflow(wr)
        self.assertIsInstance(wf.data, BaseWorkflowData)
