# Interface for submodule: Mesh
from typing import Union, Any
# additional imports
from .support.template_class import itkTemplate as _itkTemplate


# Interface for class: Mesh
from ._proxies import MeshProxy as _MeshProxy
class _MeshTemplateGetter():
    def __getitem__(self, parameters) -> _MeshTemplate:
        """Specify class type with:
            	[INSERT_TYPE_NAMES_HERE]
            :return: MeshTemplate
            """
        ...


class _MeshTemplate(_itkTemplate, metaclass=_MeshTemplateGetter):
    """Interface for instantiating itk::Mesh< INSERT_TYPE_NAMES_HERE >
        Create a new Mesh Object (of default type):
            'itk.Mesh.New(**kwargs)
        Supports type specification through dictionary access:
            'itk.Mesh[INSERT_TYPE_NAMES_HERE].New(**kwargs)"""

    @staticmethod
    def New(**kwargs) -> _MeshProxy:
        """Instantiate itk::Mesh< INSERT_TYPE_NAMES_HERE >"""
        ...

Mesh = _MeshTemplate

