/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges.dlsfls;

import com.google.common.collect.ImmutableMap;
import java.util.function.Predicate;
import org.opensearch.security.privileges.dlsfls.AbstractRuleBasedPrivileges;

public class IndexToRuleMap<Rule extends AbstractRuleBasedPrivileges.Rule> {
    private static final IndexToRuleMap<?> UNRESTRICTED = new IndexToRuleMap(ImmutableMap.of());
    private final ImmutableMap<String, Rule> indexMap;

    public IndexToRuleMap(ImmutableMap<String, Rule> indexMap) {
        this.indexMap = indexMap;
    }

    public boolean isUnrestricted() {
        return this.indexMap.isEmpty() || this.indexMap.values().stream().allMatch(AbstractRuleBasedPrivileges.Rule::isUnrestricted);
    }

    public ImmutableMap<String, Rule> getIndexMap() {
        return this.indexMap;
    }

    public boolean containsAny(Predicate<Rule> predicate) {
        if (this.indexMap.isEmpty()) {
            return false;
        }
        for (AbstractRuleBasedPrivileges.Rule rule : this.indexMap.values()) {
            if (!predicate.test(rule)) continue;
            return true;
        }
        return false;
    }

    public static <Rule extends AbstractRuleBasedPrivileges.Rule> IndexToRuleMap<Rule> unrestricted() {
        return UNRESTRICTED;
    }
}

