/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.fdt;

public class Group
implements Comparable<Group> {
    private int count = 0;
    private double est = 0.0;
    private double ub = 0.0;
    private double lb = 0.0;
    private double fraction = 0.0;
    private double rse = 0.0;
    private String priKey = null;
    private static final String fmt = "%,12d%,15.2f%,15.2f%,15.2f%12.6f%12.6f %s";
    private static final String hfmt = "%12s%15s%15s%15s%12s%12s %s";

    public Group copy() {
        return new Group();
    }

    public Group init(String priKey, int count, double estimate, double ub, double lb, double fraction, double rse) {
        this.count = count;
        this.est = estimate;
        this.ub = ub;
        this.lb = lb;
        this.fraction = fraction;
        this.rse = rse;
        this.priKey = priKey;
        return this;
    }

    public String getPrimaryKey() {
        return this.priKey;
    }

    public int getCount() {
        return this.count;
    }

    public double getEstimate() {
        return this.est;
    }

    public double getUpperBound() {
        return this.ub;
    }

    public double getLowerBound() {
        return this.lb;
    }

    public double getFraction() {
        return this.fraction;
    }

    public double getRse() {
        return this.rse;
    }

    public String getHeader() {
        return String.format(hfmt, "Count", "Est", "UB", "LB", "Fraction", "RSE", "PriKey");
    }

    public String toString() {
        return String.format(fmt, this.count, this.est, this.ub, this.lb, this.fraction, this.rse, this.priKey);
    }

    @Override
    public int compareTo(Group that) {
        return that.count - this.count;
    }
}

