/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.gui;

import java.awt.ComponentOrientation;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import org.languagetool.Language;
import org.languagetool.gui.LanguageAdapter;
import org.languagetool.gui.LanguageComboBoxModel;
import org.languagetool.gui.LanguageComboBoxRenderer;

class LanguageComboBox
extends JComboBox<LanguageAdapter> {
    static LanguageComboBox create(ResourceBundle messages, String extLangSuffix, boolean withFlag, boolean includeHidden) {
        return LanguageComboBox.create(messages, extLangSuffix, withFlag, includeHidden, null);
    }

    static LanguageComboBox create(ResourceBundle messages, String extLangSuffix, boolean withFlag, boolean includeHidden, LanguageAdapter first) {
        LanguageComboBox combo = new LanguageComboBox();
        combo.setModel(LanguageComboBoxModel.create(messages, extLangSuffix, includeHidden, null, first));
        if (withFlag) {
            combo.setRenderer(new LanguageComboBoxRenderer(messages, extLangSuffix));
        }
        return combo;
    }

    private LanguageComboBox() {
        this.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
    }

    void selectLanguage(Language language) {
        ComboBoxModel model = this.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            LanguageAdapter adapter = (LanguageAdapter)model.getElementAt(i);
            if (adapter.getLanguage() == null || !adapter.getLanguage().toString().equals(language.toString())) continue;
            this.setSelectedItem(adapter);
            break;
        }
    }

    Language getSelectedLanguage() {
        LanguageAdapter adapter = (LanguageAdapter)this.getSelectedItem();
        return adapter.getLanguage();
    }
}

