/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save.xml;

import java.io.IOException;
import java.io.OutputStreamWriter;
import tim.prune.config.ColourUtils;
import tim.prune.data.Coordinate;
import tim.prune.data.DataPoint;
import tim.prune.data.Timestamp;
import tim.prune.data.Track;
import tim.prune.data.TrackInfo;
import tim.prune.data.UnitSetLibrary;
import tim.prune.save.xml.KmlExportOptions;
import tim.prune.save.xml.KmlWriter;

public class KmlWriter22
extends KmlWriter {
    public KmlWriter22(TrackInfo trackInfo, KmlExportOptions kmlExportOptions, KmlWriter.ProgressUpdater progressUpdater) {
        super(trackInfo, kmlExportOptions, progressUpdater);
    }

    @Override
    protected void writeXmlHeader(OutputStreamWriter outputStreamWriter) throws IOException {
        outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<kml xmlns=\"http://earth.google.com/kml/2.2\" xmlns:gx=\"http://www.google.com/kml/ext/2.2\">\n");
    }

    @Override
    protected int writeTrack(OutputStreamWriter outputStreamWriter, boolean bl, int n, int n2) throws IOException {
        int n3 = 0;
        String string = "\t<Placemark>\n\t\t<name>track</name>\n\t\t<Style>\n\t\t\t<LineStyle>\n\t\t\t\t<color>cc" + KmlWriter22.reverseRGB(ColourUtils.makeHexCode(this._exportOptions.getTrackColour())) + "</color>\n" + "\t\t\t\t<width>4</width>\n\t\t\t</LineStyle>\n" + "\t\t</Style>\n\t\t<gx:Track>\n";
        string = bl ? String.valueOf(string) + "\t\t\t<extrude>1</extrude>\n\t\t\t<altitudeMode>absolute</altitudeMode>\n" : String.valueOf(string) + "\t\t\t<altitudeMode>clampToGround</altitudeMode>\n";
        String string2 = "\n\t\t</gx:Track>\n\t</Placemark>\n";
        boolean bl2 = this._exportOptions.getExportJustSelection();
        outputStreamWriter.write(string);
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        Track track = this._trackInfo.getTrack();
        boolean bl3 = true;
        int n4 = track.getNumPoints();
        int n5 = 0;
        while (n5 < n4) {
            boolean bl4;
            DataPoint dataPoint = track.getPoint(n5);
            boolean bl5 = bl4 = !bl2 || n5 >= n && n5 <= n2;
            if (!dataPoint.isWaypoint() && bl4) {
                if (dataPoint.getSegmentStart() && !bl3) {
                    outputStreamWriter.write(stringBuilder.toString());
                    outputStreamWriter.write(10);
                    outputStreamWriter.write(stringBuilder2.toString());
                    outputStreamWriter.write(10);
                    outputStreamWriter.write(string2);
                    stringBuilder.setLength(0);
                    stringBuilder2.setLength(0);
                    outputStreamWriter.write(string);
                }
                if (dataPoint.getPhoto() == null) {
                    stringBuilder.append("<when>");
                    if (dataPoint.hasTimestamp()) {
                        stringBuilder.append(dataPoint.getTimestamp().getText(Timestamp.Format.ISO8601, null));
                    }
                    stringBuilder.append("</when>\n");
                    stringBuilder2.append("<gx:coord>");
                    stringBuilder2.append(dataPoint.getLongitude().output(Coordinate.Format.DECIMAL_FORCE_POINT)).append(' ');
                    stringBuilder2.append(dataPoint.getLatitude().output(Coordinate.Format.DECIMAL_FORCE_POINT)).append(' ');
                    if (dataPoint.hasAltitude()) {
                        stringBuilder2.append(dataPoint.getAltitude().getStringValue(UnitSetLibrary.UNITS_METRES));
                    } else {
                        stringBuilder2.append('0');
                    }
                    stringBuilder2.append("</gx:coord>\n");
                    ++n3;
                    bl3 = false;
                }
            }
            ++n5;
        }
        outputStreamWriter.write(stringBuilder.toString());
        outputStreamWriter.write(10);
        outputStreamWriter.write(stringBuilder2.toString());
        outputStreamWriter.write(10);
        outputStreamWriter.write(string2);
        return n3;
    }
}

