/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.hana.ui.views;

import java.util.Locale;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.hana.ui.internal.HANAEdition;
import org.jkiss.dbeaver.ext.hana.ui.internal.HANAMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageWithAuth;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.utils.CommonUtils;

public class HANAConnectionPage
extends ConnectionPageWithAuth
implements IDialogPageProvider {
    static final String PROP_DATABASE_NAME = "databaseName";
    static final String PROV_PROP_INSTANCE_NUMBER = "instanceNumber";
    static final String PROV_PROP_EDITION = "edition";
    private Combo editionCombo;
    private Text hostText;
    private Text portText;
    private Label instanceLabel;
    private Text instanceText;
    private Label databaseLabel;
    private Text databaseText;
    private boolean created;
    private HANAEdition edition;
    private String portValue;
    private String instanceValue;
    private String databaseValue;
    private final Image logoImage = this.createImage("icons/sap_hana_logo.png");

    public void dispose() {
        super.dispose();
        UIUtils.dispose((Resource)this.logoImage);
    }

    public Image getImage() {
        return this.logoImage;
    }

    public void createControl(Composite composite) {
        Composite settingsGroup = new Composite(composite, 0);
        settingsGroup.setLayout((Layout)new GridLayout(1, false));
        settingsGroup.setLayoutData((Object)new GridData(1808));
        Group addrGroup = UIUtils.createControlGroup((Composite)settingsGroup, (String)HANAMessages.label_connection, (int)2, (int)0, (int)0);
        addrGroup.setLayoutData((Object)new GridData(768));
        UIUtils.createControlLabel((Composite)addrGroup, (String)HANAMessages.label_edition);
        this.editionCombo = new Combo((Composite)addrGroup, 12);
        HANAEdition[] hANAEditionArray = HANAEdition.values();
        int n = hANAEditionArray.length;
        int n2 = 0;
        while (n2 < n) {
            HANAEdition edition = hANAEditionArray[n2];
            this.editionCombo.add(edition.getTitle());
            ++n2;
        }
        this.hostText = UIUtils.createLabelText((Composite)addrGroup, (String)HANAMessages.label_host, (String)"");
        this.portText = UIUtils.createLabelText((Composite)addrGroup, (String)HANAMessages.label_port, (String)"");
        this.portText.setLayoutData((Object)new GridData(32));
        ((GridData)this.portText.getLayoutData()).widthHint = UIUtils.getFontHeight((Control)this.portText) * 5;
        this.portText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.instanceLabel = UIUtils.createControlLabel((Composite)addrGroup, (String)HANAMessages.label_instance);
        this.instanceText = new Text((Composite)addrGroup, 2048);
        this.instanceText.setLayoutData((Object)new GridData(2));
        ((GridData)this.instanceText.getLayoutData()).widthHint = UIUtils.getFontHeight((Control)this.instanceText) * 5;
        this.instanceText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.instanceText.setToolTipText(HANAMessages.tooltip_instance);
        this.databaseLabel = UIUtils.createControlLabel((Composite)addrGroup, (String)HANAMessages.label_database);
        this.databaseText = new Text((Composite)addrGroup, 2048);
        this.databaseText.setLayoutData((Object)new GridData(768));
        this.editionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HANAConnectionPage.this.editionUpdated();
                HANAConnectionPage.this.site.updateButtons();
            }
        });
        this.hostText.addModifyListener(e -> {
            this.hostUpdated();
            this.site.updateButtons();
        });
        this.portText.addModifyListener(e -> this.site.updateButtons());
        this.instanceText.addModifyListener(e -> {
            this.instanceUpdated();
            this.site.updateButtons();
        });
        this.databaseText.addModifyListener(e -> this.site.updateButtons());
        this.createAuthPanel(settingsGroup, 1);
        this.createDriverPanel(settingsGroup);
        this.setControl((Control)settingsGroup);
        this.created = true;
    }

    public boolean isComplete() {
        if (CommonUtils.isEmpty((String)this.hostText.getText().trim())) {
            return false;
        }
        if (CommonUtils.isEmpty((String)this.portText.getText().trim())) {
            return false;
        }
        if (this.edition != HANAEdition.GENERIC) {
            int instance;
            if (this.instanceText.getEditable() && !CommonUtils.isEmpty((String)this.instanceText.getText()) && ((instance = CommonUtils.toInt((Object)this.instanceText.getText().trim(), (int)-1)) < 0 || instance > 99)) {
                return false;
            }
            if (this.databaseText.getEditable() && CommonUtils.isEmpty((String)this.databaseText.getText().trim())) {
                return false;
            }
        }
        return super.isComplete();
    }

    private String getProperty(DBPConnectionConfiguration connectionInfo, String name) {
        for (Map.Entry entry : connectionInfo.getProperties().entrySet()) {
            if (!((String)entry.getKey()).equalsIgnoreCase(name)) continue;
            return (String)entry.getValue();
        }
        return null;
    }

    private void setProperty(DBPConnectionConfiguration connectionInfo, String name, String value) {
        for (Map.Entry entry : connectionInfo.getProperties().entrySet()) {
            if (!((String)entry.getKey()).equalsIgnoreCase(name) || ((String)entry.getKey()).equals(name)) continue;
            connectionInfo.removeProperty(name);
        }
        connectionInfo.setProperty(name, value);
    }

    private void removeProperty(DBPConnectionConfiguration connectionInfo, String name) {
        for (Map.Entry entry : connectionInfo.getProperties().entrySet()) {
            if (!((String)entry.getKey()).equalsIgnoreCase(name)) continue;
            connectionInfo.removeProperty(name);
        }
    }

    public void loadSettings() {
        super.loadSettings();
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        this.edition = HANAEdition.fromName(connectionInfo.getProviderProperty(PROV_PROP_EDITION));
        this.portValue = CommonUtils.toString((Object)connectionInfo.getHostPort());
        this.instanceValue = CommonUtils.notEmpty((String)connectionInfo.getProviderProperty(PROV_PROP_INSTANCE_NUMBER));
        this.databaseValue = CommonUtils.notEmpty((String)this.getProperty(connectionInfo, PROP_DATABASE_NAME));
        if (this.created) {
            this.editionCombo.select(this.edition.ordinal());
            this.hostText.setText(CommonUtils.notEmpty((String)connectionInfo.getHostName()));
            this.portText.setText(this.portValue);
            this.instanceText.setText(this.instanceValue);
            this.databaseText.setText(this.databaseValue);
            this.editionUpdated();
        }
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        connectionInfo.setProviderProperty(PROV_PROP_EDITION, this.edition.name());
        if (this.created) {
            connectionInfo.setHostName(this.hostText.getText().trim());
            connectionInfo.setHostPort(this.portText.getText().trim());
            if (this.edition != HANAEdition.GENERIC) {
                this.instanceValue = this.instanceText.getText().trim();
                if (this.instanceValue.isEmpty()) {
                    connectionInfo.removeProviderProperty(PROV_PROP_INSTANCE_NUMBER);
                } else {
                    connectionInfo.setProviderProperty(PROV_PROP_INSTANCE_NUMBER, this.instanceValue);
                }
                this.databaseValue = this.databaseText.getText().trim();
                if (this.databaseValue.isEmpty()) {
                    this.removeProperty(connectionInfo, PROP_DATABASE_NAME);
                } else {
                    this.setProperty(connectionInfo, PROP_DATABASE_NAME, this.databaseValue);
                }
            }
        }
        super.saveSettings(dataSource);
    }

    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{new DriverPropertiesDialogPage((ConnectionPageAbstract)this)};
    }

    private void editionUpdated() {
        if (this.portText.getEditable()) {
            this.portValue = this.portText.getText().trim();
        }
        if (this.instanceText.getEditable()) {
            this.instanceValue = this.instanceText.getText().trim();
        }
        if (this.databaseText.getEditable()) {
            this.databaseValue = this.databaseText.getText().trim();
        }
        this.edition = HANAEdition.fromTitle(this.editionCombo.getText());
        this.portText.setEditable(this.edition == HANAEdition.GENERIC || this.edition == HANAEdition.EXPRESS);
        UIUtils.fixReadonlyTextBackground((Text)this.portText);
        switch (this.edition) {
            case GENERIC: {
                this.portText.setText(this.portValue);
                break;
            }
            case PLATFORM_SINGLE_DB: 
            case PLATFORM_SYSTEM_DB: 
            case PLATFORM_TENANT_DB: {
                this.instanceUpdated();
                break;
            }
            case EXPRESS: {
                if (this.portValue.isEmpty()) {
                    this.portText.setText("39015");
                    break;
                }
                this.portText.setText(this.portValue);
                break;
            }
            case CLOUD: {
                this.portText.setText("443");
                break;
            }
        }
        if (this.edition == HANAEdition.PLATFORM_SINGLE_DB || this.edition == HANAEdition.PLATFORM_SYSTEM_DB || this.edition == HANAEdition.PLATFORM_TENANT_DB) {
            if (this.instanceValue.isEmpty()) {
                int port = CommonUtils.toInt((Object)this.portValue);
                if (port >= 30000 && port <= 39999) {
                    this.instanceText.setText(String.valueOf((port - 30000) / 100));
                }
            } else {
                this.instanceText.setText(this.instanceValue);
            }
            this.instanceText.setEditable(true);
        } else if (this.edition == HANAEdition.EXPRESS) {
            this.instanceText.setText("90");
            this.instanceText.setEditable(false);
        } else {
            this.instanceText.setText("");
            this.instanceText.setEditable(false);
        }
        UIUtils.fixReadonlyTextBackground((Text)this.instanceText);
        if (this.edition == HANAEdition.PLATFORM_TENANT_DB) {
            this.databaseText.setText(this.databaseValue);
            this.databaseText.setEditable(true);
        } else {
            this.databaseText.setText("");
            this.databaseText.setEditable(false);
        }
        UIUtils.fixReadonlyTextBackground((Text)this.databaseText);
        boolean visible = this.edition != HANAEdition.GENERIC && this.edition != HANAEdition.CLOUD;
        this.toggleControlVisibility((Control)this.instanceLabel, visible);
        this.toggleControlVisibility((Control)this.instanceText, visible);
        this.toggleControlVisibility((Control)this.databaseLabel, visible);
        this.toggleControlVisibility((Control)this.databaseText, visible);
        ((Composite)this.getControl()).layout(true, true);
    }

    private void toggleControlVisibility(Control control, boolean visible) {
        control.setVisible(visible);
        Object layoutData = control.getLayoutData();
        if (layoutData instanceof GridData) {
            ((GridData)layoutData).exclude = !visible;
        }
    }

    private void hostUpdated() {
        if (CommonUtils.isEmpty((String)this.hostText.getText())) {
            return;
        }
        String host = this.hostText.getText().trim();
        if (this.edition == HANAEdition.GENERIC && CommonUtils.isEmpty((String)this.portText.getText()) && host.endsWith(":443")) {
            this.hostText.setText(host.substring(0, host.length() - ":443".length()));
            this.editionCombo.select(this.editionCombo.indexOf(HANAEdition.CLOUD.getTitle()));
            this.editionUpdated();
        }
    }

    private void instanceUpdated() {
        if (CommonUtils.isEmpty((String)this.instanceText.getText())) {
            return;
        }
        int instance = CommonUtils.toInt((Object)this.instanceText.getText().trim(), (int)0);
        switch (this.edition) {
            case PLATFORM_SINGLE_DB: {
                this.portText.setText(String.format("3%02d15", instance));
                break;
            }
            case PLATFORM_SYSTEM_DB: 
            case PLATFORM_TENANT_DB: {
                this.portText.setText(String.format("3%02d13", instance));
                break;
            }
        }
    }
}

