/*
 * Decompiled with CFR 0.152.
 */
package org.cts;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.cts.IdentifiableComponent;
import org.cts.Identifier;
import org.cts.crs.CRSException;
import org.cts.crs.CompoundCRS;
import org.cts.crs.CoordinateReferenceSystem;
import org.cts.crs.GeocentricCRS;
import org.cts.crs.GeodeticCRS;
import org.cts.crs.Geographic2DCRS;
import org.cts.crs.Geographic3DCRS;
import org.cts.crs.ProjectedCRS;
import org.cts.crs.VerticalCRS;
import org.cts.cs.Axis;
import org.cts.cs.CoordinateSystem;
import org.cts.datum.Ellipsoid;
import org.cts.datum.GeodeticDatum;
import org.cts.datum.PrimeMeridian;
import org.cts.datum.VerticalDatum;
import org.cts.op.AbstractCoordinateOperation;
import org.cts.op.CoordinateOperationSequence;
import org.cts.op.Identity;
import org.cts.op.LongitudeRotation;
import org.cts.op.projection.AlbersEqualArea;
import org.cts.op.projection.CassiniSoldner;
import org.cts.op.projection.CylindricalEqualArea;
import org.cts.op.projection.EquidistantCylindrical;
import org.cts.op.projection.GaussSchreiberTransverseMercator;
import org.cts.op.projection.Krovak;
import org.cts.op.projection.LambertAzimuthalEqualArea;
import org.cts.op.projection.LambertConicConformal1SP;
import org.cts.op.projection.LambertConicConformal2SP;
import org.cts.op.projection.Mercator1SP;
import org.cts.op.projection.MillerCylindrical;
import org.cts.op.projection.NewZealandMapGrid;
import org.cts.op.projection.ObliqueMercator;
import org.cts.op.projection.ObliqueStereographicAlternative;
import org.cts.op.projection.Polyconic;
import org.cts.op.projection.Projection;
import org.cts.op.projection.Stereographic;
import org.cts.op.projection.SwissObliqueMercator;
import org.cts.op.projection.TransverseMercator;
import org.cts.op.projection.UniversalTransverseMercator;
import org.cts.op.transformation.FrenchGeocentricNTF2RGF;
import org.cts.op.transformation.GeocentricTransformation;
import org.cts.op.transformation.GeocentricTranslation;
import org.cts.op.transformation.NTv2GridShiftTransformation;
import org.cts.op.transformation.SevenParameterTransformation;
import org.cts.parser.proj.ProjValueParameters;
import org.cts.units.Measure;
import org.cts.units.Quantity;
import org.cts.units.Unit;
import org.cts.util.AngleFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRSHelper {
    static final Logger LOGGER = LoggerFactory.getLogger(CRSHelper.class);
    private static CRSGridCache<String, AbstractCoordinateOperation> CRSGRIDPOOL = new CRSGridCache(5);

    public static CoordinateReferenceSystem createCoordinateReferenceSystem(Identifier identifier, Map<String, String> parameters) throws CRSException {
        GeodeticCRS crs;
        if ((parameters.get("projcs") != null || parameters.get("geogcs") != null) && parameters.get("vert_cs") != null) {
            Identifier id = CRSHelper.getIdentifier(parameters);
            GeodeticCRS horizontalCRS = (GeodeticCRS)CRSHelper.createCoordinateReferenceSystem(id, parameters);
            id = CRSHelper.getIdentifier(parameters);
            VerticalCRS verticalCRS = (VerticalCRS)CRSHelper.createCoordinateReferenceSystem(id, parameters);
            return new CompoundCRS(identifier, horizontalCRS, verticalCRS);
        }
        GeodeticDatum geodeticDatum = CRSHelper.getDatum(parameters);
        if (geodeticDatum == null) {
            VerticalDatum verticalDatum = CRSHelper.getVerticalDatum(parameters);
            if (verticalDatum == null) {
                throw new CRSException("No datum definition. Cannot create the CoordinateReferenceSystem");
            }
            CoordinateSystem cs = CRSHelper.getCoordinateSystem(parameters, 1);
            return new VerticalCRS(identifier, verticalDatum, cs);
        }
        String sproj = parameters.remove("proj");
        if (null == sproj) {
            throw new CRSException("No projection defined for this Coordinate Reference System");
        }
        if (sproj.equalsIgnoreCase(ProjValueParameters.GEOCENT)) {
            CoordinateSystem cs = CRSHelper.getCoordinateSystem(parameters, 2);
            crs = new GeocentricCRS(identifier, geodeticDatum, cs);
        } else if (sproj.equalsIgnoreCase(ProjValueParameters.LONGLAT)) {
            CoordinateSystem cs = CRSHelper.getCoordinateSystem(parameters, 3);
            crs = cs.getDimension() == 2 ? new Geographic2DCRS(identifier, geodeticDatum, cs) : new Geographic3DCRS(identifier, geodeticDatum, cs);
        } else {
            CoordinateSystem cs = CRSHelper.getCoordinateSystem(parameters, 4);
            Projection proj = CRSHelper.getProjection(sproj, geodeticDatum.getEllipsoid(), parameters);
            if (null != proj) {
                crs = new ProjectedCRS(identifier, geodeticDatum, cs, proj);
                if (identifier.getCode().equalsIgnoreCase("EPSG:3857")) {
                    crs = new ProjectedCRS(identifier, GeodeticDatum.WGS84, cs, proj);
                }
            } else {
                throw new CRSException("Unknown projection : " + sproj);
            }
        }
        CRSHelper.setNadgrids(crs, parameters);
        parameters.remove("geogunit");
        parameters.remove("geogunitval");
        parameters.remove("geogunitrefname");
        parameters.remove("wktext");
        parameters.remove("no_defs");
        parameters.remove("no_uoff");
        return crs;
    }

    private static Identifier getIdentifier(Map<String, String> param) {
        Identifier id;
        String name = param.remove("projcs");
        String refname = param.remove("projrefname");
        if (name != null) {
            param.remove("geogcs");
            param.remove("geogrefname");
        } else {
            name = param.remove("geogcs");
            refname = param.remove("geogrefname");
        }
        if (name == null) {
            name = param.remove("vert_cs");
            refname = param.remove("vertrefname");
        }
        if (refname != null) {
            String[] authorityNameWithKey = refname.split(":");
            id = new Identifier(authorityNameWithKey[0], authorityNameWithKey[1], name);
        } else {
            id = new Identifier(CoordinateReferenceSystem.class, name);
        }
        return id;
    }

    private static CoordinateSystem getCoordinateSystem(Map<String, String> param, int crsType) throws CRSException {
        Quantity quant = Quantity.LENGTH;
        boolean isVert = false;
        int dim = 0;
        switch (crsType) {
            case 1: {
                isVert = true;
                dim = 1;
                break;
            }
            case 2: {
                dim = 3;
                break;
            }
            case 3: {
                dim = param.get("axis3") != null ? 3 : 2;
                quant = Quantity.ANGLE;
                break;
            }
            case 4: {
                dim = 2;
            }
        }
        Unit[] units = new Unit[dim];
        Axis[] axes = new Axis[dim];
        Unit unit = CRSHelper.getUnit(quant, param, isVert);
        for (int i = 0; i < dim; ++i) {
            units[i] = unit;
            axes[i] = CRSHelper.getAxis(param, crsType, i);
        }
        return new CoordinateSystem(axes, units);
    }

    private static Axis getAxis(Map<String, String> param, int crsType, int index) throws CRSException {
        Axis defaultAxis = null;
        String saxis = null;
        String saxistype = null;
        block0 : switch (crsType) {
            case 1: {
                saxis = param.remove("vertaxis");
                saxistype = param.remove("vertaxistype");
                defaultAxis = Axis.HEIGHT;
                break;
            }
            case 2: {
                switch (index) {
                    case 0: {
                        saxis = param.remove("axis1");
                        saxistype = param.remove("axis1type");
                        defaultAxis = Axis.X;
                        break block0;
                    }
                    case 1: {
                        saxis = param.remove("axis2");
                        saxistype = param.remove("axis2type");
                        defaultAxis = Axis.Y;
                        break block0;
                    }
                    case 2: {
                        saxis = param.remove("axis3");
                        saxistype = param.remove("axis3type");
                        defaultAxis = Axis.Z;
                        break block0;
                    }
                }
                throw new CRSException("Wrong argument index: " + index + ". Parameter shall be between 1 and 3.");
            }
            case 3: {
                switch (index) {
                    case 0: {
                        saxis = param.remove("axis1");
                        saxistype = param.remove("axis1type");
                        defaultAxis = Axis.LONGITUDE;
                        break block0;
                    }
                    case 1: {
                        saxis = param.remove("axis2");
                        saxistype = param.remove("axis2type");
                        defaultAxis = Axis.LATITUDE;
                        break block0;
                    }
                    case 2: {
                        saxis = param.remove("axis3");
                        saxistype = param.remove("axis3type");
                        defaultAxis = Axis.HEIGHT;
                    }
                }
                throw new CRSException("Wrong argument index: " + index + ". Parameter shall be 1 or 2.");
            }
            case 4: {
                switch (index) {
                    case 0: {
                        saxis = param.remove("axis1");
                        saxistype = param.remove("axis1type");
                        defaultAxis = Axis.EASTING;
                        break block0;
                    }
                    case 1: {
                        saxis = param.remove("axis2");
                        saxistype = param.remove("axis2type");
                        defaultAxis = Axis.NORTHING;
                        break block0;
                    }
                }
                throw new CRSException("Wrong argument index: " + index + ". Parameter shall be 1 or 2.");
            }
            default: {
                throw new CRSException("Wrong argument crsType: " + crsType + ". Parameter shall be between 1 and 4.");
            }
        }
        Axis.Direction axistype = Axis.getDirection(saxistype);
        Axis axis = Axis.getAxis(axistype, saxis);
        axis = axis == null && saxis != null && axistype != null ? new Axis(saxis, axistype) : defaultAxis;
        return axis;
    }

    private static Unit getUnit(Quantity quant, Map<String, String> param, boolean isVertical) {
        String sunitAuth;
        String sunitval;
        String sunit;
        Identifier id = null;
        if (isVertical) {
            sunit = param.remove("vertunit");
            sunitval = param.remove("vertunitval");
            sunitAuth = param.remove("vertunitrefname");
        } else {
            sunit = param.remove("units");
            sunitval = param.remove("to_meter");
            sunitAuth = param.remove("unitrefname");
        }
        Unit unit = Unit.getUnit(quant, sunit);
        String string = sunit = sunit == null ? "UNKNOWN" : sunit;
        if (unit == null && sunitAuth != null) {
            String[] authNameWithKey = sunitAuth.split(":");
            id = new Identifier(authNameWithKey[0], authNameWithKey[1], sunit);
            unit = (Unit)IdentifiableComponent.getComponent(id);
        }
        if (unit == null && sunitval != null) {
            id = id == null ? new Identifier(Unit.class, sunit) : id;
            unit = new Unit(quant, Double.parseDouble(sunitval), id);
        }
        if (unit == null) {
            unit = quant == Quantity.ANGLE ? Unit.DEGREE : Unit.getBaseUnit(quant);
        }
        return unit;
    }

    private static GeocentricTransformation getToWGS84(Map<String, String> param) {
        String towgs84Parameters = param.remove("towgs84");
        if (null == towgs84Parameters) {
            return Identity.IDENTITY;
        }
        double[] bwp = new double[7];
        String[] sbwp = towgs84Parameters.split(",");
        boolean identity = true;
        boolean translation = true;
        for (int i = 0; i < sbwp.length; ++i) {
            bwp[i] = Double.parseDouble(sbwp[i]);
            if (bwp[i] != 0.0) {
                identity = false;
            }
            if (bwp[i] == 0.0 || i <= 2) continue;
            translation = false;
        }
        AbstractCoordinateOperation op = identity ? Identity.IDENTITY : (translation ? new GeocentricTranslation(bwp[0], bwp[1], bwp[2]) : SevenParameterTransformation.createBursaWolfTransformation(bwp[0], bwp[1], bwp[2], bwp[3], bwp[4], bwp[5], bwp[6]));
        return op == null ? Identity.IDENTITY : op;
    }

    private static PrimeMeridian getPrimeMeridian(Map<String, String> param) {
        Identifier id;
        String pmName = param.remove("pm");
        String pmValueWKT = param.remove("pmvalue");
        String authCode = param.remove("primemrefname");
        if (authCode != null) {
            String[] authNameWithKey = authCode.split(":");
            id = pmName != null ? new Identifier(authNameWithKey[0], authNameWithKey[1], pmName) : new Identifier(authNameWithKey[0], authNameWithKey[1], "UNKNOWN");
        } else {
            id = pmName != null ? new Identifier(PrimeMeridian.class, pmName) : new Identifier(PrimeMeridian.class);
        }
        PrimeMeridian pm = null;
        if (null != pmName && (pm = PrimeMeridian.primeMeridianFromName.get(pmName.toLowerCase())) == null) {
            try {
                double pmdd = Double.parseDouble(pmName);
                pm = PrimeMeridian.createPrimeMeridianFromDDLongitude(id, pmdd);
            }
            catch (NumberFormatException ex) {
                try {
                    double pmdd = Double.parseDouble(pmValueWKT);
                    pm = PrimeMeridian.createPrimeMeridianFromDDLongitude(id, pmdd);
                }
                catch (NumberFormatException e) {
                    LOGGER.error(pmName + " prime meridian is not parsable");
                    return null;
                }
            }
        }
        if (pm == null && authCode != null) {
            pm = (PrimeMeridian)IdentifiableComponent.getComponent(id);
        }
        if (pm == null) {
            pm = PrimeMeridian.GREENWICH;
        }
        return pm;
    }

    private static GeodeticDatum getDatum(Map<String, String> param) {
        String datumName = param.remove("datum");
        String authCode = param.remove("datumrefname");
        GeocentricTransformation toWGS84 = CRSHelper.getToWGS84(param);
        GeodeticDatum gd = null;
        if (null != datumName && (gd = GeodeticDatum.getGeodeticDatum(datumName.toLowerCase())) != null && !toWGS84.isIdentity() && !toWGS84.equals(gd.getToWGS84())) {
            gd = GeodeticDatum.createGeodeticDatum(gd.getPrimeMeridian(), gd.getEllipsoid(), toWGS84);
        }
        if (gd == null && authCode != null) {
            String[] authNameWithKey = authCode.split(":");
            Identifier id = datumName != null ? new Identifier(authNameWithKey[0], authNameWithKey[1], datumName) : new Identifier(authNameWithKey[0], authNameWithKey[1], "UNKNOWN");
            gd = (GeodeticDatum)IdentifiableComponent.getComponent(id);
        }
        if (param.get("nadgrids") != null && param.get("nadgrids").toLowerCase().contains("ntf_r93.gsb")) {
            if (PrimeMeridian.PARIS.equals(CRSHelper.getPrimeMeridian(param))) {
                gd = GeodeticDatum.NTF_PARIS;
            } else if (PrimeMeridian.GREENWICH.equals(CRSHelper.getPrimeMeridian(param))) {
                gd = GeodeticDatum.NTF;
            }
        }
        if (gd == null) {
            Ellipsoid ell = CRSHelper.getEllipsoid(param);
            PrimeMeridian pm = CRSHelper.getPrimeMeridian(param);
            if (null != pm && null != ell) {
                gd = GeodeticDatum.createGeodeticDatum(pm, ell, toWGS84);
            }
        }
        param.remove("ellps");
        param.remove("a");
        param.remove("b");
        param.remove("rf");
        param.remove("spheroidrefname");
        param.remove("pm");
        param.remove("towgs84");
        return gd;
    }

    private static VerticalDatum getVerticalDatum(Map<String, String> param) {
        String datumName = param.remove("vert_datum");
        String authCode = param.remove("vertdatumrefname");
        String vertType = param.remove("vertdatumtype");
        VerticalDatum vd = null;
        Identifier id = new Identifier(VerticalDatum.class);
        if (null != datumName) {
            vd = VerticalDatum.datumFromName.get(datumName.toLowerCase());
            id = new Identifier(VerticalDatum.class, datumName);
        }
        if (vd == null && authCode != null) {
            String[] authNameWithKey = authCode.split(":");
            id = datumName != null ? new Identifier(authNameWithKey[0], authNameWithKey[1], datumName) : new Identifier(authNameWithKey[0], authNameWithKey[1], "UNKNOWN");
            vd = (VerticalDatum)IdentifiableComponent.getComponent(id);
        }
        if (vd == null && vertType != null) {
            int type = (int)Double.parseDouble(vertType);
            vd = new VerticalDatum(id, null, "", "", VerticalDatum.getType(type), "", null);
        }
        return vd;
    }

    private static void setNadgrids(GeodeticCRS crs, Map<String, String> param) {
        String nadgrids = param.remove("nadgrids");
        if (nadgrids != null) {
            String[] grids;
            for (String grid : grids = nadgrids.split(",")) {
                if (grid.equalsIgnoreCase("null")) continue;
                LOGGER.warn("A grid has been found.");
                if (grid.equalsIgnoreCase("@null")) {
                    crs.getDatum().addGeocentricTransformation(GeodeticDatum.WGS84, Identity.IDENTITY);
                    continue;
                }
                try {
                    NTv2GridShiftTransformation ntf_r93;
                    AbstractCoordinateOperation aco;
                    if (grid.equalsIgnoreCase("ntf_r93.gsb")) {
                        aco = (AbstractCoordinateOperation)CRSGRIDPOOL.get("NTF2RGF93");
                        if (aco == null) {
                            aco = new FrenchGeocentricNTF2RGF();
                            CRSGRIDPOOL.put("NTF2RGF93", aco);
                        }
                        if (aco instanceof FrenchGeocentricNTF2RGF) {
                            FrenchGeocentricNTF2RGF ntf2rgf = (FrenchGeocentricNTF2RGF)aco;
                            crs.getDatum().addGeocentricTransformation(GeodeticDatum.RGF93, ntf2rgf);
                            crs.getDatum().addGeocentricTransformation(GeodeticDatum.WGS84, ntf2rgf);
                            LOGGER.info("Add French Geocentric Grid transformation from " + crs.getDatum() + " to RGF93 and WGS84");
                            AbstractCoordinateOperation gridNTF = (AbstractCoordinateOperation)CRSGRIDPOOL.get("NTv2");
                            if (gridNTF == null) {
                                NTv2GridShiftTransformation gridNTFNew = NTv2GridShiftTransformation.createNTv2GridShiftTransformation(grid);
                                gridNTFNew.loadGridShiftFile();
                                CRSGRIDPOOL.put("NTv2", gridNTFNew);
                                gridNTF = gridNTFNew;
                            }
                            if (!(gridNTF instanceof NTv2GridShiftTransformation)) continue;
                            NTv2GridShiftTransformation ntf_r932 = (NTv2GridShiftTransformation)gridNTF;
                            crs.getDatum().addGeographicTransformation(GeodeticDatum.WGS84, new CoordinateOperationSequence(ntf_r932.getIdentifier(), LongitudeRotation.getLongitudeRotationFrom(crs.getDatum().getPrimeMeridian()), ntf_r932));
                            crs.getDatum().addGeographicTransformation(GeodeticDatum.RGF93, new CoordinateOperationSequence(ntf_r932.getIdentifier(), LongitudeRotation.getLongitudeRotationFrom(crs.getDatum().getPrimeMeridian()), ntf_r932));
                            LOGGER.info("Add NTv2 transformation from " + crs.getDatum() + " to RGF93 and WGS84");
                            continue;
                        }
                        LOGGER.info("Cannot find the  French Geocentric Grid transformation from " + crs.getDatum() + " to RGF93 and WGS84");
                        continue;
                    }
                    aco = (AbstractCoordinateOperation)CRSGRIDPOOL.get("NTv2");
                    if (aco == null) {
                        ntf_r93 = NTv2GridShiftTransformation.createNTv2GridShiftTransformation(grid);
                        ntf_r93.loadGridShiftFile();
                        CRSGRIDPOOL.put("NTv2", ntf_r93);
                    }
                    if (!(aco instanceof NTv2GridShiftTransformation)) continue;
                    ntf_r93 = (NTv2GridShiftTransformation)aco;
                    GeodeticDatum datum = GeodeticDatum.getGeodeticDatum(ntf_r93.getToDatum());
                    crs.getDatum().addGeographicTransformation(datum, new CoordinateOperationSequence(ntf_r93.getIdentifier(), new LongitudeRotation(crs.getDatum().getPrimeMeridian().getLongitudeFromGreenwichInRadians()), ntf_r93));
                    LOGGER.info("Add NTv2 transformation from " + crs.getDatum() + " to " + datum);
                }
                catch (Exception ex) {
                    LOGGER.error("Cannot find the nadgrid " + grid + ".", (Throwable)ex);
                }
            }
        }
    }

    private static Ellipsoid getEllipsoid(Map<String, String> param) {
        String ellipsoidName = param.remove("ellps");
        String a = param.remove("a");
        String b = param.remove("b");
        String rf = param.remove("rf");
        String authorityCode = param.remove("spheroidrefname");
        Ellipsoid ellps = null;
        if (null != ellipsoidName) {
            ellps = Ellipsoid.ellipsoidFromName.get(ellipsoidName.replaceAll("[^a-zA-Z0-9_]", "").toLowerCase());
        }
        if (ellps == null && authorityCode != null) {
            String[] authNameWithKey = authorityCode.split(":");
            Identifier id = ellipsoidName != null ? new Identifier(authNameWithKey[0], authNameWithKey[1], ellipsoidName) : new Identifier(authNameWithKey[0], authNameWithKey[1], "UNKNOWN");
            ellps = (Ellipsoid)IdentifiableComponent.getComponent(id);
        }
        if (ellps == null && null != a && (null != b || null != rf)) {
            double a_ = Double.parseDouble(a);
            if (null != b) {
                double b_ = Double.parseDouble(b);
                ellps = Ellipsoid.createEllipsoidFromSemiMinorAxis(a_, b_);
            } else {
                double rf_ = Double.parseDouble(rf);
                ellps = Ellipsoid.createEllipsoidFromInverseFlattening(a_, rf_);
            }
        }
        if (ellps == null) {
            LOGGER.warn("Ellipsoid cannot be defined");
        }
        return ellps;
    }

    private static Projection getProjection(String projectionName, Ellipsoid ell, Map<String, String> param) throws CRSException {
        double gamma;
        double lat_ts;
        String slat_0 = param.remove("lat_0");
        String slat_1 = param.remove("lat_1");
        String slat_2 = param.remove("lat_2");
        String slat_ts = param.remove("lat_ts");
        String slon_0 = param.remove("lon_0");
        String slonc = param.remove("lonc");
        String salpha = param.remove("alpha");
        String sgamma = param.remove("gamma");
        String sk = param.remove("k");
        String sk_0 = param.remove("k_0");
        String sx_0 = param.remove("x_0");
        String sy_0 = param.remove("y_0");
        double lat_0 = slat_0 != null ? AngleFormat.parseAngle(slat_0) : 0.0;
        double lat_1 = slat_1 != null ? AngleFormat.parseAngle(slat_1) : 0.0;
        double lat_2 = slat_2 != null ? AngleFormat.parseAngle(slat_2) : 0.0;
        double d = lat_ts = slat_ts != null ? AngleFormat.parseAngle(slat_ts) : 0.0;
        double lon_0 = slon_0 != null ? AngleFormat.parseAngle(slon_0) : (slonc != null ? AngleFormat.parseAngle(slonc) : 0.0);
        double alpha = salpha != null ? AngleFormat.parseAngle(salpha) : 0.0;
        double d2 = gamma = sgamma != null ? AngleFormat.parseAngle(sgamma) : 0.0;
        if (sk != null && sk_0 != null && !sk.equals(sk_0)) {
            LOGGER.warn("Two different scales factor at origin are defined, the one chosen for the projection is k_0");
        }
        double k_0 = sk_0 != null ? Double.parseDouble(sk_0) : (sk != null ? Double.parseDouble(sk) : 1.0);
        double x_0 = sx_0 != null ? Double.parseDouble(sx_0) : 0.0;
        double y_0 = sy_0 != null ? Double.parseDouble(sy_0) : 0.0;
        HashMap<String, Measure> map = new HashMap<String, Measure>();
        map.put("central meridian", new Measure(lon_0, Unit.DEGREE));
        map.put("latitude of origin", new Measure(lat_0, Unit.DEGREE));
        map.put("standard parallel 1", new Measure(lat_1, Unit.DEGREE));
        map.put("standard parallel 2", new Measure(lat_2, Unit.DEGREE));
        map.put("latitude of true scale", new Measure(lat_ts, Unit.DEGREE));
        map.put("azimuth", new Measure(alpha, Unit.DEGREE));
        map.put("rectified grid angle", new Measure(gamma, Unit.DEGREE));
        map.put("scale factor", new Measure(k_0, Unit.UNIT));
        map.put("false easting", new Measure(x_0, Unit.METER));
        map.put("false northing", new Measure(y_0, Unit.METER));
        if (projectionName.equalsIgnoreCase(ProjValueParameters.LCC)) {
            if (slat_2 != null) {
                return new LambertConicConformal2SP(ell, map);
            }
            return new LambertConicConformal1SP(ell, map);
        }
        if (projectionName.equalsIgnoreCase(ProjValueParameters.TMERC)) {
            return new TransverseMercator(ell, map);
        }
        if (projectionName.equalsIgnoreCase(ProjValueParameters.UTM)) {
            int zone = param.get("zone") != null ? Integer.parseInt(param.remove("zone")) : 0;
            lon_0 = (6.0 * (double)(zone - 1) + 183.0) % 360.0;
            lon_0 = (lon_0 + 180.0) % 360.0 - 180.0;
            y_0 = param.containsKey("south") ? 1.0E7 : 0.0;
            map.put("central meridian", new Measure(lon_0, Unit.DEGREE));
            map.put("false northing", new Measure(y_0, Unit.METER));
            return new UniversalTransverseMercator(ell, map);
        }
        if (projectionName.equalsIgnoreCase(ProjValueParameters.MERC)) {
            return new Mercator1SP(ell, map);
        }
        if (projectionName.equalsIgnoreCase(ProjValueParameters.EQC)) {
            return new EquidistantCylindrical(ell, map);
        }
        if (projectionName.equalsIgnoreCase(ProjValueParameters.STERE)) {
            return new Stereographic(ell, map);
        }
        if (projectionName.equalsIgnoreCase(ProjValueParameters.STEREA)) {
            return new ObliqueStereographicAlternative(ell, map);
        }
        if (projectionName.equalsIgnoreCase(ProjValueParameters.CASS)) {
            return new CassiniSoldner(ell, map);
        }
        if (projectionName.equalsIgnoreCase(ProjValueParameters.OMERC)) {
            if (alpha == 90.0 && gamma == 90.0) {
                return new SwissObliqueMercator(ell, map);
            }
            return new ObliqueMercator(ell, map);
        }
        if (projectionName.equalsIgnoreCase(ProjValueParameters.SOMERC)) {
            return new SwissObliqueMercator(ell, map);
        }
        if (projectionName.equalsIgnoreCase(ProjValueParameters.AEA)) {
            return new AlbersEqualArea(ell, map);
        }
        if (projectionName.equalsIgnoreCase(ProjValueParameters.LAEA)) {
            return new LambertAzimuthalEqualArea(ell, map);
        }
        if (projectionName.equalsIgnoreCase(ProjValueParameters.POLY)) {
            return new Polyconic(ell, map);
        }
        if (projectionName.equalsIgnoreCase(ProjValueParameters.CEA)) {
            return new CylindricalEqualArea(ell, map);
        }
        if (projectionName.equalsIgnoreCase(ProjValueParameters.MILL)) {
            return new MillerCylindrical(ell, map);
        }
        if (projectionName.equalsIgnoreCase(ProjValueParameters.KROVAK)) {
            return new Krovak(ell, map);
        }
        if (projectionName.equalsIgnoreCase(ProjValueParameters.NZMG)) {
            return new NewZealandMapGrid(ell, map);
        }
        if (projectionName.equalsIgnoreCase(ProjValueParameters.GSTMERC)) {
            return new GaussSchreiberTransverseMercator(ell, map);
        }
        if (projectionName.equalsIgnoreCase(ProjValueParameters.LEAC)) {
            if (map.containsKey("south")) {
                map.put("lat_2", new Measure(-90.0, Unit.DEGREE));
            } else {
                map.put("lat_2", new Measure(90.0, Unit.DEGREE));
            }
            if (!map.containsKey("lat_1")) {
                map.put("lat_1", new Measure(0.0, Unit.DEGREE));
            }
            return new AlbersEqualArea(ell, map);
        }
        throw new CRSException("Cannot create the projection " + projectionName);
    }

    public static class CRSGridCache<K, V>
    extends LinkedHashMap<K, V> {
        private final int limit;

        public CRSGridCache(int limit) {
            super(16, 0.75f, true);
            this.limit = limit;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.limit;
        }
    }
}

