/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.webresources.AbstractArchiveResourceSet;
import org.apache.catalina.webresources.JarContents;
import org.apache.catalina.webresources.JarWarResource;
import org.apache.catalina.webresources.TomcatJarInputStream;
import org.apache.tomcat.util.buf.UriUtil;
import org.apache.tomcat.util.compat.JreCompat;

public class JarWarResourceSet
extends AbstractArchiveResourceSet {
    private final String archivePath;

    public JarWarResourceSet(WebResourceRoot webResourceRoot, String string, String string2, String string3, String string4) throws IllegalArgumentException {
        this.setRoot(webResourceRoot);
        this.setWebAppMount(string);
        this.setBase(string2);
        this.archivePath = string3;
        this.setInternalPath(string4);
        if (this.getRoot().getState().isAvailable()) {
            try {
                this.start();
            }
            catch (LifecycleException lifecycleException) {
                throw new IllegalStateException(lifecycleException);
            }
        }
    }

    @Override
    protected WebResource createArchiveResource(JarEntry jarEntry, String string, Manifest manifest) {
        return new JarWarResource(this, string, this.getBaseUrlString(), jarEntry, this.archivePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, JarEntry> getArchiveEntries(boolean bl) {
        Object object = this.archiveLock;
        synchronized (object) {
            Object object2;
            if (this.archiveEntries == null) {
                object2 = null;
                InputStream inputStream = null;
                this.archiveEntries = new HashMap();
                boolean bl2 = false;
                try {
                    object2 = this.openJarFile();
                    JarEntry jarEntry = ((JarFile)object2).getJarEntry(this.archivePath);
                    inputStream = ((JarFile)object2).getInputStream(jarEntry);
                    try (TomcatJarInputStream tomcatJarInputStream = new TomcatJarInputStream(inputStream);){
                        String string;
                        JarEntry jarEntry2 = tomcatJarInputStream.getNextJarEntry();
                        while (jarEntry2 != null) {
                            this.archiveEntries.put(jarEntry2.getName(), jarEntry2);
                            jarEntry2 = tomcatJarInputStream.getNextJarEntry();
                        }
                        Manifest manifest = tomcatJarInputStream.getManifest();
                        this.setManifest(manifest);
                        if (manifest != null && JreCompat.isJre9Available() && (string = manifest.getMainAttributes().getValue("Multi-Release")) != null) {
                            bl2 = Boolean.parseBoolean(string);
                        }
                        if ((jarEntry2 = tomcatJarInputStream.getMetaInfEntry()) != null) {
                            this.archiveEntries.put(jarEntry2.getName(), jarEntry2);
                        }
                        if ((jarEntry2 = tomcatJarInputStream.getManifestEntry()) != null) {
                            this.archiveEntries.put(jarEntry2.getName(), jarEntry2);
                        }
                    }
                    if (bl2) {
                        this.processArchivesEntriesForMultiRelease();
                    }
                }
                catch (IOException iOException) {
                    this.archiveEntries = null;
                    throw new IllegalStateException(iOException);
                }
                finally {
                    if (object2 != null) {
                        this.closeJarFile();
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            if ((object2 = this.getRoot()).getArchiveIndexStrategyEnum().getUsesBloom() || object2.getContext() != null && object2.getContext().getUseBloomFilterForArchives()) {
                this.jarContents = new JarContents(this.archiveEntries.values());
                this.retainBloomFilterForArchives = object2.getArchiveIndexStrategyEnum().getRetain();
            }
            return this.archiveEntries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JarFile openJarFile() throws IOException {
        Object object = this.archiveLock;
        synchronized (object) {
            if (this.archive == null) {
                this.archive = JreCompat.getInstance().jarFileNewInstance(this.getBase());
            }
            ++this.archiveUseCount;
            return this.archive;
        }
    }

    protected void processArchivesEntriesForMultiRelease() {
        int n = JreCompat.getInstance().jarFileRuntimeMajorVersion();
        HashMap<String, VersionedJarEntry> hashMap = new HashMap<String, VersionedJarEntry>();
        Iterator iterator = this.archiveEntries.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String object = (String)entry.getKey();
            if (!object.startsWith("META-INF/versions/")) continue;
            iterator.remove();
            int n2 = object.indexOf(47, 18);
            if (n2 <= 0) continue;
            String string = object.substring(n2 + 1);
            int n3 = Integer.parseInt(object.substring(18, n2));
            if (n3 > n) continue;
            VersionedJarEntry versionedJarEntry = (VersionedJarEntry)hashMap.get(string);
            if (versionedJarEntry == null) {
                hashMap.put(string, new VersionedJarEntry(n3, (JarEntry)entry.getValue()));
                continue;
            }
            if (n3 <= versionedJarEntry.getVersion()) continue;
            hashMap.put(string, new VersionedJarEntry(n3, (JarEntry)entry.getValue()));
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            this.archiveEntries.put((String)entry.getKey(), ((VersionedJarEntry)entry.getValue()).getJarEntry());
        }
    }

    @Override
    protected JarEntry getArchiveEntry(String string) {
        throw new IllegalStateException(sm.getString("jarWarResourceSet.codingError"));
    }

    @Override
    protected boolean isMultiRelease() {
        return false;
    }

    @Override
    protected void initInternal() throws LifecycleException {
        try (JarFile jarFile = new JarFile(this.getBase());){
            JarEntry jarEntry = jarFile.getJarEntry(this.archivePath);
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            try (JarInputStream jarInputStream = new JarInputStream(inputStream);){
                this.setManifest(jarInputStream.getManifest());
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException);
        }
        try {
            this.setBaseUrl(UriUtil.buildJarSafeUrl((File)new File(this.getBase())));
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(malformedURLException);
        }
    }

    private static final class VersionedJarEntry {
        private final int version;
        private final JarEntry jarEntry;

        VersionedJarEntry(int n, JarEntry jarEntry) {
            this.version = n;
            this.jarEntry = jarEntry;
        }

        public int getVersion() {
            return this.version;
        }

        public JarEntry getJarEntry() {
            return this.jarEntry;
        }
    }
}

