/*
 * Decompiled with CFR 0.152.
 */
package com.password4j;

import com.password4j.BadParametersException;
import com.password4j.Hash;
import com.password4j.HashBuilder;
import com.password4j.HashChecker;
import com.password4j.Utils;

public class Password {
    private Password() {
    }

    public static HashBuilder hash(CharSequence plainTextPassword) {
        if (plainTextPassword == null) {
            throw new BadParametersException("Password cannot be null");
        }
        return new HashBuilder(plainTextPassword);
    }

    public static HashBuilder hash(byte[] plainTextPassword) {
        if (plainTextPassword == null || plainTextPassword.length == 0) {
            throw new BadParametersException("Password cannot be null");
        }
        return new HashBuilder(plainTextPassword);
    }

    public static HashChecker check(CharSequence plainTextPassword, String hash) {
        if (hash == null || plainTextPassword == null) {
            throw new BadParametersException("Hash or plain cannot be null");
        }
        return new HashChecker(plainTextPassword, hash);
    }

    public static HashChecker check(byte[] plainTextPassword, byte[] hash) {
        if (hash == null || plainTextPassword == null || hash.length == 0 || plainTextPassword.length == 0) {
            throw new BadParametersException("Hash or plain cannot be null");
        }
        return new HashChecker(plainTextPassword, hash);
    }

    public static boolean check(CharSequence plainTextPassword, Hash hashObject) {
        return Password.check(Utils.fromCharSequenceToBytes(plainTextPassword), hashObject);
    }

    public static boolean check(byte[] plainTextPassword, Hash hashObject) {
        if (hashObject == null || hashObject.getHashingFunction() == null) {
            throw new BadParametersException("Invalid Hash object. " + (hashObject != null ? hashObject.toString() : null));
        }
        if (plainTextPassword == null) {
            return false;
        }
        return hashObject.getHashingFunction().check(plainTextPassword, hashObject.getResultAsBytes(), hashObject.getSaltBytes(), hashObject.getPepper());
    }

    static {
        Utils.printBanner(System.out);
    }
}

