/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import net.shibboleth.shared.xml.DOMTypeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.common.AbstractSAMLObjectUnmarshaller;
import org.opensaml.saml.saml2.core.Extensions;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.xmlsec.signature.Signature;
import org.w3c.dom.Attr;

public abstract class RequestAbstractTypeUnmarshaller
extends AbstractSAMLObjectUnmarshaller {
    @Override
    protected void processChildElement(@Nonnull XMLObject parentObject, @Nonnull XMLObject childObject) throws UnmarshallingException {
        RequestAbstractType req = (RequestAbstractType)parentObject;
        if (childObject instanceof Issuer) {
            req.setIssuer((Issuer)childObject);
        } else if (childObject instanceof Signature) {
            req.setSignature((Signature)childObject);
        } else if (childObject instanceof Extensions) {
            req.setExtensions((Extensions)childObject);
        } else {
            super.processChildElement(parentObject, childObject);
        }
    }

    @Override
    protected void processAttribute(@Nonnull XMLObject xmlObject, @Nonnull Attr attribute) throws UnmarshallingException {
        RequestAbstractType req = (RequestAbstractType)xmlObject;
        if (attribute.getNamespaceURI() == null) {
            if (attribute.getLocalName().equals("Version")) {
                req.setVersion(this.parseSAMLVersion(attribute));
            } else if (attribute.getLocalName().equals("ID")) {
                req.setID(attribute.getValue());
                attribute.getOwnerElement().setIdAttributeNode(attribute, true);
            } else if (attribute.getLocalName().equals("IssueInstant") && !Strings.isNullOrEmpty((String)attribute.getValue())) {
                req.setIssueInstant(DOMTypeSupport.stringToInstant(attribute.getValue()));
            } else if (attribute.getLocalName().equals("Destination")) {
                req.setDestination(attribute.getValue());
            } else if (attribute.getLocalName().equals("Consent")) {
                req.setConsent(attribute.getValue());
            } else {
                super.processAttribute(xmlObject, attribute);
            }
        } else {
            super.processAttribute(xmlObject, attribute);
        }
    }
}

