/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.util.Locale;
import org.passay.IllegalRegexRule;

public class RepeatCharacterRegexRule
extends IllegalRegexRule {
    public static final int DEFAULT_SEQUENCE_LENGTH = 5;
    public static final int MINIMUM_SEQUENCE_LENGTH = 3;
    private static final String REPEAT_CHAR_REGEX = "([^\\x00-\\x1F])\\1{%d}";
    protected int sequenceLength;

    public RepeatCharacterRegexRule() {
        this(5);
    }

    public RepeatCharacterRegexRule(int sl) {
        this(sl, true);
    }

    public RepeatCharacterRegexRule(int sl, boolean reportAll) {
        super(String.format(Locale.ENGLISH, REPEAT_CHAR_REGEX, sl - 1), reportAll);
        if (sl < 3) {
            throw new IllegalArgumentException(String.format("sequence length must be >= %s", 3));
        }
        this.sequenceLength = sl;
    }

    public int getSequenceLength() {
        return this.sequenceLength;
    }
}

