/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.state.sampler;

import com.amazon.randomcutforest.sampler.AbstractStreamSampler;
import com.amazon.randomcutforest.sampler.CompactSampler;
import com.amazon.randomcutforest.state.IStateMapper;
import com.amazon.randomcutforest.state.sampler.CompactSamplerState;
import com.amazon.randomcutforest.util.ArrayPacking;
import java.util.Arrays;
import lombok.Generated;

public class CompactSamplerMapper
implements IStateMapper<CompactSampler, CompactSamplerState> {
    private boolean validateHeapEnabled = false;
    private boolean compressionEnabled = true;

    @Override
    public CompactSampler toModel(CompactSamplerState state, long seed) {
        long[] sequenceIndex;
        float[] weight = new float[state.getCapacity()];
        int[] pointIndex = new int[state.getCapacity()];
        int size = state.getSize();
        System.arraycopy(state.getWeight(), 0, weight, 0, size);
        System.arraycopy(ArrayPacking.unpackInts(state.getPointIndex(), state.isCompressed()), 0, pointIndex, 0, size);
        if (state.isStoreSequenceIndicesEnabled()) {
            sequenceIndex = new long[state.getCapacity()];
            System.arraycopy(state.getSequenceIndex(), 0, sequenceIndex, 0, size);
        } else {
            sequenceIndex = null;
        }
        return ((CompactSampler.Builder)((CompactSampler.Builder)((CompactSampler.Builder)((CompactSampler.Builder)((AbstractStreamSampler.Builder)((CompactSampler.Builder)((CompactSampler.Builder)((CompactSampler.Builder)((CompactSampler.Builder)((CompactSampler.Builder)((CompactSampler.Builder)((CompactSampler.Builder)new CompactSampler.Builder().capacity(state.getCapacity())).timeDecay(state.getTimeDecay())).randomSeed(state.getRandomSeed())).storeSequenceIndexesEnabled(state.isStoreSequenceIndicesEnabled())).weight(weight)).pointIndex(pointIndex)).sequenceIndex(sequenceIndex)).validateHeap(this.validateHeapEnabled)).initialAcceptFraction(state.getInitialAcceptFraction())).mostRecentTimeDecayUpdate(state.getSequenceIndexOfMostRecentTimeDecayUpdate())).maxSequenceIndex(state.getMaxSequenceIndex())).size(state.getSize())).build();
    }

    @Override
    public CompactSamplerState toState(CompactSampler model) {
        CompactSamplerState state = new CompactSamplerState();
        state.setSize(model.size());
        state.setCompressed(this.compressionEnabled);
        state.setCapacity(model.getCapacity());
        state.setTimeDecay(model.getTimeDecay());
        state.setSequenceIndexOfMostRecentTimeDecayUpdate(model.getMostRecentTimeDecayUpdate());
        state.setMaxSequenceIndex(model.getMaxSequenceIndex());
        state.setInitialAcceptFraction(model.getInitialAcceptFraction());
        state.setStoreSequenceIndicesEnabled(model.isStoreSequenceIndexesEnabled());
        state.setRandomSeed(model.getRandomSeed());
        state.setWeight(Arrays.copyOf(model.getWeightArray(), model.size()));
        state.setPointIndex(ArrayPacking.pack(model.getPointIndexArray(), model.size(), state.isCompressed()));
        if (model.isStoreSequenceIndexesEnabled()) {
            state.setSequenceIndex(Arrays.copyOf(model.getSequenceIndexArray(), model.size()));
        }
        return state;
    }

    @Generated
    public boolean isValidateHeapEnabled() {
        return this.validateHeapEnabled;
    }

    @Generated
    public boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    @Generated
    public void setValidateHeapEnabled(boolean validateHeapEnabled) {
        this.validateHeapEnabled = validateHeapEnabled;
    }

    @Generated
    public void setCompressionEnabled(boolean compressionEnabled) {
        this.compressionEnabled = compressionEnabled;
    }
}

