/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import net.rubygrapefruit.platform.file.FileInfo;
import net.rubygrapefruit.platform.file.WindowsFileInfo;
import net.rubygrapefruit.platform.internal.WindowsFileTime;

public class WindowsFileStat
implements WindowsFileInfo {
    private final String path;
    private FileInfo.Type type;
    private long size;
    private long lastModified;

    public WindowsFileStat(String path) {
        this.path = path;
    }

    public void details(int type, long size, long lastModifiedWinTime) {
        this.type = FileInfo.Type.values()[type];
        this.size = size;
        this.lastModified = WindowsFileTime.toJavaTime(lastModifiedWinTime);
    }

    public String toString() {
        return this.path;
    }

    @Override
    public FileInfo.Type getType() {
        return this.type;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getLastModifiedTime() {
        return this.lastModified;
    }
}

