/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.normalization;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.internal.execution.FileCollectionFingerprinter;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileNormalizer;
import org.gradle.internal.fingerprint.impl.EmptyCurrentFileCollectionFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotHierarchyVisitor;
import org.gradle.internal.snapshot.MissingFileSnapshot;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.gradle.internal.snapshot.SnapshotVisitResult;
import org.gradle.kotlin.dsl.normalization.CurrentFileCollectionFingerprintImpl;
import org.gradle.kotlin.dsl.normalization.KotlinCompileClasspathFingerprinter;
import org.gradle.kotlin.dsl.normalization.KotlinCompileClasspathFingerprinterKt;
import org.gradle.kotlin.dsl.normalization.KotlinDslCompileAvoidanceClasspathHashCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.buildtools.api.jvm.ClassSnapshot;
import org.jetbrains.kotlin.buildtools.api.jvm.ClassSnapshotGranularity;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001c\u0010\u0012\u001a\u00020\u000f2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014H\u0002J\b\u0010\u0017\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/gradle/kotlin/dsl/normalization/KotlinCompileClasspathFingerprinter;", "Lorg/gradle/internal/execution/FileCollectionFingerprinter;", "classpathSnapshotHashesCache", "Lorg/gradle/kotlin/dsl/normalization/KotlinDslCompileAvoidanceClasspathHashCache;", "<init>", "(Lorg/gradle/kotlin/dsl/normalization/KotlinDslCompileAvoidanceClasspathHashCache;)V", "getNormalizer", "Lorg/gradle/internal/fingerprint/FileNormalizer;", "fingerprint", "Lorg/gradle/internal/fingerprint/CurrentFileCollectionFingerprint;", "fileSystemSnapshot", "Lorg/gradle/internal/snapshot/FileSystemSnapshot;", "previousFingerprint", "Lorg/gradle/internal/fingerprint/FileCollectionFingerprint;", "computeHashForFile", "Lorg/gradle/internal/hash/HashCode;", "file", "Ljava/io/File;", "hash", "snapshots", "", "", "Lorg/jetbrains/kotlin/buildtools/api/jvm/ClassSnapshot;", "empty", "kotlin-dsl"})
public final class KotlinCompileClasspathFingerprinter
implements FileCollectionFingerprinter {
    @NotNull
    private final KotlinDslCompileAvoidanceClasspathHashCache classpathSnapshotHashesCache;

    public KotlinCompileClasspathFingerprinter(@NotNull KotlinDslCompileAvoidanceClasspathHashCache classpathSnapshotHashesCache) {
        Intrinsics.checkNotNullParameter((Object)classpathSnapshotHashesCache, (String)"classpathSnapshotHashesCache");
        this.classpathSnapshotHashesCache = classpathSnapshotHashesCache;
    }

    @NotNull
    public FileNormalizer getNormalizer() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public CurrentFileCollectionFingerprint fingerprint(@NotNull FileSystemSnapshot fileSystemSnapshot, @Nullable FileCollectionFingerprint previousFingerprint) {
        Intrinsics.checkNotNullParameter((Object)fileSystemSnapshot, (String)"fileSystemSnapshot");
        Map fingerprints = new LinkedHashMap();
        fileSystemSnapshot.accept(new FileSystemSnapshotHierarchyVisitor(this, fingerprints){
            final /* synthetic */ KotlinCompileClasspathFingerprinter this$0;
            final /* synthetic */ Map<String, HashCode> $fingerprints;
            {
                this.this$0 = $receiver;
                this.$fingerprints = $fingerprints;
            }

            public final SnapshotVisitResult visitEntry(FileSystemLocationSnapshot snapshot) {
                Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
                if (snapshot instanceof MissingFileSnapshot) {
                    return SnapshotVisitResult.CONTINUE;
                }
                if (snapshot instanceof RegularFileSnapshot) {
                    String string = ((RegularFileSnapshot)snapshot).getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
                    if (!StringsKt.endsWith((String)string, (String)".jar", (boolean)true)) {
                        return SnapshotVisitResult.CONTINUE;
                    }
                }
                KotlinDslCompileAvoidanceClasspathHashCache kotlinDslCompileAvoidanceClasspathHashCache = KotlinCompileClasspathFingerprinter.access$getClasspathSnapshotHashesCache$p(this.this$0);
                HashCode hashCode = snapshot.getHash();
                Intrinsics.checkNotNullExpressionValue((Object)hashCode, (String)"getHash(...)");
                HashCode fingerprint2 = kotlinDslCompileAvoidanceClasspathHashCache.getHash(hashCode, (Function0<? extends HashCode>)((Function0)() -> fingerprint.1.visitEntry$lambda$0(this.this$0, snapshot)));
                this.$fingerprints.put(snapshot.getAbsolutePath(), fingerprint2);
                return SnapshotVisitResult.SKIP_SUBTREE;
            }

            private static final HashCode visitEntry$lambda$0(KotlinCompileClasspathFingerprinter this$0, FileSystemLocationSnapshot $snapshot) {
                return KotlinCompileClasspathFingerprinter.access$computeHashForFile(this$0, new File($snapshot.getAbsolutePath()));
            }
        });
        return fingerprints.isEmpty() ? (CurrentFileCollectionFingerprint)new EmptyCurrentFileCollectionFingerprint("COMPILE_CLASSPATH") : (CurrentFileCollectionFingerprint)new CurrentFileCollectionFingerprintImpl(fingerprints);
    }

    private final HashCode computeHashForFile(File file) {
        Map snapshots = KotlinCompileClasspathFingerprinterKt.getCompilationService().calculateClasspathSnapshot(file, ClassSnapshotGranularity.CLASS_LEVEL, true).getClassSnapshots();
        return this.hash(snapshots);
    }

    private final HashCode hash(Map<String, ? extends ClassSnapshot> snapshots) {
        Hasher hasher = Hashing.newHasher();
        Intrinsics.checkNotNullExpressionValue((Object)hasher, (String)"newHasher(...)");
        Hasher hasher2 = hasher;
        snapshots.entrySet().stream().filter(hash.1.INSTANCE).map(hash.2.INSTANCE).forEach(new Consumer(hasher2){
            final /* synthetic */ Hasher $hasher;
            {
                this.$hasher = $hasher;
            }

            public final void accept(Long it) {
                Intrinsics.checkNotNull((Object)it);
                this.$hasher.putLong(it.longValue());
            }
        });
        HashCode hashCode = hasher2.hash();
        Intrinsics.checkNotNullExpressionValue((Object)hashCode, (String)"hash(...)");
        return hashCode;
    }

    @NotNull
    public CurrentFileCollectionFingerprint empty() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public static final /* synthetic */ KotlinDslCompileAvoidanceClasspathHashCache access$getClasspathSnapshotHashesCache$p(KotlinCompileClasspathFingerprinter $this) {
        return $this.classpathSnapshotHashesCache;
    }

    public static final /* synthetic */ HashCode access$computeHashForFile(KotlinCompileClasspathFingerprinter $this, File file) {
        return $this.computeHashForFile(file);
    }
}

