/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.os.AndroidVersion;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import jogamp.common.Debug;
import jogamp.common.os.PlatformPropsImpl;

public class VersionUtil {
    private static final boolean DEBUG = Debug.debug("VersionUtil");
    public static final String SEPERATOR = "-----------------------------------------------------------------------------------------------------";

    public static StringBuilder getPlatformInfo(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append(SEPERATOR).append(Platform.getNewline());
        stringBuilder.append("Platform: ").append((Object)Platform.getOSType()).append(" / ").append(Platform.getOSName()).append(' ').append(Platform.getOSVersion()).append(" (").append(Platform.getOSVersionNumber()).append("), ");
        stringBuilder.append(Platform.getArchName()).append(" (").append((Object)Platform.getCPUType()).append(", ").append((Object)Platform.getABIType()).append("), ");
        stringBuilder.append(Runtime.getRuntime().availableProcessors()).append(" cores, ").append("littleEndian ").append(PlatformPropsImpl.LITTLE_ENDIAN);
        stringBuilder.append(Platform.getNewline());
        if (Platform.OSType.ANDROID == PlatformPropsImpl.OS_TYPE) {
            stringBuilder.append("Platform: Android Version: ").append(AndroidVersion.CODENAME).append(", ");
            stringBuilder.append(AndroidVersion.RELEASE).append(" [").append(AndroidVersion.RELEASE).append("], SDK: ").append(AndroidVersion.SDK_INT).append(", ").append(AndroidVersion.SDK_NAME);
            stringBuilder.append(Platform.getNewline());
        }
        Platform.getMachineDataInfo().toString(stringBuilder).append(Platform.getNewline());
        stringBuilder.append("Platform: Java Version: ").append(Platform.getJavaVersion()).append(" (").append(Platform.getJavaVersionNumber()).append("u").append(PlatformPropsImpl.JAVA_VERSION_UPDATE).append("), VM: ").append(Platform.getJavaVMName());
        stringBuilder.append(", Runtime: ").append(Platform.getJavaRuntimeName()).append(Platform.getNewline());
        stringBuilder.append("Platform: Java Vendor: ").append(Platform.getJavaVendor()).append(", ").append(Platform.getJavaVendorURL());
        if (PlatformPropsImpl.JAVA_21) {
            stringBuilder.append(", Java21");
        } else if (PlatformPropsImpl.JAVA_17) {
            stringBuilder.append(", Java17");
        } else if (PlatformPropsImpl.JAVA_9) {
            stringBuilder.append(", Java9");
        } else if (PlatformPropsImpl.JAVA_6) {
            stringBuilder.append(", Java6");
        } else if (PlatformPropsImpl.JAVA_SE) {
            stringBuilder.append(", JavaSE");
        }
        stringBuilder.append(", dynamicLib: ").append(PlatformPropsImpl.useDynamicLibraries);
        stringBuilder.append(", AWT enabled: ").append(Platform.AWT_AVAILABLE);
        stringBuilder.append(Platform.getNewline()).append(SEPERATOR);
        return stringBuilder;
    }

    public static String getPlatformInfo() {
        return VersionUtil.getPlatformInfo(null).toString();
    }

    public static String getExtensionName(Manifest manifest) {
        return VersionUtil.getExtensionName(manifest.getMainAttributes());
    }

    public static String getExtensionName(Attributes attributes) {
        if (null != attributes) {
            return attributes.getValue(Attributes.Name.EXTENSION_NAME);
        }
        return null;
    }

    public static Manifest getManifest(ClassLoader classLoader, String string) {
        return VersionUtil.getManifest(classLoader, new String[]{string});
    }

    public static Manifest getManifest(ClassLoader classLoader, String[] stringArray) {
        return VersionUtil.getManifest(classLoader, stringArray, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manifest getManifest(ClassLoader classLoader, String[] stringArray, boolean bl) {
        Object object;
        Manifest[] manifestArray = new Manifest[stringArray.length];
        Manifest manifest = null;
        try {
            if (DEBUG) {
                System.err.println();
                System.err.println("XXXX: getManifest: acceptFirst " + bl + ", extensions " + Arrays.asList(stringArray));
            }
            List<URL> list = VersionUtil.getResources(classLoader, "META-INF/MANIFEST.MF");
            object = VersionUtil.getResources(classLoader.getParent(), "META-INF/MANIFEST.MF");
            if (DEBUG) {
                Iterator<URL> iterator = object.iterator();
                while (iterator.hasNext()) {
                    URL uRL = iterator.next();
                    System.err.println("XXXX: drop parent " + uRL);
                }
            }
            list.removeAll((Collection<?>)object);
            if (DEBUG) {
                for (URL uRL : list) {
                    System.err.println("XXXX: uniq " + uRL);
                }
            }
            for (URL uRL : list) {
                Manifest manifest2;
                InputStream inputStream = uRL.openStream();
                try {
                    manifest2 = new Manifest(inputStream);
                }
                finally {
                    IOUtil.close(inputStream, false);
                }
                Attributes attributes = manifest2.getMainAttributes();
                String string = VersionUtil.getExtensionName(attributes);
                if (DEBUG) {
                    System.err.println("XXXX: ext-name " + string + ", resource " + uRL);
                }
                if (null == string || null == attributes) continue;
                if (null == manifest) {
                    manifest = manifest2;
                }
                for (int i = 0; i < stringArray.length && null == manifestArray[i]; ++i) {
                    String string2 = stringArray[i];
                    if (!string2.equals(string)) continue;
                    if (0 == i) {
                        return manifest2;
                    }
                    manifestArray[i] = manifest2;
                }
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to read manifest.", iOException);
        }
        for (int i = 1; i < manifestArray.length; ++i) {
            if (null == manifestArray[i]) continue;
            object = manifestArray[i];
            return object;
        }
        if (bl && null != manifest) {
            return manifest;
        }
        return null;
    }

    private static List<URL> getResources(ClassLoader classLoader, String string) throws IOException {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (null != classLoader) {
            Enumeration<URL> enumeration = classLoader.getResources(string);
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                arrayList.add(uRL);
            }
        }
        return arrayList;
    }

    public static StringBuilder getFullManifestInfo(Manifest manifest, StringBuilder stringBuilder) {
        if (null == manifest) {
            return stringBuilder;
        }
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        Attributes attributes = manifest.getMainAttributes();
        Set<Object> set = attributes.keySet();
        for (Attributes.Name name : set) {
            String string = attributes.getValue(name);
            stringBuilder.append(" ");
            stringBuilder.append(name);
            stringBuilder.append(" = ");
            stringBuilder.append(string);
            stringBuilder.append(Platform.getNewline());
        }
        return stringBuilder;
    }
}

