/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class EngineConfig
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(EngineConfig.class);
    protected Engine engine = null;
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.startup");

    @Override
    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        try {
            this.engine = (Engine)lifecycleEvent.getLifecycle();
        }
        catch (ClassCastException classCastException) {
            log.error((Object)sm.getString("engineConfig.cce", new Object[]{lifecycleEvent.getLifecycle()}), (Throwable)classCastException);
            return;
        }
        if (lifecycleEvent.getType().equals("start")) {
            this.start();
        } else if (lifecycleEvent.getType().equals("stop")) {
            this.stop();
        }
    }

    protected void start() {
        if (this.engine.getLogger().isTraceEnabled()) {
            this.engine.getLogger().trace((Object)sm.getString("engineConfig.start"));
        }
    }

    protected void stop() {
        if (this.engine.getLogger().isTraceEnabled()) {
            this.engine.getLogger().trace((Object)sm.getString("engineConfig.stop"));
        }
    }
}

