/*
 * Decompiled with CFR 0.152.
 */
package de.tuberlin.polymake.common.geometry;

import de.tuberlin.polymake.common.geometry.EmbeddedGeometry;
import de.tuberlin.polymake.common.geometry.GeometryIf;
import de.tuberlin.polymake.common.geometry.PointSet;
import de.tuberlin.polymake.common.geometry.PolymakePoint;
import java.util.HashMap;
import java.util.Vector;

public class EmbeddedGeometries {
    protected PointSet embedding = new PointSet();
    protected HashMap geomIndexMap = new HashMap(8);
    protected EmbeddedGeometry[] geometries;
    protected String name = "NoName";

    public EmbeddedGeometries(String string, EmbeddedGeometry[] embeddedGeometryArray) {
        this.name = string;
        this.geometries = new EmbeddedGeometry[embeddedGeometryArray.length];
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i] = (EmbeddedGeometry)embeddedGeometryArray[i].clone();
            this.geomIndexMap.put(this.geometries[i].getName(), new Integer(i));
        }
    }

    public EmbeddedGeometries(String string, PointSet pointSet, EmbeddedGeometry[] embeddedGeometryArray) {
        this.name = string;
        if (pointSet != null) {
            this.embedding = new PointSet(pointSet);
        }
        this.embedding.setName(string);
        this.geometries = new EmbeddedGeometry[embeddedGeometryArray.length];
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i] = (EmbeddedGeometry)embeddedGeometryArray[i].clone();
            this.geomIndexMap.put(this.geometries[i].getName(), new Integer(i));
        }
    }

    public void moveVertex(String string, int n, double[] dArray) {
        int n2 = (Integer)this.geomIndexMap.get(string);
        int n3 = this.geometries[n2].getVertexIndex(n);
        this.embedding.setPointCoords(n3, dArray);
        this.update(this.embedding, false);
    }

    public PolymakePoint getEmbeddedVertex(String string, int n) {
        int n2 = this.getEmbeddedVertexIndex(string, n);
        PolymakePoint polymakePoint = this.embedding.getPoint(n2);
        return new PolymakePoint(polymakePoint.getCoords(), Integer.toString(n2));
    }

    public void update(PointSet pointSet, boolean bl) {
        int n;
        this.name = pointSet.getName();
        this.embedding.setName(this.name);
        if (this.embedding.getNPoints() <= pointSet.getNPoints()) {
            this.embedding.setNPoints(pointSet.getNPoints());
        }
        for (n = 0; n < pointSet.getNPoints(); ++n) {
            PolymakePoint polymakePoint = pointSet.getPoint(n);
            double[] dArray = polymakePoint.getCoords();
            if (polymakePoint.getLabel() != null) {
                this.embedding.setPointCoords(Integer.parseInt(polymakePoint.getLabel()), dArray);
                continue;
            }
            this.embedding.setPointCoords(n, dArray);
        }
        for (n = 0; n < this.geometries.length; ++n) {
            if (!this.geometries[n].isDynamic()) continue;
            this.geometries[n].update(this.embedding, bl);
        }
    }

    public double[] getVertexCoords(int n) {
        return this.embedding.getPoint(n).getCoords();
    }

    public int getNumberOfGeometries() {
        return this.geometries.length;
    }

    public PointSet getEmbedding() {
        return this.embedding;
    }

    public void setGeometry(int n, GeometryIf geometryIf) {
        this.geometries[n].setGeometry(geometryIf.copy());
    }

    public GeometryIf getGeometry(int n) {
        return this.geometries[n].getGeometry();
    }

    public GeometryIf[] getGeometries() {
        GeometryIf[] geometryIfArray = new GeometryIf[this.geometries.length];
        for (int i = 0; i < geometryIfArray.length; ++i) {
            geometryIfArray[i] = this.geometries[i].getGeometry();
        }
        return geometryIfArray;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Object clone() {
        return new EmbeddedGeometries(this.name, this.embedding, this.geometries);
    }

    public String toString() {
        Object object = new String();
        object = (String)object + "name = " + this.name + "\n";
        object = (String)object + "embedding = " + this.embedding.toString() + "\n";
        for (int i = 0; i < this.geometries.length; ++i) {
            object = (String)object + "geometries[" + i + "]=" + this.geometries[i].toString();
        }
        return object;
    }

    public Vector getMarkedVertices() {
        int n;
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < this.embedding.getNPoints(); ++n) {
            this.embedding.setMarkedPoint(n, false);
        }
        for (n = 0; n < this.geometries.length; ++n) {
            GeometryIf geometryIf = this.getGeometry(n);
            for (int i = 0; i < geometryIf.getNumVertices(); ++i) {
                if (!geometryIf.getMarked(i)) continue;
                vector.add(Integer.toString(this.geometries[n].vertexList[i]));
                double[] dArray = geometryIf.getVertexCoords(i);
                this.embedding.setPointCoords(this.geometries[n].vertexList[i], dArray);
                this.embedding.setMarkedPoint(this.geometries[n].vertexList[i], true);
            }
        }
        return vector;
    }

    public int getEmbeddedVertexIndex(String string, int n) {
        int n2 = (Integer)this.geomIndexMap.get(string);
        return this.geometries[n2].getVertexIndex(n);
    }
}

