/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.spi.resources.sharing;

import java.io.IOException;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class CreatedBy
implements ToXContentFragment,
NamedWriteable {
    private final String username;
    private final String tenant;

    public CreatedBy(String username) {
        this.username = username;
        this.tenant = null;
    }

    public CreatedBy(String username, String tenant) {
        this.username = username;
        this.tenant = tenant;
    }

    public CreatedBy(StreamInput in) throws IOException {
        this.username = in.readString();
        this.tenant = in.readOptionalString();
    }

    public String getUsername() {
        return this.username;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String toString() {
        if (this.tenant != null) {
            return "CreatedBy {user='%s', tenant='%s'}\n".formatted(this.username, this.tenant).trim();
        }
        return "CreatedBy {user='%s'}\n".formatted(this.username).trim();
    }

    public String getWriteableName() {
        return "created_by";
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.username);
        out.writeOptionalString(this.tenant);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.tenant != null) {
            return builder.startObject().field("user", this.username).field("tenant", this.tenant).endObject();
        }
        return builder.startObject().field("user", this.username).endObject();
    }

    public static CreatedBy fromXContent(XContentParser parser) throws IOException {
        String username = null;
        String tenant = null;
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            if (parser.currentToken() != XContentParser.Token.FIELD_NAME) continue;
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "user": {
                    if (XContentParser.Token.VALUE_STRING == parser.currentToken()) {
                        username = parser.text();
                        continue block8;
                    }
                    throw new IllegalArgumentException("created_by cannot be empty");
                }
                case "tenant": {
                    tenant = parser.currentToken() == XContentParser.Token.VALUE_NULL ? null : parser.text();
                    continue block8;
                }
            }
            throw new IllegalArgumentException("created_by contains unknown field: " + fieldName);
        }
        if (username == null) {
            throw new IllegalArgumentException("created_by cannot be empty");
        }
        return new CreatedBy(username, tenant);
    }
}

