/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.hasher;

import com.password4j.HashingFunction;
import java.nio.CharBuffer;
import java.util.Arrays;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.core.common.Strings;
import org.opensearch.security.hasher.PasswordHasher;

abstract class AbstractPasswordHasher
implements PasswordHasher {
    HashingFunction hashingFunction;

    AbstractPasswordHasher() {
    }

    @Override
    public abstract String hash(char[] var1);

    @Override
    public abstract boolean check(char[] var1, String var2);

    protected void cleanup(CharBuffer password) {
        password.clear();
        char[] passwordOverwrite = new char[password.capacity()];
        Arrays.fill(passwordOverwrite, '\u0000');
        password.put(passwordOverwrite);
    }

    protected void checkPasswordNotNullOrEmpty(char[] password) {
        if (password == null || password.length == 0) {
            throw new OpenSearchSecurityException("Password cannot be empty or null", new Object[0]);
        }
    }

    protected void checkHashNotNullOrEmpty(String hash) {
        if (Strings.isNullOrEmpty((String)hash)) {
            throw new OpenSearchSecurityException("Hash cannot be empty or null", new Object[0]);
        }
    }
}

