/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.text;

import java.io.Closeable;
import java.io.IOException;
import org.gradle.api.logging.StandardOutputListener;
import org.gradle.internal.logging.text.AbstractStyledTextOutput;
import org.gradle.internal.logging.text.StreamBackedStandardOutputListener;

public class StreamingStyledTextOutput
extends AbstractStyledTextOutput
implements Closeable {
    private final StandardOutputListener listener;
    private final Closeable closeable;

    public StreamingStyledTextOutput(StandardOutputListener listener) {
        this(listener, listener);
    }

    public StreamingStyledTextOutput(Appendable appendable) {
        this(appendable, new StreamBackedStandardOutputListener(appendable));
    }

    private StreamingStyledTextOutput(Object target, StandardOutputListener listener) {
        this.listener = listener;
        this.closeable = target instanceof Closeable ? (Closeable)target : null;
    }

    @Override
    protected void doAppend(String text) {
        this.listener.onOutput((CharSequence)text);
    }

    @Override
    public void close() throws IOException {
        if (this.closeable != null) {
            this.closeable.close();
        }
    }
}

