/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal.prebuilt;

import org.gradle.api.DomainObjectSet;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.internal.resolve.ProjectModelResolver;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.nativeplatform.NativeLibraryBinary;
import org.gradle.nativeplatform.PrebuiltLibraries;
import org.gradle.nativeplatform.PrebuiltLibrary;
import org.gradle.nativeplatform.Repositories;
import org.gradle.nativeplatform.internal.resolve.LibraryBinaryLocator;
import org.gradle.nativeplatform.internal.resolve.LibraryIdentifier;
import org.jspecify.annotations.Nullable;

public class PrebuiltLibraryBinaryLocator
implements LibraryBinaryLocator {
    private final ProjectModelResolver projectModelResolver;

    public PrebuiltLibraryBinaryLocator(ProjectModelResolver projectModelResolver) {
        this.projectModelResolver = projectModelResolver;
    }

    @Override
    public @Nullable DomainObjectSet<NativeLibraryBinary> getBinaries(LibraryIdentifier library) {
        ModelRegistry projectModel = this.projectModelResolver.resolveProjectModel(library.getProjectPath());
        Repositories repositories = (Repositories)projectModel.find("repositories", Repositories.class);
        if (repositories == null) {
            return null;
        }
        PrebuiltLibrary prebuiltLibrary = this.getPrebuiltLibrary((NamedDomainObjectSet<PrebuiltLibraries>)repositories.withType(PrebuiltLibraries.class), library.getLibraryName());
        return prebuiltLibrary != null ? prebuiltLibrary.getBinaries() : null;
    }

    private PrebuiltLibrary getPrebuiltLibrary(NamedDomainObjectSet<PrebuiltLibraries> repositories, String libraryName) {
        for (PrebuiltLibraries prebuiltLibraries : repositories) {
            PrebuiltLibrary prebuiltLibrary = prebuiltLibraries.resolveLibrary(libraryName);
            if (prebuiltLibrary == null) continue;
            return prebuiltLibrary;
        }
        return null;
    }
}

