/**
 * SECTION:role-details
 * @short_description: Role a contact has in an organisation.
 * 
 * <para>This represents the role a <link linkend="FolksPersona"><type>FolksPersona</type></link> or <link linkend="FolksIndividual"><type>FolksIndividual</type></link> has in a single given organisation, such as a company.</para>
 *
 * Since: 0.4.0
 */
/**
 * FOLKS_TYPE_ROLE:
 * 
 * The type for <link linkend="FolksRole"><type>FolksRole</type></link>.
 */
/**
 * folks_role_is_empty:
 * @self: the <link linkend="FolksRole"><type>FolksRole</type></link> instance
 * 
 * Whether none of the components is set.
 * 
 * Returns: <para><code>true</code> if all the components are the empty string, <code>false</code> otherwise. </para>
 *
 * Since: 0.6.7
 */
/**
 * folks_role_to_string:
 * @self: the <link linkend="FolksRole"><type>FolksRole</type></link> instance
 * 
 * Formatted version of this role.
 *
 * Since: 0.4.0
 */
/**
 * folks_role_new:
 * @title: (in) (allow-none): &nbsp;.  <para>title of the position </para>
 * @organisation_name: (in) (allow-none): &nbsp;.  <para>organisation where the role is hold </para>
 * @uid: (in) (allow-none): &nbsp;.  <para>a Unique ID associated to this Role </para>
 * 
 * Default constructor.
 * 
 * Returns: <para>a new Role </para>
 *
 * Since: 0.4.0
 */
/**
 * FolksRole:organisation-name:
 * 
 * The name of the organisation in which the role is held.
 */
/**
 * folks_role_get_organisation_name:
 * @self: the <link linkend="FolksRole"><type>FolksRole</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksRole--organisation-name"><type>"organisation-name"</type></link> property.
 * 
 * The name of the organisation in which the role is held.
 * 
 * Returns: the value of the <link linkend="FolksRole--organisation-name"><type>"organisation-name"</type></link> property
 */
/**
 * folks_role_set_organisation_name:
 * @self: the <link linkend="FolksRole"><type>FolksRole</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksRole--organisation-name"><type>"organisation-name"</type></link> property
 * 
 * Set the value of the <link linkend="FolksRole--organisation-name"><type>"organisation-name"</type></link> property to @value.
 * 
 * The name of the organisation in which the role is held.
 */
/**
 * FolksRole:title:
 * 
 * The title of the position held.
 * 
 * <para>For example: “Director, Ministry of Silly Walks”</para>
 */
/**
 * folks_role_get_title:
 * @self: the <link linkend="FolksRole"><type>FolksRole</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksRole--title"><type>"title"</type></link> property.
 * 
 * The title of the position held.
 * 
 * <para>For example: “Director, Ministry of Silly Walks”</para>
 * 
 * Returns: the value of the <link linkend="FolksRole--title"><type>"title"</type></link> property
 */
/**
 * folks_role_set_title:
 * @self: the <link linkend="FolksRole"><type>FolksRole</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksRole--title"><type>"title"</type></link> property
 * 
 * Set the value of the <link linkend="FolksRole--title"><type>"title"</type></link> property to @value.
 * 
 * The title of the position held.
 * 
 * <para>For example: “Director, Ministry of Silly Walks”</para>
 */
/**
 * FolksRole:role:
 * 
 * The role of the position.
 * 
 * <para>For example: “Programmer”</para>
 *
 * Since: 0.6.0
 */
/**
 * folks_role_get_role:
 * @self: the <link linkend="FolksRole"><type>FolksRole</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksRole--role"><type>"role"</type></link> property.
 * 
 * The role of the position.
 * 
 * <para>For example: “Programmer”</para>
 * 
 * Returns: the value of the <link linkend="FolksRole--role"><type>"role"</type></link> property
 *
 * Since: 0.6.0
 */
/**
 * folks_role_set_role:
 * @self: the <link linkend="FolksRole"><type>FolksRole</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksRole--role"><type>"role"</type></link> property
 * 
 * Set the value of the <link linkend="FolksRole--role"><type>"role"</type></link> property to @value.
 * 
 * The role of the position.
 * 
 * <para>For example: “Programmer”</para>
 *
 * Since: 0.6.0
 */
/**
 * FolksRole:uid:
 * 
 * The UID that distinguishes this role.
 *
 * Deprecated: 0.6.5: Replaced by #FolksAbstractFieldDetails:id.
 */
/**
 * folks_role_get_uid:
 * @self: the <link linkend="FolksRole"><type>FolksRole</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksRole--uid"><type>"uid"</type></link> property.
 * 
 * The UID that distinguishes this role.
 * 
 * Returns: the value of the <link linkend="FolksRole--uid"><type>"uid"</type></link> property
 *
 * Deprecated: 0.6.5: Replaced by #FolksAbstractFieldDetails:id.
 */
/**
 * folks_role_set_uid:
 * @self: the <link linkend="FolksRole"><type>FolksRole</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksRole--uid"><type>"uid"</type></link> property
 * 
 * Set the value of the <link linkend="FolksRole--uid"><type>"uid"</type></link> property to @value.
 * 
 * The UID that distinguishes this role.
 *
 * Deprecated: 0.6.5: Replaced by #FolksAbstractFieldDetails:id.
 */
/**
 * folks_role_equal:
 * @a: (in): &nbsp;.  <para>a role to compare </para>
 * @b: (in): &nbsp;.  <para>another role to compare </para>
 * 
 * Compare if two roles are equal. Roles are equal if their titles and organisation names are equal.
 * 
 * Returns: <para><code>true</code> if the roles are equal, <code>false</code> otherwise </para>
 */
/**
 * folks_role_hash:
 * @r: (in): &nbsp;.  <para>a role to hash </para>
 * 
 * Hash function for the class. Suitable for use as a hash table key.
 * 
 * Returns: <para>hash value for the role instance </para>
 */
/**
 * FolksRole:
 * 
 * Role a contact has in an organisation.
 * 
 * <para>This represents the role a <link linkend="FolksPersona"><type>FolksPersona</type></link> or <link linkend="FolksIndividual"><type>FolksIndividual</type></link> has in a single given organisation, such as a company.</para>
 *
 * Since: 0.4.0
 */
/**
 * FolksRoleClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="FOLKS-TYPE-ROLE:CAPS"><literal>FOLKS_TYPE_ROLE</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
/**
 * FOLKS_TYPE_ROLE_FIELD_DETAILS:
 * 
 * The type for <link linkend="FolksRoleFieldDetails"><type>FolksRoleFieldDetails</type></link>.
 */
/**
 * folks_role_field_details_new:
 * @value: (in): &nbsp;.  <para>the non-empty <link linkend="FolksRole"><type>FolksRole</type></link> of the field </para>
 * @parameters: (in) (allow-none): &nbsp;.  <para>initial parameters. See <link linkend="FolksAbstractFieldDetails--parameters"><type>"parameters"</type></link>. A <code>null</code> value is equivalent to an empty map of parameters. </para>
 * 
 * Create a new RoleFieldDetails.
 * 
 * Returns: <para>a new RoleFieldDetails </para>
 *
 * Since: 0.6.0
 */
/**
 * FolksRoleFieldDetails:
 * 
 * Object representing details of a contact in an organisation which can have some parameters associated with it.
 * 
 * <para>See <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link>.</para>
 *
 * Since: 0.6.0
 */
/**
 * FolksRoleFieldDetailsClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="FOLKS-TYPE-ROLE-FIELD-DETAILS:CAPS"><literal>FOLKS_TYPE_ROLE_FIELD_DETAILS</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
/**
 * folks_role_details_change_roles:
 * @self: the <link linkend="FolksRoleDetails"><type>FolksRoleDetails</type></link> instance
 * @roles: (in): &nbsp;.  <para>the set of roles </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Change the contact&apos;s roles.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksRoleDetails--roles"><type>"roles"</type></link> directly, as this method gives error notification and will only return once the roles have been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the roles failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-role-details-change-roles-finish"><function>folks_role_details_change_roles_finish()</function></link>
 *
 * Since: 0.6.2
 */
/**
 * folks_role_details_change_roles_finish:
 * @self: the <link linkend="FolksRoleDetails"><type>FolksRoleDetails</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: (error-domains FolksPropertyError): location to store the error occurring, or %NULL to ignore
 * 
 * Change the contact&apos;s roles.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksRoleDetails--roles"><type>"roles"</type></link> directly, as this method gives error notification and will only return once the roles have been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the roles failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-role-details-change-roles"><function>folks_role_details_change_roles()</function></link>
 *
 * Since: 0.6.2
 */
/**
 * FolksRoleDetails:roles:
 * 
 * The roles of the contact.
 *
 * Since: 0.6.0
 */
/**
 * folks_role_details_get_roles:
 * @self: the <link linkend="FolksRoleDetails"><type>FolksRoleDetails</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksRoleDetails--roles"><type>"roles"</type></link> property.
 * 
 * The roles of the contact.
 * 
 * Returns: the value of the <link linkend="FolksRoleDetails--roles"><type>"roles"</type></link> property
 *
 * Since: 0.6.0
 */
/**
 * folks_role_details_set_roles:
 * @self: the <link linkend="FolksRoleDetails"><type>FolksRoleDetails</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksRoleDetails--roles"><type>"roles"</type></link> property
 * 
 * Set the value of the <link linkend="FolksRoleDetails--roles"><type>"roles"</type></link> property to @value.
 * 
 * The roles of the contact.
 *
 * Since: 0.6.0
 */
/**
 * FolksRoleDetails:
 * 
 * This interfaces represents the list of roles a <link linkend="FolksPersona"><type>FolksPersona</type></link> and <link linkend="FolksIndividual"><type>FolksIndividual</type></link> might have.
 *
 * Since: 0.4.0
 */
/**
 * FolksRoleDetailsIface:
 * @change_roles: virtual method called by <link linkend="folks-role-details-change-roles"><function>folks_role_details_change_roles()</function></link>
 * @change_roles_finish: asynchronous finish function for <structfield>change_roles</structfield>, called by <link linkend="folks-role-details-change-roles"><function>folks_role_details_change_roles()</function></link>
 * @get_roles: getter method for the abstract property <link linkend="FolksRoleDetails--roles"><type>"roles"</type></link>
 * @set_roles: setter method for the abstract property <link linkend="FolksRoleDetails--roles"><type>"roles"</type></link>
 * @parent_iface: the parent interface structure
 * 
 * Interface for creating <link linkend="FolksRoleDetails"><type>FolksRoleDetails</type></link> implementations.
 */
