/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.object.struct;

import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.utils.CommonUtils;

public class ConstraintNameGenerator {
    private static final Log log = Log.getLog(ConstraintNameGenerator.class);
    @NotNull
    private final DBSEntity entity;
    private final Map<DBSEntityConstraintType, String> TYPE_PREFIX = new HashMap<DBSEntityConstraintType, String>();
    private DBSEntityConstraintType constraintType;
    private String constraintName;
    private static final Pattern NAME_INDEX_PATTERN = Pattern.compile("_([0-9]+)");

    public ConstraintNameGenerator(DBSEntity entity) {
        this(entity, null);
    }

    public ConstraintNameGenerator(DBSEntity entity, String constraintName) {
        this(entity, constraintName, DBSEntityConstraintType.PRIMARY_KEY);
    }

    public ConstraintNameGenerator(@NotNull DBSEntity entity, String constraintName, DBSEntityConstraintType constraintType) {
        this.entity = entity;
        this.constraintName = constraintName;
        this.addTypePrefix(DBSEntityConstraintType.PRIMARY_KEY, "_PK");
        this.addTypePrefix(DBSEntityConstraintType.UNIQUE_KEY, "_UNIQUE");
        this.addTypePrefix(DBSEntityConstraintType.VIRTUAL_KEY, "_VK");
        this.addTypePrefix(DBSEntityConstraintType.FOREIGN_KEY, "_FK");
        this.addTypePrefix(DBSEntityConstraintType.CHECK, "_CHECK");
        this.constraintType = constraintType;
        if (CommonUtils.isEmpty((String)constraintName)) {
            this.generateConstraintName(false);
        }
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public void setConstraintName(String constraintName) {
        this.constraintName = constraintName;
    }

    public DBSEntityConstraintType getConstraintType() {
        return this.constraintType;
    }

    public void setConstraintType(DBSEntityConstraintType newType) {
        String oldPrefix;
        boolean nameUpdated = false;
        if (!CommonUtils.isEmpty((String)this.constraintName) && (oldPrefix = this.TYPE_PREFIX.get(this.constraintType)) != null) {
            String newPrefix;
            String testName = this.constraintName;
            Matcher matcher = NAME_INDEX_PATTERN.matcher(testName);
            if (matcher.find() && matcher.end() == testName.length()) {
                testName = testName.substring(0, matcher.start());
            }
            if (testName.toLowerCase().endsWith(oldPrefix.toLowerCase()) && (newPrefix = this.TYPE_PREFIX.get(newType)) != null) {
                if (Character.isLowerCase(this.constraintName.charAt(0))) {
                    newPrefix = newPrefix.toLowerCase(Locale.ENGLISH);
                }
                this.constraintName = testName.substring(0, testName.length() - oldPrefix.length()) + newPrefix;
                nameUpdated = true;
            }
        }
        this.constraintType = newType;
        if (!nameUpdated) {
            this.generateConstraintName(true);
        } else {
            this.makeNameUnique();
        }
    }

    private void generateConstraintName(boolean forceRefresh) {
        if (CommonUtils.isEmpty((String)this.constraintName) || forceRefresh) {
            String entityName;
            String namePrefix = this.TYPE_PREFIX.get(this.constraintType);
            if (namePrefix == null) {
                namePrefix = "_KEY";
            }
            if ((entityName = CommonUtils.escapeIdentifier((String)this.entity.getName())) != null && !entityName.isBlank() && Character.isLowerCase(entityName.charAt(0))) {
                namePrefix = namePrefix.toLowerCase(Locale.ENGLISH);
            }
            this.constraintName = entityName + namePrefix;
        }
        this.makeNameUnique();
    }

    private void makeNameUnique() {
        try {
            int conIndex = 1;
            Object curName = this.constraintName;
            Collection conList = this.entity.getConstraints((DBRProgressMonitor)new VoidProgressMonitor());
            while (DBUtils.findObject((Collection)conList, (String)curName) != null) {
                curName = this.constraintName + "_" + conIndex;
                ++conIndex;
            }
            this.constraintName = DBObjectNameCaseTransformer.transformName((DBPDataSource)this.entity.getDataSource(), (String)curName);
        }
        catch (DBException e) {
            log.debug((Object)e);
        }
    }

    private void addTypePrefix(DBSEntityConstraintType type, String prefix) {
        if (this.entity.getDataSource() != null) {
            prefix = this.entity.getDataSource().getSQLDialect().storesUnquotedCase().transform(prefix);
        }
        this.TYPE_PREFIX.put(type, prefix);
    }

    public String validateAllowedType(DBSEntityConstraintType constraintType) {
        if (constraintType == DBSEntityConstraintType.PRIMARY_KEY) {
            boolean hasPK = false;
            try {
                for (DBSEntityConstraint con : CommonUtils.safeCollection((Collection)this.entity.getConstraints((DBRProgressMonitor)new VoidProgressMonitor()))) {
                    if (con.getConstraintType() != DBSEntityConstraintType.PRIMARY_KEY) continue;
                    hasPK = true;
                    break;
                }
            }
            catch (DBException e) {
                log.debug((Object)e);
            }
            if (hasPK) {
                return "Primary key already exists in '" + DBUtils.getObjectFullName((DBPNamedObject)this.entity, (DBPEvaluationContext)DBPEvaluationContext.UI) + "'";
            }
        }
        return null;
    }
}

