/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.tasks;

import java.util.List;
import org.jkiss.dbeaver.ext.oracle.model.OracleTable;
import org.jkiss.dbeaver.ext.oracle.tasks.OracleToolTableGatherStatisticsSettings;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.sql.task.SQLToolExecuteHandler;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class OracleToolsTableGatherStatistics
extends SQLToolExecuteHandler<DBSObject, OracleToolTableGatherStatisticsSettings> {
    public OracleToolTableGatherStatisticsSettings createToolSettings() {
        return new OracleToolTableGatherStatisticsSettings();
    }

    public void generateObjectQueries(DBCSession session, OracleToolTableGatherStatisticsSettings settings, List<DBEPersistAction> queries, DBSObject object) throws DBCException {
        if (object instanceof OracleTable) {
            OracleTable table = (OracleTable)object;
            int percent = settings.getSamplePercent();
            String sql = "BEGIN \n DBMS_STATS.GATHER_TABLE_STATS (\n OWNNAME => '" + DBUtils.getQuotedIdentifier((DBSObject)table.getSchema()) + "',\n TABNAME => '" + DBUtils.getQuotedIdentifier((DBSObject)table) + "'";
            if (percent > 0) {
                sql = sql + ",\n estimate_percent => " + percent;
            }
            sql = sql + " \n );\n END;";
            queries.add((DBEPersistAction)new SQLDatabasePersistAction(sql));
        }
    }
}

