/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.UDecoder;
import org.apache.tomcat.util.file.ConfigFileLoader;

public class ParameterLimitValve
extends ValveBase {
    private Map<Pattern, Integer[]> urlPatternLimits = new ConcurrentHashMap<Pattern, Integer[]>();
    private String resourcePath = "parameter_limit.config";
    private boolean context = false;

    public ParameterLimitValve() {
        super(true);
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String string) {
        this.resourcePath = string;
    }

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        this.containerLog = LogFactory.getLog((String)(this.getContainer().getLogName() + ".parameterLimit"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void startInternal() throws LifecycleException {
        Object object;
        Object object2;
        InputStream inputStream;
        block29: {
            super.startInternal();
            inputStream = null;
            if (this.getContainer() instanceof Context) {
                this.context = true;
                object2 = "/WEB-INF/" + this.resourcePath;
                inputStream = ((Context)this.getContainer()).getServletContext().getResourceAsStream((String)object2);
                if (this.containerLog.isDebugEnabled()) {
                    if (inputStream == null) {
                        this.containerLog.debug((Object)sm.getString("parameterLimitValve.noConfiguration", new Object[]{object2}));
                    } else {
                        this.containerLog.debug((Object)sm.getString("parameterLimitValve.readConfiguration", new Object[]{object2}));
                    }
                }
            } else {
                object2 = Container.getConfigPath(this.getContainer(), this.resourcePath);
                try {
                    object = ConfigFileLoader.getSource().getResource((String)object2);
                    inputStream = object.getInputStream();
                }
                catch (IOException iOException) {
                    if (!this.containerLog.isDebugEnabled()) break block29;
                    this.containerLog.debug((Object)sm.getString("parameterLimitValve.noConfiguration", new Object[]{object2}), (Throwable)iOException);
                }
            }
        }
        if (inputStream == null) {
            return;
        }
        try {
            object2 = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            try {
                object = new BufferedReader((Reader)object2);
                try {
                    this.setUrlPatternLimits((BufferedReader)object);
                }
                finally {
                    ((BufferedReader)object).close();
                }
            }
            finally {
                ((InputStreamReader)object2).close();
            }
        }
        catch (IOException iOException) {
            this.containerLog.error((Object)sm.getString("parameterLimitValve.closeError"), (Throwable)iOException);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                this.containerLog.error((Object)sm.getString("parameterLimitValve.closeError"), (Throwable)iOException);
            }
        }
    }

    public void setUrlPatternLimits(String string) {
        this.urlPatternLimits.clear();
        this.setUrlPatternLimits(new BufferedReader(new StringReader(string)));
    }

    public void setUrlPatternLimits(BufferedReader bufferedReader) {
        block9: {
            if (this.containerLog == null && this.getContainer() != null) {
                this.containerLog = LogFactory.getLog((String)(this.getContainer().getLogName() + ".parameterLimit"));
            }
            try {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    if ((string = string.trim()).isEmpty() || string.startsWith("#")) continue;
                    int n = string.lastIndexOf(61);
                    if (n == -1) {
                        throw new IllegalArgumentException(sm.getString("parameterLimitValve.invalidLine", new Object[]{string}));
                    }
                    String string2 = string.substring(0, n).trim();
                    String string3 = string.substring(n + 1).trim();
                    Pattern pattern = Pattern.compile(UDecoder.URLDecode((String)string2, (Charset)StandardCharsets.UTF_8));
                    String[] stringArray = string3.split(",");
                    if (stringArray.length == 1) {
                        this.urlPatternLimits.put(pattern, new Integer[]{Integer.valueOf(stringArray[0]), null, null});
                    } else if (stringArray.length == 3) {
                        this.urlPatternLimits.put(pattern, new Integer[]{Integer.valueOf(stringArray[0]), Integer.valueOf(stringArray[1]), Integer.valueOf(stringArray[2])});
                    } else {
                        throw new IllegalArgumentException(sm.getString("parameterLimitValve.invalidLimitsString", new Object[]{string3}));
                    }
                    if (this.containerLog == null || !this.containerLog.isTraceEnabled()) continue;
                    this.containerLog.trace((Object)("Add pattern " + pattern + " and limit(s) " + string3));
                }
            }
            catch (IOException iOException) {
                if (this.containerLog == null) break block9;
                this.containerLog.error((Object)sm.getString("parameterLimitValve.readError"), (Throwable)iOException);
            }
        }
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        super.stopInternal();
        this.urlPatternLimits.clear();
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (this.urlPatternLimits.isEmpty()) {
            this.getNext().invoke(request, response);
            return;
        }
        String string = this.context ? request.getRequestPathMB().toString() : request.getDecodedRequestURI();
        for (Map.Entry<Pattern, Integer[]> entry : this.urlPatternLimits.entrySet()) {
            if (!entry.getKey().matcher(string).matches()) continue;
            Integer[] integerArray = entry.getValue();
            request.setMaxParameterCount(integerArray[0]);
            if (integerArray[1] == null) break;
            request.setMaxPartCount(integerArray[1]);
            request.setMaxPartHeaderSize(integerArray[2]);
            break;
        }
        this.getNext().invoke(request, response);
    }
}

