/*
 * Decompiled with CFR 0.152.
 */
package com.selectivem.collections;

import com.selectivem.collections.CheckList;
import com.selectivem.collections.CheckListImpl;
import com.selectivem.collections.CheckTable;
import com.selectivem.collections.IndexedImmutableSetImpl;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;

class CheckTableImpl {
    CheckTableImpl() {
    }

    static <R, C> CheckTable<R, C> create(R row, Set<C> columns) {
        int columnsSize = columns.size();
        if (columnsSize == 0) {
            throw new IllegalArgumentException("Must contain at least one column");
        }
        if (columnsSize == 1) {
            return new SingleCellCheckTable<R, C>(row, columns.iterator().next(), IndexedImmutableSetImpl.of(row), IndexedImmutableSetImpl.of(columns));
        }
        return new SingleRowCheckTable<R, C>(row, columns);
    }

    static <R, C> CheckTable<R, C> create(Set<R> rows, C column) {
        int rowsSize = rows.size();
        if (rowsSize == 0) {
            throw new IllegalArgumentException("Must contain at least one row");
        }
        if (rowsSize == 1) {
            return new SingleCellCheckTable<R, C>(rows.iterator().next(), column, IndexedImmutableSetImpl.of(rows), IndexedImmutableSetImpl.of(column));
        }
        return new SingleColumnCheckTable<R, C>(rows, column);
    }

    static <R, C> CheckTable<R, C> create(Set<R> rows, Set<C> columns) {
        int rowsSize = rows.size();
        int columnsSize = columns.size();
        if (rowsSize == 0 || columnsSize == 0) {
            throw new IllegalArgumentException("Must contain at least one column and at least one row (got " + rows + "/" + columns + ")");
        }
        if (rowsSize == 1) {
            if (columnsSize == 1) {
                return new SingleCellCheckTable<R, C>(rows.iterator().next(), columns.iterator().next(), IndexedImmutableSetImpl.of(rows), IndexedImmutableSetImpl.of(columns));
            }
            return new SingleRowCheckTable<R, C>(rows.iterator().next(), columns);
        }
        if (columnsSize == 1) {
            return new SingleColumnCheckTable<R, C>(rows, columns.iterator().next());
        }
        return new ArrayCheckTable<R, C>(rows, columns);
    }

    static final class SingleCellCheckTable<R, C>
    extends AbstractCheckTable<R, C> {
        private final R row;
        private final C column;
        private final Set<R> rowSet;
        private final Set<C> columnSet;
        private boolean checked = false;

        SingleCellCheckTable(R row, C column, IndexedImmutableSetImpl<R> rowSet, IndexedImmutableSetImpl<C> columnSet) {
            this.row = row;
            this.column = column;
            this.rowSet = rowSet;
            this.columnSet = columnSet;
        }

        @Override
        public boolean check(R row, C column) {
            if (!row.equals(this.row)) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            if (!column.equals(this.column)) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            if (!this.checked) {
                this.checked = true;
            }
            return true;
        }

        @Override
        public void uncheck(R row, C column) {
            if (!row.equals(this.row)) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            if (!column.equals(this.column)) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            if (this.checked) {
                this.checked = false;
            }
        }

        @Override
        public boolean isComplete() {
            return this.checked;
        }

        @Override
        public boolean isBlank() {
            return !this.checked;
        }

        @Override
        public boolean checkIf(R row, Predicate<C> columnCheckPredicate) {
            if (!row.equals(this.row)) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            if (this.checked) {
                return true;
            }
            if (columnCheckPredicate.test(this.column)) {
                this.checked = true;
            }
            return this.checked;
        }

        @Override
        public boolean checkIf(Predicate<R> rowCheckPredicate, C column) {
            if (!column.equals(this.column)) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            if (this.checked) {
                return true;
            }
            if (rowCheckPredicate.test(this.row)) {
                this.checked = true;
            }
            return this.checked;
        }

        @Override
        public void uncheckIf(R row, Predicate<C> columnCheckPredicate) {
            if (!row.equals(this.row)) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            if (this.checked && columnCheckPredicate.test(this.column)) {
                this.checked = false;
            }
        }

        @Override
        public void uncheckIf(Predicate<R> rowCheckPredicate, C column) {
            if (!column.equals(this.column)) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            if (this.checked && rowCheckPredicate.test(this.row)) {
                this.checked = false;
            }
        }

        @Override
        public boolean isChecked(R row, C column) {
            if (!row.equals(this.row)) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            if (!column.equals(this.column)) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            return this.checked;
        }

        @Override
        public boolean isRowComplete(R row) {
            if (!row.equals(this.row)) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            return this.checked;
        }

        @Override
        public boolean isColumnComplete(C column) {
            if (!column.equals(this.column)) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            return this.checked;
        }

        @Override
        public String toString(String checkedIndicator, String uncheckedIndicator) {
            return this.row + "/" + this.column + ": " + (this.checked ? checkedIndicator : uncheckedIndicator);
        }

        @Override
        public String toTableString(String checkedIndicator, String uncheckedIndicator) {
            StringBuilder result = new StringBuilder();
            int rowHeaderWidth = this.row.toString().length() + 1;
            SingleCellCheckTable.appendPadded("", rowHeaderWidth, ' ', result);
            result.append("|");
            String columnLabel = this.column.toString();
            if (columnLabel.length() > 40) {
                columnLabel = columnLabel.substring(0, 40);
            }
            int columnWidth = columnLabel.length();
            result.append(" ").append(columnLabel).append(" |");
            result.append("\n");
            result.append(this.row.toString());
            result.append(" |");
            String v = this.checked ? checkedIndicator : uncheckedIndicator;
            result.append(" ");
            SingleCellCheckTable.appendPadded(v, columnWidth, ' ', result);
            result.append(" |");
            return result.toString();
        }

        @Override
        public Set<R> getCompleteRows() {
            if (this.checked) {
                return this.rowSet;
            }
            return IndexedImmutableSetImpl.empty();
        }

        @Override
        public Set<C> getCompleteColumns() {
            if (this.checked) {
                return this.columnSet;
            }
            return IndexedImmutableSetImpl.empty();
        }

        @Override
        public Set<R> getIncompleteRows() {
            if (this.checked) {
                return IndexedImmutableSetImpl.empty();
            }
            return this.rowSet;
        }

        @Override
        public Set<C> getIncompleteColumns() {
            if (this.checked) {
                return IndexedImmutableSetImpl.empty();
            }
            return this.columnSet;
        }

        @Override
        public Set<R> getCheckedRows(C column) {
            if (!column.equals(this.column)) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            return this.getCompleteRows();
        }

        @Override
        public Set<C> getCheckedColumns(R row) {
            if (!row.equals(this.row)) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            return this.getCompleteColumns();
        }

        @Override
        public Set<R> getRows() {
            return this.rowSet;
        }

        @Override
        public Set<C> getColumns() {
            return this.columnSet;
        }

        @Override
        public void uncheckAll() {
            this.checked = false;
        }

        @Override
        public void uncheckRowIf(Predicate<R> rowCheckPredicate) {
            if (rowCheckPredicate.test(this.row)) {
                this.checked = false;
            }
        }

        @Override
        public void uncheckRow(R row) {
            if (!this.row.equals(row)) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            this.checked = false;
        }

        @Override
        public void uncheckRowIfPresent(R row) {
            if (this.row.equals(row)) {
                this.checked = false;
            }
        }

        @Override
        public Iterable<R> iterateUncheckedRows(C column) {
            if (this.column.equals(column)) {
                if (this.checked) {
                    return IndexedImmutableSetImpl.empty();
                }
                return this.rowSet;
            }
            throw new IllegalArgumentException("Invalid column: " + column);
        }

        @Override
        public Iterable<C> iterateUncheckedColumns(R row) {
            if (this.row.equals(row)) {
                if (this.checked) {
                    return IndexedImmutableSetImpl.empty();
                }
                return this.columnSet;
            }
            throw new IllegalArgumentException("Invalid row: " + row);
        }

        @Override
        public Iterable<R> iterateCheckedRows(C column) {
            if (this.column.equals(column)) {
                if (this.checked) {
                    return this.rowSet;
                }
                return IndexedImmutableSetImpl.empty();
            }
            throw new IllegalArgumentException("Invalid column: " + column);
        }

        @Override
        public Iterable<C> iterateCheckedColumns(R row) {
            if (this.row.equals(row)) {
                if (this.checked) {
                    return this.columnSet;
                }
                return IndexedImmutableSetImpl.empty();
            }
            throw new IllegalArgumentException("Invalid row: " + row);
        }

        @Override
        public boolean containsCellFor(R row, C column) {
            return this.row.equals(row) && this.column.equals(column);
        }
    }

    static final class SingleRowCheckTable<R, C>
    extends AbstractCheckTable<R, C> {
        private final R row;
        private final CheckList<C> columns;

        SingleRowCheckTable(R row, Set<C> columns) {
            this.row = row;
            this.columns = CheckListImpl.create(columns, "column");
        }

        @Override
        public boolean check(R row, C column) {
            if (!row.equals(this.row)) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            return this.columns.check(column);
        }

        @Override
        public void uncheck(R row, C column) {
            if (!row.equals(this.row)) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            this.columns.uncheck(column);
        }

        @Override
        public boolean isComplete() {
            return this.columns.isComplete();
        }

        @Override
        public boolean isBlank() {
            return this.columns.isBlank();
        }

        @Override
        public boolean checkIf(R row, Predicate<C> columnCheckPredicate) {
            if (!row.equals(this.row)) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            return this.columns.checkIf(columnCheckPredicate);
        }

        @Override
        public boolean checkIf(Predicate<R> rowCheckPredicate, C column) {
            if (this.isComplete()) {
                return true;
            }
            if (rowCheckPredicate.test(this.row)) {
                return this.columns.check(column);
            }
            return false;
        }

        @Override
        public void uncheckIf(R row, Predicate<C> columnCheckPredicate) {
            if (!row.equals(this.row)) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            this.columns.uncheckIf(columnCheckPredicate);
        }

        @Override
        public void uncheckIf(Predicate<R> rowCheckPredicate, C column) {
            if (this.columns.isChecked(column) && rowCheckPredicate.test(this.row)) {
                this.columns.uncheck(column);
            }
        }

        @Override
        public boolean isChecked(R row, C column) {
            if (!row.equals(this.row)) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            return this.columns.isChecked(column);
        }

        @Override
        public boolean isRowComplete(R row) {
            if (!row.equals(this.row)) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            return this.isComplete();
        }

        @Override
        public boolean isColumnComplete(C column) {
            return this.columns.isChecked(column);
        }

        @Override
        public String toTableString(String checkedIndicator, String uncheckedIndicator) {
            StringBuilder result = new StringBuilder();
            int rowHeaderWidth = this.row.toString().length() + 1;
            SingleRowCheckTable.appendPadded("", rowHeaderWidth, ' ', result);
            result.append("|");
            int[] columnWidth = new int[this.columns.size()];
            int i = 0;
            for (C column : this.columns.getElements()) {
                String columnLabel = column.toString();
                if (columnLabel.length() > 40) {
                    columnLabel = columnLabel.substring(0, 40);
                }
                columnWidth[i] = columnLabel.length();
                ++i;
                result.append(" ").append(columnLabel).append(" |");
            }
            result.append("\n");
            result.append(this.row.toString());
            result.append(" |");
            i = 0;
            for (C column : this.columns.getElements()) {
                String v = this.columns.isChecked(column) ? checkedIndicator : uncheckedIndicator;
                result.append(" ");
                SingleRowCheckTable.appendPadded(v, columnWidth[i], ' ', result);
                result.append(" |");
                ++i;
            }
            return result.toString();
        }

        @Override
        public String toString(String checkedIndicator, String uncheckedIndicator) {
            return this.toTableString(checkedIndicator, uncheckedIndicator);
        }

        @Override
        public Set<R> getCompleteRows() {
            if (this.isComplete()) {
                return IndexedImmutableSetImpl.of(this.row);
            }
            return IndexedImmutableSetImpl.empty();
        }

        @Override
        public Set<C> getCompleteColumns() {
            return this.columns.getCheckedElements();
        }

        @Override
        public Set<R> getIncompleteRows() {
            if (this.isComplete()) {
                return IndexedImmutableSetImpl.empty();
            }
            return IndexedImmutableSetImpl.of(this.row);
        }

        @Override
        public Set<C> getIncompleteColumns() {
            return this.columns.getUncheckedElements();
        }

        @Override
        public Set<R> getRows() {
            return IndexedImmutableSetImpl.of(this.row);
        }

        @Override
        public Set<C> getColumns() {
            return this.columns.getElements();
        }

        @Override
        public void uncheckAll() {
            this.columns.uncheckAll();
        }

        @Override
        public void uncheckRowIf(Predicate<R> rowCheckPredicate) {
            if (rowCheckPredicate.test(this.row)) {
                this.columns.uncheckAll();
            }
        }

        @Override
        public void uncheckRow(R row) {
            if (!this.row.equals(row)) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            this.columns.uncheckAll();
        }

        @Override
        public void uncheckRowIfPresent(R row) {
            if (this.row.equals(row)) {
                this.columns.uncheckAll();
            }
        }

        @Override
        public Iterable<R> iterateUncheckedRows(C column) {
            if (this.columns.isChecked(column)) {
                return IndexedImmutableSetImpl.empty();
            }
            return IndexedImmutableSetImpl.of(this.row);
        }

        @Override
        public Iterable<C> iterateUncheckedColumns(R row) {
            if (this.row.equals(row)) {
                return this.columns.iterateUncheckedElements();
            }
            throw new IllegalArgumentException("Invalid row: " + row);
        }

        @Override
        public Set<R> getCheckedRows(C column) {
            if (this.columns.isChecked(column)) {
                return IndexedImmutableSetImpl.of(this.row);
            }
            return IndexedImmutableSetImpl.empty();
        }

        @Override
        public Set<C> getCheckedColumns(R row) {
            if (this.row.equals(row)) {
                return this.columns.getCheckedElements();
            }
            throw new IllegalArgumentException("Invalid row: " + row);
        }

        @Override
        public Iterable<R> iterateCheckedRows(C column) {
            return this.getCheckedRows(column);
        }

        @Override
        public Iterable<C> iterateCheckedColumns(R row) {
            if (this.row.equals(row)) {
                return this.columns.iterateCheckedElements();
            }
            throw new IllegalArgumentException("Invalid row: " + row);
        }

        @Override
        public boolean containsCellFor(R row, C column) {
            return this.row.equals(row) && this.columns.getElements().contains(column);
        }
    }

    static final class SingleColumnCheckTable<R, C>
    extends AbstractCheckTable<R, C> {
        private final C column;
        private final CheckList<R> rows;

        SingleColumnCheckTable(Set<R> rows, C column) {
            this.column = column;
            this.rows = CheckListImpl.create(rows, "row");
        }

        @Override
        public boolean check(R row, C column) {
            if (!column.equals(this.column)) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            return this.rows.check(row);
        }

        @Override
        public void uncheck(R row, C column) {
            if (!column.equals(this.column)) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            this.rows.uncheck(row);
        }

        @Override
        public boolean checkIf(R row, Predicate<C> columnCheckPredicate) {
            if (this.isComplete()) {
                return true;
            }
            if (columnCheckPredicate.test(this.column)) {
                return this.rows.check(row);
            }
            return false;
        }

        @Override
        public boolean checkIf(Predicate<R> rowCheckPredicate, C column) {
            if (!column.equals(this.column)) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            return this.rows.checkIf(rowCheckPredicate);
        }

        @Override
        public void uncheckIf(R row, Predicate<C> columnCheckPredicate) {
            if (!this.rows.getElements().contains(row)) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            if (this.rows.isChecked(row) && columnCheckPredicate.test(this.column)) {
                this.rows.uncheck(row);
            }
        }

        @Override
        public void uncheckIf(Predicate<R> rowCheckPredicate, C column) {
            if (!column.equals(this.column)) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            this.rows.uncheckIf(rowCheckPredicate);
        }

        @Override
        public boolean isChecked(R row, C column) {
            if (!column.equals(this.column)) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            return this.rows.isChecked(row);
        }

        @Override
        public boolean isRowComplete(R row) {
            return this.rows.isChecked(row);
        }

        @Override
        public boolean isColumnComplete(C column) {
            if (!column.equals(this.column)) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            return this.isComplete();
        }

        @Override
        public String toTableString(String checkedIndicator, String uncheckedIndicator) {
            StringBuilder result = new StringBuilder();
            int rowHeaderWidth = this.rows.getElements().stream().map(r -> r.toString().length()).max(Comparator.naturalOrder()).get();
            SingleColumnCheckTable.appendPadded("", rowHeaderWidth, ' ', result);
            result.append("|");
            String columnLabel = this.column.toString();
            int columnWidth = columnLabel.length();
            result.append(" ").append(columnLabel).append(" |");
            result.append("\n");
            for (R row : this.rows.getElements()) {
                SingleColumnCheckTable.appendPadded(row.toString(), rowHeaderWidth, ' ', result);
                result.append("|");
                String v = this.rows.isChecked(row) ? checkedIndicator : uncheckedIndicator;
                result.append(" ");
                SingleColumnCheckTable.appendPadded(v, columnWidth, ' ', result);
                result.append(" |\n");
            }
            return result.toString();
        }

        @Override
        public boolean isComplete() {
            return this.rows.isComplete();
        }

        @Override
        public boolean isBlank() {
            return this.rows.isBlank();
        }

        @Override
        public Set<R> getCompleteRows() {
            return this.rows.getCheckedElements();
        }

        @Override
        public Set<C> getCompleteColumns() {
            if (this.isComplete()) {
                return IndexedImmutableSetImpl.of(this.column);
            }
            return IndexedImmutableSetImpl.empty();
        }

        @Override
        public Set<R> getIncompleteRows() {
            return this.rows.getUncheckedElements();
        }

        @Override
        public Set<C> getIncompleteColumns() {
            if (this.isComplete()) {
                return IndexedImmutableSetImpl.empty();
            }
            return IndexedImmutableSetImpl.of(this.column);
        }

        @Override
        public Set<R> getRows() {
            return this.rows.getElements();
        }

        @Override
        public Set<C> getColumns() {
            return IndexedImmutableSetImpl.of(this.column);
        }

        @Override
        public void uncheckAll() {
            this.rows.uncheckAll();
        }

        @Override
        public void uncheckRowIf(Predicate<R> rowCheckPredicate) {
            this.rows.uncheckIf(rowCheckPredicate);
        }

        @Override
        public void uncheckRow(R row) {
            this.rows.uncheck(row);
        }

        @Override
        public void uncheckRowIfPresent(R row) {
            this.rows.uncheckIfPresent(row);
        }

        @Override
        public Set<R> getCheckedRows(C column) {
            if (this.column.equals(column)) {
                return this.rows.getCheckedElements();
            }
            throw new IllegalArgumentException("Invalid column: " + column);
        }

        @Override
        public Set<C> getCheckedColumns(R row) {
            if (this.rows.isChecked(row)) {
                return IndexedImmutableSetImpl.of(this.column);
            }
            return IndexedImmutableSetImpl.empty();
        }

        @Override
        public Iterable<R> iterateCheckedRows(C column) {
            if (this.column.equals(column)) {
                return this.rows.iterateCheckedElements();
            }
            throw new IllegalArgumentException("Invalid column: " + column);
        }

        @Override
        public Iterable<C> iterateCheckedColumns(R row) {
            return this.getCheckedColumns(row);
        }

        @Override
        public Iterable<R> iterateUncheckedRows(C column) {
            if (this.column.equals(column)) {
                return this.rows.iterateUncheckedElements();
            }
            throw new IllegalArgumentException("Invalid column: " + column);
        }

        @Override
        public Iterable<C> iterateUncheckedColumns(R row) {
            if (this.rows.isChecked(row)) {
                return IndexedImmutableSetImpl.empty();
            }
            return IndexedImmutableSetImpl.of(this.column);
        }

        @Override
        public boolean containsCellFor(R row, C column) {
            return this.column.equals(column) && this.rows.getElements().contains(row);
        }
    }

    static final class ArrayCheckTable<R, C>
    extends AbstractCheckTable<R, C> {
        private final IndexedImmutableSetImpl<R> rows;
        private final IndexedImmutableSetImpl<C> columns;
        private final boolean[] table;
        private int checkedCount = 0;
        private int uncheckedCount;
        private final int size;
        private final int rowCount;
        private final int columnCount;

        ArrayCheckTable(Set<R> rows, Set<C> columns) {
            this.rows = IndexedImmutableSetImpl.of(rows);
            this.columns = IndexedImmutableSetImpl.of(columns);
            this.size = this.rows.size() * this.columns.size();
            this.table = new boolean[this.size];
            this.rowCount = this.rows.size();
            this.columnCount = this.columns.size();
            this.uncheckedCount = this.size;
        }

        private int tableIndex(int rowIndex, int columnIndex) {
            return rowIndex + columnIndex * this.rowCount;
        }

        @Override
        public boolean check(R row, C column) {
            int rowIndex = this.rows.elementToIndex((Object)row);
            if (rowIndex == -1) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            int columnIndex = this.columns.elementToIndex((Object)column);
            if (columnIndex == -1) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            int i = this.tableIndex(rowIndex, columnIndex);
            if (!this.table[i]) {
                this.table[i] = true;
                ++this.checkedCount;
                --this.uncheckedCount;
            }
            return this.uncheckedCount == 0;
        }

        @Override
        public void uncheck(R row, C column) {
            int rowIndex = this.rows.elementToIndex((Object)row);
            if (rowIndex == -1) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            int columnIndex = this.columns.elementToIndex((Object)column);
            if (columnIndex == -1) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            int i = this.tableIndex(rowIndex, columnIndex);
            if (this.table[i]) {
                this.table[i] = false;
                --this.checkedCount;
                ++this.uncheckedCount;
            }
        }

        @Override
        public void uncheckAll() {
            this.checkedCount = 0;
            this.uncheckedCount = this.size;
            Arrays.fill(this.table, false);
        }

        @Override
        public void uncheckRowIf(Predicate<R> rowCheckPredicate) {
            if (this.isBlank()) {
                return;
            }
            for (int rowIndex = 0; rowIndex < this.rowCount; ++rowIndex) {
                R row = this.rows.indexToElement(rowIndex);
                if (!rowCheckPredicate.test(row)) continue;
                for (int columnIndex = 0; columnIndex < this.columnCount; ++columnIndex) {
                    int i = this.tableIndex(rowIndex, columnIndex);
                    if (!this.table[i]) continue;
                    this.table[i] = false;
                    --this.checkedCount;
                    ++this.uncheckedCount;
                    if (this.checkedCount != 0) continue;
                    return;
                }
            }
        }

        @Override
        public void uncheckRow(R row) {
            int rowIndex = this.rows.elementToIndex((Object)row);
            if (rowIndex == -1) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            if (this.isBlank()) {
                return;
            }
            for (int columnIndex = 0; columnIndex < this.columnCount; ++columnIndex) {
                int i = this.tableIndex(rowIndex, columnIndex);
                if (!this.table[i]) continue;
                this.table[i] = false;
                --this.checkedCount;
                ++this.uncheckedCount;
                if (this.checkedCount != 0) continue;
                return;
            }
        }

        @Override
        public void uncheckRowIfPresent(R row) {
            int rowIndex = this.rows.elementToIndex((Object)row);
            if (rowIndex == -1) {
                return;
            }
            if (this.isBlank()) {
                return;
            }
            for (int columnIndex = 0; columnIndex < this.columnCount; ++columnIndex) {
                int i = this.tableIndex(rowIndex, columnIndex);
                if (!this.table[i]) continue;
                this.table[i] = false;
                --this.checkedCount;
                ++this.uncheckedCount;
                if (this.checkedCount != 0) continue;
                return;
            }
        }

        @Override
        public boolean isComplete() {
            return this.uncheckedCount == 0;
        }

        @Override
        public boolean isBlank() {
            return this.checkedCount == 0;
        }

        @Override
        public boolean isChecked(R row, C column) {
            int rowIndex = this.rows.elementToIndex((Object)row);
            if (rowIndex == -1) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            int columnIndex = this.columns.elementToIndex((Object)column);
            if (columnIndex == -1) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            int i = this.tableIndex(rowIndex, columnIndex);
            return this.table[i];
        }

        @Override
        public boolean checkIf(R row, Predicate<C> columnCheckPredicate) {
            int rowIndex = this.rows.elementToIndex((Object)row);
            if (rowIndex == -1) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            for (int columnIndex = 0; columnIndex < this.columnCount; ++columnIndex) {
                int i = this.tableIndex(rowIndex, columnIndex);
                if (this.table[i] || !columnCheckPredicate.test(this.columns.indexToElement(columnIndex))) continue;
                this.table[i] = true;
                ++this.checkedCount;
                --this.uncheckedCount;
                if (this.uncheckedCount != 0) continue;
                return true;
            }
            return this.uncheckedCount == 0;
        }

        @Override
        public boolean checkIf(Predicate<R> rowCheckPredicate, C column) {
            int columnIndex = this.columns.elementToIndex((Object)column);
            if (columnIndex == -1) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            for (int rowIndex = 0; rowIndex < this.rowCount; ++rowIndex) {
                int i = this.tableIndex(rowIndex, columnIndex);
                if (this.table[i] || !rowCheckPredicate.test(this.rows.indexToElement(rowIndex))) continue;
                this.table[i] = true;
                ++this.checkedCount;
                --this.uncheckedCount;
                if (this.uncheckedCount != 0) continue;
                return true;
            }
            return this.uncheckedCount == 0;
        }

        @Override
        public Iterable<R> iterateUncheckedRows(C column) {
            final int columnIndex = this.columns.elementToIndex((Object)column);
            if (columnIndex == -1) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            if (this.uncheckedCount == 0) {
                return IndexedImmutableSetImpl.empty();
            }
            return new Iterable<R>(){

                @Override
                public Iterator<R> iterator() {
                    return new Iterator<R>(){
                        int rowIndex = this.findNext(0);

                        @Override
                        public boolean hasNext() {
                            return this.rowIndex != -1;
                        }

                        @Override
                        public R next() {
                            Object result = rows.indexToElement(this.rowIndex);
                            this.rowIndex = this.findNext(this.rowIndex + 1);
                            return result;
                        }

                        int findNext(int start) {
                            for (int rowIndex = start; rowIndex < rowCount; ++rowIndex) {
                                int i = this.tableIndex(rowIndex, columnIndex);
                                if (table[i]) continue;
                                return rowIndex;
                            }
                            return -1;
                        }
                    };
                }
            };
        }

        @Override
        public Iterable<C> iterateUncheckedColumns(R row) {
            final int rowIndex = this.rows.elementToIndex((Object)row);
            if (rowIndex == -1) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            if (this.uncheckedCount == 0) {
                return IndexedImmutableSetImpl.empty();
            }
            return new Iterable<C>(){

                @Override
                public Iterator<C> iterator() {
                    return new Iterator<C>(){
                        int columnIndex = this.findNext(0);

                        @Override
                        public boolean hasNext() {
                            return this.columnIndex != -1;
                        }

                        @Override
                        public C next() {
                            Object result = columns.indexToElement(this.columnIndex);
                            this.columnIndex = this.findNext(this.columnIndex + 1);
                            return result;
                        }

                        int findNext(int start) {
                            for (int columnIndex = start; columnIndex < columnCount; ++columnIndex) {
                                int i = this.tableIndex(rowIndex, columnIndex);
                                if (table[i]) continue;
                                return columnIndex;
                            }
                            return -1;
                        }
                    };
                }
            };
        }

        @Override
        public Iterable<R> iterateCheckedRows(C column) {
            final int columnIndex = this.columns.elementToIndex((Object)column);
            if (columnIndex == -1) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            if (this.uncheckedCount == 0) {
                return this.rows;
            }
            return new Iterable<R>(){

                @Override
                public Iterator<R> iterator() {
                    return new Iterator<R>(){
                        int rowIndex = this.findNext(0);

                        @Override
                        public boolean hasNext() {
                            return this.rowIndex != -1;
                        }

                        @Override
                        public R next() {
                            Object result = rows.indexToElement(this.rowIndex);
                            this.rowIndex = this.findNext(this.rowIndex + 1);
                            return result;
                        }

                        int findNext(int start) {
                            for (int rowIndex = start; rowIndex < rowCount; ++rowIndex) {
                                int i = this.tableIndex(rowIndex, columnIndex);
                                if (!table[i]) continue;
                                return rowIndex;
                            }
                            return -1;
                        }
                    };
                }
            };
        }

        @Override
        public Iterable<C> iterateCheckedColumns(R row) {
            final int rowIndex = this.rows.elementToIndex((Object)row);
            if (rowIndex == -1) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            if (this.uncheckedCount == 0) {
                return this.columns;
            }
            return new Iterable<C>(){

                @Override
                public Iterator<C> iterator() {
                    return new Iterator<C>(){
                        int columnIndex = this.findNext(0);

                        @Override
                        public boolean hasNext() {
                            return this.columnIndex != -1;
                        }

                        @Override
                        public C next() {
                            Object result = columns.indexToElement(this.columnIndex);
                            this.columnIndex = this.findNext(this.columnIndex + 1);
                            return result;
                        }

                        int findNext(int start) {
                            for (int columnIndex = start; columnIndex < columnCount; ++columnIndex) {
                                int i = this.tableIndex(rowIndex, columnIndex);
                                if (!table[i]) continue;
                                return columnIndex;
                            }
                            return -1;
                        }
                    };
                }
            };
        }

        @Override
        public void uncheckIf(R row, Predicate<C> columnCheckPredicate) {
            int rowIndex = this.rows.elementToIndex((Object)row);
            if (rowIndex == -1) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            if (this.checkedCount == 0) {
                return;
            }
            for (int columnIndex = 0; columnIndex < this.columnCount; ++columnIndex) {
                int i = this.tableIndex(rowIndex, columnIndex);
                if (!this.table[i] || !columnCheckPredicate.test(this.columns.indexToElement(columnIndex))) continue;
                this.table[i] = false;
                --this.checkedCount;
                ++this.uncheckedCount;
                if (this.checkedCount != 0) continue;
                return;
            }
        }

        @Override
        public void uncheckIf(Predicate<R> rowCheckPredicate, C column) {
            int columnIndex = this.columns.elementToIndex((Object)column);
            if (columnIndex == -1) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            if (this.checkedCount == 0) {
                return;
            }
            for (int rowIndex = 0; rowIndex < this.rowCount; ++rowIndex) {
                int i = this.tableIndex(rowIndex, columnIndex);
                if (!this.table[i] || !rowCheckPredicate.test(this.rows.indexToElement(rowIndex))) continue;
                this.table[i] = false;
                --this.checkedCount;
                ++this.uncheckedCount;
                if (this.checkedCount != 0) continue;
                return;
            }
        }

        @Override
        public String toTableString(String checkedIndicator, String uncheckedIndicator) {
            StringBuilder result = new StringBuilder();
            int rowHeaderWidth = this.rows.stream().map(r -> r.toString().length()).max(Comparator.naturalOrder()).get();
            ArrayCheckTable.appendPadded("", rowHeaderWidth, ' ', result);
            result.append("|");
            int[] columnWidth = new int[this.columns.size()];
            int i = 0;
            for (Object column : this.columns) {
                String columnLabel = column.toString();
                if (columnLabel.length() > 40) {
                    columnLabel = columnLabel.substring(0, 40);
                }
                columnWidth[i] = columnLabel.length();
                ++i;
                result.append(" ").append(columnLabel).append(" |");
            }
            result.append("\n");
            for (Object row : this.rows) {
                ArrayCheckTable.appendPadded(row.toString(), rowHeaderWidth, ' ', result);
                result.append("|");
                i = 0;
                for (Object column : this.columns) {
                    String v = this.isChecked(row, column) ? checkedIndicator : uncheckedIndicator;
                    result.append(" ");
                    ArrayCheckTable.appendPadded(v, columnWidth[i], ' ', result);
                    result.append(" |");
                    ++i;
                }
                result.append("\n");
            }
            return result.toString();
        }

        @Override
        public Set<R> getCompleteRows() {
            if (this.isBlank()) {
                return IndexedImmutableSetImpl.empty();
            }
            if (this.isComplete()) {
                return this.rows;
            }
            int estimatedRows = Math.min(this.checkedCount / this.columnCount + 12, this.rowCount - 1);
            IndexedImmutableSetImpl.InternalBuilder<R> builder = IndexedImmutableSetImpl.builder(estimatedRows);
            for (int rowIndex = 0; rowIndex < this.rowCount; ++rowIndex) {
                if (!this.isRowCompleted(rowIndex)) continue;
                R row = this.rows.indexToElement(rowIndex);
                builder = builder.with(row);
            }
            return builder.build();
        }

        @Override
        public Set<C> getCompleteColumns() {
            if (this.isBlank()) {
                return IndexedImmutableSetImpl.empty();
            }
            if (this.isComplete()) {
                return this.columns;
            }
            int estimatedColumns = Math.min(this.checkedCount / this.rowCount + 12, this.columnCount - 1);
            IndexedImmutableSetImpl.InternalBuilder<C> builder = IndexedImmutableSetImpl.builder(estimatedColumns);
            for (int columnIndex = 0; columnIndex < this.columnCount; ++columnIndex) {
                if (!this.isColumnCompleted(columnIndex)) continue;
                C column = this.columns.indexToElement(columnIndex);
                builder = builder.with(column);
            }
            return builder.build();
        }

        @Override
        public Set<R> getIncompleteRows() {
            if (this.isComplete()) {
                return IndexedImmutableSetImpl.empty();
            }
            if (this.isBlank()) {
                return this.rows;
            }
            int estimatedRows = Math.min(this.uncheckedCount / this.columnCount + 12, this.rowCount - 1);
            IndexedImmutableSetImpl.InternalBuilder<R> builder = IndexedImmutableSetImpl.builder(estimatedRows);
            for (int rowIndex = 0; rowIndex < this.rowCount; ++rowIndex) {
                if (this.isRowCompleted(rowIndex)) continue;
                R row = this.rows.indexToElement(rowIndex);
                builder = builder.with(row);
            }
            return builder.build();
        }

        @Override
        public Set<C> getIncompleteColumns() {
            if (this.isComplete()) {
                return IndexedImmutableSetImpl.empty();
            }
            if (this.isBlank()) {
                return this.columns;
            }
            int estimatedColumns = Math.min(this.uncheckedCount / this.rowCount + 12, this.columnCount - 1);
            IndexedImmutableSetImpl.InternalBuilder<C> builder = IndexedImmutableSetImpl.builder(estimatedColumns);
            for (int columnIndex = 0; columnIndex < this.columnCount; ++columnIndex) {
                if (this.isColumnCompleted(columnIndex)) continue;
                C column = this.columns.indexToElement(columnIndex);
                builder = builder.with(column);
            }
            return builder.build();
        }

        @Override
        public boolean isRowComplete(R row) {
            int rowIndex = this.rows.elementToIndex((Object)row);
            if (rowIndex == -1) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            return this.isRowCompleted(rowIndex);
        }

        @Override
        public boolean isColumnComplete(C column) {
            int columnIndex = this.columns.elementToIndex((Object)column);
            if (columnIndex == -1) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            return this.isColumnCompleted(columnIndex);
        }

        @Override
        public Set<R> getCheckedRows(C column) {
            int columnIndex = this.columns.elementToIndex((Object)column);
            if (columnIndex == -1) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            if (this.checkedCount == 0) {
                return IndexedImmutableSetImpl.empty();
            }
            IndexedImmutableSetImpl.InternalBuilder<R> builder = IndexedImmutableSetImpl.builder(this.rowCount);
            for (int rowIndex = 0; rowIndex < this.rowCount; ++rowIndex) {
                int i = this.tableIndex(rowIndex, columnIndex);
                if (!this.table[i]) continue;
                builder = builder.with(this.rows.indexToElement(rowIndex));
            }
            return builder.build();
        }

        @Override
        public Set<C> getCheckedColumns(R row) {
            int rowIndex = this.rows.elementToIndex((Object)row);
            if (rowIndex == -1) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            if (this.checkedCount == 0) {
                return IndexedImmutableSetImpl.empty();
            }
            IndexedImmutableSetImpl.InternalBuilder<C> builder = IndexedImmutableSetImpl.builder(this.columnCount);
            for (int columnIndex = 0; columnIndex < this.columnCount; ++columnIndex) {
                int i = this.tableIndex(rowIndex, columnIndex);
                if (!this.table[i]) continue;
                builder = builder.with(this.columns.indexToElement(columnIndex));
            }
            return builder.build();
        }

        private boolean isRowCompleted(int rowIndex) {
            int start = this.tableIndex(rowIndex, 0);
            int end = this.tableIndex(rowIndex, this.columnCount - 1);
            int inc = this.rowCount;
            for (int i = start; i <= end; i += inc) {
                if (this.table[i]) continue;
                return false;
            }
            return true;
        }

        private boolean isColumnCompleted(int columnIndex) {
            int start = this.tableIndex(0, columnIndex);
            int end = this.tableIndex(this.rowCount - 1, columnIndex);
            for (int i = start; i <= end; ++i) {
                if (this.table[i]) continue;
                return false;
            }
            return true;
        }

        @Override
        public Set<R> getRows() {
            return this.rows;
        }

        @Override
        public Set<C> getColumns() {
            return this.columns;
        }

        @Override
        public boolean containsCellFor(R row, C column) {
            return this.rows.contains(row) && this.columns.contains(column);
        }
    }

    static abstract class AbstractCheckTable<R, C>
    implements CheckTable<R, C> {
        static final int STRING_TABLE_HEADER_WIDTH = 40;

        AbstractCheckTable() {
        }

        @Override
        public boolean checkIf(Iterable<R> rows, Predicate<C> columnCheckPredicate) {
            for (R row : rows) {
                if (!this.checkIf(row, columnCheckPredicate)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void uncheckIf(Iterable<R> rows, Predicate<C> columnCheckPredicate) {
            if (this.isBlank()) {
                return;
            }
            for (R row : rows) {
                this.uncheckIf(row, columnCheckPredicate);
                if (!this.isBlank()) continue;
                return;
            }
        }

        @Override
        public void uncheckIf(Predicate<R> rowCheckPredicate, Iterable<C> columns) {
            if (this.isBlank()) {
                return;
            }
            for (C column : columns) {
                this.uncheckIf(rowCheckPredicate, column);
                if (!this.isBlank()) continue;
                return;
            }
        }

        @Override
        public boolean isRowIncomplete(R row) {
            return !this.isRowComplete(row);
        }

        @Override
        public boolean isColumnIncomplete(C column) {
            return !this.isColumnComplete(column);
        }

        @Override
        public String toString() {
            return this.toString("x", "");
        }

        @Override
        public String toTableString() {
            return this.toTableString("x", "");
        }

        @Override
        public String toString(String checkedIndicator, String uncheckedIndicator) {
            return this.toTableString(checkedIndicator, uncheckedIndicator);
        }

        static void appendPadded(String string, int width, char paddingChar, StringBuilder resultBuilder) {
            resultBuilder.append(string);
            for (int length = string.length(); length < width; ++length) {
                resultBuilder.append(paddingChar);
            }
        }
    }
}

