/*
 * Decompiled with CFR 0.152.
 */
package com.password4j;

import com.password4j.AbstractHashingFunction;
import com.password4j.BadParametersException;
import com.password4j.Hash;
import com.password4j.HashingFunction;
import com.password4j.SaltGenerator;
import com.password4j.Utils;
import com.password4j.types.Hmac;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class PBKDF2Function
extends AbstractHashingFunction {
    private static final Map<String, PBKDF2Function> INSTANCES = new ConcurrentHashMap<String, PBKDF2Function>();
    private static final String ALGORITHM_PREFIX = "PBKDF2WithHmac";
    protected Hmac algorithm;
    protected String algorithmAsString;
    protected int iterations;
    protected int length;

    protected PBKDF2Function() {
    }

    protected PBKDF2Function(int iterations, int length) {
        this.iterations = iterations;
        this.length = length;
    }

    protected PBKDF2Function(Hmac algorithm, int iterations, int length) {
        this(iterations, length);
        this.algorithm = algorithm;
        this.algorithmAsString = algorithm.name();
    }

    protected PBKDF2Function(String algorithm, int iterations, int length) {
        this(iterations, length);
        this.algorithmAsString = algorithm;
    }

    public static PBKDF2Function getInstance(Hmac algorithm, int iterations, int length) {
        return PBKDF2Function.getInstance(algorithm.name(), iterations, length);
    }

    public static PBKDF2Function getInstance(String algorithm, int iterations, int length) {
        String key = PBKDF2Function.getUID(algorithm, iterations, length);
        if (INSTANCES.containsKey(key)) {
            return INSTANCES.get(key);
        }
        PBKDF2Function function = new PBKDF2Function(algorithm, iterations, length);
        INSTANCES.put(key, function);
        return function;
    }

    protected static SecretKey internalHash(byte[] plainTextPassword, byte[] salt, String algorithm, int iterations, int length) throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (salt == null) {
            throw new IllegalArgumentException("Salt cannot be null");
        }
        return PBKDF2Function.internalHash(Utils.fromBytesToChars(plainTextPassword), salt, algorithm, iterations, length);
    }

    protected static SecretKey internalHash(char[] plain, byte[] salt, String algorithm, int iterations, int length) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(ALGORITHM_PREFIX + algorithm);
        PBEKeySpec spec = new PBEKeySpec(plain, salt, iterations, length);
        return secretKeyFactory.generateSecret(spec);
    }

    protected static String getUID(String algorithm, int iterations, int length) {
        return algorithm + "|" + iterations + "|" + length;
    }

    protected static String toString(String algorithm, int iterations, int length) {
        return "a=" + algorithm + ", i=" + iterations + ", l=" + length;
    }

    @Override
    public Hash hash(CharSequence plainTextPassword) {
        byte[] salt = SaltGenerator.generate();
        return this.hash(Utils.fromCharSequenceToBytes(plainTextPassword), salt);
    }

    @Override
    public Hash hash(byte[] plainTextPasswordAsBytes) {
        byte[] salt = SaltGenerator.generate();
        return this.hash(plainTextPasswordAsBytes, salt);
    }

    @Override
    public Hash hash(CharSequence plainTextPassword, String salt) {
        return this.hash(Utils.fromCharSequenceToBytes(plainTextPassword), Utils.fromCharSequenceToBytes(salt));
    }

    @Override
    public Hash hash(byte[] plainTextPassword, byte[] salt) {
        try {
            SecretKey key = PBKDF2Function.internalHash(plainTextPassword, salt, this.algorithmAsString, this.iterations, this.length);
            byte[] encodedKey = key.getEncoded();
            return new Hash((HashingFunction)this, this.getHash(encodedKey, salt), encodedKey, salt);
        }
        catch (NoSuchAlgorithmException nsae) {
            String message = "`" + (Object)((Object)this.algorithm) + "` is not a valid algorithm";
            throw new UnsupportedOperationException(message, nsae);
        }
        catch (IllegalArgumentException | InvalidKeySpecException e) {
            String message = "Invalid specification with salt=" + Arrays.toString(salt) + ", iterations=" + this.iterations + " and length=" + this.length;
            throw new BadParametersException(message, e);
        }
    }

    protected String getHash(byte[] encodedKey, byte[] salt) {
        return Utils.encodeBase64(encodedKey);
    }

    @Override
    public boolean check(CharSequence plainTextPassword, String hashed) {
        return this.check((byte[])null, null);
    }

    @Override
    public boolean check(byte[] plainTextPasswordAsBytes, byte[] hashed) {
        throw new UnsupportedOperationException("This implementation requires an explicit salt.");
    }

    @Override
    public boolean check(CharSequence plainTextPassword, String hashed, String salt) {
        Hash internalHash = this.hash(plainTextPassword, salt);
        return PBKDF2Function.slowEquals(internalHash.getResult(), hashed);
    }

    @Override
    public boolean check(byte[] plainTextPasswordAsBytes, byte[] hashed, byte[] salt) {
        Hash internalHash = this.hash(plainTextPasswordAsBytes, salt);
        return PBKDF2Function.slowEquals(internalHash.getResultAsBytes(), hashed);
    }

    public String getAlgorithm() {
        return this.algorithmAsString;
    }

    public int getIterations() {
        return this.iterations;
    }

    public int getLength() {
        return this.length;
    }

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        PBKDF2Function otherStrategy = (PBKDF2Function)obj;
        return this.algorithmAsString.equals(otherStrategy.algorithmAsString) && this.iterations == otherStrategy.iterations && this.length == otherStrategy.length;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + PBKDF2Function.toString(this.algorithmAsString, this.iterations, this.length) + ')';
    }

    public int hashCode() {
        return Objects.hash(this.algorithmAsString, this.iterations, this.length);
    }
}

