/*
 * Decompiled with CFR 0.152.
 */
package com.password4j;

import com.password4j.AbstractHashingFunction;
import com.password4j.Hash;
import com.password4j.HashingFunction;
import com.password4j.SaltOption;
import com.password4j.Utils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class MessageDigestFunction
extends AbstractHashingFunction {
    protected static final SaltOption DEFAULT_SALT_OPTION = SaltOption.APPEND;
    private static final Map<String, MessageDigestFunction> INSTANCES = new ConcurrentHashMap<String, MessageDigestFunction>();
    private final String algorithm;
    private final SaltOption saltOption;

    MessageDigestFunction(String algorithm, SaltOption saltOption) {
        this.algorithm = algorithm;
        this.saltOption = saltOption;
    }

    public static MessageDigestFunction getInstance(String algorithm) {
        return MessageDigestFunction.getInstance(algorithm, DEFAULT_SALT_OPTION);
    }

    public static MessageDigestFunction getInstance(String algorithm, SaltOption saltOption) {
        String key = MessageDigestFunction.getUID(algorithm, saltOption);
        if (INSTANCES.containsKey(key)) {
            return INSTANCES.get(key);
        }
        MessageDigestFunction function = new MessageDigestFunction(algorithm, saltOption);
        INSTANCES.put(key, function);
        return function;
    }

    protected static String getUID(String algorithm, SaltOption saltOption) {
        return algorithm + "|" + saltOption.name();
    }

    protected static String toString(String algorithm, SaltOption saltOption) {
        return "a=" + algorithm + ", o=" + saltOption.name();
    }

    @Override
    public Hash hash(CharSequence plainTextPassword) {
        return this.hash(plainTextPassword, null);
    }

    @Override
    public Hash hash(byte[] plainTextPasswordAsBytes) {
        return this.hash(plainTextPasswordAsBytes, null);
    }

    @Override
    public Hash hash(CharSequence plainTextPassword, String salt) {
        return this.internalHash(Utils.fromCharSequenceToBytes(plainTextPassword), Utils.fromCharSequenceToBytes(salt));
    }

    @Override
    public Hash hash(byte[] plainTextPasswordAsBytes, byte[] saltAsBytes) {
        return this.internalHash(plainTextPasswordAsBytes, saltAsBytes);
    }

    protected Hash internalHash(byte[] plainTextPassword, byte[] salt) {
        byte[] finalCharSequence = this.concatenateSalt(plainTextPassword, salt);
        byte[] result = this.getMessageDigest().digest(finalCharSequence);
        return new Hash((HashingFunction)this, Utils.toHex(result), result, salt);
    }

    protected MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new UnsupportedOperationException("`" + this.algorithm + "` is not supported by your system.", nsae);
        }
    }

    @Override
    public boolean check(CharSequence plainTextPassword, String hashed) {
        return this.check(plainTextPassword, hashed, null);
    }

    @Override
    public boolean check(byte[] plainTextPasswordAsBytes, byte[] hashed) {
        return this.check(plainTextPasswordAsBytes, hashed, null);
    }

    @Override
    public boolean check(CharSequence plainTextPassword, String hashed, String salt) {
        Hash hash = this.internalHash(Utils.fromCharSequenceToBytes(plainTextPassword), Utils.fromCharSequenceToBytes(salt));
        return MessageDigestFunction.slowEquals(hash.getResult(), hashed);
    }

    @Override
    public boolean check(byte[] plainTextPassword, byte[] hashed, byte[] salt) {
        Hash hash = this.internalHash(plainTextPassword, salt);
        return MessageDigestFunction.slowEquals(hash.getResultAsBytes(), hashed);
    }

    public SaltOption getSaltOption() {
        return this.saltOption;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    private byte[] concatenateSalt(byte[] plainTextPassword, byte[] salt) {
        if (salt == null || salt.length == 0) {
            return plainTextPassword;
        }
        if (this.saltOption == SaltOption.PREPEND) {
            return Utils.append(salt, plainTextPassword);
        }
        return Utils.append(plainTextPassword, salt);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + MessageDigestFunction.toString(this.algorithm, this.saltOption) + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MessageDigestFunction)) {
            return false;
        }
        MessageDigestFunction other = (MessageDigestFunction)o;
        return this.algorithm.equals(other.algorithm) && this.saltOption == other.saltOption;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.algorithm, this.saltOption});
    }
}

