/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.passay.AbstractMessageResolver;

public class PropertiesMessageResolver
extends AbstractMessageResolver {
    public static final String DEFAULT_MESSAGE_PATH = "/passay.properties";
    private final Properties messageProperties;

    public PropertiesMessageResolver() {
        this(PropertiesMessageResolver.getDefaultProperties());
    }

    public PropertiesMessageResolver(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Properties cannot be null.");
        }
        this.messageProperties = properties;
    }

    @Override
    protected String getMessage(String key) {
        return this.messageProperties.getProperty(key);
    }

    public static Properties getDefaultProperties() {
        Properties props = new Properties();
        InputStream in = null;
        try {
            in = PropertiesMessageResolver.class.getResourceAsStream(DEFAULT_MESSAGE_PATH);
            props.load(in);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error loading default message properties.", e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return props;
    }
}

